<?php
// $Id: weblinks_rss_atom_collect_handler.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// assign RSS / ATOM to template
// use class ConvertLanguage, atom_parser, rss_parser
// 2004-10-24 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_rss_atom_collect_handler') ) 
{

//=========================================================
// weblinks_rss_atom_collect_handler
//=========================================================
class weblinks_rss_atom_collect_handler extends weblinks_rss_atom_parser_base
{
// link table
	var $lid;
	var $title;
	var $url;
	var $broken;
	var $rss_flag;
	var $rss_url;
	var $rss_update;
	var $rss_xml;

// parameter
	var $cache_time;
	var $mode_auto;
	var $flag_rss_xml_save;
	var $mode_data;
	var $num_feed;

// counter
	var $count_refresh_rss_url;
	var $count_refresh_rss_update;
	var $count_refresh_atom_site;
	var $count_refresh_atomfeed;

// class instance
	var $tbl_link;
	var $tbl_atomfeed;
	var $tbl_config;
	var $rss;
	var $atom;
	var $remote;
	var $lang;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_rss_atom_collect_handler( $dirname )
{

// dont use this
//	$this->weblinks_rss_atom_parser_base();

// count
	$this->count_refresh_rss_url    = 0;
	$this->count_refresh_rss_update = 0;
	$this->count_refresh_atom_site  = 0;
	$this->count_refresh_atomfeed   = 0;

// class instance
	$this->tbl_config   =& weblinks_get_handler( 'config',   $dirname );
	$this->tbl_link     =& weblinks_get_handler( 'link',     $dirname );
	$this->tbl_atomfeed =& weblinks_get_handler( 'atomfeed', $dirname );

//	$this->tbl_link     =& table_link::getInstance();
//	$this->tbl_atomfeed =& table_atomfeed::getInstance();
//	$this->tbl_config   =& table_config::getInstance();

	$this->rss     =& weblinks_rss_parser::getInstance();
	$this->atom    =& weblinks_atom_parser::getInstance();
	$this->remote  =& weblinks_remote_file::getInstance();
	$this->lang    =& weblinks_language_convert::getInstance();

// parameter
	$this->set_mode_auto(  1 );	// auto
	$this->set_mode_data(  0 );	// atomfeed
	$this->set_cache_time( 24 );	// 24 hours
	$this->set_num_feed( 10 );

	$this->set_mode_title(   0 );	// not allow HTML tag
	$this->set_mode_content( 0 );	// not allow HTML tag
	$this->set_mode_arrange( 0 );	// raw data
	$this->set_max_content( 100 );
	$this->set_max_summary( 100 );
	$this->set_title_default( "---" );

// for debug
// 0=no save, 1=save
	$this->flag_rss_xml_save = 1;

}

//---------------------------------------------------------
// refresh and parse XML
//---------------------------------------------------------
function parse_xml_for_singlelink($lid)
{

	$this->lid = $lid;
	$this->get_link_by_lid($lid);

// refresh RSS/ATOM URL
	if ( $this->mode_auto && ($this->rss_flag == 3) )
	{
		$this->refresh_rss_url($lid, $this->url);
	}

	if ( empty($this->rss_url) )   return false;
	if ( ($this->rss_flag != 1) && ($this->rss_flag != 2) )  return false;


// refresh ATOM feed
	if ( $this->check_refresh_time( $this->rss_update ) )
	{
		$this->refresh_atom_site($lid, $this->rss_url);
	}

// parse XML
	if ( $this->mode_data )
	{
		$this->set_mode_arrange( 1 );	// view data
		$feeds = $this->parse_xml($this->rss_xml);
	}
// get ATOM feed
	else
	{
		$feeds = $this->get_atomfeed($lid);
	}

	return $feeds;

}

function parse_xml_for_block($lid)
{
	$this->lid      = $lid;

	$this->get_link_by_lid($lid);

	if ( empty($this->rss_url) )   return false;
	if ( ($this->rss_flag != 1) && ($this->rss_flag != 2) )  return false;

// refresh ATOM feed
	if ( $this->check_refresh_time( $this->rss_update ) )
	{
		$this->refresh_atom_site($lid, $this->rss_url);
	}

// parse XML
	if ( $this->mode_data )
	{
		$feeds = $this->parse_xml($this->rss_xml);
	}
// get ATOM feed
	else
	{
		$feeds = $this->get_atomfeed($lid);
	}

	return $feeds;
}

function refresh_xml_for_admin($tbl_link, $xml_data)
{
	$this->set_link_value($tbl_link);

// refresh ATOM feed
	$this->refresh_atom_cache($this->lid, $xml_data);
}

function refresh_xml_for_admin_2($xml_data)
{
	$this->rss_flag = 1;
	$this->refresh_atomfeed(0, $xml_data);
}

//---------------------------------------------------------
// get link data
//---------------------------------------------------------
function get_link_by_lid($lid)
{
	$this->tbl_link->getRowByLid($lid);
	$this->set_link_value($this->tbl_link);
}

function set_link_value($tbl_link)
{
	$this->lid        = $tbl_link->lid;
	$this->title      = $tbl_link->title;
	$this->url        = $tbl_link->url;
	$this->broken     = $tbl_link->broken;
	$this->rss_flag   = $tbl_link->rss_flag;
	$this->rss_url    = $tbl_link->rss_url;
	$this->rss_update = $tbl_link->rss_update;
	$this->rss_xml    = $tbl_link->rss_xml;
}

//---------------------------------------------------------
// refresh URL
//---------------------------------------------------------
function refresh_rss_url($lid, $url_html)
{

	$data_html = $this->read_remote_file($url_html);
	if ( empty($data_html) )
	{
		return false;
	}

	list($url_rss, $url_atom) = $this->find_rss_atom_link($data_html);

// BUG 3106: cannot find a relative RSS url correctly.
// patch by SnAKes
	$url_rss  = $this->relative_to_full_url($url_rss,  $url_html);
	$url_atom = $this->relative_to_full_url($url_atom, $url_html);

	if ($url_atom)
	{
		$this->tbl_link->updateRssUrl($lid, 2, $url_atom);
		$this->rss_flag = 2;
		$this->rss_url  = $url_atom;
		$this->count_refresh_rss_url ++;
		return true;
	}
	elseif ($url_rss)
	{
		$this->tbl_link->updateRssUrl($lid, 1, $url_rss);
		$this->rss_flag = 1;
		$this->rss_url  = $url_rss;
		$this->count_refresh_rss_url ++;
		return true;
	}
	else
	{
// in future
//		$this->tbl_link->updateRssUrl($lid, 0, '');
	}

	return false;
}

//---------------------------------------------------------
// refresh XML
//---------------------------------------------------------
function check_refresh_time($update)
{
	if ( time() > ($update + $this->cache_time) )
	{	return true;	}

	return false;
}

function refresh_atom_site($lid, $rss_url)
{
// get remote XML
	$xml_data = $this->read_remote_xml($rss_url);
	if (!$xml_data)
	{
		return false;
		// set no use RSS ( in future)
	}

// refresh XML cache
	return $this->refresh_atom_cache($lid, $xml_data);

}

function refresh_atom_cache($lid, $xml_data)
{
// refresh XML cache
	$this->rss_update = time();
	$this->rss_xml    = $xml_data;

	if ( $this->flag_rss_xml_save )
	{
		$this->tbl_link->updateRssXml($lid, $this->rss_update, addslashes($xml_data) );
	}
	else
	{
		$this->tbl_link->updateRssUpdate($lid, $this->rss_update);
	}

	$this->count_refresh_rss_update ++;

	return $this->refresh_atomfeed($lid, $xml_data);

}

// refresh ATOM feed
function refresh_atomfeed($lid, $xml_data)
{
// parse XML
	$items = $this->parse_xml($xml_data);

	if (empty($items))  return false;

// refresh ATOM feed
	foreach($items as $item)
	{
		$ret1 = $this->tbl_config->check_black( $item['url'] );
		if ( $ret1 )  continue;

		$item['lid'] = $lid;
		$ret2 = $this->tbl_atomfeed->refresh($item);
		if ($ret2)
		{	$this->count_refresh_atomfeed ++;	}

	}

	$this->count_refresh_atom_site ++;
	return true;
}

//---------------------------------------------------------
// parse XML
//---------------------------------------------------------
function parse_xml($xml_data)
{
	if ($this->rss_flag == 2)
	{
		return $this->parse_atom( $xml_data );
	}
	elseif ($this->rss_flag == 1)
	{
		return $this->parse_rss( $xml_data );
	}

	return false;
}

function parse_atom($xml_data)
{
	$ret = $this->atom->parse_data($xml_data);
	if (!$ret) return false;

	$feed = $this->atom->get_feed();
	$feed = $this->convert_array_from_utf8( $feed );
	$site_title = $feed['title'];
	$site_url   = $feed['link'];

	$entrys = $this->atom->get_entrys();
	$entrys = $this->convert_array_array_from_utf8( $entrys );
	$entrys = $this->atom->arrange_entrys( $entrys, $site_title, $site_url );
	return $entrys;
}

function parse_rss($xml_data)
{

	$ret = $this->rss->parse($xml_data);
	if (!$ret)
	{
		$error = $this->rss->get_parse_error();
	
		echo "$error <br>";
		return false;
	}

	$channel = $this->rss->get_channel();
	$channel = $this->convert_array_from_utf8( $channel );
	$site_title = $channel['title'];
	$site_url   = $channel['link'];

	$items = $this->rss->get_items();
	$items = $this->convert_array_array_from_utf8( $items );
	$items = $this->rss->arrange_items( $items, $site_title, $site_url );
	return $items;
}


//---------------------------------------------------------
// get ATOM feed
//---------------------------------------------------------
function get_atomfeed($lid)
{
	$arr = array();

// atom id array
	$aid_arr = $this->tbl_atomfeed->getAidArrayByLidLatest($lid, $this->num_feed);

// each atom
	foreach ($aid_arr as $aid) 
	{
		$record = $this->tbl_atomfeed->getRowByAid($aid);
		$arr[]  = $this->tbl_atomfeed->makeDisplay($record);
	}

	return $arr;
}


//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_mode_auto($value)
{
	$this->mode_auto = intval($value);
}

function set_mode_data($value)
{
	$this->mode_data = intval($value);
}

function set_cache_time($value)
{
	$this->cache_time = 3600 * intval($value);	// hour
}

function set_num_feed($value)
{
	$this->num_feed = intval($value);
}

function set_mode_title($value)
{
	$mode = intval($value);
	$this->rss->set_mode_title(  $mode );
	$this->atom->set_mode_title( $mode );
	$this->tbl_atomfeed->set_mode_title( $mode );
}

function set_mode_content($value)
{
	$mode = intval($value);
	$this->rss->set_mode_content(  $mode );
	$this->atom->set_mode_content( $mode );
	$this->tbl_atomfeed->set_mode_content( $mode );

}

function set_mode_arrange($value)
{
	$mode = intval($value);
	$this->rss->set_mode_arrange(  $mode );
	$this->atom->set_mode_arrange( $mode );
}

function set_max_content($value)
{
	$max = intval($value);
	$this->rss->set_max_content(  $max );
	$this->atom->set_max_content( $max );
	$this->tbl_atomfeed->set_max_content( $max );
}

function set_max_summary($value)
{
	$max = intval($value);
	$this->rss->set_max_summary(  $max );
	$this->atom->set_max_summary( $max );
	$this->tbl_atomfeed->set_max_summary( $max );
}


function set_title_default($value)
{
	$this->rss->set_title_default( $value );
}



function set_max_summary_collect($value)
{
	$max_summary = intval($value);

	$this->rss->set_max_summary($max_summary);
	$this->atom->set_max_summary($max_summary);
}

function get_rss_flag()
{
	return $this->rss_flag;
}

function get_rss_url()
{
	return $this->rss_url;
}

function get_rss_update( $format='' )
{
	if ($format)
	{
		$date = formatTimestamp($this->rss_update, $format);
		return $date;
	}

	return $this->rss_update;
}

//=========================================================
// use class ConvertLanguage
// override rss_atom_parser_base
//=========================================================
function convert_from_utf8($text)
{
	return $this->lang->convert_from_utf8($text);
}

function convert_encode_to_utf8($text, $encode)
{
	return $this->lang->convert_encode_to_utf8($text, $encode);
}

function shorten_text($text, $max=100)
{
	return $this->lang->shorten_text($text, $max);
}


//=========================================================
// use class remote_file
// override rss_atom_parser_base
//=========================================================
function read_remote_file($url)
{
	return $this->remote->read_file( $url );
}

// --- class end ---
}

// === class end ===
}

?>