<?php
// $Id: weblinks_category_handler.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// require functions.php
// 2004/01/14 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// global $weblinksConfig; in constructor
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_category_handler') ) 
{

//=========================================================
// class table_category
//=========================================================
class weblinks_category_handler extends weblinks_module_base
{
	var $tree;

// xoopsModuleConfig
	var $config_catsel;
	var $config_catimage_width;
	var $config_catimage_height;

// tablefield
	var $cid;
	var $pid;
	var $title;
	var $imgurl;
	var $lflag;
	var $orders;

// reserve
	var $cflag;
	var $tflag;

// reserve wfsection
	var $displayimg;
	var $description;
	var $catdescription;
    var $catfooter;
    var $groupid;
	var $editaccess;

// local
	var $num_all;
	var $all_records;
	var $tree_array;
	var $orderby_cid;
	var $orderby_orders;

// class instance
	var $image;
	var $remote;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_category_handler( $dirname )
{
	$this->weblinks_module_base();
	$this->check_dirname( $dirname, 'weblinks_category_handler' );

	$this->table = $this->xoops_db->prefix( $dirname.'_category' );
	$this->module_root = XOOPS_ROOT_PATH."/modules/".$dirname;
	$this->module_url  = XOOPS_URL."/modules/".$dirname;

	$this->orderby_cid    = 'cid';
	$this->orderby_orders = 'orders, cid';

	$this->num_all     = 0;
	$this->all_records = array();
	$this->tree_array  = array();

// class
	$this->tree = new XoopsTree($this->table, "cid", "pid");

	if ( class_exists('weblinks_image_size') )
	{
		$this->image =& weblinks_image_size::getInstance();
	}

	if ( class_exists('weblinks_remote_file') )
	{
		$this->remote =& weblinks_remote_file::getInstance();
	}

	global $weblinksConfig;
	$this->config_catsel          = $weblinksConfig['cat_sel'];
	$this->config_catimage_width  = $weblinksConfig['cat_img_width'];
	$this->config_catimage_height = $weblinksConfig['cat_img_height'];

}

function getAll()
{
	static $getall;
	if (!isset($getall)) 
	{
		$getall = 1;
		$this->all_records = array();
		$this->tree_array  = array();
		$this->_get_db_all_records();
		$this->_get_db_tree_array(0);
		$this->num_all = $this->_get_db_num_all();
	}

}

//---------------------------------------------------------
// insert
// for admin/category.php
//---------------------------------------------------------
function insert()
{
	$sql  = "INSERT INTO $this->table (";
	$sql .= "pid, lflag, title, imgurl, ";
	$sql .= "orders ";
	$sql .= ") VALUES (";
	$sql .= "$this->pid, $this->lflag,'$this->title', '$this->imgurl', ";
	$sql .= "$this->orders ";
	$sql .= ")";

	return $this->query_insert($sql);
}

//---------------------------------------------------------
// update
// for admin/category.php
//---------------------------------------------------------
function update($cid)
{ 
	$sql  = "UPDATE $this->table SET ";
	$sql .= "pid=$this->pid, ";
	$sql .= "lflag=$this->lflag, ";
	$sql .= "title='$this->title', ";
	$sql .= "imgurl='$this->imgurl', ";
	$sql .= "orders=$this->orders ";
	$sql .= "WHERE cid=$cid";

	return $this->query_false($sql);
}

function updateOrders($cid, $orders)
{ 
	$sql  = "UPDATE $this->table SET ";
	$sql .= "orders=$orders ";
	$sql .= "WHERE cid=$cid";

	return $this->query_false($sql);
}

//---------------------------------------------------------
// delete
// for admin/category.php
//---------------------------------------------------------
function delete($cid)
{ 
	$sql = "DELETE FROM $this->table WHERE cid=$cid";
    return $this->query_false($sql);
}

//---------------------------------------------------------
// select
//---------------------------------------------------------
// for admin/index.php
function _get_db_num_all()
{
	$sql = "SELECT count(*) FROM $this->table";
	return $this->get_num_by_sql($sql);
}

function getNumByPid($pid)
{
	$sql = "SELECT count(*) FROM $this->table WHERE pid=$pid";
	return $this->get_num_by_sql($sql);
}

// for constructor
function _get_db_all_records()
{
	$sql = "SELECT * FROM $this->table ORDER BY $this->orderby_cid";
	$res = $this->query($sql);

	$rec = array();
	while ($row = $this->xoops_db->fetchArray($res)) 
	{	  $rec[ $row['cid'] ] = $row;	}

	$this->xoops_db->freeRecordSet($res);

	$this->all_records = $rec;
	return $rec;
}

// for viewcat.php
function getRowByCid($cid)
{
	$sql = "SELECT * FROM $this->table WHERE cid = $cid";
	return $this->get_row_by_sql($sql);
}

// orderby is initialized at constructor
// for index.php
function getRowsByPid($pid,$limit=0,$offset=0)
{
	$sql = "SELECT * FROM $this->table WHERE pid=$pid ORDER BY $this->orderby_cid";
	return $this->get_row_array_by_sql($sql,$limit,$offset);
}

function getCidArrayAll($limit=0,$offset=0)
{
	$sql = "SELECT cid FROM $this->table ORDER BY cid";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

function getCidArrayByPid($pid=0, $limit=0, $offset=0)
{
	$sql = "SELECT cid FROM $this->table WHERE pid=$pid ORDER BY $this->orderby_orders";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

//---------------------------------------------------------
// add new category
// for admin/category.php
//---------------------------------------------------------
function clearItems()
{
	$this->cid    = 0;
	$this->pid    = 0;
	$this->lflag  = 0;
	$this->cflag  = 0;
	$this->tflag  = 0;
	$this->orders = 1;

	$this->title       = '';
	$this->imgurl      = '';
	$this->displayimg  = '';
	$this->description = '';
	$this->catdescription = '';
    $this->catfooter   = '';
	$this->articles    = '';
	$this->newest_time = '';
	$this->newest_uid  = '';
    $this->groupid     = '';
	$this->editaccess  = '';

}

function setItems($arr)
{
//	global $myts;

   	if ( isset($arr['pid']) )
   	{  $this->pid =  intval($arr['pid']);  }
	elseif ( isset($arr['cid']) )
	{  $this->pid = intval($arr['cid']);   }

	$this->set_field_value_intval($arr, 'lflag');
	$this->set_field_value_intval($arr, 'orders');

	$this->set_field_value($arr, 'title');
	$this->set_field_value_url($arr, 'imgurl');

	$this->title  = $this->xoops_myts->makeTareaData4Save($this->title);
	$this->imgurl = $this->xoops_myts->makeTareaData4Save($this->imgurl);
}

//---------------------------------------------------------
// display
//---------------------------------------------------------
// for class/catlink.php:
function showSelboxMulti($cid_arr='')
{
	if ( count($cid_arr) == 0 )  return '';

	$selbox = '';
	foreach ($cid_arr as $cid)
	{
		$title = $this->getValueByCid($cid, 'title', 'S');
		$selbox .= $title."<br />";
	}

	return $selbox;
}

// for admin/category.php
function makeEditSelboxMulti($cid_arr='')
{
// show always, if cid array is empty

	if ($cid_arr)
	{
		$cid_count = count($cid_arr);
	}
	else
	{
		$cid_count = 0;
	}

	$catsel_max = $this->config_catsel;
	if ($catsel_max < $cid_count) { $catsel_max = $cid_count; }

	$selbox = '';
	for($i=0; $i<$catsel_max; $i++)
	{
		$cid = 0;
		if ($i < $cid_count) { $cid = $cid_arr[$i]; }

		$selbox .= $this->makeMySelBox( $cid, 1, "cid[]", '', 1 );
		$selbox .= "<br />\n";
	}

	return $selbox;
}

// enable to modeify the display layout of a category path in the template
// for singlelink
function getParentPath($cid)
{
	$path_array = array();

	$pid_arr = $this->_get_path_array($cid);

	foreach ($pid_arr as $pid) 
	{
		$title = $this->getValueByCid($pid, 'title', 'S');
		$path_array[] = array('cid'=>$pid, 'title'=>$title);
	}

	return $path_array;
}

// Hack by Tom  $chitem
// admin can change the display number of subcategory 
// for viewcat.php
function makeSubcategorys($cid, $chitem=5)
{

	$space   = 0;
	$chcount = 0;
	$subcategories = '';

// bug fix: show all sub categories when $chitem = 0
	if ($chitem > 0) 
	{
		$child_arr = $this->getCidArrayByPid($cid);
		foreach($child_arr as $ch_id)
		{
			$chtitle = $this->getValueByCid($ch_id, 'title', 'S');

			if ($chcount >= $chitem) 
			{
				$subcategories .= "...";
				break;
			}
			if ($space>0) 
			{
				$subcategories .= ", ";
			}

			$url = $this->module_url.'/viewcat.php?cid='.$ch_id;
			$subcategories .= "<a href='$url'>".$chtitle."</a>";
			$space++;
			$chcount++;
		}
	}

	return array($space, $chcount, $subcategories);
}

//---------------------------------------------------------
// image
//---------------------------------------------------------
// for index.php
function makeImageLink($imgurl)
{
	$image_link = '';

	if ($imgurl && ($imgurl != "http://"))
	{
		list($width, $height) = $this->remote->get_image_size($imgurl);
		list($width, $height) = 
			$this->image->adjust_size( $width, $height, $this->config_catimage_width, $this->config_catimage_height );

		$image_link = $this->build_image_link($imgurl, $width, $height, 0, 'category');
	}

	return $image_link;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function getNumAll()
{
	$this->getAll();
	return $this->num_all;
}

function getRecordByCid($cid)
{
	if ( !( $this->isCid($cid) ) )  return false;
	return $this->all_records[$cid];
}

function getValueByCid($cid, $name, $format='')
{
	if ( !isset( $this->all_records[$cid][$name] ) )  return false;
	$value = $this->all_records[$cid][$name];
	return $this->make_text_to_format($value, $format);
}

function isCid($cid)
{
	if ( isset( $this->all_records[$cid] ) )  return true;

	return false;
}

function getTreeArray($limit=0, $offset=0)
{
	$this->getAll();

	$limit  = intval($limit);
	$offset = intval($offset);

	if ( ($limit == 0) && ($offset == 0) )
	{
		return $this->tree_array;
	}

	$end = $offset + $limit;

	if ($offset < 0)               return false;
	if ($end    < 0)               return false;
	if ($offset > $this->num_all)  return false;
	if ($end    > $this->num_all)  $end = $this->num_all;

	$arr = array();

	for ($i=$offset; $i<$end; $i++)
	{
		$arr[] = $this->tree_array[$i];
	}

	return $arr;
}

// for admin/category.php
function getTitle()
{	return $this->title;	}


//---------------------------------------------------------
// category tree
// tree is initialized at constructor
//---------------------------------------------------------
// for catlist.php
function makeCatpath($cid)
{
	$catpath = '';
	$pid_arr = $this->_get_path_array($cid);

	foreach ($pid_arr as $pid) 
	{
		$title = $this->all_records[$pid]['title'];
	
		if ($catpath)
		{	$catpath .= " : $title";	}
		else
		{	$catpath .= $title;	}
	}

	return  $catpath;
}

function _get_path_array($cid)
{
	return  split(":", $this->all_records[$cid]['path'] );
}

//=========================================================
// use tree class
//=========================================================
// for topten.php
function getAllChildId($cid)
{
	return $this->tree->getAllChildId($cid, $this->orderby_cid);
}

// for admin/category.php
function getPathFromId($cid)
{
	return $this->tree->getPathFromId($cid, "title");
}

//---------------------------------------------------------
// porting from xoopstree.php
//---------------------------------------------------------

// makes a nicely ordered selection box
// $preset_id is used to specify a preselected item
// set $none to 1 to add a option with value 0
// for submit.php
function makeMySelBox($preset_id=0, $none=0, $sel_name='', $onchange='',$flag=0)
{
	$selbox  = '';
	$selbox .= "<select name='".$sel_name."'";

	if ( $onchange != "" ) 
	{	$selbox .= " onchange='".$onchange."'";	}

	$selbox .= ">\n";

	if ( $none ) 
	{	$selbox .=  "<option value='0'>"._WLS_NOTSELECT."</option>\n\n";	}

	foreach ($this->tree_array as $cid) 
	{
		$lflag = $this->all_records[$cid]['lflag'];
		if (($flag == 1)&&($lflag == 0))  continue;

		$catpath = $this->makeCatpath($cid);
		$catpath = $this->xoops_myts->makeTboxData4Show($catpath);

		$sel = '';
		if ( $cid == $preset_id ) 
		{	$sel = " selected='selected'";	}

		$selbox .= "<option value= $cid $sel>$catpath</option>\n";
	}

	$selbox .= "</select>\n";

	return $selbox;
}

// recurcive function
function _get_db_tree_array( $pid=0 )
{
	$cid_arr = $this->getCidArrayByPid($pid);

	if ( count($cid_arr) == 0 )  return;

	foreach ($cid_arr as $cid) 
	{

		if ($pid == 0)
		{
			$this->all_records[$cid]['path']  = "$cid";
			$this->all_records[$cid]['depth'] =  0;
		}
		else
		{
			$path  = $this->all_records[$pid]['path'];
			$depth = $this->all_records[$pid]['depth'];
			$this->all_records[$cid]['path']  = "$path:$cid";
			$this->all_records[$cid]['depth'] =  $depth + 1;
		}

		$this->tree_array[] = $cid;
		$this->_get_db_tree_array($cid);
	}

	return;
}

// --- class end ---
}

// === class end ===
}

?>