<?php
// $Id: weblinks_atomfeed_handler.php,v 1.1 2006/01/16 07:24:56 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// 2004-11-28 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_atomfeed_handler') ) 
{

//=========================================================
// class weblinks_atomfeed_handler
//=========================================================
class weblinks_atomfeed_handler extends weblinks_module_base
{
// tablefield
	var $aid;
	var $lid;
	var $site_title;
	var $site_url;
	var $title;
	var $url;
	var $entry_id;
	var $guid;
	var $time_modified;
	var $time_issued;
	var $time_created;
	var $author_name;
	var $author_url;
	var $author_email;
	var $content;

// local
	var $mode_title;
	var $mode_content;
	var $max_content;
	var $max_summary;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_atomfeed_handler( $dirname )
{
	$this->weblinks_module_base( $dirname );
	$this->check_dirname( $dirname, 'weblinks_atomfeed_handler' );

	$this->table = $this->xoops_db->prefix( $dirname.'_atomfeed' );

	$this->set_mode_title(   0 );	// not allow HTML tag
	$this->set_mode_content( 0 );	// not allow HTML tag
	$this->set_max_content(  100 );
	$this->set_max_summary(  100 );

	$this->set_title_default( "---" );

}

//---------------------------------------------------------
// insert
//---------------------------------------------------------
function insert()
{
	$sql  = "INSERT INTO $this->table (";
	$sql .= "lid, site_title, site_url, ";
	$sql .= "title, url, entry_id, guid, ";
	$sql .= "time_modified, time_issued, time_created, ";
	$sql .= "author_name, author_url, author_email, ";
	$sql .= "content ";
	$sql .= ") VALUES (";
	$sql .= "$this->lid, '$this->site_title', '$this->site_url', ";
	$sql .= "'$this->title', '$this->url', '$this->entry_id', '$this->guid', ";
	$sql .= "$this->time_modified, $this->time_issued, $this->time_created, ";
	$sql .= "'$this->author_name', '$this->author_url', '$this->author_email', ";
	$sql .= "'$this->content' ";
	$sql .= ")";

	return $this->query_insert($sql);
}

//---------------------------------------------------------
// update
//---------------------------------------------------------

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete($aid)
{ 
	$sql = "DELETE FROM $this->table WHERE aid=$aid";
    return $this->query_false($sql);
}

function deleteByLid($lid)
{ 
	$sql = "DELETE FROM $this->table WHERE lid=$lid";
    return $this->query_false($sql);
}

function deleteByUrl($url)
{ 
	$sql = "DELETE FROM $this->table WHERE url='$url'";
    return $this->query_false($sql);
}


//---------------------------------------------------------
// select
//---------------------------------------------------------
function getNumAll()
{
	$sql = "SELECT count(*) FROM $this->table";
    return $this->get_num_by_sql($sql);
}

function getNumByLid($lid)
{
	$sql = "SELECT count(*) FROM $this->table WHERE lid=$lid";
    return $this->get_num_by_sql($sql);
}

function getNumByUrl($url)
{
	$sql = "SELECT count(*) FROM $this->table WHERE url='$url'";
    return $this->get_num_by_sql($sql);
}

function getNumByUrlTime($url,$time)
{
	$sql = "SELECT count(*) FROM $this->table WHERE url='$url' AND time_modified >= $time";
    return $this->get_num_by_sql($sql);
}

function getRowByAid($aid)
{
	$sql = "SELECT * FROM $this->table WHERE aid=$aid";
	return $this->get_row_by_sql($sql);
}

function getAidArrayLatest($limit=0)
{
	return $this->getAidArrayByOrderby("time_modified DESC", $limit, 0);
}

function getAidArrayByOrderby($orderby="time_modified DESC", $limit=0, $offset=0)
{
	$DAY    = 3;
	$future = time() + $DAY*24*3600;

	$sql = "SELECT aid FROM $this->table WHERE time_modified < $future ORDER BY $orderby";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

function getAidArrayByLidLatest($lid, $limit=0)
{
	return $this->getAidArrayByLidOrderby($lid, "time_modified DESC", $limit, 0);
}

function getAidArrayByLidOrderby($lid, $orderby="time_modified DESC", $limit=0, $offset=0)
{
	$sql = "SELECT aid FROM $this->table WHERE lid=$lid ORDER BY $orderby";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}


//---------------------------------------------------------
// clear atomfeed
//---------------------------------------------------------
function clearOverNum($num)
{
	if ($num <= 0)
	{
		return 0;	// non
	}

	$total = $this->getNumAll();

	if ($total < $num)
	{
		return 0;	// non
	}

	$limit   = $total - $num;
	$orderby = "time_modified ASC";
	$aid_arr = $this->getAidArrayByOrderby($orderby, $limit, 0);

// exec
	foreach( $aid_arr as $aid )
	{
		$this->delete($aid);
	}

	return $limit;	// excute
}

//---------------------------------------------------------
// refresh atomfeed
//---------------------------------------------------------
function refresh($item)
{
// set value
	$this->clearItems();
	$this->setItems( $item );

// return , if already exit
	$num = $this->getNumByUrlTime($this->url, $this->time_modified);
	if ($num) return false;

// delete old, if exist
	$num = $this->getNumByUrl($this->url);
	{
		$this->deleteByUrl($this->url);
	}

// add new
	$ret = $this->insert();

    return $ret;
}

function clearItems()
{
	$this->lid           = 0;
	$this->time_modified = 0;
	$this->time_issued   = 0;
	$this->time_created  = 0;

	$this->site_title   = '';
	$this->site_url     = '';
	$this->title        = '';
	$this->url          = '';
	$this->entry_id     = '';
	$this->guid         = '';
    $this->author_name  = '';
	$this->author_url   = '';
	$this->author_email = '';
	$this->content      = '';
}

function setItems($array)
{
	$this->set_field_value_intval($array, 'lid' );
	$this->set_field_value_intval($array, 'time_modified' );
	$this->set_field_value_intval($array, 'time_issued' );
	$this->set_field_value_intval($array, 'time_created' );

	$this->set_field_value_addslashes($array, 'site_title' );
	$this->set_field_value_addslashes($array, 'site_url' );
	$this->set_field_value_addslashes($array, 'title' );
	$this->set_field_value_addslashes($array, 'url' );
	$this->set_field_value_addslashes($array, 'entry_id' );
	$this->set_field_value_addslashes($array, 'guid' );
	$this->set_field_value_addslashes($array, 'author_name' );
	$this->set_field_value_addslashes($array, 'author_url' );
	$this->set_field_value_addslashes($array, 'author_email' );
	$this->set_field_value_addslashes($array, 'content' );

}

//---------------------------------------------------------
// display
//---------------------------------------------------------
function makeDisplay($array='')
{
	if (!empty($array))  $this->make_field_value($array);

// date
	$date = '';
	if ( $this->time_modified ) 
	{	$date = formatTimestamp($this->time_modified, "m");	}

	$title   = $this->make_title($this->title, 'S');
	$content = $this->make_content($this->content, $this->max_content, 'S');
	$summary = $this->make_summary($this->content, $this->max_summary, 'S');

	$array = array(

// allow HTML tag
		'title'   => $title,
		'content' => $content,
		'summary' => $summary,
		'date'    => $date,

		'site_title' => $this->xoops_myts->makeTboxData4Show($this->site_title),
		'site_url'   => $this->makeData4Show($this->site_url),
		'url'        => $this->makeData4Show($this->url),

	);

	return $array;
}

function make_title($title='', $format='')
{
	if (empty($title))  $title = $this->title;
	if (empty($title))  $title = $this->title_default;

// some site have title with html tag
	if ( !$this->mode_title )
	{
		$title = strip_tags( $title );
		$title = $this->make_text_to_format($title, $format);
	}

	return $title;
}

function make_content($content='', $max='', $format='')
{
	if (empty($content))  $content = $this->content;
	if (empty($max))      $max     = $this->max_content;

	if ( !$this->mode_content )
	{
		$content = $this->make_summary($content, $max, $format);
	}

	return $content;
}

function make_summary($content='', $max='', $format='')
{
	if (empty($content))  $content = $this->content;
	if (empty($max))      $max     = $this->max_summary;

	$summary = $content;
	$summary = $this->prepare_strip_tags( $summary );
	$summary = strip_tags( $summary );
	$summary = $this->shorten_text( $summary, $max );
	$summary = $this->xoops_myts->makeTboxData4Show( $summary );
	$summary = $this->make_text_to_format($summary, $format);

	return $summary;
}

//=========================================================
// set and get property
//=========================================================
function set_mode_title($value)
{
	$this->mode_title = intval($value);
}

function set_mode_content($value)
{
	$this->mode_content = intval($value);
}

function set_max_content($value)
{
	$this->max_content = intval($value);
}

function set_max_summary($value)
{
	$this->max_summary = intval($value);
}

function set_title_default($value)
{
	$this->title_default = $value;
}

// --- class end ---
}

// === class end ===
}

?>