<?php
// $Id: class.bin_link_check.php,v 1.5 2006/01/16 07:20:54 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// class bin_link_check
// 2004-11-28 K.OHWADA
//=========================================================

class bin_link_check
{
	var $module_dirname;
	var $module_url;
	var $module_root;

	var $X_MAILER;

	var $flag_echo;
	var $flag_echo_lid;
	var $flag_write;
	var $limit;

	var $fp;
	var $url_result;

	var $sitename;
	var $adminmail;

// class
	var $lang;
	var $check;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function bin_link_check($path, $dirname)
{
	$this->module_dirname = $dirname;
	$this->module_root    = $path."/modules/".$dirname;

	$this->X_MAILER = 'XOOPS weblinks';

// test mode ( access from web )
	$this->flag_echo     = 1;
	$this->flag_echo_lid = 0;
	$this->flag_write    = 0;
	$this->limit         = 10;

}

//---------------------------------------------------------
// check link broken
//---------------------------------------------------------
function check( $flag_mail=0 )
{
	$FILE_RESULT = "link_check.html";

	$this->include_files();
	$TITLE = _WEBLINKS_ADMIN_LINK_BROKEN_CHECK;

	$this->main_check($TITLE, $FILE_RESULT, 'check');

	if ($flag_mail)
	{
		$total_link      = $this->check->total_link;
		$num_link_broken = $this->check->num_link_broken;

// mail
		$text = <<<END_OF_TEXT
total  links: $total_link
broken links: $num_link_broken
END_OF_TEXT;

		$this->send_mail($TITLE, $text);
	}
}

function main_check($title, $file_result, $func)
{
	$this->set_env_param();

	$this->check->set_flag_echo($this->flag_echo);
	$this->check->set_flag_echo_lid($this->flag_echo_lid);

// --- file open ---
	$this->file_open($file_result);

	if ($this->flag_write && $this->fp)
	{
		$this->check->set_write($this->fp);
	}

	$this->html_header($title);

	$this->check->$func($this->limit, 0);

	$this->html_footer();
	$this->file_close();
// --- file close ---

}

//---------------------------------------------------------
// refresh rss cache
//---------------------------------------------------------
function refresh_link( $flag_mail=0 )
{
	$FILE_RESULT = "rss_refresh_link.html";

	$this->include_files();
	$TITLE = _WEBLINKS_ADMIN_RSS_REFRESH;

	$this->main_check($TITLE, $FILE_RESULT, 'refresh_link');

	if ($flag_mail)
	{
		$total_site_rss       = $this->check->total_site_rss;
		$num_link_broken      = $this->check->num_link_broken;
		$num_refresh_atomfeed = $this->check->num_refresh_atomfeed;

// mail
		$text = <<<END_OF_TEXT
total  rss links:  $total_site_rss
broken rss links:  $num_link_broken
refresh atomfeeds: $num_refresh_atomfeed
END_OF_TEXT;

		$this->send_mail($TITLE, $text);
	}
}

function refresh_site( $flag_mail=0 )
{
	$FILE_RESULT = "rss_refresh_site.html";

	$this->include_files();
	$TITLE = _WEBLINKS_ADMIN_RSS_REFRESH;

	$this->main_check($TITLE, $FILE_RESULT, 'refresh_site');

	if ($flag_mail)
	{
		$total_site_rss       = $this->check->total_site_rss;
		$num_link_broken      = $this->check->num_link_broken;
		$num_refresh_atomfeed = $this->check->num_refresh_atomfeed;

// mail
		$text = <<<END_OF_TEXT
total  rss links:  $total_site_rss
broken rss links:  $num_link_broken
refresh atomfeeds: $num_refresh_atomfeed
END_OF_TEXT;

		$this->send_mail($TITLE, $text);
	}
}

//---------------------------------------------------------
// include files
//---------------------------------------------------------
function include_files()
{
	$module_dirname = $this->module_dirname;
	$module_root    = $this->module_root;

// include config files
	$file_config = $module_root."/cache/config.php";
	include $file_config;

// local variable
	$this->module_url = XOOPS_URL."/modules/".$module_dirname;
	$this->sitename   = $xoops_sitename;
	$this->adminmail  = $xoops_adminmail;
	$language         = $xoops_language;


// system files
//	include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
	include_once XOOPS_ROOT_PATH."/class/snoopy.php";

// include files
	include_once $module_root."/conf.php";	// this line is first

	include_once $module_root."/bin/class.database.php";
	include_once $module_root."/bin/class.mysql_database.php";
//	include_once $module_root."/include/file_include.php";
	include_once $module_root."/include/weblinks_get_handler.php";

	include_once $module_root."/class/weblinks_module_base.php";
	include_once $module_root."/class/weblinks_link_base.php";
	include_once $module_root."/class/weblinks_link_handler.php";
	include_once $module_root."/class/weblinks_atomfeed_handler.php";
	include_once $module_root."/class/weblinks_config_handler.php";
	include_once $module_root."/class/weblinks_remote_file.php";
	include_once $module_root."/class/weblinks_language_base.php";

	include_once $module_root."/class/weblinks_image_size.php";
	include_once $module_root.'/class/weblinks_rss_atom_parser_base.php';
	include_once $module_root.'/class/weblinks_rss_parser.php';
	include_once $module_root.'/class/weblinks_atom_parser.php';
	include_once $module_root.'/class/weblinks_rss_atom_collect_handler.php';
	include_once $module_root.'/class/weblinks_link_check_handler.php';

// lang pack
//	file_include_module_convert( $module_dirname, $language );
//	file_include_module_lang( 'main.php',  $module_dirname, $language );
//	file_include_module_lang( 'admin.php', $module_dirname, $language );

// for local language
	$file_convert = $module_root."/language/".$language."/weblinks_language_convert.php";
	if (file_exists( $file_convert )) 
	{
		include_once $file_convert;
	}
	else
	{
		include_once $module_root."/language/english/weblinks_language_convert.php";
	}

// main.php
	$file_lang_main = $module_root."/language/".$language."/main.php";
	if ( file_exists($file_lang_main) ) 
	{
		include_once $file_lang_main;
	}
	else 
	{
		include_once $module_root."/language/english/main.php";
	}

// admin.php
	$file_lang_admin = $module_root."/language/".$language."/admin.php";
	if ( file_exists($file_lang_admin) ) 
	{
		include_once $file_lang_admin;
	}
	else 
	{
		include_once $module_root."/language/english/admin.php";
	}

// class
	$this->lang  =& weblinks_language_convert::getInstance();

//	$this->check =& link_check::getInstance();
	$this->check =& weblinks_get_handler( 'link_check', $module_dirname );

}

function include_flie_one($filename)
{
	include $this->module_root.$filename;
}

//---------------------------------------------------------
// web_param
//---------------------------------------------------------
function set_env_param()
{

// web
	if ( isset($_SERVER['REQUEST_METHOD']) )
	{

		if ( isset($_GET['limit']) )
		{
			$this->limit = $_GET['limit'];
		}
	
	}
// command line
	else
	{
		$this->flag_echo  = 0;
		$this->flag_write = 1;
		$this->limit      = 10;

		if ( isset( $argv[1] ) )
		{
			$this->flag_echo_lid = $argv[1];
		}

	}

}

//---------------------------------------------------------
// html header & footer
//---------------------------------------------------------
function html_header($title)
{
	$text = <<<END_OF_TEXT
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=EUC-JP">
<title>$title</title>
</head><body>
<h3>$title</h3>
<hr>
END_OF_TEXT;

	$this->echo_write_data($text);
}

function html_footer()
{
	$url_index = $this->module_url.'/admin/index.php';
	$index = _WEBLINKS_ADMIN_GOTO_ADMIN_INDEX;

	$text = <<<END_OF_TEXT
<br />
<hr>
<a href='$url_index'>$index</a><br />
</head></html>
END_OF_TEXT;

	$this->echo_write_data($text);
}

//---------------------------------------------------------
// result file
//---------------------------------------------------------
function file_open($filename)
{
	$file_result      = $this->module_root."/cache/".$filename;
	$this->url_result = $this->module_url. "/cache/".$filename;

	if ($this->flag_write)
	{
		$this->fp = fopen($file_result, "w");
	}
}

function file_close()
{
	if ($this->flag_write && $this->fp)
	{
		fclose($this->fp);
	}
}

function echo_write_data($data)
{
	if ($this->flag_echo)
	{
		echo $data;
	}

	if ($this->flag_write)
	{
		fwrite($this->fp, $data);
	}
}

//---------------------------------------------------------
// mail
//---------------------------------------------------------
function send_mail($title, $content)
{
	$mailto  = $this->adminmail;
	$subject = "[$this->sitename] $title";
	$body    = $this->build_mail_body($title, $content);

	$header  = "From: $this->adminmail\n";

// BUG 3209: typo X-Mailer 
	$header .= "X-Mailer: $this->X_MAILER\n"; 

	return $this->lang->send_mail($mailto, $subject, $body, $header);

}

function build_mail_body($title, $body)
{
	$siteurl = XOOPS_URL."/";

	$text = <<<END_OF_TEXT
$title

$body

You can view detail here:
$this->url_result

-----------
$this->sitename ( $siteurl )
webmaster
$this->adminmail
-----------
END_OF_TEXT;

	return $text;
}

//---------------------------------------------------------
}

?>