<?php
// $Id: category_manage.php,v 1.6 2006/01/16 07:20:54 ohwada Exp $

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin category manage
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
include_once $MODULE_ROOT."/class/weblinks_form_extend.php";

$op = 'main';
if     ( isset($_POST['op']) )  $op = $_POST['op'];
elseif ( isset($_GET['op']) )   $op = $_GET['op'];

// start
$tbl_category->getAll();

switch ($op) 
{
case "addCat":
	addCat();
	break;

case "modCat":
	modCat();
	break;

case "modCatS":
	modCatS();
	break;

case "delCat":
	delCat();
	break;

case "reorderCat":
	reorderCat();
	break;

case 'main':
default:
	categoryMenu();
	break;

}

exit();
// --- end of main ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function categoryMenu()
{
	global $tbl_category;

	xoops_cp_header();

	echo "<h3>"._WLS_WEBLINKSCONF."</h3>\n";
	echo "<h4>"._WEBLINKS_ADMIN_CATEGORY_MANAGE."</h4>\n";

	$total = $tbl_category->getNumAll();
	printf(_WEBLINKS_THERE_ARE_CATEGORY, $total);
    echo "<br /><br />\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo " - <a href='index.php'>"._WEBLINKS_ADMIN_INDEX."</a>";
	echo "<br /><br />\n";
	echo " - <a href='category_list.php'>"._WEBLINKS_ADMIN_CATEGORY_LIST."</a>";
	echo "<br /><br />\n";
	echo"</td></tr></table>\n";

// Add a New Main Category
	CategoryFormAddMain();
    echo "<br />\n";

// Add a New Sub-Category
    if ( $total > 0 ) 
    {
		CategoryFormAddSub();
		echo "<br />\n";

// Modify Category
		CategoryFormModCatSelect();
		echo "<br />\n";

// Delete Category
		CategoryFormDelCat();
		echo "<br />\n";
    }

	xoops_cp_footer();
}

function modCat()
{
	global $tbl_category;

	$cid = 0;
	if     ( isset($_POST['cid']) )  $cid = $_POST['cid'];
	elseif ( isset($_GET['cid']) )   $cid = $_GET['cid'];

	xoops_cp_header();

	echo "<h4>"._WLS_WEBLINKSCONF."</h4>";
	echo "<h4>"._WEBLINKS_ADMIN_ADDMODDEL_CATEGORY."</h4>\n";

	$total = $tbl_category->getNumAll();
	printf(_WEBLINKS_THERE_ARE_CATEGORY, $total);
    echo "<br /><br />\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo " - <a href='category_list.php'>"._WEBLINKS_ADMIN_CATEGORY_LIST."</a>";
	echo "<br /><br />\n";
	echo"</td></tr></table>\n";

	$record = $tbl_category->getRowByCid($cid);
	CategoryFormModCat($record);

	xoops_cp_footer();
}

function modCatS()
{
   	global $eh;
   	global $tbl_category;

	$cid   = 0;
	$title = '';
	if ( isset($_POST['cid']) )    $cid   = intval( $_POST['cid'] );
	if ( isset($_POST['title']) )  $title = $_POST['title'];

// system error
	if (empty($cid))
	{
	    redirect_header("category_manage.php", 2, _WLS_ERROR_CATEGORY);
	}

// form check
	if ( empty($title) ) 
	{  redirect_header("category_manage.php", 2, _WLS_ERRORTITLE);  }

	$tbl_category->clearItems();
   	$tbl_category->setItems( $_POST );
   	$tbl_category->update( $cid ) or $eh->show("0013");

    redirect_header("category_list.php",1,_WLS_DBUPDATED);
}

function delCat()
{
   	global $eh;
   	global $tbl_catlink, $tbl_category, $tbl_link;

	$MAX_SUBCAT_DEL  = 4;
	$MAX_LINK_BELONG = 10;
	$MAX_LINK_DEL    = 10;

	$cid = 0;
	if     ( isset($_POST['cid']) )  $cid = intval( $_POST['cid'] );
	elseif ( isset($_GET['cid']) )   $cid = intval( $_GET['cid'] );

	$ok  = '';
	if ( isset($_POST['ok']) )   $ok = intval( $_POST['ok'] );

// system error
	if (empty($cid))
	{
	    redirect_header("category_manage.php", 2, _WLS_ERROR_CATEGORY);
	}

	xoops_cp_header();

    if ( $ok == 1 ) 
	{
		echo "<h3>"._WLS_DELCAT."</h3>\n";
	}
	else
	{
		echo "<h3><font color=blue>"._WLS_WARNING."</font></h3>\n";
	}

// The specified category
	echo "<h4>"._WLS_CATEGORY."</h4>\n";

	$rec_cat = $tbl_category->getRowByCid($cid);
	echo "$cid: {$rec_cat['title']} <br>\n";

// sub categories
	echo "<h4>"._WLS_SUBCATEGORY."</h4>\n";

	$sub_arr   = $tbl_category->getAllChildId($cid);
	$sub_count = count($sub_arr);
	if ($sub_count > 0)
	{
		foreach ($sub_arr as $sub) 
		{
			$rec_sub = $tbl_category->getRowByCid($sub);
			echo "$sub: {$rec_sub['title']} <br>\n";
		}
	}
	else
	{
		echo _WLS_SUBCATEGORY_NON."<br>\n";
	}

// limit over
	if ($sub_count > $MAX_SUBCAT_DEL)
	{
		echo "<br>\n";
		echo "<font color=red>"._WLS_ERROR_MAX_SUBCAT."</font> ($MAX_SUBCAT_DEL) <br>\n";
		echo "<h4><a href=\"index.php\">"._WLS_GOTOADMIN."</a></h4>\n";
		xoops_cp_footer();
		exit();
	}

// all link belonging to this category
	echo "<h4>"._WLS_LINK_BELONG."</h4>\n";

	$cat_arr    = array_merge( array($cid), $sub_arr );
	$lid_arr    = $tbl_catlink->getLidArrayByCidArray($cat_arr);
	$cid_count  = count($cat_arr);
	$link_count = count($lid_arr);
	$link_del_count = 0;

	if ($link_count > 0)
	{
		echo _WLS_LINK_BELONG_NUMBER.": ".count($lid_arr)."<br>\n";
		echo "<h4>"._WLS_LINK_MAYBE_DELETE."</h4>\n";

		if ($cid_count > 0)
		{
			echo _WLS_LINK_MAYBE_DELETE_DSC."<br><br>\n";
		}

		foreach ($lid_arr as $lid)
		{

// get the number of the categories belonging to this link 
			$num = $tbl_catlink->getNumByLid($lid);

// the link belongs only to this category
			if ($num == 1)
			{
				$rec_link = $tbl_link->getRowByLid($lid);
				echo "$lid: {$rec_link['title']} <br>\n";
				$link_del_count ++;
			}
		}

		if ($link_del_count == 0)
		{
			echo _WLS_LINK_DELETE_NON."<br>\n";
		}
	}
	else
	{
		echo _WLS_LINK_BELONG_NON."<br>\n";
	}

// limit over
	if ($link_del_count > $MAX_LINK_DEL)
	{
		echo "<br>\n";
		echo "<font color=red>"._WLS_ERROR_MAX_LINK_DEL."</font> ($MAX_LINK_DEL) <br>\n";
		echo "<h4><a href=\"index.php\">"._WLS_GOTOADMIN."</a></h4>\n";
		xoops_cp_footer();
		exit();
	}

// limit over
	if ($link_count > $MAX_LINK_BELONG)
	{
		echo "<br>\n";
		echo "<font color=red>"._WLS_ERROR_MAX_LINK_BELONG."</font> ($MAX_LINK_BELONG) <br>\n";
		echo "<h4><a href=\"index.php\">"._WLS_GOTOADMIN."</a></h4>\n";
		xoops_cp_footer();
		exit();
	}

// excute
    if ( $ok == 1 ) 
    {
		echo "<br><hr>\n";
		echo "<h4>"._WLS_CATEGORY_LINK_DELETE_EXCUTE."</h4>\n";

// sub category
		foreach ($sub_arr as $sub) 
		{
			deleteCategory( $sub );
		}

		deleteCategory($cid);

		echo "<h4>"._WLS_CATEGORY_LINK_DELETED."</h4>\n";
		echo "<h4><a href=\"index.php\">"._WLS_GOTOADMIN."</a></h4>\n";
		echo "<br><hr><br>\n";
		xoops_cp_footer();
		exit();
	}

// confirm
	else 
	{
		CategoryFormDelCatOk($cid);

		xoops_cp_footer();
		exit();
    }
}

function deleteCategory($cid)
{
	global $xoops_module_mid;
	global $tbl_catlink, $tbl_category, $tbl_link, $tbl_votedata;

// get the link id is belonging to this category 
	$lid_arr = $tbl_catlink->getLidArrayByCid($cid);
	foreach ($lid_arr as $lid)
	{

// get the number of the categories belonging to this link 
		$num = $tbl_catlink->getNumByLid($lid);

// delete this link, if it belongs only to this category
		if ($num == 1)
		{
			$rec_link = $tbl_link->getRowByLid($lid);
			echo _WLS_LINK_DELETED.": $lid: {$rec_link['title']} <br>\n";

// BUG 3095: the number of links does not change, if delete link
//			$tbl_link->delete($lid)           or $eh->show("0013");
//			$tbl_votedata->deleteByLid($lid)  or $eh->show("0013");
//			xoops_comment_delete( $xoops_module_mid, $lid );
//			xoops_notification_deletebyitem( $xoops_module_mid, 'link', $lid );

			del_link_vote_comm_by_lid($lid);
		}
	}

// delete category
	$rec_cat = $tbl_category->getRowByCid($cid);
	echo _WLS_CATEGORY_DELETED.": $cid: {$rec_cat['title']} <br>\n";

	$tbl_catlink->deleteByCid($cid) or $eh->show("0013");
	$tbl_category->delete($cid)     or $eh->show("0013");

// delete comments & notifications
	xoops_notification_deletebyitem( $xoops_module_mid, 'category', $cid );

}

function addCat()
{
	global $eh;
	global $tbl_category;
	global $MODULE_URL;

	$title = '';
	if ( isset($_POST['title']) )  $title = $_POST['title'];

// system error
	if ( !isset($_POST['pid']) )
	{
	    redirect_header("category_manage.php", 2, _WLS_ERROR_CATEGORY);
	}

// form check
	if ( empty($title) ) 
	{  redirect_header("category_manage.php", 2, _WLS_ERRORTITLE);  }

	$tbl_category->clearItems();
	$tbl_category->setItems( $_POST );
	$tbl_category->insert() or $eh->show("0013");
	$newid = $tbl_category->getNewid();

	$tags = array();
	$tags['CATEGORY_NAME'] = $tbl_category->getTitle();
	$tags['CATEGORY_URL'] = $MODULE_URL."/viewcat.php?cid=$newid";
	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_category', $tags);
	redirect_header("category_list.php",1,_WLS_NEWCATADDED);
}

function reorderCat()
{
	global $tbl_category;
	global $eh;

	$order_arr = '';
	if ( isset($_POST['orders']) )  $order_arr = $_POST['orders'];

	foreach ($order_arr as $key => $value)
	{
		$cid    = intval($key);
		$orders = intval($value);
		$tbl_category->updateOrders($cid, $orders) or $eh->show("0013");
	}

	redirect_header("category_list.php", 1, _WEBLINKS_ORDERS_UPDATED);
	exit();
}

function CategoryFormAddMain()
{
	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_ADDMAIN, 'addMain' );
	$builder->add_hidden('op', 'addCat');
	$builder->add_hidden('pid', 0);
	$builder->add_text(_WLS_TITLEC, 'title', '', true);
	$builder->add_radio_array('', 'lflag', 1, get_option_lflag(), true );
	$builder->add_text(_WEBLINKS_CAT_ORDER, 'orders', 1, true);
	$builder->add_caption_full( _WEBLINKS_IMGURL_MAIN, _WEBLINKS_IMGURL_MAIN_DSC1 );
	$builder->add_text_full('imgurl', 'http://', 100, 255);
	$builder->add_submit_button( '', 'post', _WLS_ADD );
	$builder->display();
}

function CategoryFormAddSub()
{
	global $tbl_category;
	$category = $tbl_category->makeMySelBox(0, 0, 'pid');

	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_ADDSUB, 'addSub' );
	$builder->add_hidden('op', 'addCat');
	$builder->add_text(_WLS_TITLEC, 'title', '', true);
	$builder->add_radio_array('', 'lflag', 1, get_option_lflag(), true );
	$builder->add_text(_WEBLINKS_CAT_ORDER, 'orders', 1, true);
	$builder->add_label(_WLS_PARENT, $category );
	$builder->add_submit_button( '', 'post', _WLS_ADD );
	$builder->display();

}

function CategoryFormModCatSelect()
{
	global $tbl_category;
	$category = $tbl_category->makeMySelBox(0, 0, 'cid');

	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_MODCAT, 'modCatSelect' );
	$builder->add_hidden('op', 'modCat');
	$builder->add_label( _WLS_CATEGORY, $category );
	$builder->add_submit_button( '', 'post', _WLS_MODIFY );
	$builder->display();

}


function CategoryFormModCat($record)
{
	global $myts;

	global $tbl_category;
	$category = $tbl_category->makeMySelBox( $record['pid'], 1, 'pid' );

	$cid    = $record['cid'];
	$title  = $myts->makeTboxData4Edit( $record['title'] );
	$imgurl = $myts->makeTboxData4Edit( $record['imgurl'] );

// form
	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_MODCAT, 'modCat' );
	$builder->add_hidden('op', 'modCatS');
	$builder->add_hidden('cid', $cid);
	$builder->add_label(_WLS_CATEGORYID, '<b>'.$cid.'</b>' );
	$builder->add_text(_WLS_TITLEC, 'title', $title, true);
	$builder->add_radio_array('', 'lflag', $record['lflag'], get_option_lflag(), true );
	$builder->add_text(_WEBLINKS_CAT_ORDER, 'orders', $record['orders'], true);
	$builder->add_label(_WLS_PARENT, $category );

	$desc_imgurl = _WEBLINKS_IMGURL_MAIN_DSC1.'<br />'._WEBLINKS_IMGURL_MAIN_DSC2;
	$builder->add_caption_full( _WEBLINKS_IMGURL_MAIN, $desc_imgurl );
	$builder->add_text_full('imgurl', $imgurl, 100, 250);

// button
	$url = "category_manage.php?op=delCat&amp;cid=".$cid;

// BUG 2828: submit form is not displayed correctly
// not use add_tray_xxx
//	$builder->start_tray($caption);
//	$builder->add_tray_submit_button('', 'post', _WLS_SAVE );
//	$builder->add_tray_jump_button(  '', 'delete', _DELETE, $url );
//	$builder->add_tray_cancel_button('', 'cancel', _CANCEL );
//	$builder->add_element_tray();

	$tray_button = new XoopsFormElementTray( '' );
	$tray_button->addElement( $builder->make_submit_button( '', 'post',    _WLS_SAVE ) );
	$tray_button->addElement( $builder->make_jump_button(   '', 'delete', _DELETE, $url ) );
	$tray_button->addElement( $builder->make_cancel_button( '', 'cancel',  _CANCEL ) );
	$builder->add_element( $tray_button );

	$builder->display();
}

function CategoryFormDelCat()
{
	global $tbl_category;
	$category = $tbl_category->makeMySelBox(0, 0, 'cid');

	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_DELCAT, 'delCat' );
	$builder->add_hidden('op', 'delCat');
	$builder->add_label( _WLS_CATEGORY, $category );
	$builder->add_submit_button( '', 'post', _DELETE );
	$builder->display();

}


function CategoryFormDelCatOk($cid)
{
	$builder = new weblinks_form_extend();
	$builder->start_theme_form( _WLS_DELCAT, 'delCat' );
	$builder->add_hidden('op', 'delCat');
	$builder->add_hidden('ok', 1);
	$builder->add_hidden('cid', $cid);

// button
	$url = "category_manage.php";
	$builder->add_submit_jump_button('', 'post', _DELETE, 'cancel', _CANCEL, $url);

	$builder->display();

}

function get_option_lflag()
{
	$opt = array(
		0 => ' '._WLS_NOTLINKFLAG,
		1 => ' '._WLS_LINKFLAG,
		);

	return $opt;
}

?>
