<?php
/*
* This function accept URI like http://search.example.com/search.cgi?query=foo&p=bar
* and return array which includes domain and search words.
* You can add search engine domains and word query via a file "./searchengines.php" .
* Author : Takashi Itoh(japanese part) 	itoh@tohokuaiki.jp	
*/

function refererurl2word( $URI , $searchengine_file="./searchengines.php" , $pattern="array" , $lang="japanese"){

	$searchengine_regulated = set_regurated_se($searchengine_file) ;
	if( $searchengine_regulated && is_array($searchengine_regulated) ){
		// parse URI
		$parse_uri = parse_url( trim($URI) ) ;
		foreach( $searchengine_regulated as $searchengine_host => $query_key_tmp){
			if( @preg_match( "/$searchengine_host/" , $parse_uri['host'] ) ){
				$query_key = $query_key_tmp ;
			}
		}
		// get search word query
		foreach( explode( "&" , $parse_uri['query'] ) as $query_combined ){
			if( preg_match( "/([^=]*)=(.*)/" , $query_combined , $query_match) ){
				if( $query_key ==  $query_match[1] ){
					$searchword_parts = $query_match[2] ;
				}
			}
		}
		if( $searchword_parts ){
			$word = trans_searchword_to_array($searchword_parts , $pattern) ;
			return( $word ) ;
		}
	}else{
		return( "cant open file" ) ;
	}
}


// set regulated searchengine infomations
function set_regurated_se($searchengine_file){
	if( ! file_exists( $searchengine_file ) ){
		return( false ) ;
	}else{
		if($fp = @fopen( $searchengine_file , "r" ) ){
			$searchengine_regulated = array() ;
			while( ! feof($fp) ){
				$se_line = fgets( $fp ) ;
				if( ! preg_match("/^#.+/" , $se_line ) && preg_match( "/^([^\t\s]+)\t+([^\s]+)/", trim($se_line) , $se_matches ) ){
					$searchengine_regulated[$se_matches[1]] = $se_matches[2] ;
				}
			}
		}
		return( $searchengine_regulated ) ;
	}
}

// decode search_word to JAPANESE
function trans_searchword_to_array($searchword_parts , $pattern="array" , $lang="japanese" ){
	if($lang == "japanese"){
		mb_detect_order("ASCII,JIS,EUC-JP,UTF-8,SJIS");
		$decode_url_word = urldecode($searchword_parts);
		$enc = mb_detect_encoding($decode_url_word);
		$word = mb_convert_encoding($decode_url_word,"EUC-JP","$enc");
		$word = str_replace("" , " " , $word) ;
		if($pattern == "array"){
			$word = explode(" " , $word) ;
		}
	}
	return( $word ) ;
}

?>