<?php
class Cacher { 
	# Where things are cached. 
	# must have trailing slash! 
	var $cacheDir; 
	/* How long to cache something for in seconds */ 
	var $defaultCacheLife = '3600'; 

	/* Set($varId, $varValue) -- 
	 * Creates a file named "cache.VARID.TIMESTAMP" 
	 * and fills it with the serialized value from $varValue. 
	 * If a cache file with the same varId exists, Delete() 
	 * will remove it. */ 
	function Cacher($Dir = './cache/') {
		$this->cacheDir = $Dir;
	}
	
	function Set($varId, $varValue) { 
		# Clean up old caches with same varId 
		$this->Delete($varId); 
		# Create new file 
		$fileHandler = fopen ($this->cacheDir."cache.".$varId.".".time (), "a"); 
		# Write serialized data
		$temp = serialize ($varValue);
		fwrite ($fileHandler, $temp); 
		fclose ($fileHandler); 
	}

	/* Get($varID, $cacheLife) -- 
	 * Retrives the value inside a cache file 
	 * specified by $varID if the expiration time 
	 * (specified by $cacheLife) is not over. 
	 * If expired, returns FALSE */ 
	function Get($varId, $cacheLife="") { 
		/* Set default cache life */ 
		$cacheLife = (!empty ($cacheLife)) ? $cacheLife : $this->defaultCacheLife; 

		/* Loop through the directory looking for cache file */ 
		$dirHandler = dir ($this->cacheDir); 
		while ($file = $dirHandler->read()) { 
			/* Check for cache file with requested varId */ 
			if (preg_match ("/cache.$varId.[0-9]/", $file)) { 
				/* Cache filename array */ 
				$cacheFileName = explode (".", $file); 
				/* Cache file creation time */ 
				$cacheFileLife = $cacheFileName[2]; 
				/* Full location */ 
				$cacheFile = $this->cacheDir.$file; 

				/* Check to see if cache file has expired or not */ 
				if ((time () - $cacheFileLife) < $cacheLife) { 
					$fileHandler = fopen ($cacheFile, "r"); 
					$varValueResult = fread ($fileHandler, 
						filesize ($cacheFile)); 
					fclose ($fileHandler); 
					/* Still good, return unseralized data */ 
					return unserialize ($varValueResult); 
				} else { 
					 /* Cache expired, break loop */ 
					break; 
				} 
			} 
		} 
		$dirHandler->close(); 
		return FALSE; 
	} 

	/* Delete($varId) -- 
	 * Loops through the cache directory and 
	 * removes any cache files with the varId 
	 * specified in $varID */ 
	function Delete($varId) { 
		$dirHandler = dir ($this->cacheDir); 
		while ($file = $dirHandler->read()) { 
			if (preg_match ("/cache.$varId.[0-9]/", $file)) { 
				/* Delete cache file */ 
				unlink ($this->cacheDir.$file); 
			} 
		} 
		$dirHandler->close(); 
	} 

	function ALLDelete() { 
		$dirHandler = dir ($this->cacheDir); 
		while ($file = $dirHandler->read()) { 
			if (preg_match ("/cache/", $file)) { 
				unlink ($this->cacheDir.$file); 
			} 
		} 
		$dirHandler->close(); 
	} 

} /* end class */ 

?> 
