/**********************************************************************

  wx.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:49 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "rubysig.h"

#ifdef __WXMSW__
#include "wx/msw/private.h"
#endif

#include "timer.h"
#include "point.h"
#include "icon.h"
#include "date.h"
#include "app.h"
#include "frame.h"
#include "checkbox.h"
#include "radio.h"
#include "choice.h"
#include "combobox.h"
#include "listbox.h"
#include "gauge.h"
#include "spin.h"
#include "slider.h"
#include "menu.h"
#include "menubar.h"
#include "event.h"
#include "layout.h"
#include "rect.h"
#include "colour.h"
#include "dc.h"
#include "font.h"
#include "colourdata.h"
#include "fontdata.h"
#include "size.h"
#include "textctrl.h"
#include "calendar.h"
#include "statictext.h"
#include "bitmap.h"
#include "button.h"
#include "dialog.h"
#include "filedialog.h"
#include "dirdialog.h"
#include "colourdialog.h"
#include "fontdialog.h"
#include "messagedialog.h"
#include "sizer.h"
#include "evthandler.h"
#include "window.h"
#include "artprovider.h"
#include "log.h"
#include "list.h"
#include "listctrl.h"
#include "panel.h"
#include "brush.h"
#include "pen.h"
#include "palette.h"
#include "caret.h"
#include "statusbar.h"
#include "scrolledwindow.h"
#include "validator.h"
#include "ownerdrawn.h"
#include "config.h"
#include "region.h"
#include "cursor.h"
#include "notebook.h"
#include "tooltip.h"
#include "toolbar.h"
#include "mask.h"
#include "socket.h"
#include "url.h"
#include "stream.h"
#include "image.h"
#include "treectrl.h"

#define ruby_debug 	1

static FILE *f;
#define DUMP1(ARG1) if (ruby_debug) { f=fopen("test.dmp","a+");fprintf(f, "wxruby: %s\n", ARG1);fclose(f);}
#define DUMP2(ARG1, ARG2) if (ruby_debug) { f=fopen("test.dmp","a+");fprintf(f, "wxruby: ");\
fprintf(f, ARG1, ARG2); fprintf(f, "\n"); fclose(f); }

#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

#ifdef __WXGTK__
int  wxEntryStart(int& argc, char**argv);
#else
int  wxEntryStart(int argc, char**argv);
#endif

void wxEntryCleanup();
void SetConstant();


VALUE mWx;
VALUE rb_cWxApp;
VALUE rb_cWxClassInfo;
VALUE rb_cWxFrame;
VALUE rb_cWxCursor;
VALUE rb_cWxBusyCursor;
VALUE rb_cWxCheckBox;
VALUE rb_cWxRadioBox;
VALUE rb_cWxRadioButton;
VALUE rb_cWxChoice;
VALUE rb_cWxComboBox;
VALUE rb_cWxListItem;
VALUE rb_cWxListItemAttr;
VALUE rb_cWxListBox;
VALUE rb_cWxListCtrl;
VALUE rb_cWxGauge;
VALUE rb_cWxSlider;
VALUE rb_cWxCheckListBox;
VALUE rb_cWxDateTime;
VALUE rb_cWxMenu;
VALUE rb_cWxMenuBar;
VALUE rb_cWxPoint;
VALUE rb_cWxIcon;
VALUE rb_cWxLayoutConstraints;
VALUE rb_cWxIndividualLayoutConstraint;
VALUE rb_cWxRect;
VALUE rb_cWxRegion;
VALUE rb_cWxColour;
VALUE rb_cWxDC;
VALUE rb_cWxMemoryDC;
VALUE rb_cWxWindowDC;
VALUE rb_cWxClientDC;
VALUE rb_cWxPaintDC;
VALUE rb_cWxFont;
VALUE rb_cWxFontData;
VALUE rb_cWxColourData;
VALUE rb_cWxSize;
VALUE rb_cWxTextCtrl;
VALUE rb_cWxSpinCtrl;
VALUE rb_cWxSpinButton;
VALUE rb_cWxCalendarCtrl;
VALUE rb_cWxCalendarDateAttr;
VALUE rb_cWxStaticText;
VALUE rb_cWxStaticBox;
VALUE rb_cWxStaticLine;
VALUE rb_cWxButton;
VALUE rb_cWxTimer;
VALUE rb_cWxStopWatch;
VALUE rb_cWxBitmapButton;
VALUE rb_cWxToggleButton;
VALUE rb_cWxDialog;
VALUE rb_cWxFindReplaceData;
VALUE rb_cWxProgressDialog;
VALUE rb_cWxTextEntryDialog;
VALUE rb_cWxSingleChoiceDialog;
VALUE rb_cWxFileDialog;
VALUE rb_cWxDirDialog;
VALUE rb_cWxColourDialog;
VALUE rb_cWxFontDialog;
VALUE rb_cWxMessageDialog;
VALUE rb_cWxWindow;
VALUE rb_cWxSplitterWindow;
VALUE rb_cWxEvent;
VALUE rb_cWxKeyEvent;
VALUE rb_cWxCloseEvent;
VALUE rb_cWxCommandEvent;
VALUE rb_cWxListEvent;
VALUE rb_cWxTreeEvent;
VALUE rb_cWxSizeEvent;
VALUE rb_cWxSocketEvent;
VALUE rb_cWxMoveEvent;
VALUE rb_cWxSpinEvent;
VALUE rb_cWxNotifyEvent;
VALUE rb_cWxSplitterEvent;
VALUE rb_cWxNotebookEvent;
VALUE rb_cWxPaintEvent;
VALUE rb_cWxCalendarEvent;
VALUE rb_cWxUpdateUIEvent;
VALUE rb_cWxSizer;
VALUE rb_cWxBoxSizer;
VALUE rb_cWxNotebookSizer;
VALUE rb_cWxStaticBoxSizer;
VALUE rb_cWxGridSizer;
VALUE rb_cWxFlexGridSizer;
VALUE rb_cWxBitmap;
VALUE rb_cWxStaticBitmap;
VALUE rb_cWxArtProvider;
VALUE rb_cWxLog;
VALUE rb_cWxLogTextCtrl;
VALUE rb_cWxList;
VALUE rb_cWxImage;
VALUE rb_cWxImageList;
VALUE rb_cWxPanel;
VALUE rb_cWxNotebook;
VALUE rb_cWxBrush;
VALUE rb_cWxPen;
VALUE rb_cWxPalette;
VALUE rb_cWxCaret;
VALUE rb_cWxStatusBar;
VALUE rb_cWxToolBar;
VALUE rb_cWxScrolledWindow;
VALUE rb_cWxValidator;
VALUE rb_cWxOwnerDrawn;
VALUE rb_cWxConfig;
VALUE rb_cWxConfigBase;
VALUE rb_cWxEvtHandler;
VALUE rb_cWxToolTip;
VALUE rb_cWxMask;
VALUE rb_cWxTipProvider;
VALUE rb_cWxWindowDisabler;
VALUE rb_cWxBusyInfo;
VALUE rb_cWxFindReplaceDialog;
VALUE rb_cWxFindDialogEvent;
VALUE rb_cWxSocketBase;
VALUE rb_cWxSocketClient;
VALUE rb_cWxSocketServer;
VALUE rb_cWxProtocol;
VALUE rb_cWxURL;
VALUE rb_cWxStreamBase;
VALUE rb_cWxInputStream;
VALUE rb_cWxOutputStream;
VALUE rb_cWxFileOutputStream;
VALUE rb_cWxTreeItemData;
VALUE rb_cWxTreeCtrl;

VALUE rb_cRbApp;

static VALUE
WxGetApp(VALUE self)
{
    return rb_cRbApp;
}

static VALUE
WxMessageBox(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxString caption = "Message";
    int style = wxOK | wxCENTRE;
    wxWindow *parent = NULL;
    int x = -1;
    int y = -1;
    if(argc>1 && TYPE(argv[1])==T_STRING)
      caption = StringValuePtr(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_FIXNUM)
      style = NUM2INT(argv[2]);
    if(argc>3 && TYPE(argv[3])==T_DATA)
    	Data_Get_Struct(self, wxWindow, parent);

    return INT2NUM(wxMessageBox(message,caption,style,parent,x,y));
}

static void
WxBell(VALUE self)
{
    wxBell();
}

static VALUE
WxYield(VALUE self)
{
    return (wxYield() ? Qtrue : Qfalse);
}

static VALUE
WxSetWorkingDirectory(VALUE self,VALUE vd)
{
    return (wxSetWorkingDirectory(StringValuePtr(vd)) ? Qtrue : Qfalse);
}

static VALUE
WxGetCwd(VALUE self)
{
    return rb_str_new2(wxGetCwd());
}

static VALUE
WxGetEmailAddress(VALUE self)
{
    return rb_str_new2(wxGetEmailAddress());
}

static VALUE
WxGetHostName(VALUE self)
{
    return rb_str_new2(wxGetHostName());
}

static VALUE
WxGetFullHostName(VALUE self)
{
    return rb_str_new2(wxGetFullHostName());
}

static VALUE
WxGetUserId(VALUE self)
{
    return rb_str_new2(wxGetUserId());
}

static VALUE
WxGetUserName(VALUE self)
{
    return rb_str_new2(wxGetUserName());
}

static VALUE
WxGetHomeDir(VALUE self)
{
    return rb_str_new2(wxGetHomeDir());
}

static void
WxLogMessage(int argc, VALUE *argv, VALUE self)
{
    VALUE str = rb_f_sprintf(argc, argv);
    wxLogMessage(StringValuePtr(str));
}

static void
WxLogError(int argc, VALUE *argv, VALUE self)
{
    VALUE str = rb_f_sprintf(argc, argv);
    wxLogError(StringValuePtr(str));
}

static void
WxLogWarning(int argc, VALUE *argv, VALUE self)
{
    VALUE str = rb_f_sprintf(argc, argv);
    wxLogWarning(StringValuePtr(str));
}

static void
WxLogStatus(int argc, VALUE *argv, VALUE self)
{
    if(TYPE(argv[0])==T_DATA) {
        wxFrame *ptr;
        Data_Get_Struct(argv[0], wxFrame, ptr);
        VALUE str = rb_f_sprintf(argc-1, &argv[1]);
        wxLogStatus(ptr,StringValuePtr(str));
    }
    else {
        VALUE str = rb_f_sprintf(argc, argv);
        wxLogStatus(StringValuePtr(str));
    }
}

static VALUE
WxGetNumberFromUser(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxString prompt = StringValuePtr(argv[1]);
    wxString caption = StringValuePtr(argv[2]);
    long value = 0;
    if(argc>3) value = NUM2INT(argv[3]);
    long min = 0;
    if(argc>4) min = NUM2INT(argv[4]);
    long max = 100;
    if(argc>5) max = NUM2INT(argv[5]);
    wxWindow *parent = (wxWindow *)NULL;
    if(argc>6) {
        Data_Get_Struct(argv[6], wxWindow, parent);
    }
    wxPoint pos = wxDefaultPosition;
    if(argc>7) {
        wxPoint *ptr;
        Data_Get_Struct(argv[7], wxPoint, ptr);
        pos = *ptr;
    }
    return INT2NUM(wxGetNumberFromUser(message,prompt,caption,value,min,max,parent,pos));
}

static VALUE
WxGetTextFromUser(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxString caption = wxGetTextFromUserPromptStr;
    if(argc>1) caption = StringValuePtr(argv[1]);
    wxString default_value = wxEmptyString;
    if(argc>2) default_value = StringValuePtr(argv[2]);
    wxWindow *parent = (wxWindow *)NULL;
    if(argc>3) {
        Data_Get_Struct(argv[3], wxWindow, parent);
    }
    int x = -1;
    if(argc>4) x = NUM2INT(argv[4]);
    int y = -1;
    if(argc>5) x = NUM2INT(argv[5]);
    bool centre = TRUE;
    if(argc>6 && argv[6]==Qfalse) centre = FALSE;
    return rb_str_new2(wxGetTextFromUser(message,caption,default_value,parent,x,y,centre));
}

static VALUE
WxGetPasswordFromUser(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxString caption = wxGetTextFromUserPromptStr;
    if(argc>1) caption = StringValuePtr(argv[1]);
    wxString default_value = wxEmptyString;
    if(argc>2) default_value = StringValuePtr(argv[2]);
    wxWindow *parent = (wxWindow *)NULL;
    if(argc>3) {
        Data_Get_Struct(argv[3], wxWindow, parent);
    }
    return rb_str_new2(wxGetPasswordFromUser(message,caption,default_value,parent));
}

static VALUE
WxGetSingleChoice(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxString caption = wxGetTextFromUserPromptStr;
    if(argc>1) caption = StringValuePtr(argv[1]);
    int n;
    wxString *choices;
    n = RARRAY(argv[2])->len;
    choices = new wxString[n];
    for (int i = 0; i < n; i++) {
        choices[i] = StringValuePtr(RARRAY(argv[2])->ptr[i]);
    }
    wxWindow *parent = (wxWindow *)NULL;
    if(argc>3) {
        Data_Get_Struct(argv[3], wxWindow, parent);
    }
    int x = -1;
    if(argc>4) x = NUM2INT(argv[4]);
    int y = -1;
    if(argc>5) y = NUM2INT(argv[5]);
    bool centre = TRUE;
    if(argc>6 && argv[6]==Qfalse) centre = FALSE;
    int width = wxCHOICE_WIDTH;
    if(argc>7) width = NUM2INT(argv[7]);
    int height = wxCHOICE_HEIGHT;
    if(argc>8) height = NUM2INT(argv[8]);

    return rb_str_new2(wxGetSingleChoice(message,caption,n,choices,parent,x,y,centre,width,height));
}

static VALUE
WxGetSingleChoiceIndex(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxString caption = wxGetTextFromUserPromptStr;
    if(argc>1) caption = StringValuePtr(argv[1]);
    int n;
    wxString *choices;
    n = RARRAY(argv[2])->len;
    choices = new wxString[n];
    for (int i = 0; i < n; i++) {
        choices[i] = StringValuePtr(RARRAY(argv[2])->ptr[i]);
    }
    wxWindow *parent = (wxWindow *)NULL;
    if(argc>3) {
        Data_Get_Struct(argv[3], wxWindow, parent);
    }
    int x = -1;
    if(argc>4) x = NUM2INT(argv[4]);
    int y = -1;
    if(argc>5) y = NUM2INT(argv[5]);
    bool centre = TRUE;
    if(argc>6 && argv[6]==Qfalse) centre = FALSE;
    int width = wxCHOICE_WIDTH;
    if(argc>7) width = NUM2INT(argv[7]);
    int height = wxCHOICE_HEIGHT;
    if(argc>8) height = NUM2INT(argv[8]);

    return INT2NUM(wxGetSingleChoiceIndex(message,caption,n,choices,parent,x,y,centre,width,height));
}

static VALUE
WxGetMultipleChoices(int argc, VALUE *argv, VALUE self)
{
    wxArrayInt selections;
    wxString message = StringValuePtr(argv[0]);
    wxString caption = wxGetTextFromUserPromptStr;
    if(argc>1) caption = StringValuePtr(argv[1]);
    int n,i;
    wxString *choices;
    n = RARRAY(argv[2])->len;
    choices = new wxString[n];
    for (i = 0; i < n; i++) {
        choices[i] = StringValuePtr(RARRAY(argv[2])->ptr[i]);
    }
    wxWindow *parent = (wxWindow *)NULL;
    if(argc>3) {
        Data_Get_Struct(argv[3], wxWindow, parent);
    }
    int x = -1;
    if(argc>4) x = NUM2INT(argv[4]);
    int y = -1;
    if(argc>5) y = NUM2INT(argv[5]);
    bool centre = TRUE;
    if(argc>6 && argv[6]==Qfalse) centre = FALSE;
    int width = wxCHOICE_WIDTH;
    if(argc>7) width = NUM2INT(argv[7]);
    int height = wxCHOICE_HEIGHT;
    if(argc>8) height = NUM2INT(argv[8]);

    int r = wxGetMultipleChoices(selections,message,caption,n,choices,parent,x,y,centre,width,height);
    VALUE ary = rb_ary_new();
    for(i=0;i<r;i++)
        rb_ary_push(ary,INT2NUM(selections[i]));
    return ary;
}

static VALUE
WxCreateFileTipProvider(VALUE self,VALUE vfilename,VALUE vcurrentTip)
{
    wxString filename = StringValuePtr(vfilename);
    size_t currentTip = NUM2INT(vcurrentTip);
    return WxTipProvider::init0(wxCreateFileTipProvider(filename,currentTip));
}

static VALUE
WxShowTip(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    Data_Get_Struct(argv[0], wxWindow, parent);
    wxTipProvider *tipProvider;
    Data_Get_Struct(argv[1], wxTipProvider, tipProvider);
    bool showAtStartup = TRUE;
    if(argc>2 && argv[2]==Qfalse) showAtStartup = FALSE;
    return (wxShowTip(parent,tipProvider,showAtStartup) ? Qtrue : Qfalse);
}

static VALUE
WxFileSelector(int argc, VALUE *argv, VALUE self)
{
    wxChar *message = (wxChar *)wxFileSelectorPromptStr;
    if(argc>0) message = StringValuePtr(argv[0]);
    wxChar *default_path = NULL;
    if(argc>1) default_path = StringValuePtr(argv[1]);
    wxChar *default_filename = NULL;
    if(argc>2) default_filename = StringValuePtr(argv[2]);
    wxChar *default_extension = NULL;
    if(argc>3) default_extension = StringValuePtr(argv[3]);
    wxChar *wildcard = (wxChar *)wxFileSelectorDefaultWildcardStr;
    if(argc>4) wildcard = StringValuePtr(argv[4]);
    int flags = 0;
    if(argc>5) flags = NUM2INT(argv[5]);
    wxWindow *parent = NULL;
    if(argc>6)
        Data_Get_Struct(argv[6], wxWindow, parent);
    int x = -1;
    if(argc>7) x = NUM2INT(argv[7]);
    int y = -1;
    if(argc>8) y = NUM2INT(argv[8]);

    return rb_str_new2(wxFileSelector(message,default_path,default_filename,default_extension,wildcard,flags,parent,x,y));
}

static VALUE
WxLoadFileSelector(int argc, VALUE *argv, VALUE self)
{
    wxChar *what = StringValuePtr(argv[0]);
    wxChar *extension = StringValuePtr(argv[1]);
    wxChar *default_name = NULL;
    if(argc>2) default_name = StringValuePtr(argv[2]);
    wxWindow *parent = NULL;
    if(argc>3)
        Data_Get_Struct(argv[3], wxWindow, parent);

    return rb_str_new2(wxLoadFileSelector(what,extension,default_name,parent));
}

static VALUE
WxSaveFileSelector(int argc, VALUE *argv, VALUE self)
{
    wxChar *what = StringValuePtr(argv[0]);
    wxChar *extension = StringValuePtr(argv[1]);
    wxChar *default_name = NULL;
    if(argc>2) default_name = StringValuePtr(argv[2]);
    wxWindow *parent = NULL;
    if(argc>3)
        Data_Get_Struct(argv[3], wxWindow, parent);

    return rb_str_new2(wxSaveFileSelector(what,extension,default_name,parent));
}

static VALUE
WxGetColourFromUser(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent = (wxWindow *)NULL;
    wxColour colInit = wxNullColour;
    if(argc>0)
        Data_Get_Struct(argv[0], wxWindow, parent);
    if(argc>1) {
        wxColour *ptr;
        Data_Get_Struct(argv[1], wxColour, ptr);
        colInit = *ptr;
    }
    return WxColour::init0(wxGetColourFromUser(parent,colInit));
}


#ifdef __WXMSW__
extern "C"
BOOL WINAPI DllMain( HANDLE hModule, DWORD fdwReason, LPVOID lpReserved )
{
    if( fdwReason == DLL_PROCESS_ATTACH )
        wxSetInstance( (HINSTANCE)hModule );
    return TRUE;
}
#endif

VALUE new0(VALUE self)
{
    VALUE res = rb_funcall2(self, rb_intern("allocate"), 0, 0);
    rb_obj_call_init(res, 0, 0);
    return res;
}

VALUE new1(VALUE self,VALUE arg1)
{
    VALUE res = rb_funcall2(self, rb_intern("allocate"), 0, 0);
    rb_obj_call_init(res, 1, &arg1);
    return res;
}

VALUE new2(VALUE self,VALUE arg1,VALUE arg2)
{
    VALUE argv[2];
    argv[0] = arg1;
    argv[1] = arg2;
    VALUE res = rb_funcall2(self, rb_intern("allocate"), 0, 0);
    rb_obj_call_init(res, 2, argv);
    return res;
}

VALUE new3(VALUE self,VALUE arg1,VALUE arg2,VALUE arg3)
{
    VALUE argv[3];
    argv[0] = arg1;
    argv[1] = arg2;
    argv[2] = arg3;
    VALUE res = rb_funcall2(self, rb_intern("allocate"), 0, 0);
    rb_obj_call_init(res, 3, argv);
    return res;
}

VALUE new4(VALUE self,VALUE arg1,VALUE arg2,VALUE arg3,VALUE arg4)
{
    VALUE argv[4];
    argv[0] = arg1;
    argv[1] = arg2;
    argv[2] = arg3;
    argv[3] = arg4;
    VALUE res = rb_funcall2(self, rb_intern("allocate"), 0, 0);
    rb_obj_call_init(res, 4, argv);
    return res;
}

VALUE new_1(int argc, VALUE *argv, VALUE self)
{
    VALUE res = rb_funcall2(self, rb_intern("allocate"), 0, 0);
    rb_obj_call_init(res, argc, argv);
    return res;
}

extern "C"
void Init_wx()
{
    mWx = rb_define_module("Wx");

    rb_cWxApp = rb_define_class_under(mWx,"WxApp", rb_cObject);
    rb_define_alloc_func(rb_cWxApp,WxRbApp::alloc);
    rb_define_singleton_method(rb_cWxApp, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxApp, "initialize", VALUEFUNC(WxRbApp::init), 0);
    rb_define_method(rb_cWxApp, "MainLoop", VALUEFUNC(WxRbApp::MainLoop), 0);
    rb_define_method(rb_cWxApp, "SetTopWindow", VALUEFUNC(WxRbApp::SetTopWindow), 1);
    rb_define_method(rb_cWxApp, "GetAppName", VALUEFUNC(WxRbApp::GetAppName), 0);
    rb_define_method(rb_cWxApp, "GetClassName", VALUEFUNC(WxRbApp::GetClassName), 0);
    rb_define_method(rb_cWxApp, "GetVendorName", VALUEFUNC(WxRbApp::GetVendorName), 0);
    rb_define_method(rb_cWxApp, "SetAppName", VALUEFUNC(WxRbApp::SetAppName), 1);
    rb_define_method(rb_cWxApp, "SetClassName", VALUEFUNC(WxRbApp::SetClassName), 1);
    rb_define_method(rb_cWxApp, "SetVendorName", VALUEFUNC(WxRbApp::SetVendorName), 1);
    rb_define_method(rb_cWxApp, "Yield", VALUEFUNC(WxRbApp::Yield), 0);

    rb_cWxClassInfo = rb_define_class_under(mWx,"WxClassInfo", rb_cObject);
    rb_define_alloc_func(rb_cWxClassInfo,WxClassInfo::alloc);
    rb_define_method(rb_cWxClassInfo, "GetClassName", VALUEFUNC(WxClassInfo::GetClassName), 0);

    rb_cWxArtProvider = rb_define_class_under(mWx,"WxArtProvider", rb_cObject);
    rb_define_alloc_func(rb_cWxArtProvider,WxArtProvider::alloc);
    rb_define_singleton_method(rb_cWxArtProvider, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxArtProvider, "initialize", VALUEFUNC(WxArtProvider::init), 0);
    rb_define_method(rb_cWxArtProvider, "CreateBitmap", VALUEFUNC(WxArtProvider::CreateBitmap), 3);
    rb_define_singleton_method(rb_cWxArtProvider, "GetBitmap", VALUEFUNC(WxArtProvider::GetBitmap), -1);
    rb_define_singleton_method(rb_cWxArtProvider, "GetIcon", VALUEFUNC(WxArtProvider::GetIcon), -1);
    rb_define_singleton_method(rb_cWxArtProvider, "PopProvider", VALUEFUNC(WxArtProvider::PopProvider), 0);
    rb_define_singleton_method(rb_cWxArtProvider, "PushProvider", VALUEFUNC(WxArtProvider::PushProvider), 1);
    rb_define_singleton_method(rb_cWxArtProvider, "RemoveProvider", VALUEFUNC(WxArtProvider::RemoveProvider), 1);

    rb_cWxDateTime = rb_define_class_under(mWx,"WxDateTime", rb_cObject);
    rb_define_alloc_func(rb_cWxDateTime,WxDateTime::alloc);
    rb_define_singleton_method(rb_cWxDateTime, "Today", VALUEFUNC(WxDateTime::Today), 0);
    rb_define_singleton_method(rb_cWxDateTime, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxDateTime, "initialize", VALUEFUNC(WxDateTime::init), -1);
    rb_define_method(rb_cWxDateTime, "GetDay", VALUEFUNC(WxDateTime::GetDay), 0);
    rb_define_method(rb_cWxDateTime, "FormatISODate", VALUEFUNC(WxDateTime::FormatISODate), 0);

    rb_cWxEvtHandler = rb_define_class_under(mWx,"WxEvtHandler", rb_cObject);
    rb_define_alloc_func(rb_cWxEvtHandler,WxEvtHandler::alloc);
    rb_define_method(rb_cWxEvtHandler,"AddPendingEvent",VALUEFUNC(WxEvtHandler::AddPendingEvent),1);
    rb_define_method(rb_cWxEvtHandler,"GetClientData",VALUEFUNC(WxEvtHandler::GetClientData),0);
    rb_define_method(rb_cWxEvtHandler,"GetEvtHandlerEnabled",VALUEFUNC(WxEvtHandler::GetEvtHandlerEnabled),0);
    rb_define_method(rb_cWxEvtHandler,"GetNextHandler",VALUEFUNC(WxEvtHandler::GetNextHandler),0);
    rb_define_method(rb_cWxEvtHandler,"GetPreviousHandler",VALUEFUNC(WxEvtHandler::GetPreviousHandler),0);
    rb_define_method(rb_cWxEvtHandler,"ProcessEvent",VALUEFUNC(WxEvtHandler::ProcessEvent),1);
    rb_define_method(rb_cWxEvtHandler,"SetClientData",VALUEFUNC(WxEvtHandler::SetClientData),1);
    rb_define_method(rb_cWxEvtHandler,"SetEvtHandlerEnabled",VALUEFUNC(WxEvtHandler::SetEvtHandlerEnabled),1);
    rb_define_method(rb_cWxEvtHandler,"SetNextHandler",VALUEFUNC(WxEvtHandler::SetNextHandler),1);
    rb_define_method(rb_cWxEvtHandler,"SetPreviousHandler",VALUEFUNC(WxEvtHandler::SetPreviousHandler),1);

    rb_cWxWindow = rb_define_class_under(mWx,"WxWindow", rb_cWxEvtHandler);
    rb_define_alloc_func(rb_cWxWindow,WxWindow::alloc);
    rb_define_singleton_method(rb_cWxWindow, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxWindow,"initialize",VALUEFUNC(WxWindow::init),-1);
    rb_define_method(rb_cWxWindow,"AddChild",VALUEFUNC(WxWindow::AddChild),1);
    rb_define_method(rb_cWxWindow,"CaptureMouse",VALUEFUNC(WxWindow::CaptureMouse),0);
    rb_define_method(rb_cWxWindow,"Centre",VALUEFUNC(WxWindow::Centre),-1);
    rb_define_method(rb_cWxWindow,"CentreOnParent",VALUEFUNC(WxWindow::CentreOnParent),-1);
    rb_define_method(rb_cWxWindow,"CentreOnScreen",VALUEFUNC(WxWindow::CentreOnScreen),-1);
    rb_define_method(rb_cWxWindow,"Clear",VALUEFUNC(WxWindow::Clear),0);
    rb_define_method(rb_cWxWindow,"ClientToScreen",VALUEFUNC(WxWindow::ClientToScreen),-1);
    rb_define_method(rb_cWxWindow,"Close",VALUEFUNC(WxWindow::Close),1);
    rb_define_method(rb_cWxWindow,"ConvertDialogToPixels",VALUEFUNC(WxWindow::ConvertDialogToPixels),1);
    rb_define_method(rb_cWxWindow,"ConvertPixelsToDialog",VALUEFUNC(WxWindow::ConvertPixelsToDialog),1);
    rb_define_method(rb_cWxWindow,"Destroy",VALUEFUNC(WxWindow::Destroy),0);
    rb_define_method(rb_cWxWindow,"DestroyChildren",VALUEFUNC(WxWindow::DestroyChildren),0);
    rb_define_method(rb_cWxWindow,"Disable",VALUEFUNC(WxWindow::Disable),0);
#ifdef __WXMSW__
    rb_define_method(rb_cWxWindow,"DragAcceptFiles",VALUEFUNC(WxWindow::DragAcceptFiles),1);
#endif
    rb_define_method(rb_cWxWindow,"Enable",VALUEFUNC(WxWindow::Enable),-1);
    rb_define_singleton_method(rb_cWxWindow,"FindFocus",VALUEFUNC(WxWindow::FindFocus),0);
    rb_define_method(rb_cWxWindow,"FindWindow",VALUEFUNC(WxWindow::FindWindow),1);
    rb_define_singleton_method(rb_cWxWindow,"FindWindowById",VALUEFUNC(WxWindow::FindWindowById),-1);
    rb_define_singleton_method(rb_cWxWindow,"FindWindowByLabel",VALUEFUNC(WxWindow::FindWindowByLabel),-1);
    rb_define_singleton_method(rb_cWxWindow,"FindWindowByName",VALUEFUNC(WxWindow::FindWindowByName),-1);
    rb_define_method(rb_cWxWindow,"Fit",VALUEFUNC(WxWindow::Fit),0);
    rb_define_method(rb_cWxWindow,"FitInside",VALUEFUNC(WxWindow::FitInside),0);
    rb_define_method(rb_cWxWindow,"Freeze",VALUEFUNC(WxWindow::Freeze),0);
    rb_define_method(rb_cWxWindow,"GetAdjustedBestSize",VALUEFUNC(WxWindow::GetAdjustedBestSize),0);
    rb_define_method(rb_cWxWindow,"GetBackgroundColour",VALUEFUNC(WxWindow::GetBackgroundColour),0);
    rb_define_method(rb_cWxWindow,"GetBestSize",VALUEFUNC(WxWindow::GetBestSize),0);
    rb_define_singleton_method(rb_cWxWindow,"GetCapture",VALUEFUNC(WxWindow::GetCapture),0);
    rb_define_method(rb_cWxWindow,"GetCaret",VALUEFUNC(WxWindow::GetCaret),0);
    rb_define_method(rb_cWxWindow,"GetCharHeight",VALUEFUNC(WxWindow::GetCharHeight),0);
    rb_define_method(rb_cWxWindow,"GetCharWidth",VALUEFUNC(WxWindow::GetCharWidth),0);
    rb_define_method(rb_cWxWindow,"GetClientSize",VALUEFUNC(WxWindow::GetClientSize),0);
    rb_define_method(rb_cWxWindow,"GetClientSizeWH",VALUEFUNC(WxWindow::GetClientSizeWH),0);
    rb_define_method(rb_cWxWindow,"GetConstraints",VALUEFUNC(WxWindow::GetConstraints),0);
    rb_define_method(rb_cWxWindow,"GetContainingSizer",VALUEFUNC(WxWindow::GetContainingSizer),0);
    rb_define_method(rb_cWxWindow,"GetExtraStyle",VALUEFUNC(WxWindow::GetExtraStyle),0);
    rb_define_method(rb_cWxWindow,"GetFont",VALUEFUNC(WxWindow::GetFont),0);
    rb_define_method(rb_cWxWindow,"GetForegroundColour",VALUEFUNC(WxWindow::GetForegroundColour),0);
    rb_define_method(rb_cWxWindow,"GetGrandParent",VALUEFUNC(WxWindow::GetGrandParent),0);
    rb_define_method(rb_cWxWindow,"GetHandle",VALUEFUNC(WxWindow::GetHandle),0);
    rb_define_method(rb_cWxWindow,"GetHelpText",VALUEFUNC(WxWindow::GetHelpText),0);
    rb_define_method(rb_cWxWindow,"GetId",VALUEFUNC(WxWindow::GetId),0);
    rb_define_method(rb_cWxWindow,"GetLabel",VALUEFUNC(WxWindow::GetLabel),0);
    rb_define_method(rb_cWxWindow,"GetName",VALUEFUNC(WxWindow::GetName),0);
    rb_define_method(rb_cWxWindow,"GetParent",VALUEFUNC(WxWindow::GetParent),0);
    rb_define_method(rb_cWxWindow,"GetPosition",VALUEFUNC(WxWindow::GetPosition),0);
    rb_define_method(rb_cWxWindow,"GetPositionXY",VALUEFUNC(WxWindow::GetPositionXY),0);
    rb_define_method(rb_cWxWindow,"GetRect",VALUEFUNC(WxWindow::GetRect),0);
    rb_define_method(rb_cWxWindow,"GetScrollPos",VALUEFUNC(WxWindow::GetScrollPos),1);
    rb_define_method(rb_cWxWindow,"GetScrollRange",VALUEFUNC(WxWindow::GetScrollRange),1);
    rb_define_method(rb_cWxWindow,"GetScrollThumb",VALUEFUNC(WxWindow::GetScrollThumb),1);
    rb_define_method(rb_cWxWindow,"GetSize",VALUEFUNC(WxWindow::GetSize),0);
    rb_define_method(rb_cWxWindow,"GetSizeWH",VALUEFUNC(WxWindow::GetSizeWH),0);
    rb_define_method(rb_cWxWindow,"GetSizer",VALUEFUNC(WxWindow::GetSizer),0);
    rb_define_method(rb_cWxWindow,"GetTextExtent",VALUEFUNC(WxWindow::GetTextExtent),-1);
    rb_define_method(rb_cWxWindow,"GetTitle",VALUEFUNC(WxWindow::GetTitle),0);
    rb_define_method(rb_cWxWindow,"GetUpdateRegion",VALUEFUNC(WxWindow::GetUpdateRegion),0);
    rb_define_method(rb_cWxWindow,"GetValidator",VALUEFUNC(WxWindow::GetValidator),0);
    rb_define_method(rb_cWxWindow,"GetVirtualSize",VALUEFUNC(WxWindow::GetVirtualSize),0);
    rb_define_method(rb_cWxWindow,"GetWindowStyle",VALUEFUNC(WxWindow::GetWindowStyle),0);
    rb_define_method(rb_cWxWindow,"GetWindowStyleFlag",VALUEFUNC(WxWindow::GetWindowStyleFlag),0);
    rb_define_method(rb_cWxWindow,"HasCapture",VALUEFUNC(WxWindow::HasCapture),0);
    rb_define_method(rb_cWxWindow,"Hide",VALUEFUNC(WxWindow::Hide),0);
    rb_define_method(rb_cWxWindow,"InitDialog",VALUEFUNC(WxWindow::InitDialog),0);
    rb_define_method(rb_cWxWindow,"IsEnabled",VALUEFUNC(WxWindow::IsEnabled),0);
    rb_define_method(rb_cWxWindow,"IsExposed",VALUEFUNC(WxWindow::IsExposed),-1);
    rb_define_method(rb_cWxWindow,"IsRetained",VALUEFUNC(WxWindow::IsRetained),0);
    rb_define_method(rb_cWxWindow,"IsShown",VALUEFUNC(WxWindow::IsShown),0);
    rb_define_method(rb_cWxWindow,"IsTopLevel",VALUEFUNC(WxWindow::IsTopLevel),0);
    rb_define_method(rb_cWxWindow,"Layout",VALUEFUNC(WxWindow::Layout),0);
    rb_define_method(rb_cWxWindow,"Lower",VALUEFUNC(WxWindow::Lower),0);
    rb_define_method(rb_cWxWindow,"MakeModal",VALUEFUNC(WxWindow::MakeModal),1);
    rb_define_method(rb_cWxWindow,"Move",VALUEFUNC(WxWindow::Move),-1);
    rb_define_method(rb_cWxWindow,"PopupMenu",VALUEFUNC(WxWindow::PopupMenu),-1);
    rb_define_method(rb_cWxWindow,"Raise",VALUEFUNC(WxWindow::Raise),0);
    rb_define_method(rb_cWxWindow,"Refresh",VALUEFUNC(WxWindow::Refresh),-1);
    rb_define_method(rb_cWxWindow,"RefreshRect",VALUEFUNC(WxWindow::RefreshRect),1);
    rb_define_method(rb_cWxWindow,"ReleaseMouse",VALUEFUNC(WxWindow::ReleaseMouse),0);
    rb_define_method(rb_cWxWindow,"RemoveChild",VALUEFUNC(WxWindow::RemoveChild),1);
    rb_define_method(rb_cWxWindow,"Reparent",VALUEFUNC(WxWindow::Reparent),1);
    rb_define_method(rb_cWxWindow,"ScreenToClient",VALUEFUNC(WxWindow::ScreenToClient),-1);
    rb_define_method(rb_cWxWindow,"ScrollLines",VALUEFUNC(WxWindow::ScrollLines),1);
    rb_define_method(rb_cWxWindow,"ScrollPages",VALUEFUNC(WxWindow::ScrollPages),1);
    rb_define_method(rb_cWxWindow,"ScrollWindow",VALUEFUNC(WxWindow::ScrollWindow),-1);
    rb_define_method(rb_cWxWindow,"SetAutoLayout",VALUEFUNC(WxWindow::SetAutoLayout),1);
    rb_define_method(rb_cWxWindow,"SetBackgroundColour",VALUEFUNC(WxWindow::SetBackgroundColour),1);
    rb_define_method(rb_cWxWindow,"SetCaret",VALUEFUNC(WxWindow::SetCaret),1);
    rb_define_method(rb_cWxWindow,"SetClientSize",VALUEFUNC(WxWindow::SetClientSize),-1);
    rb_define_method(rb_cWxWindow,"SetConstraints",VALUEFUNC(WxWindow::SetConstraints),1);
    rb_define_method(rb_cWxWindow,"SetContainingSizer",VALUEFUNC(WxWindow::SetContainingSizer),1);
    rb_define_method(rb_cWxWindow,"SetCursor",VALUEFUNC(WxWindow::SetCursor),1);
    rb_define_method(rb_cWxWindow,"SetExtraStyle",VALUEFUNC(WxWindow::SetExtraStyle),1);
    rb_define_method(rb_cWxWindow,"SetFocus",VALUEFUNC(WxWindow::SetFocus),0);
    rb_define_method(rb_cWxWindow,"SetFocusFromKbd",VALUEFUNC(WxWindow::SetFocusFromKbd),0);
    rb_define_method(rb_cWxWindow,"SetFont",VALUEFUNC(WxWindow::SetFont),1);
    rb_define_method(rb_cWxWindow,"SetForegroundColour",VALUEFUNC(WxWindow::SetForegroundColour),1);
    rb_define_method(rb_cWxWindow,"SetHelpText",VALUEFUNC(WxWindow::SetHelpText),1);
    rb_define_method(rb_cWxWindow,"SetId",VALUEFUNC(WxWindow::SetId),1);
    rb_define_method(rb_cWxWindow,"SetName",VALUEFUNC(WxWindow::SetName),1);
    rb_define_method(rb_cWxWindow,"SetPalette",VALUEFUNC(WxWindow::SetPalette),1);
    rb_define_method(rb_cWxWindow,"SetScrollPos",VALUEFUNC(WxWindow::SetScrollPos),-1);
    rb_define_method(rb_cWxWindow,"SetScrollbar",VALUEFUNC(WxWindow::SetScrollbar),-1);
    rb_define_method(rb_cWxWindow,"SetSize",VALUEFUNC(WxWindow::SetSize),-1);
    rb_define_method(rb_cWxWindow,"SetSizeHints",VALUEFUNC(WxWindow::SetSizeHints),-1);
    rb_define_method(rb_cWxWindow,"SetSizer",VALUEFUNC(WxWindow::SetSizer),-1);
    rb_define_method(rb_cWxWindow,"SetSizerAndFit",VALUEFUNC(WxWindow::SetSizerAndFit),-1);
    rb_define_method(rb_cWxWindow,"SetThemeEnabled",VALUEFUNC(WxWindow::SetThemeEnabled),1);
    rb_define_method(rb_cWxWindow,"SetTitle",VALUEFUNC(WxWindow::SetTitle),1);
    rb_define_method(rb_cWxWindow,"SetValidator",VALUEFUNC(WxWindow::SetValidator),1);
    rb_define_method(rb_cWxWindow,"SetVirtualSize",VALUEFUNC(WxWindow::SetVirtualSize),-1);
    rb_define_method(rb_cWxWindow,"SetVirtualSizeHints",VALUEFUNC(WxWindow::SetVirtualSizeHints),-1);
    rb_define_method(rb_cWxWindow,"SetWindowStyle",VALUEFUNC(WxWindow::SetWindowStyle),1);
    rb_define_method(rb_cWxWindow,"SetWindowStyleFlag",VALUEFUNC(WxWindow::SetWindowStyleFlag),1);
    rb_define_method(rb_cWxWindow,"Show",VALUEFUNC(WxWindow::Show),-1);
    rb_define_method(rb_cWxWindow,"Thaw",VALUEFUNC(WxWindow::Thaw),0);
    rb_define_method(rb_cWxWindow,"TransferDataFromWindow",VALUEFUNC(WxWindow::TransferDataFromWindow),0);
    rb_define_method(rb_cWxWindow,"TransferDataToWindow",VALUEFUNC(WxWindow::TransferDataToWindow),0);
    rb_define_method(rb_cWxWindow,"Update",VALUEFUNC(WxWindow::Update),0);
    rb_define_method(rb_cWxWindow,"WarpPointer",VALUEFUNC(WxWindow::WarpPointer),2);
    rb_define_method(rb_cWxWindow,"SetToolTip",VALUEFUNC(WxWindow::SetToolTip),1);
    rb_define_method(rb_cWxWindow,"GetToolTip",VALUEFUNC(WxWindow::GetToolTip),0);
    rb_define_method(rb_cWxWindow,"GetClassInfo",VALUEFUNC(WxWindow::GetClassInfo),0);
#ifdef __WXMSW__
    rb_define_method(rb_cWxWindow,"GetHWND",VALUEFUNC(WxWindow::GetHWND),0);
#endif
    rb_define_method(rb_cWxWindow,"free",VALUEFUNC(WxWindow::free),0);

    rb_cWxSplitterWindow = rb_define_class_under(mWx,"WxSplitterWindow", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxSplitterWindow,WxSplitterWindow::alloc);
    rb_define_singleton_method(rb_cWxSplitterWindow, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSplitterWindow,"initialize",VALUEFUNC(WxSplitterWindow::init),-1);
    rb_define_method(rb_cWxSplitterWindow,"GetMinimumPaneSize",VALUEFUNC(WxSplitterWindow::GetMinimumPaneSize),0);
    rb_define_method(rb_cWxSplitterWindow,"GetSashPosition",VALUEFUNC(WxSplitterWindow::GetSashPosition),0);
    rb_define_method(rb_cWxSplitterWindow,"GetSplitMode",VALUEFUNC(WxSplitterWindow::GetSplitMode),0);
    rb_define_method(rb_cWxSplitterWindow,"GetWindow1",VALUEFUNC(WxSplitterWindow::GetWindow1),0);
    rb_define_method(rb_cWxSplitterWindow,"GetWindow2",VALUEFUNC(WxSplitterWindow::GetWindow2),0);
    rb_define_method(rb_cWxSplitterWindow,"Initialize",VALUEFUNC(WxSplitterWindow::Initialize),1);
    rb_define_method(rb_cWxSplitterWindow,"IsSplit",VALUEFUNC(WxSplitterWindow::IsSplit),0);
    rb_define_method(rb_cWxSplitterWindow,"ReplaceWindow",VALUEFUNC(WxSplitterWindow::ReplaceWindow),2);
    rb_define_method(rb_cWxSplitterWindow,"SetMinimumPaneSize",VALUEFUNC(WxSplitterWindow::SetMinimumPaneSize),1);
    rb_define_method(rb_cWxSplitterWindow,"SetSashPosition",VALUEFUNC(WxSplitterWindow::SetSashPosition),-1);
    rb_define_method(rb_cWxSplitterWindow,"SetSplitMode",VALUEFUNC(WxSplitterWindow::SetSplitMode),1);
    rb_define_method(rb_cWxSplitterWindow,"SplitHorizontally",VALUEFUNC(WxSplitterWindow::SplitHorizontally),-1);
    rb_define_method(rb_cWxSplitterWindow,"SplitVertically",VALUEFUNC(WxSplitterWindow::SplitVertically),-1);
    rb_define_method(rb_cWxSplitterWindow,"Unsplit",VALUEFUNC(WxSplitterWindow::Unsplit),-1);

    rb_define_method(mWx, "WxFrame", VALUEFUNC(WxFrame::init2), 1);
    rb_cWxFrame = rb_define_class_under(mWx,"WxFrame", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxFrame,WxFrame::alloc);
    rb_define_singleton_method(rb_cWxFrame, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFrame, "initialize", VALUEFUNC(WxFrame::init), -1);
    rb_define_method(rb_cWxFrame, "SetMenuBar", VALUEFUNC(WxFrame::SetMenuBar), 1);
    rb_define_method(rb_cWxFrame, "CreateStatusBar", VALUEFUNC(WxFrame::CreateStatusBar), -1);
    rb_define_method(rb_cWxFrame, "SetStatusText", VALUEFUNC(WxFrame::SetStatusText), -1);
    rb_define_method(rb_cWxFrame, "SetIcon", VALUEFUNC(WxFrame::SetIcon), 1);
    rb_define_method(rb_cWxFrame, "GetMenuBar", VALUEFUNC(WxFrame::GetMenuBar), 0);
    rb_define_method(rb_cWxFrame, "GetStatusBar", VALUEFUNC(WxFrame::GetStatusBar), 0);
    rb_define_method(rb_cWxFrame, "GetStatusBarPane", VALUEFUNC(WxFrame::GetStatusBarPane), 0);
    rb_define_method(rb_cWxFrame, "PopStatusText", VALUEFUNC(WxFrame::PopStatusText), -1);
    rb_define_method(rb_cWxFrame, "PushStatusText", VALUEFUNC(WxFrame::PushStatusText), -1);
    rb_define_method(rb_cWxFrame, "SetStatusBar", VALUEFUNC(WxFrame::SetStatusBar), 1);
    rb_define_method(rb_cWxFrame, "SetStatusBarPane", VALUEFUNC(WxFrame::SetStatusBarPane), 1);
    rb_define_method(rb_cWxFrame, "SetStatusWidths", VALUEFUNC(WxFrame::SetStatusWidths), 1);
    rb_define_method(rb_cWxFrame, "SendSizeEvent", VALUEFUNC(WxFrame::SendSizeEvent), 0);
    rb_define_method(rb_cWxFrame, "GetToolBar", VALUEFUNC(WxFrame::GetToolBar), 0);
    rb_define_method(rb_cWxFrame, "SetToolBar", VALUEFUNC(WxFrame::SetToolBar), 1);
    rb_define_method(rb_cWxFrame, "CreateToolBar", VALUEFUNC(WxFrame::CreateToolBar), -1);

    rb_cWxMenu = rb_define_class_under(mWx,"WxMenu", rb_cObject);
    rb_define_alloc_func(rb_cWxMenu,WxMenu::alloc);
    rb_define_singleton_method(rb_cWxMenu, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxMenu, "initialize", VALUEFUNC(WxMenu::init), -1);
    rb_define_method(rb_cWxMenu, "Append", VALUEFUNC(WxMenu::Append), -1);
    rb_define_method(rb_cWxMenu, "AppendCheckItem", VALUEFUNC(WxMenu::AppendCheckItem), -1);
    rb_define_method(rb_cWxMenu, "AppendRadioItem", VALUEFUNC(WxMenu::AppendRadioItem), -1);
    rb_define_method(rb_cWxMenu, "AppendSeparator", VALUEFUNC(WxMenu::AppendSeparator), 0);
    rb_define_method(rb_cWxMenu, "Check", VALUEFUNC(WxMenu::Check), 2);
    rb_define_method(rb_cWxMenu, "Enable", VALUEFUNC(WxMenu::Enable), 2);

    rb_cWxMenuBar = rb_define_class_under(mWx,"WxMenuBar", rb_cObject);
    rb_define_alloc_func(rb_cWxMenuBar,WxMenuBar::alloc);
    rb_define_singleton_method(rb_cWxMenuBar, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxMenuBar, "initialize", VALUEFUNC(WxMenuBar::init), -1);
    rb_define_method(rb_cWxMenuBar, "Append", VALUEFUNC(WxMenuBar::Append), -1);
    rb_define_method(rb_cWxMenuBar, "Check", VALUEFUNC(WxMenuBar::Check), 2);
    rb_define_method(rb_cWxMenuBar, "IsChecked", VALUEFUNC(WxMenuBar::IsChecked), 1);

    rb_cWxBrush = rb_define_class_under(mWx,"WxBrush", rb_cObject);
    rb_define_alloc_func(rb_cWxBrush,WxBrush::alloc);
    rb_define_singleton_method(rb_cWxBrush, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxBrush, "initialize", VALUEFUNC(WxBrush::init), -1);
    rb_define_method(rb_cWxBrush, "GetColour", VALUEFUNC(WxBrush::GetColour), 0);
#ifdef __WXMSW__
    rb_define_method(rb_cWxBrush, "GetStipple", VALUEFUNC(WxBrush::GetStipple), 0);
#endif
    rb_define_method(rb_cWxBrush, "GetStyle", VALUEFUNC(WxBrush::GetStyle), 0);
    rb_define_method(rb_cWxBrush, "Ok", VALUEFUNC(WxBrush::Ok), 0);
    rb_define_method(rb_cWxBrush, "SetColour", VALUEFUNC(WxBrush::SetColour), -1);
#ifdef __WXMSW__
    rb_define_method(rb_cWxBrush, "SetStipple", VALUEFUNC(WxBrush::SetStipple), 1);
#endif
    rb_define_method(rb_cWxBrush, "SetStyle", VALUEFUNC(WxBrush::SetStyle), 1);

    rb_cWxPalette = rb_define_class_under(mWx,"WxPalette", rb_cObject);
    rb_define_alloc_func(rb_cWxPalette,WxPalette::alloc);
    rb_define_singleton_method(rb_cWxPalette, "new", VALUEFUNC(new3), 3);
    rb_define_method(rb_cWxPalette, "initialize", VALUEFUNC(WxPalette::init), 3);
    rb_define_method(rb_cWxPalette, "GetPixel", VALUEFUNC(WxPalette::GetPixel), 3);
    rb_define_method(rb_cWxPalette, "GetRGB", VALUEFUNC(WxPalette::GetRGB), 1);
    rb_define_method(rb_cWxPalette, "Ok", VALUEFUNC(WxPalette::Ok), 0);

    rb_cWxPen = rb_define_class_under(mWx,"WxPen", rb_cObject);
    rb_define_alloc_func(rb_cWxPen,WxPen::alloc);
    rb_define_singleton_method(rb_cWxPen, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxPen, "initialize", VALUEFUNC(WxPen::init), -1);
    rb_define_method(rb_cWxPen, "GetCap", VALUEFUNC(WxPen::GetCap), 0);
    rb_define_method(rb_cWxPen, "GetColour", VALUEFUNC(WxPen::GetColour), 0);
    rb_define_method(rb_cWxPen, "GetDashes", VALUEFUNC(WxPen::GetDashes), 0);
    rb_define_method(rb_cWxPen, "GetJoin", VALUEFUNC(WxPen::GetJoin), 0);
#ifdef __WXMSW__
    rb_define_method(rb_cWxPen, "GetStipple", VALUEFUNC(WxPen::GetStipple), 0);
#endif
    rb_define_method(rb_cWxPen, "GetStyle", VALUEFUNC(WxPen::GetStyle), 0);
    rb_define_method(rb_cWxPen, "GetWidth", VALUEFUNC(WxPen::GetWidth), 0);
    rb_define_method(rb_cWxPen, "Ok", VALUEFUNC(WxPen::Ok), 0);
    rb_define_method(rb_cWxPen, "SetCap", VALUEFUNC(WxPen::SetCap), 1);
    rb_define_method(rb_cWxPen, "SetColour", VALUEFUNC(WxPen::SetColour), -1);
    rb_define_method(rb_cWxPen, "SetDashes", VALUEFUNC(WxPen::SetDashes), 1);
    rb_define_method(rb_cWxPen, "SetJoin", VALUEFUNC(WxPen::SetJoin), 1);
#ifdef __WXMSW__
    rb_define_method(rb_cWxPen, "SetStipple", VALUEFUNC(WxPen::SetStipple), 1);
#endif
    rb_define_method(rb_cWxPen, "SetStyle", VALUEFUNC(WxPen::SetStyle), 1);
    rb_define_method(rb_cWxPen, "SetWidth", VALUEFUNC(WxPen::SetWidth), 1);

    rb_cWxCaret = rb_define_class_under(mWx,"WxCaret", rb_cObject);
    rb_define_alloc_func(rb_cWxCaret,WxCaret::alloc);
    rb_define_singleton_method(rb_cWxCaret, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxCaret, "initialize", VALUEFUNC(WxCaret::init), -1);
    rb_define_singleton_method(rb_cWxCaret, "GetBlinkTime", VALUEFUNC(WxCaret::GetBlinkTime), 0);
    rb_define_method(rb_cWxCaret, "GetPosition", VALUEFUNC(WxCaret::GetPosition), 0);
    rb_define_method(rb_cWxCaret, "GetPositionXY", VALUEFUNC(WxCaret::GetPositionXY), 0);
    rb_define_method(rb_cWxCaret, "GetSize", VALUEFUNC(WxCaret::GetSize), 0);
    rb_define_method(rb_cWxCaret, "GetSizeXY", VALUEFUNC(WxCaret::GetSizeXY), 0);
    rb_define_method(rb_cWxCaret, "GetWindow", VALUEFUNC(WxCaret::GetWindow), 0);

    rb_define_method(rb_cWxCaret, "Hide", VALUEFUNC(WxCaret::Hide), 0);
    rb_define_method(rb_cWxCaret, "IsOk", VALUEFUNC(WxCaret::IsOk), 0);
    rb_define_method(rb_cWxCaret, "IsVisible", VALUEFUNC(WxCaret::IsVisible), 0);
    rb_define_method(rb_cWxCaret, "Move", VALUEFUNC(WxCaret::Move), 2);
    rb_define_singleton_method(rb_cWxCaret, "SetBlinkTime", VALUEFUNC(WxCaret::SetBlinkTime), 1);
    rb_define_method(rb_cWxCaret, "SetSize", VALUEFUNC(WxCaret::SetSize), -1);
    rb_define_method(rb_cWxCaret, "Show", VALUEFUNC(WxCaret::Show), -1);

    rb_cWxPoint = rb_define_class_under(mWx,"WxPoint", rb_cObject);
    rb_define_alloc_func(rb_cWxPoint,WxPoint::alloc);
    rb_define_singleton_method(rb_cWxPoint, "new", VALUEFUNC(new2), 2);
    rb_define_method(rb_cWxPoint, "initialize", VALUEFUNC(WxPoint::init), 2);
    rb_define_method(rb_cWxPoint, "x", VALUEFUNC(WxPoint::x), 0);
    rb_define_method(rb_cWxPoint, "y", VALUEFUNC(WxPoint::y), 0);

    rb_cWxRect = rb_define_class_under(mWx,"WxRect", rb_cObject);
    rb_define_alloc_func(rb_cWxRect,WxRect::alloc);
    rb_define_singleton_method(rb_cWxRect, "new", VALUEFUNC(new4), 4);
    rb_define_method(rb_cWxRect, "initialize", VALUEFUNC(WxRect::init), 4);
    rb_define_method(rb_cWxRect, "x", VALUEFUNC(WxRect::x), 0);
    rb_define_method(rb_cWxRect, "y", VALUEFUNC(WxRect::y), 0);
    rb_define_method(rb_cWxRect, "width", VALUEFUNC(WxRect::width), 0);
    rb_define_method(rb_cWxRect, "height", VALUEFUNC(WxRect::height), 0);

    rb_cWxRegion = rb_define_class_under(mWx,"WxRegion", rb_cObject);
    rb_define_alloc_func(rb_cWxRegion,WxRegion::alloc);
    rb_define_singleton_method(rb_cWxRegion, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxRegion, "initialize", VALUEFUNC(WxRegion::init), -1);
    rb_define_method(rb_cWxRegion, "Clear", VALUEFUNC(WxRegion::Clear), 0);
    rb_define_method(rb_cWxRegion, "Contains", VALUEFUNC(WxRegion::Contains), -1);
    rb_define_method(rb_cWxRegion, "GetBox", VALUEFUNC(WxRegion::GetBox), 0);
    rb_define_method(rb_cWxRegion, "Intersect", VALUEFUNC(WxRegion::Intersect), -1);
    rb_define_method(rb_cWxRegion, "IsEmpty", VALUEFUNC(WxRegion::IsEmpty), 0);
    rb_define_method(rb_cWxRegion, "Offset", VALUEFUNC(WxRegion::Offset), 2);
    rb_define_method(rb_cWxRegion, "Subtract", VALUEFUNC(WxRegion::Subtract), 1);
    rb_define_method(rb_cWxRegion, "Union", VALUEFUNC(WxRegion::Union), -1);
    rb_define_method(rb_cWxRegion, "Xor", VALUEFUNC(WxRegion::Xor), -1);

    rb_cWxColour = rb_define_class_under(mWx,"WxColour", rb_cObject);
    rb_define_alloc_func(rb_cWxColour,WxColour::alloc);
    rb_define_singleton_method(rb_cWxColour, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxColour, "initialize", VALUEFUNC(WxColour::init), -1);
    rb_define_method(rb_cWxColour, "Blue", VALUEFUNC(WxColour::Blue), 0);
    rb_define_method(rb_cWxColour, "Green", VALUEFUNC(WxColour::Green), 0);
    rb_define_method(rb_cWxColour, "Red", VALUEFUNC(WxColour::Red), 0);
    rb_define_method(rb_cWxColour, "Ok", VALUEFUNC(WxColour::Ok), 0);

    rb_cWxFont = rb_define_class_under(mWx,"WxFont", rb_cObject);
    rb_define_alloc_func(rb_cWxFont,WxFont::alloc);
    rb_define_singleton_method(rb_cWxFont, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFont, "initialize", VALUEFUNC(WxFont::init), -1);

    rb_cWxDC = rb_define_class_under(mWx,"WxDC", rb_cObject);
    rb_define_alloc_func(rb_cWxDC,WxDC::alloc);
    rb_define_singleton_method(rb_cWxDC, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxDC, "initialize", VALUEFUNC(WxDC::init), 0);
    rb_define_method(rb_cWxDC, "free", VALUEFUNC(WxDC::free), 0);
    rb_define_method(rb_cWxDC, "BeginDrawing", VALUEFUNC(WxDC::BeginDrawing), 0);
    rb_define_method(rb_cWxDC, "Blit", VALUEFUNC(WxDC::Blit), -1);
    rb_define_method(rb_cWxDC, "CalcBoundingBox", VALUEFUNC(WxDC::CalcBoundingBox), 2);
    rb_define_method(rb_cWxDC, "Clear", VALUEFUNC(WxDC::Clear), 0);
    rb_define_method(rb_cWxDC, "CrossHair", VALUEFUNC(WxDC::CrossHair), 2);
    rb_define_method(rb_cWxDC, "DestroyClippingRegion", VALUEFUNC(WxDC::DestroyClippingRegion), 0);
    rb_define_method(rb_cWxDC, "DeviceToLogicalX", VALUEFUNC(WxDC::DeviceToLogicalX), 1);
    rb_define_method(rb_cWxDC, "DeviceToLogicalXRel", VALUEFUNC(WxDC::DeviceToLogicalXRel), 1);
    rb_define_method(rb_cWxDC, "DeviceToLogicalY", VALUEFUNC(WxDC::DeviceToLogicalY), 1);
    rb_define_method(rb_cWxDC, "DeviceToLogicalYRel", VALUEFUNC(WxDC::DeviceToLogicalYRel), 1);
    rb_define_method(rb_cWxDC, "DrawArc", VALUEFUNC(WxDC::DrawArc), 6);
    rb_define_method(rb_cWxDC, "DrawBitmap", VALUEFUNC(WxDC::DrawBitmap), 4);
    rb_define_method(rb_cWxDC, "DrawCheckMark", VALUEFUNC(WxDC::DrawCheckMark), -1);
    rb_define_method(rb_cWxDC, "DrawCircle", VALUEFUNC(WxDC::DrawCircle), -1);
    rb_define_method(rb_cWxDC, "DrawEllipse", VALUEFUNC(WxDC::DrawEllipse), -1);
    rb_define_method(rb_cWxDC, "DrawEllipticArc", VALUEFUNC(WxDC::DrawEllipticArc), 6);
    rb_define_method(rb_cWxDC, "DrawIcon", VALUEFUNC(WxDC::DrawIcon), 3);
    rb_define_method(rb_cWxDC, "DrawLine", VALUEFUNC(WxDC::DrawLine), 4);
    rb_define_method(rb_cWxDC, "DrawLines", VALUEFUNC(WxDC::DrawLines), -1);
    rb_define_method(rb_cWxDC, "DrawPoint", VALUEFUNC(WxDC::DrawPoint), 2);
    rb_define_method(rb_cWxDC, "DrawPolygon", VALUEFUNC(WxDC::DrawPolygon), -1);
    rb_define_method(rb_cWxDC, "DrawRectangle", VALUEFUNC(WxDC::DrawRectangle), 4);
    rb_define_method(rb_cWxDC, "DrawRotatedText", VALUEFUNC(WxDC::DrawRotatedText), 4);
    rb_define_method(rb_cWxDC, "DrawSpline", VALUEFUNC(WxDC::DrawSpline), 1);
    rb_define_method(rb_cWxDC, "DrawText", VALUEFUNC(WxDC::DrawText), -1);
    rb_define_method(rb_cWxDC, "DrawRoundedRectangle", VALUEFUNC(WxDC::DrawRoundedRectangle), -1);
    rb_define_method(rb_cWxDC, "EndDoc", VALUEFUNC(WxDC::EndDoc), 0);
    rb_define_method(rb_cWxDC, "EndDrawing", VALUEFUNC(WxDC::EndDrawing), 0);
    rb_define_method(rb_cWxDC, "EndPage", VALUEFUNC(WxDC::EndPage), 0);
    rb_define_method(rb_cWxDC, "FloodFill", VALUEFUNC(WxDC::FloodFill), -1);
    rb_define_method(rb_cWxDC, "GetBackground", VALUEFUNC(WxDC::GetBackground), 0);
    rb_define_method(rb_cWxDC, "GetBackgroundMode", VALUEFUNC(WxDC::GetBackgroundMode), 0);
    rb_define_method(rb_cWxDC, "GetBrush", VALUEFUNC(WxDC::GetBrush), 0);
    rb_define_method(rb_cWxDC, "GetCharHeight", VALUEFUNC(WxDC::GetCharHeight), 0);
    rb_define_method(rb_cWxDC, "GetCharWidth", VALUEFUNC(WxDC::GetCharWidth), 0);
    rb_define_method(rb_cWxDC, "GetClippingBox", VALUEFUNC(WxDC::GetClippingBox), 0);
    rb_define_method(rb_cWxDC, "GetFont", VALUEFUNC(WxDC::GetFont), 0);
    rb_define_method(rb_cWxDC, "GetLogicalFunction", VALUEFUNC(WxDC::GetLogicalFunction), 0);
    rb_define_method(rb_cWxDC, "GetMapMode", VALUEFUNC(WxDC::GetMapMode), 0);
    rb_define_method(rb_cWxDC, "GetOptimization", VALUEFUNC(WxDC::GetOptimization), 0);
    rb_define_method(rb_cWxDC, "GetPen", VALUEFUNC(WxDC::GetPen), 0);
    rb_define_method(rb_cWxDC, "GetPixel", VALUEFUNC(WxDC::GetPixel), 2);
    rb_define_method(rb_cWxDC, "GetSize", VALUEFUNC(WxDC::GetSize), 0);
    rb_define_method(rb_cWxDC, "GetTextBackground", VALUEFUNC(WxDC::GetTextBackground), 0);
    rb_define_method(rb_cWxDC, "GetTextExtent", VALUEFUNC(WxDC::GetTextExtent), -1);
    rb_define_method(rb_cWxDC, "GetTextForeground", VALUEFUNC(WxDC::GetTextForeground), 0);
    rb_define_method(rb_cWxDC, "GetUserScale", VALUEFUNC(WxDC::GetUserScale), 0);
    rb_define_method(rb_cWxDC, "LogicalToDeviceX", VALUEFUNC(WxDC::LogicalToDeviceX), 1);
    rb_define_method(rb_cWxDC, "LogicalToDeviceXRel", VALUEFUNC(WxDC::LogicalToDeviceXRel), 1);
    rb_define_method(rb_cWxDC, "LogicalToDeviceY", VALUEFUNC(WxDC::LogicalToDeviceY), 1);
    rb_define_method(rb_cWxDC, "LogicalToDeviceYRel", VALUEFUNC(WxDC::LogicalToDeviceYRel), 1);
    rb_define_method(rb_cWxDC, "MaxX", VALUEFUNC(WxDC::MaxX), 0);
    rb_define_method(rb_cWxDC, "MaxY", VALUEFUNC(WxDC::MaxY), 0);
    rb_define_method(rb_cWxDC, "MinX", VALUEFUNC(WxDC::MinX), 0);
    rb_define_method(rb_cWxDC, "MinY", VALUEFUNC(WxDC::MinY), 0);
    rb_define_method(rb_cWxDC, "Ok", VALUEFUNC(WxDC::Ok), 0);
    rb_define_method(rb_cWxDC, "ResetBoundingBox", VALUEFUNC(WxDC::ResetBoundingBox), 0);
    rb_define_method(rb_cWxDC, "SetAxisOrientation", VALUEFUNC(WxDC::SetAxisOrientation), 2);
    rb_define_method(rb_cWxDC, "SetBackground", VALUEFUNC(WxDC::SetBackground), 1);
    rb_define_method(rb_cWxDC, "SetBackgroundMode", VALUEFUNC(WxDC::SetBackgroundMode), 1);
    rb_define_method(rb_cWxDC, "SetBrush", VALUEFUNC(WxDC::SetBrush), 1);
    rb_define_method(rb_cWxDC, "SetClippingRegion", VALUEFUNC(WxDC::SetClippingRegion), -1);
    rb_define_method(rb_cWxDC, "SetDeviceOrigin", VALUEFUNC(WxDC::SetDeviceOrigin), 2);
    rb_define_method(rb_cWxDC, "SetFont", VALUEFUNC(WxDC::SetFont), 1);
    rb_define_method(rb_cWxDC, "SetLogicalFunction", VALUEFUNC(WxDC::SetLogicalFunction),12);
    rb_define_method(rb_cWxDC, "SetMapMode", VALUEFUNC(WxDC::SetMapMode), 1);
    rb_define_method(rb_cWxDC, "SetOptimization", VALUEFUNC(WxDC::SetOptimization), 1);
    rb_define_method(rb_cWxDC, "SetPalette", VALUEFUNC(WxDC::SetPalette), 1);
    rb_define_method(rb_cWxDC, "SetPen", VALUEFUNC(WxDC::SetPen), 1);
    rb_define_method(rb_cWxDC, "SetTextBackground", VALUEFUNC(WxDC::SetTextBackground), 1);
    rb_define_method(rb_cWxDC, "SetTextForeground", VALUEFUNC(WxDC::SetTextForeground), 1);
    rb_define_method(rb_cWxDC, "SetUserScale", VALUEFUNC(WxDC::SetUserScale), 2);
    rb_define_method(rb_cWxDC, "StartDoc", VALUEFUNC(WxDC::StartDoc), 1);
    rb_define_method(rb_cWxDC, "StartPage", VALUEFUNC(WxDC::StartPage), 0);

    rb_cWxMemoryDC = rb_define_class_under(mWx,"WxMemoryDC", rb_cWxDC);
    rb_define_alloc_func(rb_cWxMemoryDC,WxMemoryDC::alloc);
    rb_define_singleton_method(rb_cWxMemoryDC, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxMemoryDC, "initialize", VALUEFUNC(WxMemoryDC::init), 0);
    rb_define_method(rb_cWxMemoryDC, "SelectObject", VALUEFUNC(WxMemoryDC::SelectObject), 1);

    rb_cWxWindowDC = rb_define_class_under(mWx,"WxWindowDC", rb_cWxDC);
    rb_define_alloc_func(rb_cWxWindowDC,WxWindowDC::alloc);
    rb_define_singleton_method(rb_cWxWindowDC, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxWindowDC, "initialize", VALUEFUNC(WxWindowDC::init), 1);

    rb_cWxClientDC = rb_define_class_under(mWx,"WxClientDC", rb_cWxWindowDC);
    rb_define_alloc_func(rb_cWxClientDC,WxClientDC::alloc);
    rb_define_singleton_method(rb_cWxClientDC, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxClientDC, "initialize", VALUEFUNC(WxClientDC::init), 1);

    rb_cWxPaintDC = rb_define_class_under(mWx,"WxPaintDC", rb_cWxWindowDC);
    rb_define_alloc_func(rb_cWxPaintDC,WxPaintDC::alloc);
    rb_define_singleton_method(rb_cWxPaintDC, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxPaintDC, "initialize", VALUEFUNC(WxPaintDC::init), 1);

    rb_cWxColourData = rb_define_class_under(mWx,"WxColourData", rb_cObject);
    rb_define_alloc_func(rb_cWxColourData,WxColourData::alloc);
    rb_define_singleton_method(rb_cWxColourData, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxColourData, "initialize", VALUEFUNC(WxColourData::init), 0);
    rb_define_method(rb_cWxColourData, "GetChooseFull", VALUEFUNC(WxColourData::GetChooseFull), 1);
    rb_define_method(rb_cWxColourData, "GetColour", VALUEFUNC(WxColourData::GetColour), 0);
    rb_define_method(rb_cWxColourData, "GetCustomColour", VALUEFUNC(WxColourData::GetCustomColour), 0);
    rb_define_method(rb_cWxColourData, "SetChooseFull", VALUEFUNC(WxColourData::SetChooseFull), 1);
    rb_define_method(rb_cWxColourData, "SetColour", VALUEFUNC(WxColourData::SetColour), 1);
    rb_define_method(rb_cWxColourData, "SetCustomColour", VALUEFUNC(WxColourData::SetCustomColour), 2);

    rb_cWxFontData = rb_define_class_under(mWx,"WxFontData", rb_cObject);
    rb_define_alloc_func(rb_cWxFontData,WxFontData::alloc);
    rb_define_singleton_method(rb_cWxFontData, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxFontData, "initialize", VALUEFUNC(WxFontData::init), 0);
    rb_define_method(rb_cWxFontData, "SetInitialFont", VALUEFUNC(WxFontData::SetInitialFont), 1);
    rb_define_method(rb_cWxFontData, "SetColour", VALUEFUNC(WxFontData::SetColour), 1);
    rb_define_method(rb_cWxFontData, "SetShowHelp", VALUEFUNC(WxFontData::SetShowHelp), 1);
    rb_define_method(rb_cWxFontData, "GetChosenFont", VALUEFUNC(WxFontData::GetChosenFont), 0);
    rb_define_method(rb_cWxFontData, "GetColour", VALUEFUNC(WxFontData::GetColour), 0);

    rb_cWxSize = rb_define_class_under(mWx,"WxSize", rb_cObject);
    rb_define_alloc_func(rb_cWxSize,WxSize::alloc);
    rb_define_singleton_method(rb_cWxSize, "new", VALUEFUNC(new2), 2);
    rb_define_method(rb_cWxSize, "initialize", VALUEFUNC(WxSize::init), 2);
    rb_define_method(rb_cWxSize, "Set", VALUEFUNC(WxSize::Set), 2);
    rb_define_method(rb_cWxSize, "SetHeight", VALUEFUNC(WxSize::SetHeight), 1);
    rb_define_method(rb_cWxSize, "SetWidth", VALUEFUNC(WxSize::SetWidth), 1);
    rb_define_method(rb_cWxSize, "GetHeight", VALUEFUNC(WxSize::GetHeight), 0);
    rb_define_method(rb_cWxSize, "GetWidth", VALUEFUNC(WxSize::GetWidth), 0);
    rb_define_method(rb_cWxSize, "x", VALUEFUNC(WxSize::x), 0);
    rb_define_method(rb_cWxSize, "y", VALUEFUNC(WxSize::y), 0);

    rb_cWxTextCtrl = rb_define_class_under(mWx,"WxTextCtrl", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxTextCtrl,WxTextCtrl::alloc);
    rb_define_singleton_method(rb_cWxTextCtrl, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxTextCtrl, "initialize", VALUEFUNC(WxTextCtrl::init), -1);
    rb_define_method(rb_cWxTextCtrl, "LoadFile", VALUEFUNC(WxTextCtrl::LoadFile), 1);
    rb_define_method(rb_cWxTextCtrl, "SaveFile", VALUEFUNC(WxTextCtrl::SaveFile), 1);
    rb_define_method(rb_cWxTextCtrl, "IsModified", VALUEFUNC(WxTextCtrl::IsModified), 0);
    rb_define_method(rb_cWxTextCtrl, "DiscardEdits", VALUEFUNC(WxTextCtrl::DiscardEdits), 0);
    rb_define_method(rb_cWxTextCtrl, "GetNumberOfLines", VALUEFUNC(WxTextCtrl::GetNumberOfLines), 0);
    rb_define_method(rb_cWxTextCtrl, "XYToPosition", VALUEFUNC(WxTextCtrl::XYToPosition), 2);
    rb_define_method(rb_cWxTextCtrl, "SetInsertionPoint", VALUEFUNC(WxTextCtrl::SetInsertionPoint), 1);
    rb_define_method(rb_cWxTextCtrl, "GetValue", VALUEFUNC(WxTextCtrl::GetValue), 0);
    rb_define_method(rb_cWxTextCtrl, "SetValue", VALUEFUNC(WxTextCtrl::SetValue), 1);
    rb_define_method(rb_cWxTextCtrl, "AppendText", VALUEFUNC(WxTextCtrl::AppendText), 1);
    rb_define_method(rb_cWxTextCtrl, "WriteText", VALUEFUNC(WxTextCtrl::WriteText), 1);
    rb_define_method(rb_cWxTextCtrl, "<<", VALUEFUNC(WxTextCtrl::op_append), 1);
    rb_define_method(rb_cWxTextCtrl, "CanCopy", VALUEFUNC(WxTextCtrl::CanCopy), 0);
    rb_define_method(rb_cWxTextCtrl, "CanCut", VALUEFUNC(WxTextCtrl::CanCut), 0);
    rb_define_method(rb_cWxTextCtrl, "CanPaste", VALUEFUNC(WxTextCtrl::CanPaste), 0);
    rb_define_method(rb_cWxTextCtrl, "CanRedo", VALUEFUNC(WxTextCtrl::CanRedo), 0);
    rb_define_method(rb_cWxTextCtrl, "CanUndo", VALUEFUNC(WxTextCtrl::CanUndo), 0);
    rb_define_method(rb_cWxTextCtrl, "Clear", VALUEFUNC(WxTextCtrl::Clear), 0);
    rb_define_method(rb_cWxTextCtrl, "Copy", VALUEFUNC(WxTextCtrl::Copy), 0);
    rb_define_method(rb_cWxTextCtrl, "Cut", VALUEFUNC(WxTextCtrl::Cut), 0);

    rb_cWxSpinCtrl = rb_define_class_under(mWx,"WxSpinCtrl", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxSpinCtrl,WxSpinCtrl::alloc);
    rb_define_singleton_method(rb_cWxSpinCtrl, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSpinCtrl, "initialize", VALUEFUNC(WxSpinCtrl::init), -1);
    rb_define_method(rb_cWxSpinCtrl, "SetValue",    VALUEFUNC(WxSpinCtrl::SetValue), 1);
    rb_define_method(rb_cWxSpinCtrl, "GetValue",    VALUEFUNC(WxSpinCtrl::GetValue), 0);
    rb_define_method(rb_cWxSpinCtrl, "SetRange",    VALUEFUNC(WxSpinCtrl::SetRange), 2);
#ifdef __WXMSW__
    rb_define_method(rb_cWxSpinCtrl, "SetSelection",VALUEFUNC(WxSpinCtrl::SetSelection), 2);
#endif
    rb_define_method(rb_cWxSpinCtrl, "GetMin",      VALUEFUNC(WxSpinCtrl::GetMin), 0);
    rb_define_method(rb_cWxSpinCtrl, "GetMax",      VALUEFUNC(WxSpinCtrl::GetMax), 0);

    rb_cWxSpinButton = rb_define_class_under(mWx,"WxSpinButton", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxSpinButton,WxSpinButton::alloc);
    rb_define_singleton_method(rb_cWxSpinButton, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSpinButton, "initialize", VALUEFUNC(WxSpinButton::init), -1);
    rb_define_method(rb_cWxSpinButton, "GetMax", VALUEFUNC(WxSpinButton::GetMax), 0);
    rb_define_method(rb_cWxSpinButton, "GetMin", VALUEFUNC(WxSpinButton::GetMin), 0);
    rb_define_method(rb_cWxSpinButton, "GetValue", VALUEFUNC(WxSpinButton::GetValue), 0);
    rb_define_method(rb_cWxSpinButton, "SetRange", VALUEFUNC(WxSpinButton::SetRange), 2);
    rb_define_method(rb_cWxSpinButton, "SetValue", VALUEFUNC(WxSpinButton::SetValue), 1);

    rb_cWxCalendarDateAttr = rb_define_class_under(mWx,"WxCalendarDateAttr", rb_cObject);
    rb_define_alloc_func(rb_cWxCalendarDateAttr,WxCalendarDateAttr::alloc);
    rb_define_singleton_method(rb_cWxCalendarDateAttr, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxCalendarDateAttr, "initialize", VALUEFUNC(WxCalendarDateAttr::init), -1);
    rb_define_method(rb_cWxCalendarDateAttr, "GetBackgroundColour", VALUEFUNC(WxCalendarDateAttr::GetBackgroundColour), 0);

    rb_cWxCalendarCtrl = rb_define_class_under(mWx,"WxCalendarCtrl", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxCalendarCtrl,WxCalendarCtrl::alloc);
    rb_define_singleton_method(rb_cWxCalendarCtrl, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxCalendarCtrl, "initialize", VALUEFUNC(WxCalendarCtrl::init), -1);
    rb_define_method(rb_cWxCalendarCtrl, "SetAttr", VALUEFUNC(WxCalendarCtrl::SetAttr), 2);
    rb_define_method(rb_cWxCalendarCtrl, "GetAttr", VALUEFUNC(WxCalendarCtrl::GetAttr), 1);
    rb_define_method(rb_cWxCalendarCtrl, "ResetAttr", VALUEFUNC(WxCalendarCtrl::ResetAttr), 1);
    rb_define_method(rb_cWxCalendarCtrl, "EnableHolidayDisplay", VALUEFUNC(WxCalendarCtrl::EnableHolidayDisplay), -1);
    rb_define_method(rb_cWxCalendarCtrl, "EnableYearChange", VALUEFUNC(WxCalendarCtrl::EnableYearChange), -1);
    rb_define_method(rb_cWxCalendarCtrl, "EnableMonthChange", VALUEFUNC(WxCalendarCtrl::EnableMonthChange), -1);

    rb_cWxFindReplaceData = rb_define_class_under(mWx,"WxFindReplaceData", rb_cObject);
    rb_define_alloc_func(rb_cWxFindReplaceData,WxFindReplaceData::alloc);
    rb_define_singleton_method(rb_cWxFindReplaceData, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFindReplaceData, "initialize", VALUEFUNC(WxFindReplaceData::init), -1);
    rb_define_method(rb_cWxFindReplaceData, "GetFindString", VALUEFUNC(WxFindReplaceData::GetFindString), 0);
    rb_define_method(rb_cWxFindReplaceData, "GetFlags", VALUEFUNC(WxFindReplaceData::GetFlags), 0);
    rb_define_method(rb_cWxFindReplaceData, "GetReplaceString", VALUEFUNC(WxFindReplaceData::GetReplaceString), 0);
    rb_define_method(rb_cWxFindReplaceData, "SetFindString", VALUEFUNC(WxFindReplaceData::SetFindString), 1);
    rb_define_method(rb_cWxFindReplaceData, "SetFlags", VALUEFUNC(WxFindReplaceData::SetFlags), 1);
    rb_define_method(rb_cWxFindReplaceData, "SetReplaceString", VALUEFUNC(WxFindReplaceData::SetReplaceString), 1);

    rb_cWxDialog = rb_define_class_under(mWx,"WxDialog", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxDialog,WxDialog::alloc);
    rb_define_singleton_method(rb_cWxDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxDialog, "initialize", VALUEFUNC(WxDialog::init), -1);
    rb_define_method(rb_cWxDialog, "ShowModal", VALUEFUNC(WxDialog::ShowModal), 0);

    rb_cWxTipProvider = rb_define_class_under(mWx,"WxTipProvider", rb_cObject);
    rb_define_alloc_func(rb_cWxTipProvider,WxTipProvider::alloc);
    rb_define_singleton_method(rb_cWxTipProvider, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxTipProvider, "GetTip", VALUEFUNC(WxTipProvider::GetTip), 0);
    rb_define_method(rb_cWxTipProvider, "PreprocessTip", VALUEFUNC(WxTipProvider::PreprocessTip), 1);
    rb_define_method(rb_cWxTipProvider, "GetCurrentTip", VALUEFUNC(WxTipProvider::GetCurrentTip), 0);

    rb_cWxFindReplaceDialog = rb_define_class_under(mWx,"WxFindReplaceDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxFindReplaceDialog,WxFindReplaceDialog::alloc);
    rb_define_singleton_method(rb_cWxFindReplaceDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFindReplaceDialog, "initialize", VALUEFUNC(WxFindReplaceDialog::init), -1);
    rb_define_method(rb_cWxFindReplaceDialog, "GetData", VALUEFUNC(WxFindReplaceDialog::GetData), 0);
    rb_define_method(rb_cWxFindReplaceDialog, "SetData", VALUEFUNC(WxFindReplaceDialog::SetData), 1);

    rb_cWxProgressDialog = rb_define_class_under(mWx,"WxProgressDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxProgressDialog,WxProgressDialog::alloc);
    rb_define_singleton_method(rb_cWxProgressDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxProgressDialog, "initialize", VALUEFUNC(WxProgressDialog::init), -1);
    rb_define_method(rb_cWxProgressDialog, "Update", VALUEFUNC(WxProgressDialog::Update), -1);
    rb_define_method(rb_cWxProgressDialog, "Resume", VALUEFUNC(WxProgressDialog::Resume), 0);

    rb_cWxTextEntryDialog = rb_define_class_under(mWx,"WxTextEntryDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxTextEntryDialog,WxTextEntryDialog::alloc);
    rb_define_singleton_method(rb_cWxTextEntryDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxTextEntryDialog, "initialize", VALUEFUNC(WxTextEntryDialog::init), -1);
    rb_define_method(rb_cWxTextEntryDialog, "GetValue", VALUEFUNC(WxTextEntryDialog::GetValue), 0);
    rb_define_method(rb_cWxTextEntryDialog, "SetValue", VALUEFUNC(WxTextEntryDialog::SetValue), 1);

    rb_cWxSingleChoiceDialog = rb_define_class_under(mWx,"WxSingleChoiceDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxSingleChoiceDialog,WxSingleChoiceDialog::alloc);
    rb_define_singleton_method(rb_cWxSingleChoiceDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSingleChoiceDialog, "initialize", VALUEFUNC(WxSingleChoiceDialog::init), -1);
    rb_define_method(rb_cWxSingleChoiceDialog, "SetSelection", VALUEFUNC(WxSingleChoiceDialog::SetSelection), 1);
    rb_define_method(rb_cWxSingleChoiceDialog, "GetSelection", VALUEFUNC(WxSingleChoiceDialog::GetSelection), 0);
    rb_define_method(rb_cWxSingleChoiceDialog, "GetStringSelection", VALUEFUNC(WxSingleChoiceDialog::GetStringSelection), 0);

    rb_cWxStaticText = rb_define_class_under(mWx,"WxStaticText", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxStaticText,WxStaticText::alloc);
    rb_define_singleton_method(rb_cWxStaticText, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxStaticText, "initialize", VALUEFUNC(WxStaticText::init), -1);
    rb_define_method(rb_cWxStaticText, "SetLabel", VALUEFUNC(WxStaticText::SetLabel), 1);
    rb_define_method(rb_cWxStaticText, "SetFont", VALUEFUNC(WxStaticText::SetFont), 1);

    rb_cWxStaticBox = rb_define_class_under(mWx,"WxStaticBox", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxStaticBox,WxStaticBox::alloc);
    rb_define_singleton_method(rb_cWxStaticBox, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxStaticBox, "initialize", VALUEFUNC(WxStaticBox::init), -1);

    rb_cWxStaticLine = rb_define_class_under(mWx,"WxStaticLine", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxStaticLine,WxStaticLine::alloc);
    rb_define_singleton_method(rb_cWxStaticLine, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxStaticLine, "initialize", VALUEFUNC(WxStaticLine::init), -1);

    rb_cWxTimer = rb_define_class_under(mWx,"WxTimer", rb_cObject);
    rb_define_alloc_func(rb_cWxTimer,WxTimer::alloc);
    rb_define_singleton_method(rb_cWxTimer, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxTimer, "initialize", VALUEFUNC(WxTimer::init), -1);
    rb_define_method(rb_cWxTimer, "Start", VALUEFUNC(WxTimer::Start), -1);
    rb_define_method(rb_cWxTimer, "Stop", VALUEFUNC(WxTimer::Stop), 0);

    rb_cWxStopWatch = rb_define_class_under(mWx,"WxStopWatch", rb_cObject);
    rb_define_alloc_func(rb_cWxStopWatch,WxStopWatch::alloc);
    rb_define_singleton_method(rb_cWxStopWatch, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxStopWatch, "initialize", VALUEFUNC(WxStopWatch::init), 0);
    rb_define_method(rb_cWxStopWatch, "Pause", VALUEFUNC(WxStopWatch::Pause), 0);
    rb_define_method(rb_cWxStopWatch, "Resume", VALUEFUNC(WxStopWatch::Resume), 0);
    rb_define_method(rb_cWxStopWatch, "Start", VALUEFUNC(WxStopWatch::Start), -1);
    rb_define_method(rb_cWxStopWatch, "Time", VALUEFUNC(WxStopWatch::Time), 0);
    rb_define_method(rb_cWxStopWatch, "free", VALUEFUNC(WxStopWatch::free), 0);

    rb_cWxConfigBase = rb_define_class_under(mWx,"WxConfigBase", rb_cObject);
    rb_define_alloc_func(rb_cWxConfigBase,WxConfigBase::alloc);
//    rb_define_method(rb_cWxConfigBase, "initialize", VALUEFUNC(WxConfigBase::init), -1);
    rb_define_singleton_method(rb_cWxConfigBase, "Get", VALUEFUNC(WxConfigBase::Get), -1);
    rb_define_singleton_method(rb_cWxConfigBase, "Set", VALUEFUNC(WxConfigBase::Set), 1);
    rb_define_singleton_method(rb_cWxConfigBase, "Create", VALUEFUNC(WxConfigBase::Create), 0);
    rb_define_singleton_method(rb_cWxConfigBase, "DontCreateOnDemand", VALUEFUNC(WxConfigBase::DontCreateOnDemand), 0);
    rb_define_method(rb_cWxConfigBase, "free", VALUEFUNC(WxConfigBase::free), 0);
    rb_define_method(rb_cWxConfigBase, "Read", VALUEFUNC(WxConfigBase::Read), -1);
    rb_define_method(rb_cWxConfigBase, "ReadInt", VALUEFUNC(WxConfigBase::ReadInt), -1);
    rb_define_method(rb_cWxConfigBase, "ReadBool", VALUEFUNC(WxConfigBase::ReadBool), -1);
    rb_define_method(rb_cWxConfigBase, "ReadFloat", VALUEFUNC(WxConfigBase::ReadFloat), -1);
    rb_define_method(rb_cWxConfigBase, "SetExpandEnvVars", VALUEFUNC(WxConfigBase::SetExpandEnvVars), -1);
    rb_define_method(rb_cWxConfigBase, "SetPath", VALUEFUNC(WxConfigBase::SetPath), 1);
    rb_define_method(rb_cWxConfigBase, "SetRecordDefaults", VALUEFUNC(WxConfigBase::SetRecordDefaults), -1);
    rb_define_method(rb_cWxConfigBase, "Write", VALUEFUNC(WxConfigBase::Write), 2);
    rb_define_method(rb_cWxConfigBase, "DeleteAll", VALUEFUNC(WxConfigBase::DeleteAll), 0);

    rb_cWxConfig = rb_define_class_under(mWx,"WxConfig", rb_cWxConfigBase);
    rb_define_alloc_func(rb_cWxConfig,WxConfig::alloc);
    rb_define_singleton_method(rb_cWxConfig, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxConfig, "initialize", VALUEFUNC(WxConfig::init), -1);

    rb_cWxBitmap = rb_define_class_under(mWx,"WxBitmap", rb_cObject);
    rb_define_alloc_func(rb_cWxBitmap,WxBitmap::alloc);
    rb_define_singleton_method(rb_cWxBitmap, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxBitmap, "initialize", VALUEFUNC(WxBitmap::init), -1);
    rb_define_method(rb_cWxBitmap, "GetWidth", VALUEFUNC(WxBitmap::GetWidth), 0);
    rb_define_method(rb_cWxBitmap, "GetHeight", VALUEFUNC(WxBitmap::GetHeight), 0);
    rb_define_method(rb_cWxBitmap, "Ok", VALUEFUNC(WxBitmap::Ok), 0);
    rb_define_method(rb_cWxBitmap, "SetMask", VALUEFUNC(WxBitmap::SetMask), 1);
    rb_define_method(rb_cWxBitmap, "GetMask", VALUEFUNC(WxBitmap::GetMask), 0);
    rb_define_method(rb_cWxBitmap, "ConvertToImage", VALUEFUNC(WxBitmap::ConvertToImage), 0);

    rb_cWxStaticBitmap = rb_define_class_under(mWx,"WxStaticBitmap", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxStaticBitmap,WxStaticBitmap::alloc);
    rb_define_singleton_method(rb_cWxStaticBitmap, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxStaticBitmap, "initialize", VALUEFUNC(WxStaticBitmap::init), -1);
    rb_define_method(rb_cWxStaticBitmap, "SetBitmap", VALUEFUNC(WxStaticBitmap::SetBitmap), 1);

    rb_cWxButton = rb_define_class_under(mWx,"WxButton", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxButton,WxButton::alloc);
    rb_define_singleton_method(rb_cWxButton, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxButton, "initialize", VALUEFUNC(WxButton::init), -1);
    rb_define_method(rb_cWxButton, "GetDefaultSize", VALUEFUNC(WxButton::GetDefaultSize), 0);
    rb_define_method(rb_cWxButton, "GetLabel", VALUEFUNC(WxButton::GetLabel), 0);
    rb_define_method(rb_cWxButton, "SetDefault", VALUEFUNC(WxButton::SetDefault), 0);
    rb_define_method(rb_cWxButton, "SetLabel", VALUEFUNC(WxButton::SetLabel), 1);

    rb_cWxBitmapButton = rb_define_class_under(mWx,"WxBitmapButton", rb_cWxButton);
    rb_define_alloc_func(rb_cWxBitmapButton,WxBitmapButton::alloc);
    rb_define_singleton_method(rb_cWxBitmapButton, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxBitmapButton, "initialize", VALUEFUNC(WxBitmapButton::init), -1);
    rb_define_method(rb_cWxBitmapButton, "GetBitmapDisabled", VALUEFUNC(WxBitmapButton::GetBitmapDisabled), 0);
    rb_define_method(rb_cWxBitmapButton, "GetBitmapFocus", VALUEFUNC(WxBitmapButton::GetBitmapFocus), 0);
    rb_define_method(rb_cWxBitmapButton, "GetBitmapLabel", VALUEFUNC(WxBitmapButton::GetBitmapLabel), 0);
    rb_define_method(rb_cWxBitmapButton, "GetBitmapSelected", VALUEFUNC(WxBitmapButton::GetBitmapSelected), 0);
    rb_define_method(rb_cWxBitmapButton, "SetBitmapDisabled", VALUEFUNC(WxBitmapButton::SetBitmapDisabled), 1);
    rb_define_method(rb_cWxBitmapButton, "SetBitmapFocus", VALUEFUNC(WxBitmapButton::SetBitmapFocus), 1);
    rb_define_method(rb_cWxBitmapButton, "SetBitmapLabel", VALUEFUNC(WxBitmapButton::SetBitmapLabel), 1);
    rb_define_method(rb_cWxBitmapButton, "SetBitmapSelected", VALUEFUNC(WxBitmapButton::SetBitmapSelected), 1);

    rb_cWxToggleButton = rb_define_class_under(mWx,"WxToggleButton", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxToggleButton,WxToggleButton::alloc);
    rb_define_singleton_method(rb_cWxToggleButton, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxToggleButton, "initialize", VALUEFUNC(WxToggleButton::init), -1);
    rb_define_method(rb_cWxToggleButton, "GetValue", VALUEFUNC(WxToggleButton::GetValue), 0);
    rb_define_method(rb_cWxToggleButton, "SetValue", VALUEFUNC(WxToggleButton::SetValue), 1);

    rb_cWxIcon = rb_define_class_under(mWx,"WxIcon", rb_cWxBitmap);
    rb_define_alloc_func(rb_cWxIcon,WxIcon::alloc);
    rb_define_singleton_method(rb_cWxIcon, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxIcon, "initialize", VALUEFUNC(WxIcon::init), -1);
    rb_define_method(rb_cWxIcon, "Ok", VALUEFUNC(WxIcon::Ok), 0);
    rb_define_method(rb_cWxIcon, "CopyFromBitmap", VALUEFUNC(WxIcon::CopyFromBitmap), 1);
    rb_define_method(rb_cWxIcon, "GetDepth", VALUEFUNC(WxIcon::GetDepth), 0);
    rb_define_method(rb_cWxIcon, "GetHeight", VALUEFUNC(WxIcon::GetHeight), 0);
    rb_define_method(rb_cWxIcon, "GetWidth", VALUEFUNC(WxIcon::GetWidth), 0);
    rb_define_method(rb_cWxIcon, "LoadFile", VALUEFUNC(WxIcon::LoadFile), 2);
    rb_define_method(rb_cWxIcon, "SetDepth", VALUEFUNC(WxIcon::SetDepth), 1);
    rb_define_method(rb_cWxIcon, "SetHeight", VALUEFUNC(WxIcon::SetHeight), 1);
//    rb_define_method(rb_cWxIcon, "SetOk", VALUEFUNC(WxIcon::SetOk), 1);
    rb_define_method(rb_cWxIcon, "SetWidth", VALUEFUNC(WxIcon::SetWidth), 1);

    rb_cWxMask = rb_define_class_under(mWx,"WxMask", rb_cObject);
    rb_define_alloc_func(rb_cWxMask,WxMask::alloc);
    rb_define_singleton_method(rb_cWxMask, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxMask, "initialize", VALUEFUNC(WxMask::init), -1);

    rb_cWxCursor = rb_define_class_under(mWx,"WxCursor", rb_cWxBitmap);
    rb_define_alloc_func(rb_cWxCursor,WxCursor::alloc);
    rb_define_singleton_method(rb_cWxCursor, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxCursor, "initialize", VALUEFUNC(WxCursor::init), -1);
    rb_define_method(rb_cWxCursor, "Ok", VALUEFUNC(WxCursor::Ok), 0);

    rb_cWxBusyCursor = rb_define_class_under(mWx,"WxBusyCursor", rb_cObject);
    rb_define_alloc_func(rb_cWxBusyCursor,WxBusyCursor::alloc);
    rb_define_singleton_method(rb_cWxBusyCursor, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxBusyCursor, "initialize", VALUEFUNC(WxBusyCursor::init), -1);
    rb_define_method(rb_cWxBusyCursor, "free", VALUEFUNC(WxBusyCursor::free), 0);

    rb_cWxFileDialog = rb_define_class_under(mWx,"WxFileDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxFileDialog,WxFileDialog::alloc);
    rb_define_singleton_method(rb_cWxFileDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFileDialog, "initialize", VALUEFUNC(WxFileDialog::init), -1);
    rb_define_method(rb_cWxFileDialog, "GetDirectory", VALUEFUNC(WxFileDialog::GetDirectory), 0);
    rb_define_method(rb_cWxFileDialog, "GetFilename", VALUEFUNC(WxFileDialog::GetFilename), 0);
    rb_define_method(rb_cWxFileDialog, "GetFilenames", VALUEFUNC(WxFileDialog::GetFilenames), 0);
    rb_define_method(rb_cWxFileDialog, "GetFilterIndex", VALUEFUNC(WxFileDialog::GetFilterIndex), 0);
    rb_define_method(rb_cWxFileDialog, "GetMessage", VALUEFUNC(WxFileDialog::GetMessage), 0);
    rb_define_method(rb_cWxFileDialog, "GetPath", VALUEFUNC(WxFileDialog::GetPath), 0);
    rb_define_method(rb_cWxFileDialog, "GetPaths", VALUEFUNC(WxFileDialog::GetPaths), 0);
    rb_define_method(rb_cWxFileDialog, "GetStyle", VALUEFUNC(WxFileDialog::GetStyle), 0);
    rb_define_method(rb_cWxFileDialog, "GetWildcard", VALUEFUNC(WxFileDialog::GetWildcard), 0);
    rb_define_method(rb_cWxFileDialog, "SetDirectory", VALUEFUNC(WxFileDialog::SetDirectory), 1);
    rb_define_method(rb_cWxFileDialog, "SetFilename", VALUEFUNC(WxFileDialog::SetFilename), 1);
    rb_define_method(rb_cWxFileDialog, "SetFilterIndex", VALUEFUNC(WxFileDialog::SetFilterIndex), 1);
    rb_define_method(rb_cWxFileDialog, "SetMessage", VALUEFUNC(WxFileDialog::SetMessage), 1);
    rb_define_method(rb_cWxFileDialog, "SetPath", VALUEFUNC(WxFileDialog::SetPath), 1);
    rb_define_method(rb_cWxFileDialog, "SetStyle", VALUEFUNC(WxFileDialog::SetStyle), 1);
    rb_define_method(rb_cWxFileDialog, "SetWildcard", VALUEFUNC(WxFileDialog::SetWildcard), 1);

    rb_cWxDirDialog = rb_define_class_under(mWx,"WxDirDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxDirDialog,WxDirDialog::alloc);
    rb_define_singleton_method(rb_cWxDirDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxDirDialog, "initialize", VALUEFUNC(WxDirDialog::init), -1);
    rb_define_method(rb_cWxDirDialog, "ShowModal", VALUEFUNC(WxDirDialog::ShowModal), 0);
    rb_define_method(rb_cWxDirDialog, "GetPath", VALUEFUNC(WxDirDialog::GetPath), 0);

    rb_cWxColourDialog = rb_define_class_under(mWx,"WxColourDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxColourDialog,WxColourDialog::alloc);
    rb_define_singleton_method(rb_cWxColourDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxColourDialog, "initialize", VALUEFUNC(WxColourDialog::init), -1);
    rb_define_method(rb_cWxColourDialog, "ShowModal", VALUEFUNC(WxColourDialog::ShowModal), 0);
    rb_define_method(rb_cWxColourDialog, "GetColourData", VALUEFUNC(WxColourDialog::GetColourData), 0);

    rb_cWxFontDialog = rb_define_class_under(mWx,"WxFontDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxFontDialog,WxFontDialog::alloc);
    rb_define_singleton_method(rb_cWxFontDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFontDialog, "initialize", VALUEFUNC(WxFontDialog::init), -1);
    rb_define_method(rb_cWxFontDialog, "ShowModal", VALUEFUNC(WxFontDialog::ShowModal), 0);
    rb_define_method(rb_cWxFontDialog, "GetFontData", VALUEFUNC(WxFontDialog::GetFontData), 0);

    rb_cWxMessageDialog = rb_define_class_under(mWx,"WxMessageDialog", rb_cWxDialog);
    rb_define_alloc_func(rb_cWxMessageDialog,WxMessageDialog::alloc);
    rb_define_singleton_method(rb_cWxMessageDialog, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxMessageDialog, "initialize", VALUEFUNC(WxMessageDialog::init), -1);
    rb_define_method(rb_cWxMessageDialog, "ShowModal", VALUEFUNC(WxMessageDialog::ShowModal), 0);

    rb_cWxSlider = rb_define_class_under(mWx,"WxSlider", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxSlider,WxSlider::alloc);
    rb_define_singleton_method(rb_cWxSlider, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSlider, "initialize", VALUEFUNC(WxSlider::init), -1);
    rb_define_method(rb_cWxSlider, "ClearSel", VALUEFUNC(WxSlider::ClearSel), 0);
    rb_define_method(rb_cWxSlider, "ClearTicks", VALUEFUNC(WxSlider::ClearTicks), 0);
    rb_define_method(rb_cWxSlider, "GetLineSize", VALUEFUNC(WxSlider::GetLineSize), 0);
    rb_define_method(rb_cWxSlider, "GetMax", VALUEFUNC(WxSlider::GetMax), 0);
    rb_define_method(rb_cWxSlider, "GetMin", VALUEFUNC(WxSlider::GetMin), 0);
    rb_define_method(rb_cWxSlider, "GetPageSize", VALUEFUNC(WxSlider::GetPageSize), 0);
    rb_define_method(rb_cWxSlider, "GetSelEnd", VALUEFUNC(WxSlider::GetSelEnd), 0);
    rb_define_method(rb_cWxSlider, "GetSelStart", VALUEFUNC(WxSlider::GetSelStart), 0);
    rb_define_method(rb_cWxSlider, "GetThumbLength", VALUEFUNC(WxSlider::GetThumbLength), 0);
    rb_define_method(rb_cWxSlider, "GetTickFreq", VALUEFUNC(WxSlider::GetTickFreq), 0);
    rb_define_method(rb_cWxSlider, "GetValue", VALUEFUNC(WxSlider::GetValue), 0);
    rb_define_method(rb_cWxSlider, "SetRange", VALUEFUNC(WxSlider::SetRange), 2);
    rb_define_method(rb_cWxSlider, "SetTickFreq", VALUEFUNC(WxSlider::SetTickFreq), 2);
    rb_define_method(rb_cWxSlider, "SetLineSize", VALUEFUNC(WxSlider::SetLineSize), 1);
    rb_define_method(rb_cWxSlider, "SetPageSize", VALUEFUNC(WxSlider::SetPageSize), 1);
    rb_define_method(rb_cWxSlider, "SetSelection", VALUEFUNC(WxSlider::SetSelection), 2);
    rb_define_method(rb_cWxSlider, "SetThumbLength", VALUEFUNC(WxSlider::SetThumbLength), 1);
    rb_define_method(rb_cWxSlider, "SetTick", VALUEFUNC(WxSlider::SetTick), 1);
    rb_define_method(rb_cWxSlider, "SetValue", VALUEFUNC(WxSlider::SetValue), 1);

    rb_cWxGauge = rb_define_class_under(mWx,"WxGauge", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxGauge,WxGauge::alloc);
    rb_define_singleton_method(rb_cWxGauge, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxGauge, "initialize", VALUEFUNC(WxGauge::init), -1);
    rb_define_method(rb_cWxGauge, "SetBezelFace", VALUEFUNC(WxGauge::SetBezelFace), 1);
    rb_define_method(rb_cWxGauge, "SetRange", VALUEFUNC(WxGauge::SetRange), 1);
    rb_define_method(rb_cWxGauge, "SetShadowWidth", VALUEFUNC(WxGauge::SetShadowWidth), 1);
    rb_define_method(rb_cWxGauge, "SetValue", VALUEFUNC(WxGauge::SetValue), 1);
    rb_define_method(rb_cWxGauge, "GetBezelFace", VALUEFUNC(WxGauge::GetBezelFace), 0);
    rb_define_method(rb_cWxGauge, "GetRange", VALUEFUNC(WxGauge::GetRange), 0);
    rb_define_method(rb_cWxGauge, "GetShadowWidth", VALUEFUNC(WxGauge::GetShadowWidth), 0);
    rb_define_method(rb_cWxGauge, "GetValue", VALUEFUNC(WxGauge::GetValue), 0);

    rb_cWxChoice = rb_define_class_under(mWx,"WxChoice", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxChoice,WxChoice::alloc);
    rb_define_singleton_method(rb_cWxChoice, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxChoice, "initialize", VALUEFUNC(WxChoice::init), -1);
    rb_define_method(rb_cWxChoice, "Append", VALUEFUNC(WxChoice::Append), -1);
    rb_define_method(rb_cWxChoice, "SetSelection", VALUEFUNC(WxChoice::SetSelection), 1);
    rb_define_method(rb_cWxChoice, "SetStringSelection", VALUEFUNC(WxChoice::SetStringSelection), 1);
    rb_define_method(rb_cWxChoice, "SetClientData", VALUEFUNC(WxChoice::SetClientData), 2);
    rb_define_method(rb_cWxChoice, "GetClientData", VALUEFUNC(WxChoice::GetClientData), 1);
    rb_define_method(rb_cWxChoice, "GetCount", VALUEFUNC(WxChoice::GetCount), 0);
    rb_define_method(rb_cWxChoice, "GetSelection", VALUEFUNC(WxChoice::GetSelection), 0);
    rb_define_method(rb_cWxChoice, "GetString", VALUEFUNC(WxChoice::GetString), 1);
    rb_define_method(rb_cWxChoice, "GetStringSelection", VALUEFUNC(WxChoice::GetStringSelection), 0);
    rb_define_method(rb_cWxChoice, "Delete", VALUEFUNC(WxChoice::Delete), 1);
    rb_define_method(rb_cWxChoice, "Clear", VALUEFUNC(WxChoice::Clear), 0);

    rb_cWxComboBox = rb_define_class_under(mWx,"WxComboBox", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxComboBox,WxComboBox::alloc);
    rb_define_singleton_method(rb_cWxComboBox, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxComboBox, "initialize", VALUEFUNC(WxComboBox::init), -1);
    rb_define_method(rb_cWxComboBox, "Append", VALUEFUNC(WxComboBox::Append), -1);
    rb_define_method(rb_cWxComboBox, "SetSelection", VALUEFUNC(WxComboBox::SetSelection), 1);
    rb_define_method(rb_cWxComboBox, "SetStringSelection", VALUEFUNC(WxComboBox::SetStringSelection), 1);
    rb_define_method(rb_cWxComboBox, "SetClientData", VALUEFUNC(WxComboBox::SetClientData), 2);
    rb_define_method(rb_cWxComboBox, "GetClientData", VALUEFUNC(WxComboBox::GetClientData), 1);
    rb_define_method(rb_cWxComboBox, "GetCount", VALUEFUNC(WxComboBox::GetCount), 0);
    rb_define_method(rb_cWxComboBox, "GetSelection", VALUEFUNC(WxComboBox::GetSelection), 0);
    rb_define_method(rb_cWxComboBox, "GetString", VALUEFUNC(WxComboBox::GetString), 1);
    rb_define_method(rb_cWxComboBox, "GetStringSelection", VALUEFUNC(WxComboBox::GetStringSelection), 0);
    rb_define_method(rb_cWxComboBox, "Delete", VALUEFUNC(WxComboBox::Delete), 1);
    rb_define_method(rb_cWxComboBox, "Clear", VALUEFUNC(WxComboBox::Clear), 0);

    rb_cWxListBox = rb_define_class_under(mWx,"WxListBox", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxListBox,WxListBox::alloc);
    rb_define_singleton_method(rb_cWxListBox, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxListBox, "initialize", VALUEFUNC(WxListBox::init), -1);
    rb_define_method(rb_cWxListBox, "Append", VALUEFUNC(WxListBox::Append), 1);
    rb_define_method(rb_cWxListBox, "SetSelection", VALUEFUNC(WxListBox::SetSelection), -1);
    rb_define_method(rb_cWxListBox, "GetString", VALUEFUNC(WxListBox::GetString), 1);
    rb_define_method(rb_cWxListBox, "GetStringSelection", VALUEFUNC(WxListBox::GetStringSelection), 0);
#ifdef __WXMSW__
    rb_define_method(rb_cWxListBox, "GetItem", VALUEFUNC(WxListBox::GetItem), 1);
#endif
    rb_define_method(rb_cWxListBox, "Deselect", VALUEFUNC(WxListBox::Deselect), 1);
    rb_define_method(rb_cWxListBox, "Delete", VALUEFUNC(WxListBox::Delete), 1);
    rb_define_method(rb_cWxListBox, "DeselectAll", VALUEFUNC(WxListBox::DeselectAll), -1);
    rb_define_method(rb_cWxListBox, "IsSelected", VALUEFUNC(WxListBox::IsSelected), 1);
    rb_define_method(rb_cWxListBox, "Select", VALUEFUNC(WxListBox::Select), 1);
    rb_define_method(rb_cWxListBox, "GetSelection", VALUEFUNC(WxListBox::GetSelection), 0);
    rb_define_method(rb_cWxListBox, "GetSelections", VALUEFUNC(WxListBox::GetSelections), 0);
    rb_define_method(rb_cWxListBox, "GetCount", VALUEFUNC(WxListBox::GetCount), 0);
    rb_define_method(rb_cWxListBox, "InsertItems", VALUEFUNC(WxListBox::InsertItems), 2);
    rb_define_method(rb_cWxListBox, "SetClientData", VALUEFUNC(WxListBox::SetClientData), 2);
    rb_define_method(rb_cWxListBox,"GetClientData",VALUEFUNC(WxListBox::GetClientData),1);
    rb_define_method(rb_cWxListBox, "SetString", VALUEFUNC(WxListBox::SetString), 2);
    rb_define_method(rb_cWxListBox, "SetStringSelection", VALUEFUNC(WxListBox::SetStringSelection), -1);
    rb_define_method(rb_cWxListBox, "Clear", VALUEFUNC(WxListBox::Clear), 0);

    rb_cWxImage = rb_define_class_under(mWx,"WxImage", rb_cObject);
    rb_define_alloc_func(rb_cWxImage,WxImage::alloc);
    rb_define_singleton_method(rb_cWxImage, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxImage, "initialize", VALUEFUNC(WxImage::init), -1);
    rb_define_method(rb_cWxImage, "ConvertToBitmap", VALUEFUNC(WxImage::ConvertToBitmap), 0);
    rb_define_method(rb_cWxImage, "ConvertToMono", VALUEFUNC(WxImage::ConvertToMono), 3);
    rb_define_method(rb_cWxImage, "Copy", VALUEFUNC(WxImage::Copy), 0);
    rb_define_method(rb_cWxImage, "Create", VALUEFUNC(WxImage::Create), 2);
    rb_define_method(rb_cWxImage, "Destroy", VALUEFUNC(WxImage::Destroy), 0);
    rb_define_method(rb_cWxImage, "GetBlue", VALUEFUNC(WxImage::GetBlue), 2);
    rb_define_method(rb_cWxImage, "GetData", VALUEFUNC(WxImage::GetData), 0);
    rb_define_method(rb_cWxImage, "GetGreen", VALUEFUNC(WxImage::GetGreen), 2);
    rb_define_method(rb_cWxImage, "GetHeight", VALUEFUNC(WxImage::GetHeight), 0);
    rb_define_method(rb_cWxImage, "GetImageCount", VALUEFUNC(WxImage::GetImageCount), -1);
    rb_define_method(rb_cWxImage, "GetMaskBlue", VALUEFUNC(WxImage::GetMaskBlue), 0);
    rb_define_method(rb_cWxImage, "GetMaskGreen", VALUEFUNC(WxImage::GetMaskGreen), 0);
    rb_define_method(rb_cWxImage, "GetMaskRed", VALUEFUNC(WxImage::GetMaskRed), 0);
    rb_define_method(rb_cWxImage, "GetOption", VALUEFUNC(WxImage::GetOption), 1);
    rb_define_method(rb_cWxImage, "GetOptionInt", VALUEFUNC(WxImage::GetOptionInt), 1);
    rb_define_method(rb_cWxImage, "GetPalette", VALUEFUNC(WxImage::GetPalette), 0);
    rb_define_method(rb_cWxImage, "GetRed", VALUEFUNC(WxImage::GetRed), 2);
    rb_define_method(rb_cWxImage, "HasOption", VALUEFUNC(WxImage::HasOption), 1);
    rb_define_method(rb_cWxImage, "GetSubImage", VALUEFUNC(WxImage::GetSubImage), 1);
    rb_define_method(rb_cWxImage, "GetWidth", VALUEFUNC(WxImage::GetWidth), 0);
    rb_define_method(rb_cWxImage, "HasMask", VALUEFUNC(WxImage::HasMask), 0);
    rb_define_method(rb_cWxImage, "LoadFile", VALUEFUNC(WxImage::LoadFile), -1);
    rb_define_method(rb_cWxImage, "Mirror", VALUEFUNC(WxImage::Mirror), -1);
    rb_define_method(rb_cWxImage, "Ok", VALUEFUNC(WxImage::Ok), 0);
    rb_define_method(rb_cWxImage, "Replace", VALUEFUNC(WxImage::Replace), 6);
    rb_define_method(rb_cWxImage, "Rescale", VALUEFUNC(WxImage::Rescale), 2);
    rb_define_method(rb_cWxImage, "Rotate", VALUEFUNC(WxImage::Rotate), -1);
    rb_define_method(rb_cWxImage, "Rotate90", VALUEFUNC(WxImage::Rotate90), -1);
    rb_define_method(rb_cWxImage, "SaveFile", VALUEFUNC(WxImage::SaveFile), -1);
    rb_define_method(rb_cWxImage, "Scale", VALUEFUNC(WxImage::Scale), 2);
    rb_define_method(rb_cWxImage, "SetData", VALUEFUNC(WxImage::SetData), 1);
    rb_define_method(rb_cWxImage, "SetMask", VALUEFUNC(WxImage::SetMask), -1);
    rb_define_method(rb_cWxImage, "SetMaskColour", VALUEFUNC(WxImage::SetMaskColour), 3);
    rb_define_method(rb_cWxImage, "SetMaskFromImage", VALUEFUNC(WxImage::SetMaskFromImage), 4);
    rb_define_method(rb_cWxImage, "SetOption", VALUEFUNC(WxImage::SetOption), 2);
    rb_define_method(rb_cWxImage, "SetPalette", VALUEFUNC(WxImage::SetPalette), 1);
    rb_define_method(rb_cWxImage, "SetRGB", VALUEFUNC(WxImage::SetRGB), 5);

    rb_cWxImageList = rb_define_class_under(mWx,"WxImageList", rb_cObject);
    rb_define_alloc_func(rb_cWxImageList,WxImageList::alloc);
    rb_define_singleton_method(rb_cWxImageList, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxImageList, "initialize", VALUEFUNC(WxImageList::init), -1);
    rb_define_method(rb_cWxImageList, "Add", VALUEFUNC(WxImageList::Add), -1);
    rb_define_method(rb_cWxImageList, "AddWithColourMask", VALUEFUNC(WxImageList::AddWithColourMask), 2);
    rb_define_method(rb_cWxImageList, "Draw", VALUEFUNC(WxImageList::Draw), -1);
    rb_define_method(rb_cWxImageList, "GetImageCount", VALUEFUNC(WxImageList::GetImageCount), 0);
    rb_define_method(rb_cWxImageList, "GetSize", VALUEFUNC(WxImageList::GetSize), 1);
    rb_define_method(rb_cWxImageList, "Remove", VALUEFUNC(WxImageList::Remove), 1);
    rb_define_method(rb_cWxImageList, "RemoveAll", VALUEFUNC(WxImageList::RemoveAll), 0);
    rb_define_method(rb_cWxImageList, "Replace", VALUEFUNC(WxImageList::Replace), -1);
#ifdef __WXMSW__
    rb_define_method(rb_cWxImageList, "ReplaceIcon", VALUEFUNC(WxImageList::ReplaceIcon), 2);
#endif

    rb_cWxListCtrl = rb_define_class_under(mWx,"WxListCtrl", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxListCtrl,WxListCtrl::alloc);
    rb_define_singleton_method(rb_cWxListCtrl, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxListCtrl, "initialize", VALUEFUNC(WxListCtrl::init), -1);
    rb_define_method(rb_cWxListCtrl, "Arrange", VALUEFUNC(WxListCtrl::Arrange), -1);
    rb_define_method(rb_cWxListCtrl, "AssignImageList", VALUEFUNC(WxListCtrl::AssignImageList), 2);
    rb_define_method(rb_cWxListCtrl, "ClearAll", VALUEFUNC(WxListCtrl::ClearAll), 0);
    rb_define_method(rb_cWxListCtrl, "DeleteAllItems", VALUEFUNC(WxListCtrl::DeleteAllItems), 0);
    rb_define_method(rb_cWxListCtrl, "DeleteColumn", VALUEFUNC(WxListCtrl::DeleteColumn), 1);
    rb_define_method(rb_cWxListCtrl, "DeleteItem", VALUEFUNC(WxListCtrl::DeleteItem), 1);
    rb_define_method(rb_cWxListCtrl, "EditLabel", VALUEFUNC(WxListCtrl::EditLabel), 1);
    rb_define_method(rb_cWxListCtrl, "EnsureVisible", VALUEFUNC(WxListCtrl::EnsureVisible), 1);
    rb_define_method(rb_cWxListCtrl, "FindItem", VALUEFUNC(WxListCtrl::FindItem), -1);
    rb_define_method(rb_cWxListCtrl, "GetColumn", VALUEFUNC(WxListCtrl::GetColumn), 2);
    rb_define_method(rb_cWxListCtrl, "GetColumnCount", VALUEFUNC(WxListCtrl::GetColumnCount), 0);
    rb_define_method(rb_cWxListCtrl, "GetColumnWidth", VALUEFUNC(WxListCtrl::GetColumnWidth), 1);
    rb_define_method(rb_cWxListCtrl, "GetCountPerPage", VALUEFUNC(WxListCtrl::GetCountPerPage), 0);
#ifdef __WXMSW__
    rb_define_method(rb_cWxListCtrl, "GetEditControl", VALUEFUNC(WxListCtrl::GetEditControl), 0);
#endif
    rb_define_method(rb_cWxListCtrl, "GetImageList", VALUEFUNC(WxListCtrl::GetImageList), 1);
    rb_define_method(rb_cWxListCtrl, "GetItemCount", VALUEFUNC(WxListCtrl::GetItemCount), 0);
    rb_define_method(rb_cWxListCtrl, "GetItem", VALUEFUNC(WxListCtrl::GetItem), 1);
    rb_define_method(rb_cWxListCtrl, "GetItemData", VALUEFUNC(WxListCtrl::GetItemData), 1);
    rb_define_method(rb_cWxListCtrl, "GetItemPosition", VALUEFUNC(WxListCtrl::GetItemPosition), 1);
    rb_define_method(rb_cWxListCtrl, "GetItemRect", VALUEFUNC(WxListCtrl::GetItemRect), -1);
    rb_define_method(rb_cWxListCtrl, "GetItemSpacing", VALUEFUNC(WxListCtrl::GetItemSpacing), 1);
    rb_define_method(rb_cWxListCtrl, "GetItemState", VALUEFUNC(WxListCtrl::GetItemState), 2);
    rb_define_method(rb_cWxListCtrl, "GetItemText", VALUEFUNC(WxListCtrl::GetItemText), -1);
    rb_define_method(rb_cWxListCtrl, "GetSelectedItemCount", VALUEFUNC(WxListCtrl::GetSelectedItemCount), 0);
    rb_define_method(rb_cWxListCtrl, "GetTextColour", VALUEFUNC(WxListCtrl::GetTextColour), 0);
    rb_define_method(rb_cWxListCtrl, "GetTopItem", VALUEFUNC(WxListCtrl::GetTopItem), 0);
    rb_define_method(rb_cWxListCtrl, "HitTest", VALUEFUNC(WxListCtrl::HitTest), 1);
    rb_define_method(rb_cWxListCtrl, "InsertColumn", VALUEFUNC(WxListCtrl::InsertColumn), -1);
    rb_define_method(rb_cWxListCtrl, "InsertItem", VALUEFUNC(WxListCtrl::InsertItem), -1);
    rb_define_method(rb_cWxListCtrl, "ScrollList", VALUEFUNC(WxListCtrl::ScrollList), 2);
    rb_define_method(rb_cWxListCtrl, "SetBackgroundColour", VALUEFUNC(WxListCtrl::SetBackgroundColour), 1);
    rb_define_method(rb_cWxListCtrl, "SetColumn", VALUEFUNC(WxListCtrl::SetColumn), 2);
    rb_define_method(rb_cWxListCtrl, "SetColumnWidth", VALUEFUNC(WxListCtrl::SetColumnWidth), 2);
    rb_define_method(rb_cWxListCtrl, "SetImageList", VALUEFUNC(WxListCtrl::SetImageList), 2);
    rb_define_method(rb_cWxListCtrl, "SetItem", VALUEFUNC(WxListCtrl::SetItem), -1);
    rb_define_method(rb_cWxListCtrl, "SetItemCount", VALUEFUNC(WxListCtrl::SetItemCount), 1);
    rb_define_method(rb_cWxListCtrl, "SetItemData", VALUEFUNC(WxListCtrl::SetItemData), 2);
    rb_define_method(rb_cWxListCtrl, "SetItemImage", VALUEFUNC(WxListCtrl::SetItemImage), 3);
    rb_define_method(rb_cWxListCtrl, "SetItemPosition", VALUEFUNC(WxListCtrl::SetItemPosition), 2);
    rb_define_method(rb_cWxListCtrl, "SetItemState", VALUEFUNC(WxListCtrl::SetItemState), 3);
    rb_define_method(rb_cWxListCtrl, "SetItemText", VALUEFUNC(WxListCtrl::SetItemText), 2);
    rb_define_method(rb_cWxListCtrl, "SetSingleStyle", VALUEFUNC(WxListCtrl::SetSingleStyle), -1);
    rb_define_method(rb_cWxListCtrl, "SetTextColour", VALUEFUNC(WxListCtrl::SetTextColour), 1);
    rb_define_method(rb_cWxListCtrl, "SetWindowStyleFlag", VALUEFUNC(WxListCtrl::SetWindowStyleFlag), 1);
    rb_define_method(rb_cWxListCtrl, "GetNextItem", VALUEFUNC(WxListCtrl::GetNextItem), -1);
    rb_define_method(rb_cWxListCtrl, "SortItems", VALUEFUNC(WxListCtrl::SortItems), 2);
    rb_define_method(rb_cWxListCtrl, "IsVirtual", VALUEFUNC(WxListCtrl::IsVirtual), 0);
    rb_define_method(rb_cWxListCtrl, "RefreshItem", VALUEFUNC(WxListCtrl::RefreshItem), 1);
    rb_define_method(rb_cWxListCtrl, "RefreshItems", VALUEFUNC(WxListCtrl::RefreshItems), 2);

    rb_cWxCheckBox = rb_define_class_under(mWx,"WxCheckBox", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxCheckBox,WxCheckBox::alloc);
    rb_define_singleton_method(rb_cWxCheckBox, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxCheckBox, "initialize", VALUEFUNC(WxCheckBox::init), -1);
    rb_define_method(rb_cWxCheckBox, "GetValue", VALUEFUNC(WxCheckBox::GetValue), 0);
    rb_define_method(rb_cWxCheckBox, "SetValue", VALUEFUNC(WxCheckBox::SetValue), 1);

    rb_cWxRadioButton = rb_define_class_under(mWx,"WxRadioButton", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxRadioButton,WxRadioButton::alloc);
    rb_define_singleton_method(rb_cWxRadioButton, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxRadioButton, "initialize", VALUEFUNC(WxRadioButton::init), -1);
    rb_define_method(rb_cWxRadioButton, "GetValue", VALUEFUNC(WxRadioButton::GetValue), 0);
    rb_define_method(rb_cWxRadioButton, "SetValue", VALUEFUNC(WxRadioButton::SetValue), 1);

    rb_cWxRadioBox = rb_define_class_under(mWx,"WxRadioBox", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxRadioBox,WxRadioBox::alloc);
    rb_define_singleton_method(rb_cWxRadioBox, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxRadioBox, "initialize", VALUEFUNC(WxRadioBox::init), -1);
    rb_define_method(rb_cWxRadioBox, "SetSelection", VALUEFUNC(WxRadioBox::SetSelection), 1);
    rb_define_method(rb_cWxRadioBox, "GetString", VALUEFUNC(WxRadioBox::GetString), 1);
    rb_define_method(rb_cWxRadioBox, "GetStringSelection", VALUEFUNC(WxRadioBox::GetStringSelection), 0);
    rb_define_method(rb_cWxRadioBox, "SetStringSelection", VALUEFUNC(WxRadioBox::SetStringSelection), 1);

    rb_cWxCheckListBox = rb_define_class_under(mWx,"WxCheckListBox", rb_cWxListBox);
    rb_define_alloc_func(rb_cWxCheckListBox,WxCheckListBox::alloc);
    rb_define_singleton_method(rb_cWxCheckListBox, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxCheckListBox, "initialize", VALUEFUNC(WxCheckListBox::init), -1);
    rb_define_method(rb_cWxCheckListBox, "Check", VALUEFUNC(WxCheckListBox::Check), -1);
    rb_define_method(rb_cWxCheckListBox, "IsChecked", VALUEFUNC(WxCheckListBox::IsChecked), 1);

    rb_cWxIndividualLayoutConstraint = rb_define_class_under(mWx,"WxIndividualLayoutConstraint", rb_cObject);
    rb_define_alloc_func(rb_cWxIndividualLayoutConstraint,WxIndividualLayoutConstraint::alloc);
    rb_define_singleton_method(rb_cWxIndividualLayoutConstraint, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "initialize", VALUEFUNC(WxIndividualLayoutConstraint::init), 0);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "SameAs", VALUEFUNC(WxIndividualLayoutConstraint::SameAs), -1);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "LeftOf", VALUEFUNC(WxIndividualLayoutConstraint::LeftOf), -1);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "RightOf", VALUEFUNC(WxIndividualLayoutConstraint::RightOf), -1);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "Above", VALUEFUNC(WxIndividualLayoutConstraint::Above), -1);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "Below", VALUEFUNC(WxIndividualLayoutConstraint::Below), -1);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "PercentOf", VALUEFUNC(WxIndividualLayoutConstraint::PercentOf), 3);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "AsIs", VALUEFUNC(WxIndividualLayoutConstraint::AsIs), 0);
    rb_define_method(rb_cWxIndividualLayoutConstraint, "Absolute", VALUEFUNC(WxIndividualLayoutConstraint::Absolute), 1);

    rb_cWxLayoutConstraints = rb_define_class_under(mWx,"WxLayoutConstraints", rb_cObject);
    rb_define_alloc_func(rb_cWxLayoutConstraints,WxLayoutConstraints::alloc);
    rb_define_singleton_method(rb_cWxLayoutConstraints, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxLayoutConstraints, "initialize", VALUEFUNC(WxLayoutConstraints::init), 0);
    rb_define_method(rb_cWxLayoutConstraints, "left", VALUEFUNC(WxLayoutConstraints::left), 0);
    rb_define_method(rb_cWxLayoutConstraints, "top", VALUEFUNC(WxLayoutConstraints::top), 0);
    rb_define_method(rb_cWxLayoutConstraints, "width", VALUEFUNC(WxLayoutConstraints::width), 0);
    rb_define_method(rb_cWxLayoutConstraints, "height", VALUEFUNC(WxLayoutConstraints::height), 0);
    rb_define_method(rb_cWxLayoutConstraints, "right", VALUEFUNC(WxLayoutConstraints::right), 0);
    rb_define_method(rb_cWxLayoutConstraints, "bottom", VALUEFUNC(WxLayoutConstraints::bottom), 0);
    rb_define_method(rb_cWxLayoutConstraints, "centreX", VALUEFUNC(WxLayoutConstraints::centreX), 0);
    rb_define_method(rb_cWxLayoutConstraints, "centreY", VALUEFUNC(WxLayoutConstraints::centreY), 0);

    rb_cWxWindowDisabler = rb_define_class_under(mWx,"WxWindowDisabler", rb_cObject);
    rb_define_alloc_func(rb_cWxWindowDisabler,WxWindowDisabler::alloc);
    rb_define_singleton_method(rb_cWxWindowDisabler, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxWindowDisabler, "initialize", VALUEFUNC(WxWindowDisabler::init), -1);
    rb_define_method(rb_cWxWindowDisabler, "free", VALUEFUNC(WxWindowDisabler::free), 0);

    rb_cWxBusyInfo = rb_define_class_under(mWx,"WxBusyInfo", rb_cObject);
    rb_define_alloc_func(rb_cWxBusyInfo,WxBusyInfo::alloc);
    rb_define_singleton_method(rb_cWxBusyInfo, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxBusyInfo, "initialize", VALUEFUNC(WxBusyInfo::init), -1);
    rb_define_method(rb_cWxBusyInfo, "free", VALUEFUNC(WxBusyInfo::free), 0);

    rb_cWxLog = rb_define_class_under(mWx,"WxLog", rb_cObject);
    rb_define_alloc_func(rb_cWxLog,WxLog::alloc);
    rb_define_method(rb_cWxLog, "Flush", VALUEFUNC(WxLog::Flush), 0);
    rb_define_singleton_method(rb_cWxLog, "GetActiveTarget", VALUEFUNC(WxLog::GetActiveTarget), 0);
    rb_define_singleton_method(rb_cWxLog, "SetActiveTarget", VALUEFUNC(WxLog::SetActiveTarget), 1);
    rb_define_singleton_method(rb_cWxLog, "DontCreateOnDemand", VALUEFUNC(WxLog::DontCreateOnDemand), 0);
    rb_define_singleton_method(rb_cWxLog, "FlushActive", VALUEFUNC(WxLog::FlushActive), 0);
    rb_define_singleton_method(rb_cWxLog, "Resume", VALUEFUNC(WxLog::Resume), 0);
    rb_define_singleton_method(rb_cWxLog, "Suspend", VALUEFUNC(WxLog::Suspend), 0);

    rb_cWxLogTextCtrl = rb_define_class_under(mWx,"WxLogTextCtrl", rb_cWxLog);
    rb_define_alloc_func(rb_cWxLogTextCtrl,WxLogTextCtrl::alloc);
    rb_define_singleton_method(rb_cWxLogTextCtrl, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxLogTextCtrl, "initialize", VALUEFUNC(WxLogTextCtrl::init), 1);

    rb_cWxEvent = rb_define_class_under(mWx,"WxEvent", rb_cObject);
    rb_define_alloc_func(rb_cWxEvent,WxEvent::alloc);
    rb_define_method(rb_cWxEvent, "Skip", VALUEFUNC(WxEvent::Skip), -1);
    rb_define_method(rb_cWxEvent, "GetId", VALUEFUNC(WxEvent::GetId), 0);
    rb_define_method(rb_cWxEvent, "GetEventObject", VALUEFUNC(WxEvent::GetEventObject), 0);
    rb_define_method(rb_cWxEvent, "GetEventType", VALUEFUNC(WxEvent::GetEventType), 0);

    rb_cWxKeyEvent = rb_define_class_under(mWx,"WxKeyEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxKeyEvent,WxKeyEvent::alloc);
    rb_define_method(rb_cWxKeyEvent, "GetKeyCode", VALUEFUNC(WxKeyEvent::GetKeyCode), 0);
    rb_define_method(rb_cWxKeyEvent, "KeyCode", VALUEFUNC(WxKeyEvent::GetKeyCode), 0);
    rb_define_method(rb_cWxKeyEvent, "AltDown", VALUEFUNC(WxKeyEvent::AltDown), 0);
    rb_define_method(rb_cWxKeyEvent, "ControlDown", VALUEFUNC(WxKeyEvent::ControlDown), 0);
    rb_define_method(rb_cWxKeyEvent, "HasModifiers", VALUEFUNC(WxKeyEvent::HasModifiers), 0);
    rb_define_method(rb_cWxKeyEvent, "MetaDown", VALUEFUNC(WxKeyEvent::MetaDown), 0);
    rb_define_method(rb_cWxKeyEvent, "ShiftDown", VALUEFUNC(WxKeyEvent::ShiftDown), 0);

    rb_cWxCloseEvent = rb_define_class_under(mWx,"WxCloseEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxCloseEvent,WxCloseEvent::alloc);
    rb_define_method(rb_cWxCloseEvent, "CanVeto", VALUEFUNC(WxCloseEvent::CanVeto), 0);
    rb_define_method(rb_cWxCloseEvent, "Veto", VALUEFUNC(WxCloseEvent::Veto), -1);

    rb_cWxCommandEvent = rb_define_class_under(mWx,"WxCommandEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxCommandEvent,WxCommandEvent::alloc);
    rb_define_method(rb_cWxCommandEvent, "GetSelection", VALUEFUNC(WxCommandEvent::GetSelection), 0);
    rb_define_method(rb_cWxCommandEvent, "GetString", VALUEFUNC(WxCommandEvent::GetString), 0);
    rb_define_method(rb_cWxCommandEvent, "IsChecked", VALUEFUNC(WxCommandEvent::IsChecked), 0);
    rb_define_method(rb_cWxCommandEvent, "IsSelection", VALUEFUNC(WxCommandEvent::IsSelection), 0);
    rb_define_method(rb_cWxCommandEvent, "GetClientData", VALUEFUNC(WxCommandEvent::GetClientData), 0);
    rb_define_method(rb_cWxCommandEvent, "GetExtraLong", VALUEFUNC(WxCommandEvent::GetExtraLong), 0);
    rb_define_method(rb_cWxCommandEvent, "GetInt", VALUEFUNC(WxCommandEvent::GetInt), 0);

    rb_cWxCalendarEvent = rb_define_class_under(mWx,"WxCalendarEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxCalendarEvent,WxCalendarEvent::alloc);
    rb_define_method(rb_cWxCalendarEvent, "GetDate", VALUEFUNC(WxCalendarEvent::GetDate), 0);

    rb_cWxNotifyEvent = rb_define_class_under(mWx,"WxNotifyEvent", rb_cWxCommandEvent);
    rb_define_alloc_func(rb_cWxNotifyEvent,WxNotifyEvent::alloc);
    rb_define_method(rb_cWxNotifyEvent, "Allow", VALUEFUNC(WxNotifyEvent::Allow), 0);
    rb_define_method(rb_cWxNotifyEvent, "IsAllowed", VALUEFUNC(WxNotifyEvent::IsAllowed), 0);
    rb_define_method(rb_cWxNotifyEvent, "Veto", VALUEFUNC(WxNotifyEvent::Veto), 0);

    rb_cWxListEvent = rb_define_class_under(mWx,"WxListEvent", rb_cWxNotifyEvent);
    rb_define_alloc_func(rb_cWxListEvent,WxListEvent::alloc);
    rb_define_method(rb_cWxListEvent, "GetData", VALUEFUNC(WxListEvent::GetData), 0);
    rb_define_method(rb_cWxListEvent, "GetCacheFrom", VALUEFUNC(WxListEvent::GetCacheFrom), 0);
    rb_define_method(rb_cWxListEvent, "GetColumn", VALUEFUNC(WxListEvent::GetColumn), 0);
    rb_define_method(rb_cWxListEvent, "GetIndex", VALUEFUNC(WxListEvent::GetIndex), 0);
    rb_define_method(rb_cWxListEvent, "GetKeyCode", VALUEFUNC(WxListEvent::GetKeyCode), 0);
    rb_define_method(rb_cWxListEvent, "GetMask", VALUEFUNC(WxListEvent::GetMask), 0);
//    rb_define_method(rb_cWxListEvent, "Cancelled", VALUEFUNC(WxListEvent::Cancelled), 0);
    rb_define_method(rb_cWxListEvent, "GetImage", VALUEFUNC(WxListEvent::GetImage), 0);
    rb_define_method(rb_cWxListEvent, "GetItem", VALUEFUNC(WxListEvent::GetItem), 0);
    rb_define_method(rb_cWxListEvent, "GetLabel", VALUEFUNC(WxListEvent::GetLabel), 0);
    rb_define_method(rb_cWxListEvent, "GetPoint", VALUEFUNC(WxListEvent::GetPoint), 0);
    rb_define_method(rb_cWxListEvent, "GetText", VALUEFUNC(WxListEvent::GetText), 0);
    rb_define_method(rb_cWxListEvent, "GetCacheTo", VALUEFUNC(WxListEvent::GetCacheTo), 0);

    rb_cWxTreeEvent = rb_define_class_under(mWx,"WxTreeEvent", rb_cWxNotifyEvent);
    rb_define_alloc_func(rb_cWxTreeEvent,WxTreeEvent::alloc);
    rb_define_method(rb_cWxTreeEvent, "GetKeyCode", VALUEFUNC(WxTreeEvent::GetKeyCode), 0);
    rb_define_method(rb_cWxTreeEvent, "GetKeyEvent", VALUEFUNC(WxTreeEvent::GetKeyEvent), 0);
    rb_define_method(rb_cWxTreeEvent, "GetItem", VALUEFUNC(WxTreeEvent::GetItem), 0);
    rb_define_method(rb_cWxTreeEvent, "GetLabel", VALUEFUNC(WxTreeEvent::GetLabel), 0);
    rb_define_method(rb_cWxTreeEvent, "GetOldItem", VALUEFUNC(WxTreeEvent::GetOldItem), 0);
    rb_define_method(rb_cWxTreeEvent, "GetPoint", VALUEFUNC(WxTreeEvent::GetPoint), 0);
    rb_define_method(rb_cWxTreeEvent, "IsEditCancelled", VALUEFUNC(WxTreeEvent::IsEditCancelled), 0);

    rb_cWxSocketEvent = rb_define_class_under(mWx,"WxSocketEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxSocketEvent,WxSocketEvent::alloc);
    rb_define_method(rb_cWxSocketEvent, "GetClientData", VALUEFUNC(WxSocketEvent::GetClientData), 0);
    rb_define_method(rb_cWxSocketEvent, "GetSocket", VALUEFUNC(WxSocketEvent::GetSocket), 0);
    rb_define_method(rb_cWxSocketEvent, "GetSocketEvent", VALUEFUNC(WxSocketEvent::GetSocketEvent), 0);

    rb_cWxSizeEvent = rb_define_class_under(mWx,"WxSizeEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxSizeEvent,WxSizeEvent::alloc);
    rb_define_method(rb_cWxSizeEvent, "GetSize", VALUEFUNC(WxSizeEvent::GetSize), 0);

    rb_cWxMoveEvent = rb_define_class_under(mWx,"WxMoveEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxMoveEvent,WxMoveEvent::alloc);
    rb_define_method(rb_cWxMoveEvent, "GetPosition", VALUEFUNC(WxMoveEvent::GetPosition), 0);


    rb_cWxSplitterEvent = rb_define_class_under(mWx,"WxSplitterEvent", rb_cWxNotifyEvent);
    rb_define_alloc_func(rb_cWxSplitterEvent,WxSplitterEvent::alloc);
    rb_define_method(rb_cWxSplitterEvent, "GetSashPosition", VALUEFUNC(WxSplitterEvent::GetSashPosition), 0);
    rb_define_method(rb_cWxSplitterEvent, "GetWindowBeingRemoved", VALUEFUNC(WxSplitterEvent::GetWindowBeingRemoved), 0);
    rb_define_method(rb_cWxSplitterEvent, "GetX", VALUEFUNC(WxSplitterEvent::GetX), 0);
    rb_define_method(rb_cWxSplitterEvent, "GetY", VALUEFUNC(WxSplitterEvent::GetY), 0);
    rb_define_method(rb_cWxSplitterEvent, "SetSashPosition", VALUEFUNC(WxSplitterEvent::SetSashPosition), 1);

    rb_cWxNotebookEvent = rb_define_class_under(mWx,"WxNotebookEvent", rb_cWxNotifyEvent);
    rb_define_alloc_func(rb_cWxNotebookEvent,WxNotebookEvent::alloc);
    rb_define_method(rb_cWxNotebookEvent, "GetSelection", VALUEFUNC(WxNotebookEvent::GetSelection), 0);
    rb_define_method(rb_cWxNotebookEvent, "SetSelection", VALUEFUNC(WxNotebookEvent::SetSelection), 1);
    rb_define_method(rb_cWxNotebookEvent, "GetOldSelection", VALUEFUNC(WxNotebookEvent::GetOldSelection), 0);
    rb_define_method(rb_cWxNotebookEvent, "SetOldSelection", VALUEFUNC(WxNotebookEvent::SetOldSelection), 1);

    rb_cWxFindDialogEvent = rb_define_class_under(mWx,"WxFindDialogEvent", rb_cWxCommandEvent);
    rb_define_alloc_func(rb_cWxFindDialogEvent,WxFindDialogEvent::alloc);
    rb_define_method(rb_cWxFindDialogEvent, "GetDialog", VALUEFUNC(WxEvent::GetEventObject), 0);
    rb_define_method(rb_cWxFindDialogEvent, "GetFindString", VALUEFUNC(WxFindDialogEvent::GetFindString), 0);
    rb_define_method(rb_cWxFindDialogEvent, "GetFlags", VALUEFUNC(WxFindDialogEvent::GetFlags), 0);
    rb_define_method(rb_cWxFindDialogEvent, "GetReplaceString", VALUEFUNC(WxFindDialogEvent::GetReplaceString), 0);
    rb_define_method(rb_cWxFindDialogEvent, "SetFindString", VALUEFUNC(WxFindDialogEvent::SetFindString), 1);
    rb_define_method(rb_cWxFindDialogEvent, "SetFlags", VALUEFUNC(WxFindDialogEvent::SetFlags), 1);
    rb_define_method(rb_cWxFindDialogEvent, "SetReplaceString", VALUEFUNC(WxFindDialogEvent::SetReplaceString), 1);

    rb_cWxSpinEvent = rb_define_class_under(mWx,"WxSpinEvent", rb_cWxNotifyEvent);
    rb_define_alloc_func(rb_cWxSpinEvent,WxSpinEvent::alloc);
    rb_define_method(rb_cWxSpinEvent, "GetPosition", VALUEFUNC(WxSpinEvent::GetPosition), 0);
    rb_define_method(rb_cWxSpinEvent, "SetPosition", VALUEFUNC(WxSpinEvent::SetPosition), 1);

    rb_cWxPaintEvent = rb_define_class_under(mWx,"WxPaintEvent", rb_cWxEvent);
    rb_define_alloc_func(rb_cWxPaintEvent,WxPaintEvent::alloc);

    rb_cWxUpdateUIEvent = rb_define_class_under(mWx,"WxUpdateUIEvent", rb_cWxCommandEvent);
    rb_define_alloc_func(rb_cWxUpdateUIEvent,WxUpdateUIEvent::alloc);
    rb_define_method(rb_cWxUpdateUIEvent, "Enable", VALUEFUNC(WxUpdateUIEvent::Enable), 1);

    rb_cWxSizer = rb_define_class_under(mWx,"WxSizer", rb_cObject);
    rb_define_alloc_func(rb_cWxSizer,WxSizer::alloc);
    rb_define_singleton_method(rb_cWxSizer, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxSizer, "initialize", VALUEFUNC(WxSizer::init), 0);
    rb_define_method(rb_cWxSizer, "Add", VALUEFUNC(WxSizer::Add), -1);
    rb_define_method(rb_cWxSizer, "Insert", VALUEFUNC(WxSizer::Insert), -1);
    rb_define_method(rb_cWxSizer, "Fit", VALUEFUNC(WxSizer::Fit), 1);
    rb_define_method(rb_cWxSizer, "FitInside", VALUEFUNC(WxSizer::FitInside), 1);
    rb_define_method(rb_cWxSizer, "SetSizeHints", VALUEFUNC(WxSizer::SetSizeHints), 1);
    rb_define_method(rb_cWxSizer, "SetVirtualSizeHints", VALUEFUNC(WxSizer::SetVirtualSizeHints), 1);
    rb_define_method(rb_cWxSizer, "Remove", VALUEFUNC(WxSizer::Remove), 1);
    rb_define_method(rb_cWxSizer, "Show", VALUEFUNC(WxSizer::Show), -1);
    rb_define_method(rb_cWxSizer, "Layout", VALUEFUNC(WxSizer::Layout), 0);

    rb_cWxBoxSizer = rb_define_class_under(mWx,"WxBoxSizer", rb_cWxSizer);
    rb_define_alloc_func(rb_cWxBoxSizer,WxBoxSizer::alloc);
    rb_define_singleton_method(rb_cWxBoxSizer, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxBoxSizer, "initialize", VALUEFUNC(WxBoxSizer::init), 1);
    rb_define_method(rb_cWxBoxSizer, "RecalcSizes", VALUEFUNC(WxBoxSizer::RecalcSizes), 0);
    rb_define_method(rb_cWxBoxSizer, "CalcMin", VALUEFUNC(WxBoxSizer::CalcMin), 0);
    rb_define_method(rb_cWxBoxSizer, "GetOrientation", VALUEFUNC(WxBoxSizer::GetOrientation), 0);
    rb_define_method(rb_cWxBoxSizer, "SetOrientation", VALUEFUNC(WxBoxSizer::SetOrientation), 1);

    rb_cWxNotebookSizer = rb_define_class_under(mWx,"WxNotebookSizer", rb_cWxSizer);
    rb_define_alloc_func(rb_cWxNotebookSizer,WxNotebookSizer::alloc);
    rb_define_singleton_method(rb_cWxNotebookSizer, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxNotebookSizer, "initialize", VALUEFUNC(WxNotebookSizer::init), 1);
    rb_define_method(rb_cWxNotebookSizer, "RecalcSizes", VALUEFUNC(WxNotebookSizer::RecalcSizes), 0);
    rb_define_method(rb_cWxNotebookSizer, "CalcMin", VALUEFUNC(WxNotebookSizer::CalcMin), 0);
    rb_define_method(rb_cWxNotebookSizer, "GetNotebook", VALUEFUNC(WxNotebookSizer::GetNotebook), 0);

    rb_cWxStaticBoxSizer = rb_define_class_under(mWx,"WxStaticBoxSizer", rb_cWxBoxSizer);
    rb_define_alloc_func(rb_cWxStaticBoxSizer,WxStaticBoxSizer::alloc);
    rb_define_singleton_method(rb_cWxStaticBoxSizer, "new", VALUEFUNC(new2), 2);
    rb_define_method(rb_cWxStaticBoxSizer, "initialize", VALUEFUNC(WxStaticBoxSizer::init), 2);

    rb_cWxGridSizer = rb_define_class_under(mWx,"WxGridSizer", rb_cWxSizer);
    rb_define_alloc_func(rb_cWxGridSizer,WxGridSizer::alloc);
    rb_define_singleton_method(rb_cWxGridSizer, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxGridSizer, "initialize", VALUEFUNC(WxGridSizer::init), -1);
    rb_define_method(rb_cWxGridSizer, "RecalcSizes", VALUEFUNC(WxGridSizer::RecalcSizes), 0);
    rb_define_method(rb_cWxGridSizer, "CalcMin", VALUEFUNC(WxGridSizer::CalcMin), 0);
    rb_define_method(rb_cWxGridSizer, "GetCols", VALUEFUNC(WxGridSizer::GetCols), 0);
    rb_define_method(rb_cWxGridSizer, "GetRows", VALUEFUNC(WxGridSizer::GetRows), 0);
    rb_define_method(rb_cWxGridSizer, "GetVGap", VALUEFUNC(WxGridSizer::GetVGap), 0);
    rb_define_method(rb_cWxGridSizer, "GetHGap", VALUEFUNC(WxGridSizer::GetHGap), 0);
    rb_define_method(rb_cWxGridSizer, "SetCols", VALUEFUNC(WxGridSizer::SetCols), 1);
    rb_define_method(rb_cWxGridSizer, "SetRows", VALUEFUNC(WxGridSizer::SetRows), 1);
    rb_define_method(rb_cWxGridSizer, "SetVGap", VALUEFUNC(WxGridSizer::SetVGap), 1);
    rb_define_method(rb_cWxGridSizer, "SetHGap", VALUEFUNC(WxGridSizer::SetHGap), 1);

    rb_cWxFlexGridSizer = rb_define_class_under(mWx,"WxFlexGridSizer", rb_cWxSizer);
    rb_define_alloc_func(rb_cWxFlexGridSizer,WxFlexGridSizer::alloc);
    rb_define_singleton_method(rb_cWxFlexGridSizer, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxFlexGridSizer, "initialize", VALUEFUNC(WxFlexGridSizer::init), -1);
    rb_define_method(rb_cWxFlexGridSizer, "RecalcSizes", VALUEFUNC(WxFlexGridSizer::RecalcSizes), 0);
    rb_define_method(rb_cWxFlexGridSizer, "CalcMin", VALUEFUNC(WxFlexGridSizer::CalcMin), 0);

    rb_cWxValidator = rb_define_class_under(mWx,"WxValidator", rb_cObject);
    rb_define_alloc_func(rb_cWxValidator,WxValidator::alloc);
    rb_define_singleton_method(rb_cWxValidator, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxValidator, "initialize", VALUEFUNC(WxValidator::init), 0);
    rb_define_method(rb_cWxValidator, "GetWindow", VALUEFUNC(WxValidator::GetWindow), 0);
    rb_define_method(rb_cWxValidator, "SetBellOnError", VALUEFUNC(WxValidator::SetBellOnError), -1);

    rb_cWxToolTip = rb_define_class_under(mWx,"WxToolTip", rb_cObject);
    rb_define_alloc_func(rb_cWxToolTip,WxToolTip::alloc);
    rb_define_singleton_method(rb_cWxToolTip, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxToolTip, "initialize", VALUEFUNC(WxToolTip::init), 1);
    rb_define_singleton_method(rb_cWxToolTip, "Enable", VALUEFUNC(WxToolTip::Enable), 1);
    rb_define_singleton_method(rb_cWxToolTip, "SetDelay", VALUEFUNC(WxToolTip::SetDelay), 1);
    rb_define_method(rb_cWxToolTip, "SetTip", VALUEFUNC(WxToolTip::SetTip), 1);
    rb_define_method(rb_cWxToolTip, "GetTip", VALUEFUNC(WxToolTip::GetTip), 0);
    rb_define_method(rb_cWxToolTip, "GetWindow", VALUEFUNC(WxToolTip::GetWindow), 0);

    rb_cWxPanel = rb_define_class_under(mWx,"WxPanel", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxPanel,WxPanel::alloc);
    rb_define_singleton_method(rb_cWxPanel, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxPanel, "initialize", VALUEFUNC(WxPanel::init), -1);
    rb_define_method(rb_cWxPanel, "GetDefaultItem", VALUEFUNC(WxPanel::GetDefaultItem), 0);
    rb_define_method(rb_cWxPanel, "InitDialog", VALUEFUNC(WxPanel::InitDialog), 0);
    rb_define_method(rb_cWxPanel, "SetDefaultItem", VALUEFUNC(WxPanel::SetDefaultItem), 1);

    rb_cWxNotebook = rb_define_class_under(mWx,"WxNotebook", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxNotebook,WxNotebook::alloc);
    rb_define_singleton_method(rb_cWxNotebook, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxNotebook, "initialize", VALUEFUNC(WxNotebook::init), -1);
    rb_define_method(rb_cWxNotebook, "AddPage", VALUEFUNC(WxNotebook::AddPage), -1);
    rb_define_method(rb_cWxNotebook, "AdvanceSelection", VALUEFUNC(WxNotebook::AdvanceSelection), -1);
    rb_define_method(rb_cWxNotebook, "AssignImageList", VALUEFUNC(WxNotebook::AssignImageList), 1);
    rb_define_method(rb_cWxNotebook, "DeleteAllPages", VALUEFUNC(WxNotebook::DeleteAllPages), 0);
    rb_define_method(rb_cWxNotebook, "DeletePage", VALUEFUNC(WxNotebook::DeletePage), 1);
    rb_define_method(rb_cWxNotebook, "GetImageList", VALUEFUNC(WxNotebook::GetImageList), 0);
    rb_define_method(rb_cWxNotebook, "GetPage", VALUEFUNC(WxNotebook::GetPage), 1);
    rb_define_method(rb_cWxNotebook, "GetPageCount", VALUEFUNC(WxNotebook::GetPageCount), 0);
    rb_define_method(rb_cWxNotebook, "GetPageImage", VALUEFUNC(WxNotebook::GetPageImage), 1);
    rb_define_method(rb_cWxNotebook, "GetPageText", VALUEFUNC(WxNotebook::GetPageText), 1);
    rb_define_method(rb_cWxNotebook, "GetRowCount", VALUEFUNC(WxNotebook::GetRowCount), 0);
    rb_define_method(rb_cWxNotebook, "GetSelection", VALUEFUNC(WxNotebook::GetSelection), 0);
    rb_define_method(rb_cWxNotebook, "InsertPage", VALUEFUNC(WxNotebook::InsertPage), -1);
    rb_define_method(rb_cWxNotebook, "RemovePage", VALUEFUNC(WxNotebook::RemovePage), 1);
    rb_define_method(rb_cWxNotebook, "SetImageList", VALUEFUNC(WxNotebook::SetImageList), 1);
    rb_define_method(rb_cWxNotebook, "SetPadding", VALUEFUNC(WxNotebook::SetPadding), 1);
    rb_define_method(rb_cWxNotebook, "SetImageList", VALUEFUNC(WxNotebook::SetImageList), 1);
    rb_define_method(rb_cWxNotebook, "SetPageImage", VALUEFUNC(WxNotebook::SetPageImage), 1);
    rb_define_method(rb_cWxNotebook, "SetPageSize", VALUEFUNC(WxNotebook::SetPageSize), 1);
    rb_define_method(rb_cWxNotebook, "SetPageText", VALUEFUNC(WxNotebook::SetPageText), 2);
    rb_define_method(rb_cWxNotebook, "SetSelection", VALUEFUNC(WxNotebook::SetSelection), 1);

    rb_cWxStatusBar = rb_define_class_under(mWx,"WxStatusBar", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxStatusBar,WxStatusBar::alloc);
    rb_define_singleton_method(rb_cWxStatusBar, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxStatusBar, "initialize", VALUEFUNC(WxStatusBar::init), -1);
    rb_define_method(rb_cWxStatusBar, "GetFieldRect", VALUEFUNC(WxStatusBar::GetFieldRect), 1);
    rb_define_method(rb_cWxStatusBar, "GetFieldsCount", VALUEFUNC(WxStatusBar::GetFieldsCount), -1);
    rb_define_method(rb_cWxStatusBar, "GetStatusText", VALUEFUNC(WxStatusBar::GetStatusText), -1);
    rb_define_method(rb_cWxStatusBar, "PopStatusText", VALUEFUNC(WxStatusBar::PopStatusText), -1);
    rb_define_method(rb_cWxStatusBar, "PushStatusText", VALUEFUNC(WxStatusBar::PushStatusText), -1);
    rb_define_method(rb_cWxStatusBar, "SetFieldsCount", VALUEFUNC(WxStatusBar::SetFieldsCount), -1);
    rb_define_method(rb_cWxStatusBar, "SetMinHeight", VALUEFUNC(WxStatusBar::SetMinHeight), 1);
    rb_define_method(rb_cWxStatusBar, "SetStatusText", VALUEFUNC(WxStatusBar::SetStatusText), -1);
    rb_define_method(rb_cWxStatusBar, "SetStatusWidths", VALUEFUNC(WxStatusBar::SetStatusWidths), 1);

    rb_cWxScrolledWindow = rb_define_class_under(mWx,"WxScrolledWindow", rb_cWxPanel);
    rb_define_alloc_func(rb_cWxScrolledWindow,WxScrolledWindow::alloc);
    rb_define_singleton_method(rb_cWxScrolledWindow, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxScrolledWindow, "initialize", VALUEFUNC(WxScrolledWindow::init), -1);
    rb_define_method(rb_cWxScrolledWindow, "CalcScrolledPosition", VALUEFUNC(WxScrolledWindow::CalcScrolledPosition), 2);
    rb_define_method(rb_cWxScrolledWindow, "CalcUnscrolledPosition", VALUEFUNC(WxScrolledWindow::CalcUnscrolledPosition), 2);
    rb_define_method(rb_cWxScrolledWindow, "EnableScrolling", VALUEFUNC(WxScrolledWindow::EnableScrolling), 2);
    rb_define_method(rb_cWxScrolledWindow, "GetScrollPixelsPerUnit", VALUEFUNC(WxScrolledWindow::GetScrollPixelsPerUnit), 0);
    rb_define_method(rb_cWxScrolledWindow, "GetViewStart", VALUEFUNC(WxScrolledWindow::GetViewStart), 0);
    rb_define_method(rb_cWxScrolledWindow, "GetVirtualSize", VALUEFUNC(WxScrolledWindow::GetVirtualSize), 0);
    rb_define_method(rb_cWxScrolledWindow, "IsRetained", VALUEFUNC(WxScrolledWindow::IsRetained), 0);
    rb_define_method(rb_cWxScrolledWindow, "PrepareDC", VALUEFUNC(WxScrolledWindow::PrepareDC), 1);
    rb_define_method(rb_cWxScrolledWindow, "Scroll", VALUEFUNC(WxScrolledWindow::Scroll), 2);
    rb_define_method(rb_cWxScrolledWindow, "SetScrollRate", VALUEFUNC(WxScrolledWindow::SetScrollRate), 2);
    rb_define_method(rb_cWxScrolledWindow, "SetScrollbars", VALUEFUNC(WxScrolledWindow::SetScrollbars), -1);
    rb_define_method(rb_cWxScrolledWindow, "SetTargetWindow", VALUEFUNC(WxScrolledWindow::SetTargetWindow), 1);

    rb_cWxToolBar = rb_define_class_under(mWx,"WxToolBar", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxToolBar,WxToolBar::alloc);
    rb_define_singleton_method(rb_cWxToolBar, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxToolBar, "initialize", VALUEFUNC(WxToolBar::init), -1);
    rb_define_method(rb_cWxToolBar, "AddCheckTool", VALUEFUNC(WxToolBar::AddCheckTool), -1);
    rb_define_method(rb_cWxToolBar, "AddControl", VALUEFUNC(WxToolBar::AddControl), 1);
    rb_define_method(rb_cWxToolBar, "AddRadioTool", VALUEFUNC(WxToolBar::AddRadioTool), -1);
    rb_define_method(rb_cWxToolBar, "AddSeparator", VALUEFUNC(WxToolBar::AddSeparator), 0);
    rb_define_method(rb_cWxToolBar, "AddTool", VALUEFUNC(WxToolBar::AddTool), -1);
    rb_define_method(rb_cWxToolBar, "DeleteTool", VALUEFUNC(WxToolBar::DeleteTool), 1);
    rb_define_method(rb_cWxToolBar, "DeleteToolByPos", VALUEFUNC(WxToolBar::DeleteToolByPos), 1);
    rb_define_method(rb_cWxToolBar, "EnableTool", VALUEFUNC(WxToolBar::EnableTool), 2);
    rb_define_method(rb_cWxToolBar, "GetMargins", VALUEFUNC(WxToolBar::GetMargins), 0);
    rb_define_method(rb_cWxToolBar, "GetToolBitmapSize", VALUEFUNC(WxToolBar::GetToolBitmapSize), 0);
    rb_define_method(rb_cWxToolBar, "GetToolClientData", VALUEFUNC(WxToolBar::GetToolClientData), 1);
    rb_define_method(rb_cWxToolBar, "GetToolEnabled", VALUEFUNC(WxToolBar::GetToolEnabled), 1);
    rb_define_method(rb_cWxToolBar, "GetToolLongHelp", VALUEFUNC(WxToolBar::GetToolLongHelp), 1);
    rb_define_method(rb_cWxToolBar, "GetToolPacking", VALUEFUNC(WxToolBar::GetToolPacking), 0);
    rb_define_method(rb_cWxToolBar, "GetToolSeparation", VALUEFUNC(WxToolBar::GetToolSeparation), 0);
    rb_define_method(rb_cWxToolBar, "GetToolShortHelp", VALUEFUNC(WxToolBar::GetToolShortHelp), 1);
    rb_define_method(rb_cWxToolBar, "GetToolSize", VALUEFUNC(WxToolBar::GetToolSize), 0);
    rb_define_method(rb_cWxToolBar, "GetToolState", VALUEFUNC(WxToolBar::GetToolState), 1);
    rb_define_method(rb_cWxToolBar, "InsertControl", VALUEFUNC(WxToolBar::InsertControl), 2);
    rb_define_method(rb_cWxToolBar, "InsertSeparator", VALUEFUNC(WxToolBar::InsertSeparator), 1);
    rb_define_method(rb_cWxToolBar, "InsertTool", VALUEFUNC(WxToolBar::InsertTool), -1);
    rb_define_method(rb_cWxToolBar, "Realize", VALUEFUNC(WxToolBar::Realize), 0);
    rb_define_method(rb_cWxToolBar, "RemoveTool", VALUEFUNC(WxToolBar::RemoveTool), 1);
    rb_define_method(rb_cWxToolBar, "SetMargins", VALUEFUNC(WxToolBar::SetMargins), 2);
    rb_define_method(rb_cWxToolBar, "SetToolBitmapSize", VALUEFUNC(WxToolBar::SetToolBitmapSize), 1);
    rb_define_method(rb_cWxToolBar, "SetToolClientData", VALUEFUNC(WxToolBar::SetToolClientData), 2);
    rb_define_method(rb_cWxToolBar, "SetToolLongHelp", VALUEFUNC(WxToolBar::SetToolLongHelp), 2);
    rb_define_method(rb_cWxToolBar, "SetToolPacking", VALUEFUNC(WxToolBar::SetToolPacking), 1);
    rb_define_method(rb_cWxToolBar, "SetToolSeparation", VALUEFUNC(WxToolBar::SetToolSeparation), 1);
    rb_define_method(rb_cWxToolBar, "SetToolShortHelp", VALUEFUNC(WxToolBar::SetToolShortHelp), 2);
    rb_define_method(rb_cWxToolBar, "ToggleTool", VALUEFUNC(WxToolBar::ToggleTool), 2);
    rb_define_method(rb_cWxToolBar, "SetRows", VALUEFUNC(WxToolBar::SetRows), 1);
    rb_define_method(rb_cWxToolBar, "SetMaxRowsCols", VALUEFUNC(WxToolBar::SetMaxRowsCols), 2);
    rb_define_method(rb_cWxToolBar, "GetMaxRows", VALUEFUNC(WxToolBar::GetMaxRows), 0);
    rb_define_method(rb_cWxToolBar, "GetMaxCols", VALUEFUNC(WxToolBar::GetMaxCols), 0);

#ifdef __WXMSW__
    rb_cWxOwnerDrawn = rb_define_class_under(mWx,"WxOwnerDrawn", rb_cObject);
    rb_define_alloc_func(rb_cWxOwnerDrawn,WxOwnerDrawn::alloc);
    rb_define_singleton_method(rb_cWxOwnerDrawn, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxOwnerDrawn, "initialize", VALUEFUNC(WxOwnerDrawn::init), -1);
    rb_define_method(rb_cWxOwnerDrawn, "GetBackgroundColour", VALUEFUNC(WxOwnerDrawn::GetBackgroundColour), 0);
    rb_define_method(rb_cWxOwnerDrawn, "GetBitmap", VALUEFUNC(WxOwnerDrawn::GetBitmap), -1);
    rb_define_method(rb_cWxOwnerDrawn, "GetDefaultMarginWidth", VALUEFUNC(WxOwnerDrawn::GetDefaultMarginWidth), 0);
    rb_define_method(rb_cWxOwnerDrawn, "GetFont", VALUEFUNC(WxOwnerDrawn::GetFont), 0);
    rb_define_method(rb_cWxOwnerDrawn, "GetMarginWidth", VALUEFUNC(WxOwnerDrawn::GetMarginWidth), 0);
    rb_define_method(rb_cWxOwnerDrawn, "GetName", VALUEFUNC(WxOwnerDrawn::GetName), 0);
    rb_define_method(rb_cWxOwnerDrawn, "GetTextColour", VALUEFUNC(WxOwnerDrawn::GetTextColour), 0);
    rb_define_method(rb_cWxOwnerDrawn, "IsCheckable", VALUEFUNC(WxOwnerDrawn::IsCheckable), 0);
    rb_define_method(rb_cWxOwnerDrawn, "IsOwnerDrawn", VALUEFUNC(WxOwnerDrawn::IsOwnerDrawn), 0);
    rb_define_method(rb_cWxOwnerDrawn, "ResetOwnerDrawn", VALUEFUNC(WxOwnerDrawn::ResetOwnerDrawn), 0);
    rb_define_method(rb_cWxOwnerDrawn, "SetAccelString", VALUEFUNC(WxOwnerDrawn::SetAccelString), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetBackgroundColour", VALUEFUNC(WxOwnerDrawn::SetBackgroundColour), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetBitmap", VALUEFUNC(WxOwnerDrawn::SetBitmap), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetBitmaps", VALUEFUNC(WxOwnerDrawn::SetBitmaps), -1);
    rb_define_method(rb_cWxOwnerDrawn, "SetCheckable", VALUEFUNC(WxOwnerDrawn::SetCheckable), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetFont", VALUEFUNC(WxOwnerDrawn::SetFont), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetMarginWidth", VALUEFUNC(WxOwnerDrawn::SetMarginWidth), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetName", VALUEFUNC(WxOwnerDrawn::SetName), 1);
    rb_define_method(rb_cWxOwnerDrawn, "SetTextColour", VALUEFUNC(WxOwnerDrawn::SetTextColour), 1);
#endif

    rb_cWxListItemAttr = rb_define_class_under(mWx,"WxListItemAttr", rb_cObject);
    rb_define_alloc_func(rb_cWxListItemAttr,WxListItemAttr::alloc);
    rb_define_singleton_method(rb_cWxListItemAttr, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxListItemAttr, "initialize", VALUEFUNC(WxListItemAttr::init), -1);
    rb_define_method(rb_cWxListItemAttr, "GetBackgroundColour", VALUEFUNC(WxListItemAttr::GetBackgroundColour), 0);
    rb_define_method(rb_cWxListItemAttr, "GetFont", VALUEFUNC(WxListItemAttr::GetFont), 0);
    rb_define_method(rb_cWxListItemAttr, "GetTextColour", VALUEFUNC(WxListItemAttr::GetTextColour), 0);
    rb_define_method(rb_cWxListItemAttr, "HasBackgroundColour", VALUEFUNC(WxListItemAttr::HasBackgroundColour), 0);
    rb_define_method(rb_cWxListItemAttr, "HasFont", VALUEFUNC(WxListItemAttr::HasFont), 0);
    rb_define_method(rb_cWxListItemAttr, "HasTextColour", VALUEFUNC(WxListItemAttr::HasTextColour), 0);
    rb_define_method(rb_cWxListItemAttr, "SetBackgroundColour", VALUEFUNC(WxListItemAttr::SetBackgroundColour), 1);
    rb_define_method(rb_cWxListItemAttr, "SetFont", VALUEFUNC(WxListItemAttr::SetFont), 1);
    rb_define_method(rb_cWxListItemAttr, "SetTextColour", VALUEFUNC(WxListItemAttr::SetTextColour), 1);

    rb_cWxListItem = rb_define_class_under(mWx,"WxListItem", rb_cObject);
    rb_define_alloc_func(rb_cWxListItem,WxListItem::alloc);
    rb_define_singleton_method(rb_cWxListItem, "new", VALUEFUNC(new_1), 0);
    rb_define_method(rb_cWxListItem, "initialize", VALUEFUNC(WxListItem::init), 0);
    rb_define_method(rb_cWxListItem, "free", VALUEFUNC(WxListItem::free), 0);
    rb_define_method(rb_cWxListItem, "Clear", VALUEFUNC(WxListItem::Clear), 0);
    rb_define_method(rb_cWxListItem, "GetAlign", VALUEFUNC(WxListItem::GetAlign), 0);
    rb_define_method(rb_cWxListItem, "GetBackgroundColour", VALUEFUNC(WxListItem::GetBackgroundColour), 0);
    rb_define_method(rb_cWxListItem, "GetColumn", VALUEFUNC(WxListItem::GetColumn), 0);
    rb_define_method(rb_cWxListItem, "GetData", VALUEFUNC(WxListItem::GetData), 0);
    rb_define_method(rb_cWxListItem, "GetFont", VALUEFUNC(WxListItem::GetFont), 0);
    rb_define_method(rb_cWxListItem, "GetId", VALUEFUNC(WxListItem::GetId), 0);
    rb_define_method(rb_cWxListItem, "GetImage", VALUEFUNC(WxListItem::GetImage), 0);
    rb_define_method(rb_cWxListItem, "GetMask", VALUEFUNC(WxListItem::GetMask), 0);
    rb_define_method(rb_cWxListItem, "GetState", VALUEFUNC(WxListItem::GetState), 0);
    rb_define_method(rb_cWxListItem, "GetText", VALUEFUNC(WxListItem::GetText), 0);
    rb_define_method(rb_cWxListItem, "GetTextColour", VALUEFUNC(WxListItem::GetTextColour), 0);
    rb_define_method(rb_cWxListItem, "GetWidth", VALUEFUNC(WxListItem::GetWidth), 0);
    rb_define_method(rb_cWxListItem, "SetAlign", VALUEFUNC(WxListItem::SetAlign), 1);
    rb_define_method(rb_cWxListItem, "SetBackgroundColour", VALUEFUNC(WxListItem::SetBackgroundColour), 1);
    rb_define_method(rb_cWxListItem, "SetColumn", VALUEFUNC(WxListItem::SetColumn), 1);
    rb_define_method(rb_cWxListItem, "SetBackgroundColour", VALUEFUNC(WxListItem::SetBackgroundColour), 1);
    rb_define_method(rb_cWxListItem, "SetData", VALUEFUNC(WxListItem::SetData), 1);
    rb_define_method(rb_cWxListItem, "SetFont", VALUEFUNC(WxListItem::SetFont), 1);
    rb_define_method(rb_cWxListItem, "SetId", VALUEFUNC(WxListItem::SetId), 1);
    rb_define_method(rb_cWxListItem, "SetImage", VALUEFUNC(WxListItem::SetImage), 1);
    rb_define_method(rb_cWxListItem, "SetMask", VALUEFUNC(WxListItem::SetMask), 1);
    rb_define_method(rb_cWxListItem, "SetState", VALUEFUNC(WxListItem::SetState), 1);
    rb_define_method(rb_cWxListItem, "SetStateMask", VALUEFUNC(WxListItem::SetStateMask), 1);
    rb_define_method(rb_cWxListItem, "SetText", VALUEFUNC(WxListItem::SetText), 1);
    rb_define_method(rb_cWxListItem, "SetTextColour", VALUEFUNC(WxListItem::SetTextColour), 1);
    rb_define_method(rb_cWxListItem, "SetWidth", VALUEFUNC(WxListItem::SetWidth), 1);
    rb_define_method(rb_cWxListItem, "GetAttributes", VALUEFUNC(WxListItem::GetAttributes), 0);

    rb_cWxSocketBase = rb_define_class_under(mWx,"WxSocketBase", rb_cObject);
    rb_define_alloc_func(rb_cWxSocketBase,WxSocketBase::alloc);
    rb_define_method(rb_cWxSocketBase, "Close", VALUEFUNC(WxSocketBase::Close), 0);
    rb_define_method(rb_cWxSocketBase, "Destroy", VALUEFUNC(WxSocketBase::Destroy), 0);
    rb_define_method(rb_cWxSocketBase, "Discard", VALUEFUNC(WxSocketBase::Discard), 0);
    rb_define_method(rb_cWxSocketBase, "Error", VALUEFUNC(WxSocketBase::Error), 0);
    rb_define_method(rb_cWxSocketBase, "GetClientData", VALUEFUNC(WxSocketBase::GetClientData), 0);
    rb_define_method(rb_cWxSocketBase, "GetFlags", VALUEFUNC(WxSocketBase::GetFlags), 0);
    rb_define_method(rb_cWxSocketBase, "InterruptWait", VALUEFUNC(WxSocketBase::InterruptWait), 0);
    rb_define_method(rb_cWxSocketBase, "IsConnected", VALUEFUNC(WxSocketBase::IsConnected), 0);
    rb_define_method(rb_cWxSocketBase, "IsData", VALUEFUNC(WxSocketBase::IsData), 0);
    rb_define_method(rb_cWxSocketBase, "IsDisconnected", VALUEFUNC(WxSocketBase::IsDisconnected), 0);
    rb_define_method(rb_cWxSocketBase, "LastCount", VALUEFUNC(WxSocketBase::LastCount), 0);
    rb_define_method(rb_cWxSocketBase, "LastError", VALUEFUNC(WxSocketBase::LastError), 0);
    rb_define_method(rb_cWxSocketBase, "Notify", VALUEFUNC(WxSocketBase::Notify), 1);
    rb_define_method(rb_cWxSocketBase, "Ok", VALUEFUNC(WxSocketBase::Ok), 0);
    rb_define_method(rb_cWxSocketBase, "Peek", VALUEFUNC(WxSocketBase::Peek), 2);
    rb_define_method(rb_cWxSocketBase, "Read", VALUEFUNC(WxSocketBase::Read), 2);
    rb_define_method(rb_cWxSocketBase, "ReadMsg", VALUEFUNC(WxSocketBase::ReadMsg), 2);
    rb_define_method(rb_cWxSocketBase, "RestoreState", VALUEFUNC(WxSocketBase::RestoreState), 0);
    rb_define_method(rb_cWxSocketBase, "SaveState", VALUEFUNC(WxSocketBase::SaveState), 0);
    rb_define_method(rb_cWxSocketBase, "SetClientData", VALUEFUNC(WxSocketBase::SetClientData), 1);
    rb_define_method(rb_cWxSocketBase, "SetEventHandler", VALUEFUNC(WxSocketBase::SetEventHandler), -1);
    rb_define_method(rb_cWxSocketBase, "SetFlags", VALUEFUNC(WxSocketBase::SetFlags), 1);
    rb_define_method(rb_cWxSocketBase, "SetNotify", VALUEFUNC(WxSocketBase::SetNotify), 1);
    rb_define_method(rb_cWxSocketBase, "SetTimeout", VALUEFUNC(WxSocketBase::SetTimeout), 1);
    rb_define_method(rb_cWxSocketBase, "Unread", VALUEFUNC(WxSocketBase::Unread), 2);
    rb_define_method(rb_cWxSocketBase, "Wait", VALUEFUNC(WxSocketBase::Wait), -1);
    rb_define_method(rb_cWxSocketBase, "WaitForLost", VALUEFUNC(WxSocketBase::WaitForLost), -1);
    rb_define_method(rb_cWxSocketBase, "WaitForRead", VALUEFUNC(WxSocketBase::WaitForRead), -1);
    rb_define_method(rb_cWxSocketBase, "WaitForWrite", VALUEFUNC(WxSocketBase::WaitForWrite), -1);
    rb_define_method(rb_cWxSocketBase, "Write", VALUEFUNC(WxSocketBase::Write), 2);
    rb_define_method(rb_cWxSocketBase, "WriteMsg", VALUEFUNC(WxSocketBase::WriteMsg), 2);
    rb_define_method(rb_cWxSocketBase, "GetPeer", VALUEFUNC(WxSocketBase::GetPeer), 0);

    rb_cWxSocketClient = rb_define_class_under(mWx,"WxSocketClient", rb_cWxSocketBase);
    rb_define_alloc_func(rb_cWxSocketClient,WxSocketClient::alloc);
    rb_define_singleton_method(rb_cWxSocketClient, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSocketClient, "initialize", VALUEFUNC(WxSocketClient::init), -1);
    rb_define_method(rb_cWxSocketClient, "Connect", VALUEFUNC(WxSocketClient::Connect), -1);
    rb_define_method(rb_cWxSocketClient, "WaitOnConnect", VALUEFUNC(WxSocketClient::WaitOnConnect), -1);

    rb_cWxSocketServer = rb_define_class_under(mWx,"WxSocketServer", rb_cWxSocketBase);
    rb_define_alloc_func(rb_cWxSocketServer,WxSocketServer::alloc);
    rb_define_singleton_method(rb_cWxSocketServer, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxSocketServer, "initialize", VALUEFUNC(WxSocketServer::init), -1);
    rb_define_method(rb_cWxSocketServer, "Accept", VALUEFUNC(WxSocketServer::Accept), -1);
    rb_define_method(rb_cWxSocketServer, "AcceptWith", VALUEFUNC(WxSocketServer::AcceptWith), -1);
    rb_define_method(rb_cWxSocketServer, "WaitForAccept", VALUEFUNC(WxSocketServer::WaitForAccept), -1);

    rb_cWxProtocol = rb_define_class_under(mWx,"WxProtocol", rb_cWxSocketClient);
    rb_define_alloc_func(rb_cWxProtocol,WxProtocol::alloc);
    rb_define_method(rb_cWxProtocol, "Abort", VALUEFUNC(WxProtocol::Abort), 0);
    rb_define_method(rb_cWxProtocol, "GetContentType", VALUEFUNC(WxProtocol::GetContentType), 0);
    rb_define_method(rb_cWxProtocol, "GetError", VALUEFUNC(WxProtocol::GetError), 0);
    rb_define_method(rb_cWxProtocol, "GetInputStream", VALUEFUNC(WxProtocol::GetInputStream), 0);
    rb_define_method(rb_cWxProtocol, "Reconnect", VALUEFUNC(WxProtocol::Reconnect), 0);
    rb_define_method(rb_cWxProtocol, "SetPassword", VALUEFUNC(WxProtocol::SetPassword), 1);
    rb_define_method(rb_cWxProtocol, "SetUser", VALUEFUNC(WxProtocol::SetUser), 1);

    rb_cWxURL = rb_define_class_under(mWx,"WxURL", rb_cObject);
    rb_define_alloc_func(rb_cWxURL,WxURL::alloc);
    rb_define_singleton_method(rb_cWxURL, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxURL, "initialize", VALUEFUNC(WxURL::init), 1);
    rb_define_singleton_method(rb_cWxURL, "ConvertToValidURI", VALUEFUNC(WxURL::ConvertToValidURI), 1);
    rb_define_method(rb_cWxURL, "GetError", VALUEFUNC(WxURL::GetError), 0);
    rb_define_method(rb_cWxURL, "GetInputStream", VALUEFUNC(WxURL::GetInputStream), 0);
    rb_define_method(rb_cWxURL, "GetPath", VALUEFUNC(WxURL::GetPath), 0);
    rb_define_method(rb_cWxURL, "GetProtocol", VALUEFUNC(WxURL::GetProtocol), 0);
    rb_define_method(rb_cWxURL, "GetProtocolName", VALUEFUNC(WxURL::GetProtocolName), 0);
    rb_define_singleton_method(rb_cWxURL, "SetDefaultProxy", VALUEFUNC(WxURL::SetDefaultProxy), 1);
    rb_define_method(rb_cWxURL, "SetProxy", VALUEFUNC(WxURL::SetProxy), 1);

    rb_cWxStreamBase = rb_define_class_under(mWx,"WxStreamBase", rb_cObject);
    rb_define_alloc_func(rb_cWxStreamBase,WxStreamBase::alloc);
    rb_define_method(rb_cWxStreamBase, "GetLastError", VALUEFUNC(WxStreamBase::GetLastError), 0);
    rb_define_method(rb_cWxStreamBase, "IsOk", VALUEFUNC(WxStreamBase::IsOk), 0);
    rb_define_method(rb_cWxStreamBase, "Reset", VALUEFUNC(WxStreamBase::Reset), 0);
    rb_define_method(rb_cWxStreamBase, "free", VALUEFUNC(WxStreamBase::free), 0);

    rb_cWxInputStream = rb_define_class_under(mWx,"WxInputStream", rb_cWxStreamBase);
    rb_define_alloc_func(rb_cWxInputStream,WxInputStream::alloc);
    rb_define_singleton_method(rb_cWxInputStream, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxInputStream, "initialize", VALUEFUNC(WxInputStream::init), 0);
    rb_define_method(rb_cWxInputStream, "Eof", VALUEFUNC(WxInputStream::Eof), 0);
    rb_define_method(rb_cWxInputStream, "GetC", VALUEFUNC(WxInputStream::GetC), 0);
    rb_define_method(rb_cWxInputStream, "LastRead", VALUEFUNC(WxInputStream::LastRead), 0);
    rb_define_method(rb_cWxInputStream, "Peek", VALUEFUNC(WxInputStream::Peek), 0);
    rb_define_method(rb_cWxInputStream, "Read", VALUEFUNC(WxInputStream::Read), -1);
    rb_define_method(rb_cWxInputStream, "SeekI", VALUEFUNC(WxInputStream::SeekI), -1);
    rb_define_method(rb_cWxInputStream, "TellI", VALUEFUNC(WxInputStream::TellI), 0);
    rb_define_method(rb_cWxInputStream, "Ungetch", VALUEFUNC(WxInputStream::Ungetch), -1);

    rb_cWxOutputStream = rb_define_class_under(mWx,"WxOutputStream", rb_cWxStreamBase);
    rb_define_alloc_func(rb_cWxOutputStream,WxOutputStream::alloc);
    rb_define_singleton_method(rb_cWxOutputStream, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxOutputStream, "initialize", VALUEFUNC(WxOutputStream::init), 0);
    rb_define_method(rb_cWxOutputStream, "LastWrite", VALUEFUNC(WxOutputStream::LastWrite), 0);
    rb_define_method(rb_cWxOutputStream, "PutC", VALUEFUNC(WxOutputStream::PutC), 1);
    rb_define_method(rb_cWxOutputStream, "SeekO", VALUEFUNC(WxOutputStream::SeekO), -1);
    rb_define_method(rb_cWxOutputStream, "TellO", VALUEFUNC(WxOutputStream::TellO), 0);
    rb_define_method(rb_cWxOutputStream, "Write", VALUEFUNC(WxOutputStream::Write), -1);

    rb_cWxFileOutputStream = rb_define_class_under(mWx,"WxFileOutputStream", rb_cWxOutputStream);
    rb_define_alloc_func(rb_cWxFileOutputStream,WxFileOutputStream::alloc);
    rb_define_singleton_method(rb_cWxFileOutputStream, "new", VALUEFUNC(new1), 1);
    rb_define_method(rb_cWxFileOutputStream, "initialize", VALUEFUNC(WxFileOutputStream::init), 1);
    rb_define_method(rb_cWxFileOutputStream, "Ok", VALUEFUNC(WxFileOutputStream::Ok), 0);

    rb_cWxTreeItemData = rb_define_class_under(mWx,"WxTreeItemData", rb_cObject);
    rb_define_alloc_func(rb_cWxTreeItemData,WxTreeItemData::alloc);
    rb_define_singleton_method(rb_cWxTreeItemData, "new", VALUEFUNC(new0), 0);
    rb_define_method(rb_cWxTreeItemData, "initialize", VALUEFUNC(WxTreeItemData::init), 0);
    rb_define_method(rb_cWxTreeItemData, "GetId", VALUEFUNC(WxTreeItemData::GetId), 0);
    rb_define_method(rb_cWxTreeItemData, "SetId", VALUEFUNC(WxTreeItemData::SetId), 1);

    rb_cWxTreeCtrl = rb_define_class_under(mWx,"WxTreeCtrl", rb_cWxWindow);
    rb_define_alloc_func(rb_cWxTreeCtrl,WxTreeCtrl::alloc);
    rb_define_singleton_method(rb_cWxTreeCtrl, "new", VALUEFUNC(new_1), -1);
    rb_define_method(rb_cWxTreeCtrl, "initialize", VALUEFUNC(WxTreeCtrl::init), -1);
    rb_define_method(rb_cWxTreeCtrl, "AddRoot", VALUEFUNC(WxTreeCtrl::AddRoot),-1);
    rb_define_method(rb_cWxTreeCtrl, "AppendItem", VALUEFUNC(WxTreeCtrl::AppendItem),-1);
//    rb_define_method(rb_cWxTreeCtrl, "AssignButtonsImageList", VALUEFUNC(WxTreeCtrl::AssignButtonsImageList),1);
    rb_define_method(rb_cWxTreeCtrl, "AssignImageList", VALUEFUNC(WxTreeCtrl::AssignImageList),1);
    rb_define_method(rb_cWxTreeCtrl, "AssignStateImageList", VALUEFUNC(WxTreeCtrl::AssignStateImageList),1);
    rb_define_method(rb_cWxTreeCtrl, "Collapse", VALUEFUNC(WxTreeCtrl::Collapse),1);
    rb_define_method(rb_cWxTreeCtrl, "CollapseAndReset", VALUEFUNC(WxTreeCtrl::CollapseAndReset),1);
    rb_define_method(rb_cWxTreeCtrl, "Delete", VALUEFUNC(WxTreeCtrl::Delete),1);
    rb_define_method(rb_cWxTreeCtrl, "DeleteAllItems", VALUEFUNC(WxTreeCtrl::DeleteAllItems),0);
    rb_define_method(rb_cWxTreeCtrl, "DeleteChildren", VALUEFUNC(WxTreeCtrl::DeleteChildren),1);
    rb_define_method(rb_cWxTreeCtrl, "EditLabel", VALUEFUNC(WxTreeCtrl::EditLabel),1);
    rb_define_method(rb_cWxTreeCtrl, "EnsureVisible", VALUEFUNC(WxTreeCtrl::EnsureVisible),1);
    rb_define_method(rb_cWxTreeCtrl, "Expand", VALUEFUNC(WxTreeCtrl::Expand),1);
    rb_define_method(rb_cWxTreeCtrl, "GetBoundingRect", VALUEFUNC(WxTreeCtrl::GetBoundingRect),-1);
//    rb_define_method(rb_cWxTreeCtrl, "GetButtonsImageList", VALUEFUNC(WxTreeCtrl::GetButtonsImageList),0);
    rb_define_method(rb_cWxTreeCtrl, "GetChildrenCount", VALUEFUNC(WxTreeCtrl::GetChildrenCount),-1);
    rb_define_method(rb_cWxTreeCtrl, "GetCount", VALUEFUNC(WxTreeCtrl::GetCount),0);
    rb_define_method(rb_cWxTreeCtrl, "GetEditControl", VALUEFUNC(WxTreeCtrl::GetEditControl),0);
    rb_define_method(rb_cWxTreeCtrl, "GetFirstChild", VALUEFUNC(WxTreeCtrl::GetFirstChild),1);
    rb_define_method(rb_cWxTreeCtrl, "GetFirstVisibleItem", VALUEFUNC(WxTreeCtrl::GetFirstVisibleItem),0);
    rb_define_method(rb_cWxTreeCtrl, "GetImageList", VALUEFUNC(WxTreeCtrl::GetImageList),0);
    rb_define_method(rb_cWxTreeCtrl, "GetIndent", VALUEFUNC(WxTreeCtrl::GetIndent),0);
    rb_define_method(rb_cWxTreeCtrl, "GetSpacing", VALUEFUNC(WxTreeCtrl::GetSpacing),0);
    rb_define_method(rb_cWxTreeCtrl, "GetItemBackgroundColour", VALUEFUNC(WxTreeCtrl::GetItemBackgroundColour),1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemData", VALUEFUNC(WxTreeCtrl::GetItemData),1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemFont", VALUEFUNC(WxTreeCtrl::GetItemFont),1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemImage", VALUEFUNC(WxTreeCtrl::GetItemImage),-1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemParent", VALUEFUNC(WxTreeCtrl::GetItemParent),1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemSelectedImage", VALUEFUNC(WxTreeCtrl::GetItemSelectedImage),1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemText", VALUEFUNC(WxTreeCtrl::GetItemText),1);
    rb_define_method(rb_cWxTreeCtrl, "GetItemTextColour", VALUEFUNC(WxTreeCtrl::GetItemTextColour),1);
    rb_define_method(rb_cWxTreeCtrl, "GetLastChild", VALUEFUNC(WxTreeCtrl::GetLastChild),1);
    rb_define_method(rb_cWxTreeCtrl, "GetNextChild", VALUEFUNC(WxTreeCtrl::GetNextChild),2);
    rb_define_method(rb_cWxTreeCtrl, "GetNextSibling", VALUEFUNC(WxTreeCtrl::GetNextSibling),1);
    rb_define_method(rb_cWxTreeCtrl, "GetNextVisible", VALUEFUNC(WxTreeCtrl::GetNextVisible),1);
    rb_define_method(rb_cWxTreeCtrl, "GetPrevSibling", VALUEFUNC(WxTreeCtrl::GetPrevSibling),1);
    rb_define_method(rb_cWxTreeCtrl, "GetPrevVisible", VALUEFUNC(WxTreeCtrl::GetPrevVisible),1);
    rb_define_method(rb_cWxTreeCtrl, "GetRootItem", VALUEFUNC(WxTreeCtrl::GetRootItem),0);
    rb_define_method(rb_cWxTreeCtrl, "GetSelection", VALUEFUNC(WxTreeCtrl::GetSelection),0);
    rb_define_method(rb_cWxTreeCtrl, "GetSelections", VALUEFUNC(WxTreeCtrl::GetSelections),0);
    rb_define_method(rb_cWxTreeCtrl, "GetStateImageList", VALUEFUNC(WxTreeCtrl::GetStateImageList),0);
    rb_define_method(rb_cWxTreeCtrl, "HitTest", VALUEFUNC(WxTreeCtrl::HitTest),1);
    rb_define_method(rb_cWxTreeCtrl, "InsertItem", VALUEFUNC(WxTreeCtrl::InsertItem),-1);
    rb_define_method(rb_cWxTreeCtrl, "InsertItemBefore", VALUEFUNC(WxTreeCtrl::InsertItemBefore),-1);
    rb_define_method(rb_cWxTreeCtrl, "IsBold", VALUEFUNC(WxTreeCtrl::IsBold),1);
    rb_define_method(rb_cWxTreeCtrl, "IsExpanded", VALUEFUNC(WxTreeCtrl::IsExpanded),1);
    rb_define_method(rb_cWxTreeCtrl, "IsSelected", VALUEFUNC(WxTreeCtrl::IsSelected),1);
    rb_define_method(rb_cWxTreeCtrl, "IsVisible", VALUEFUNC(WxTreeCtrl::IsVisible),1);
    rb_define_method(rb_cWxTreeCtrl, "ItemHasChildren", VALUEFUNC(WxTreeCtrl::ItemHasChildren),1);
    rb_define_method(rb_cWxTreeCtrl, "PrependItem", VALUEFUNC(WxTreeCtrl::PrependItem),-1);
    rb_define_method(rb_cWxTreeCtrl, "ScrollTo", VALUEFUNC(WxTreeCtrl::ScrollTo),1);
    rb_define_method(rb_cWxTreeCtrl, "SelectItem", VALUEFUNC(WxTreeCtrl::SelectItem),1);
//    rb_define_method(rb_cWxTreeCtrl, "SetButtonsImageList", VALUEFUNC(WxTreeCtrl::SetButtonsImageList),1);
    rb_define_method(rb_cWxTreeCtrl, "SetImageList", VALUEFUNC(WxTreeCtrl::SetImageList),1);
    rb_define_method(rb_cWxTreeCtrl, "SetIndent", VALUEFUNC(WxTreeCtrl::SetIndent),1);
    rb_define_method(rb_cWxTreeCtrl, "SetSpacing", VALUEFUNC(WxTreeCtrl::SetSpacing),1);
    rb_define_method(rb_cWxTreeCtrl, "SetItemBackgroundColour", VALUEFUNC(WxTreeCtrl::SetItemBackgroundColour),2);
    rb_define_method(rb_cWxTreeCtrl, "SetItemImage", VALUEFUNC(WxTreeCtrl::SetItemImage),-1);
    rb_define_method(rb_cWxTreeCtrl, "SetItemBold", VALUEFUNC(WxTreeCtrl::SetItemBold),-1);
    rb_define_method(rb_cWxTreeCtrl, "SetItemData", VALUEFUNC(WxTreeCtrl::SetItemData),2);
    rb_define_method(rb_cWxTreeCtrl, "SetItemFont", VALUEFUNC(WxTreeCtrl::SetItemFont),2);
    rb_define_method(rb_cWxTreeCtrl, "SetItemHasChildren", VALUEFUNC(WxTreeCtrl::SetItemHasChildren),-1);
    rb_define_method(rb_cWxTreeCtrl, "SetItemSelectedImage", VALUEFUNC(WxTreeCtrl::SetItemSelectedImage),2);
    rb_define_method(rb_cWxTreeCtrl, "SetItemText", VALUEFUNC(WxTreeCtrl::SetItemText),2);
    rb_define_method(rb_cWxTreeCtrl, "SetItemTextColour", VALUEFUNC(WxTreeCtrl::SetItemTextColour),2);
    rb_define_method(rb_cWxTreeCtrl, "SetStateImageList", VALUEFUNC(WxTreeCtrl::SetStateImageList),1);
    rb_define_method(rb_cWxTreeCtrl, "SortChildren", VALUEFUNC(WxTreeCtrl::SortChildren),1);
    rb_define_method(rb_cWxTreeCtrl, "Toggle", VALUEFUNC(WxTreeCtrl::Toggle),1);
    rb_define_method(rb_cWxTreeCtrl, "Unselect", VALUEFUNC(WxTreeCtrl::Unselect),0);
    rb_define_method(rb_cWxTreeCtrl, "UnselectAll", VALUEFUNC(WxTreeCtrl::UnselectAll),0);
    rb_define_method(rb_cWxTreeCtrl, "OnCompareItems", VALUEFUNC(WxTreeCtrl::OnCompareItems),2);

    rb_define_method(mWx, "WxMessageBox", VALUEFUNC(WxMessageBox), -1);
    rb_define_method(mWx, "WxGetApp", VALUEFUNC(WxGetApp), 0);
    rb_define_method(mWx, "WxBell", VALUEFUNC(WxBell), 0);
    rb_define_method(mWx, "WxYield", VALUEFUNC(WxYield), 0);
    rb_define_method(mWx, "WxGetCwd", VALUEFUNC(WxGetCwd), 0);
    rb_define_method(mWx, "WxGetEmailAddress", VALUEFUNC(WxGetEmailAddress), 0);
    rb_define_method(mWx, "WxGetHostName", VALUEFUNC(WxGetHostName), 0);
    rb_define_method(mWx, "WxGetFullHostName", VALUEFUNC(WxGetFullHostName), 0);
    rb_define_method(mWx, "WxGetUserId", VALUEFUNC(WxGetUserId), 0);
    rb_define_method(mWx, "WxGetUserName", VALUEFUNC(WxGetUserName), 0);
    rb_define_method(mWx, "WxGetHomeDir", VALUEFUNC(WxGetHomeDir), 0);
    rb_define_method(mWx, "WxSetWorkingDirectory", VALUEFUNC(WxSetWorkingDirectory), 1);
    rb_define_method(mWx, "WxLogMessage", VALUEFUNC(WxLogMessage), -1);
    rb_define_method(mWx, "WxLogError", VALUEFUNC(WxLogError), -1);
    rb_define_method(mWx, "WxLogWarning", VALUEFUNC(WxLogWarning), -1);
    rb_define_method(mWx, "WxLogStatus", VALUEFUNC(WxLogStatus), -1);
    rb_define_method(mWx, "WxGetNumberFromUser", VALUEFUNC(WxGetNumberFromUser), -1);
    rb_define_method(mWx, "WxGetTextFromUser", VALUEFUNC(WxGetTextFromUser), -1);
    rb_define_method(mWx, "WxGetPasswordFromUser", VALUEFUNC(WxGetPasswordFromUser), -1);
    rb_define_method(mWx, "WxGetSingleChoiceIndex", VALUEFUNC(WxGetSingleChoiceIndex), -1);
    rb_define_method(mWx, "WxGetSingleChoice", VALUEFUNC(WxGetSingleChoice), -1);
    rb_define_method(mWx, "WxGetMultipleChoices", VALUEFUNC(WxGetMultipleChoices), -1);
    rb_define_method(mWx, "WxCreateFileTipProvider", VALUEFUNC(WxCreateFileTipProvider), 2);
    rb_define_method(mWx, "WxShowTip", VALUEFUNC(WxShowTip), -1);
    rb_define_method(mWx, "WxFileSelector", VALUEFUNC(WxFileSelector), -1);
    rb_define_method(mWx, "WxLoadFileSelector", VALUEFUNC(WxLoadFileSelector), -1);
    rb_define_method(mWx, "WxSaveFileSelector", VALUEFUNC(WxSaveFileSelector), -1);
    rb_define_method(mWx, "WxGetColourFromUser", VALUEFUNC(WxGetColourFromUser), -1);

    rb_define_method(mWx, "EVT_ACTIVATE",VALUEFUNC(WxEvtHandler::WxRbEVT_ACTIVATE),2);
    rb_define_method(mWx, "EVT_ACTIVATE_APP",VALUEFUNC(WxEvtHandler::WxRbEVT_ACTIVATE_APP),2);
    rb_define_method(mWx, "EVT_BUTTON",VALUEFUNC(WxEvtHandler::WxRbEVT_BUTTON),3);
    rb_define_method(mWx, "EVT_CALENDAR",VALUEFUNC(WxEvtHandler::WxRbEVT_CALENDAR),3);
    rb_define_method(mWx, "EVT_CALENDAR_DAY",VALUEFUNC(WxEvtHandler::WxRbEVT_CALENDAR_DAY),3);
    rb_define_method(mWx, "EVT_CALENDAR_MONTH",VALUEFUNC(WxEvtHandler::WxRbEVT_CALENDAR_MONTH),3);
    rb_define_method(mWx, "EVT_CALENDAR_SEL_CHANGED",VALUEFUNC(WxEvtHandler::WxRbEVT_CALENDAR_SEL_CHANGED),3);
    rb_define_method(mWx, "EVT_CALENDAR_WEEKDAY_CLICKED",VALUEFUNC(WxEvtHandler::WxRbEVT_CALENDAR_WEEKDAY_CLICKED),3);
    rb_define_method(mWx, "EVT_CALENDAR_YEAR",VALUEFUNC(WxEvtHandler::WxRbEVT_CALENDAR_YEAR),3);
    rb_define_method(mWx, "EVT_CHAR",VALUEFUNC(WxEvtHandler::WxRbEVT_CHAR),2);
    rb_define_method(mWx, "EVT_CHAR_HOOK",VALUEFUNC(WxEvtHandler::WxRbEVT_CHAR_HOOK),2);
    rb_define_method(mWx, "EVT_CHECKBOX",VALUEFUNC(WxEvtHandler::WxRbEVT_CHECKBOX),3);
    rb_define_method(mWx, "EVT_CHECKLISTBOX",VALUEFUNC(WxEvtHandler::WxRbEVT_CHECKLISTBOX),3);
    rb_define_method(mWx, "EVT_CHILD_FOCUS",VALUEFUNC(WxEvtHandler::WxRbEVT_CHILD_FOCUS),2);
    rb_define_method(mWx, "EVT_CHOICE",VALUEFUNC(WxEvtHandler::WxRbEVT_CHOICE),3);
    rb_define_method(mWx, "EVT_CLOSE",VALUEFUNC(WxEvtHandler::WxRbEVT_CLOSE),2);
    rb_define_method(mWx, "EVT_COMBOBOX",VALUEFUNC(WxEvtHandler::WxRbEVT_COMBOBOX),3);
    rb_define_method(mWx, "EVT_COMMAND",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND),4);
    rb_define_method(mWx, "EVT_COMMAND_ENTER",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_ENTER),3);
    rb_define_method(mWx, "EVT_COMMAND_KILL_FOCUS",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_KILL_FOCUS),3);
    rb_define_method(mWx, "EVT_COMMAND_LEFT_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_LEFT_CLICK),3);
    rb_define_method(mWx, "EVT_COMMAND_LEFT_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_LEFT_DCLICK),3);
    rb_define_method(mWx, "EVT_COMMAND_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_RANGE),5);
    rb_define_method(mWx, "EVT_COMMAND_RIGHT_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_RIGHT_CLICK),3);
    rb_define_method(mWx, "EVT_COMMAND_RIGHT_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_RIGHT_DCLICK),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_BOTTOM",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_BOTTOM),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_LINEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_LINEDOWN),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_LINEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_LINEUP),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_PAGEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_PAGEDOWN),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_PAGEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_PAGEUP),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_THUMBRELEASE",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_THUMBRELEASE),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_THUMBTRACK",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_THUMBTRACK),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLLWIN_TOP",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_TOP),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_BOTTOM",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_BOTTOM),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_LINEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_LINEDOWN),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_LINEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_LINEUP),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_PAGEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_PAGEDOWN),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_PAGEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_PAGEUP),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_THUMBRELEASE",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_THUMBRELEASE),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_THUMBTRACK",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_THUMBTRACK),3);
    rb_define_method(mWx, "EVT_COMMAND_SCROLL_TOP",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SCROLL_TOP),3);
    rb_define_method(mWx, "EVT_COMMAND_SET_FOCUS",VALUEFUNC(WxEvtHandler::WxRbEVT_COMMAND_SET_FOCUS),3);
    rb_define_method(mWx, "EVT_CONTEXT_MENU",VALUEFUNC(WxEvtHandler::WxRbEVT_CONTEXT_MENU),2);
    rb_define_method(mWx, "EVT_DETAILED_HELP",VALUEFUNC(WxEvtHandler::WxRbEVT_DETAILED_HELP),3);
    rb_define_method(mWx, "EVT_DETAILED_HELP_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_DETAILED_HELP_RANGE),4);
    rb_define_method(mWx, "EVT_DROP_FILES",VALUEFUNC(WxEvtHandler::WxRbEVT_DROP_FILES),2);
    rb_define_method(mWx, "EVT_END_PROCESS",VALUEFUNC(WxEvtHandler::WxRbEVT_END_PROCESS),3);
    rb_define_method(mWx, "EVT_END_SESSION",VALUEFUNC(WxEvtHandler::WxRbEVT_END_SESSION),2);
    rb_define_method(mWx, "EVT_ENTER_WINDOW",VALUEFUNC(WxEvtHandler::WxRbEVT_ENTER_WINDOW),2);
    rb_define_method(mWx, "EVT_ERASE_BACKGROUND",VALUEFUNC(WxEvtHandler::WxRbEVT_ERASE_BACKGROUND),2);
    rb_define_method(mWx, "EVT_HELP",VALUEFUNC(WxEvtHandler::WxRbEVT_HELP),3);
    rb_define_method(mWx, "EVT_HELP_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_HELP_RANGE),4);
    rb_define_method(mWx, "EVT_ICONIZE",VALUEFUNC(WxEvtHandler::WxRbEVT_ICONIZE),2);
    rb_define_method(mWx, "EVT_IDLE",VALUEFUNC(WxEvtHandler::WxRbEVT_IDLE),2);
    rb_define_method(mWx, "EVT_INIT_DIALOG",VALUEFUNC(WxEvtHandler::WxRbEVT_INIT_DIALOG),2);
    rb_define_method(mWx, "EVT_JOYSTICK_EVENTS",VALUEFUNC(WxEvtHandler::WxRbEVT_JOYSTICK_EVENTS),2);
    rb_define_method(mWx, "EVT_JOY_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_JOY_DOWN),2);
    rb_define_method(mWx, "EVT_JOY_MOVE",VALUEFUNC(WxEvtHandler::WxRbEVT_JOY_MOVE),2);
    rb_define_method(mWx, "EVT_JOY_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_JOY_UP),2);
    rb_define_method(mWx, "EVT_JOY_ZMOVE",VALUEFUNC(WxEvtHandler::WxRbEVT_JOY_ZMOVE),2);
    rb_define_method(mWx, "EVT_KEY_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_KEY_DOWN),2);
    rb_define_method(mWx, "EVT_KEY_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_KEY_UP),2);
    rb_define_method(mWx, "EVT_KILL_FOCUS",VALUEFUNC(WxEvtHandler::WxRbEVT_KILL_FOCUS),2);
    rb_define_method(mWx, "EVT_LEAVE_WINDOW",VALUEFUNC(WxEvtHandler::WxRbEVT_LEAVE_WINDOW),2);
    rb_define_method(mWx, "EVT_LEFT_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_LEFT_DCLICK),2);
    rb_define_method(mWx, "EVT_LEFT_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_LEFT_DOWN),2);
    rb_define_method(mWx, "EVT_LEFT_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_LEFT_UP),2);
    rb_define_method(mWx, "EVT_LISTBOX",VALUEFUNC(WxEvtHandler::WxRbEVT_LISTBOX),3);
    rb_define_method(mWx, "EVT_LISTBOX_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_LISTBOX_DCLICK),3);
    rb_define_method(mWx, "EVT_MAXIMIZE",VALUEFUNC(WxEvtHandler::WxRbEVT_MAXIMIZE),2);
    rb_define_method(mWx, "EVT_MENU",VALUEFUNC(WxEvtHandler::WxRbEVT_MENU),3);
    rb_define_method(mWx, "EVT_MENU_HIGHLIGHT",VALUEFUNC(WxEvtHandler::WxRbEVT_MENU_HIGHLIGHT),3);
    rb_define_method(mWx, "EVT_MENU_HIGHLIGHT_ALL",VALUEFUNC(WxEvtHandler::WxRbEVT_MENU_HIGHLIGHT_ALL),2);
    rb_define_method(mWx, "EVT_MENU_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_MENU_RANGE),4);
    rb_define_method(mWx, "EVT_MIDDLE_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_MIDDLE_DCLICK),2);
    rb_define_method(mWx, "EVT_MIDDLE_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_MIDDLE_DOWN),2);
    rb_define_method(mWx, "EVT_MIDDLE_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_MIDDLE_UP),2);
    rb_define_method(mWx, "EVT_MOTION",VALUEFUNC(WxEvtHandler::WxRbEVT_MOTION),2);
    rb_define_method(mWx, "EVT_MOUSEWHEEL",VALUEFUNC(WxEvtHandler::WxRbEVT_MOUSEWHEEL),2);
    rb_define_method(mWx, "EVT_MOUSE_EVENTS",VALUEFUNC(WxEvtHandler::WxRbEVT_MOUSE_EVENTS),2);
    rb_define_method(mWx, "EVT_MOVE",VALUEFUNC(WxEvtHandler::WxRbEVT_MOVE),2);
    rb_define_method(mWx, "EVT_NAVIGATION_KEY",VALUEFUNC(WxEvtHandler::WxRbEVT_NAVIGATION_KEY),2);
    rb_define_method(mWx, "EVT_NOTEBOOK_PAGE_CHANGED",VALUEFUNC(WxEvtHandler::WxRbEVT_NOTEBOOK_PAGE_CHANGED),3);
    rb_define_method(mWx, "EVT_NOTEBOOK_PAGE_CHANGING",VALUEFUNC(WxEvtHandler::WxRbEVT_NOTEBOOK_PAGE_CHANGING),3);
    rb_define_method(mWx, "EVT_PAINT",VALUEFUNC(WxEvtHandler::WxRbEVT_PAINT),2);
    rb_define_method(mWx, "EVT_PALETTE_CHANGED",VALUEFUNC(WxEvtHandler::WxRbEVT_PALETTE_CHANGED),2);
    rb_define_method(mWx, "EVT_QUERY_END_SESSION",VALUEFUNC(WxEvtHandler::WxRbEVT_QUERY_END_SESSION),2);
    rb_define_method(mWx, "EVT_QUERY_NEW_PALETTE",VALUEFUNC(WxEvtHandler::WxRbEVT_QUERY_NEW_PALETTE),2);
    rb_define_method(mWx, "EVT_RADIOBOX",VALUEFUNC(WxEvtHandler::WxRbEVT_RADIOBOX),3);
    rb_define_method(mWx, "EVT_RADIOBUTTON",VALUEFUNC(WxEvtHandler::WxRbEVT_RADIOBUTTON),3);
    rb_define_method(mWx, "EVT_RIGHT_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_RIGHT_DCLICK),2);
    rb_define_method(mWx, "EVT_RIGHT_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_RIGHT_DOWN),2);
    rb_define_method(mWx, "EVT_RIGHT_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_RIGHT_UP),2);
#if wxUSE_SASH
    rb_define_method(mWx, "EVT_SASH_DRAGGED",VALUEFUNC(WxEvtHandler::WxRbEVT_SASH_DRAGGED),3);
    rb_define_method(mWx, "EVT_SASH_DRAGGED_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_SASH_DRAGGED_RANGE),4);
    rb_define_method(mWx, "EVT_QUERY_LAYOUT_INFO",VALUEFUNC(WxEvtHandler::WxRbEVT_QUERY_LAYOUT_INFO),2);
    rb_define_method(mWx, "EVT_CALCULATE_LAYOUT",VALUEFUNC(WxEvtHandler::WxRbEVT_CALCULATE_LAYOUT),2);
#endif
    rb_define_method(mWx, "EVT_SCROLL",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL),2);
    rb_define_method(mWx, "EVT_SCROLLWIN",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_BOTTOM",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_BOTTOM),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_LINEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_LINEDOWN),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_LINEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_LINEUP),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_PAGEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_PAGEDOWN),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_PAGEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_PAGEUP),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_THUMBRELEASE",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_THUMBRELEASE),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_THUMBTRACK",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_THUMBTRACK),2);
    rb_define_method(mWx, "EVT_SCROLLWIN_TOP",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLLWIN_TOP),2);
    rb_define_method(mWx, "EVT_SCROLL_BOTTOM",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_BOTTOM),2);
    rb_define_method(mWx, "EVT_SCROLL_LINEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_LINEDOWN),2);
    rb_define_method(mWx, "EVT_SCROLL_LINEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_LINEUP),2);
    rb_define_method(mWx, "EVT_SCROLL_PAGEDOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_PAGEDOWN),2);
    rb_define_method(mWx, "EVT_SCROLL_PAGEUP",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_PAGEUP),2);
    rb_define_method(mWx, "EVT_SCROLL_THUMBRELEASE",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_THUMBRELEASE),2);
    rb_define_method(mWx, "EVT_SCROLL_THUMBTRACK",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_THUMBTRACK),2);
    rb_define_method(mWx, "EVT_SCROLL_TOP",VALUEFUNC(WxEvtHandler::WxRbEVT_SCROLL_TOP),2);
    rb_define_method(mWx, "EVT_SET_FOCUS",VALUEFUNC(WxEvtHandler::WxRbEVT_SET_FOCUS),2);
    rb_define_method(mWx, "EVT_SHOW",VALUEFUNC(WxEvtHandler::WxRbEVT_SHOW),2);
    rb_define_method(mWx, "EVT_SIZE",VALUEFUNC(WxEvtHandler::WxRbEVT_SIZE),2);
    rb_define_method(mWx, "EVT_SLIDER",VALUEFUNC(WxEvtHandler::WxRbEVT_SLIDER),3);
    rb_define_method(mWx, "EVT_SPIN",VALUEFUNC(WxEvtHandler::WxRbEVT_SPIN),3);
    rb_define_method(mWx, "EVT_SPINCTRL",VALUEFUNC(WxEvtHandler::WxRbEVT_SPINCTRL),3);
    rb_define_method(mWx, "EVT_SPIN_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_SPIN_DOWN),3);
    rb_define_method(mWx, "EVT_SPIN_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_SPIN_UP),3);
    rb_define_method(mWx, "EVT_SPLITTER_DOUBLECLICKED",VALUEFUNC(WxEvtHandler::WxRbEVT_SPLITTER_DOUBLECLICKED),3);
    rb_define_method(mWx, "EVT_SPLITTER_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_SPLITTER_DOUBLECLICKED),3);
    rb_define_method(mWx, "EVT_SPLITTER_SASH_POS_CHANGED",VALUEFUNC(WxEvtHandler::WxRbEVT_SPLITTER_SASH_POS_CHANGED),3);
    rb_define_method(mWx, "EVT_SPLITTER_SASH_POS_CHANGING",VALUEFUNC(WxEvtHandler::WxRbEVT_SPLITTER_SASH_POS_CHANGING),3);
    rb_define_method(mWx, "EVT_SPLITTER_UNSPLIT",VALUEFUNC(WxEvtHandler::WxRbEVT_SPLITTER_UNSPLIT),3);
    rb_define_method(mWx, "EVT_SYS_COLOUR_CHANGED",VALUEFUNC(WxEvtHandler::WxRbEVT_SYS_COLOUR_CHANGED),2);
#ifdef __WXMSW__
    rb_define_method(mWx, "EVT_TASKBAR_LEFT_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_LEFT_DCLICK),2);
    rb_define_method(mWx, "EVT_TASKBAR_LEFT_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_LEFT_DOWN),2);
    rb_define_method(mWx, "EVT_TASKBAR_LEFT_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_LEFT_UP),2);
    rb_define_method(mWx, "EVT_TASKBAR_MOVE",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_MOVE),2);
    rb_define_method(mWx, "EVT_TASKBAR_RIGHT_DCLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_RIGHT_DCLICK),2);
    rb_define_method(mWx, "EVT_TASKBAR_RIGHT_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_RIGHT_DOWN),2);
    rb_define_method(mWx, "EVT_TASKBAR_RIGHT_UP",VALUEFUNC(WxEvtHandler::WxRbEVT_TASKBAR_RIGHT_UP),2);
#endif
    rb_define_method(mWx, "EVT_TEXT",VALUEFUNC(WxEvtHandler::WxRbEVT_TEXT),3);
    rb_define_method(mWx, "EVT_TEXT_ENTER",VALUEFUNC(WxEvtHandler::WxRbEVT_TEXT_ENTER),3);
    rb_define_method(mWx, "EVT_TEXT_MAXLEN",VALUEFUNC(WxEvtHandler::WxRbEVT_TEXT_MAXLEN),3);
    rb_define_method(mWx, "EVT_TEXT_URL",VALUEFUNC(WxEvtHandler::WxRbEVT_TEXT_URL),3);
    rb_define_method(mWx, "EVT_TIMER",VALUEFUNC(WxEvtHandler::WxRbEVT_TIMER),3);
    rb_define_method(mWx, "EVT_TOGGLEBUTTON",VALUEFUNC(WxEvtHandler::WxRbEVT_TOGGLEBUTTON),3);
    rb_define_method(mWx, "EVT_TOOL",VALUEFUNC(WxEvtHandler::WxRbEVT_TOOL),3);
    rb_define_method(mWx, "EVT_TOOL_ENTER",VALUEFUNC(WxEvtHandler::WxRbEVT_TOOL_ENTER),3);
    rb_define_method(mWx, "EVT_TOOL_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_TOOL_RANGE),4);
    rb_define_method(mWx, "EVT_TOOL_RCLICKED",VALUEFUNC(WxEvtHandler::WxRbEVT_TOOL_RCLICKED),3);
    rb_define_method(mWx, "EVT_TOOL_RCLICKED_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_TOOL_RCLICKED_RANGE),4);
    rb_define_method(mWx, "EVT_UPDATE_UI",VALUEFUNC(WxEvtHandler::WxRbEVT_UPDATE_UI),3);
    rb_define_method(mWx, "EVT_UPDATE_UI_RANGE",VALUEFUNC(WxEvtHandler::WxRbEVT_UPDATE_UI_RANGE),4);
    rb_define_method(mWx, "EVT_VLBOX",VALUEFUNC(WxEvtHandler::WxRbEVT_VLBOX),3);
    rb_define_method(mWx, "EVT_WINDOW_CREATE",VALUEFUNC(WxEvtHandler::WxRbEVT_WINDOW_CREATE),2);
    rb_define_method(mWx, "EVT_WINDOW_DESTROY",VALUEFUNC(WxEvtHandler::WxRbEVT_WINDOW_DESTROY),2);

    rb_define_method(mWx, "EVT_LIST_BEGIN_DRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_BEGIN_DRAG),3);
    rb_define_method(mWx, "EVT_LIST_BEGIN_LABEL_EDIT",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_BEGIN_LABEL_EDIT),3);
    rb_define_method(mWx, "EVT_LIST_BEGIN_RDRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_BEGIN_RDRAG),3);
    rb_define_method(mWx, "EVT_LIST_CACHE_HINT",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_CACHE_HINT),3);
    rb_define_method(mWx, "EVT_LIST_COL_BEGIN_DRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_COL_BEGIN_DRAG),3);
    rb_define_method(mWx, "EVT_LIST_COL_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_COL_CLICK),3);
    rb_define_method(mWx, "EVT_LIST_COL_DRAGGING",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_COL_DRAGGING),3);
    rb_define_method(mWx, "EVT_LIST_COL_END_DRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_COL_END_DRAG),3);
    rb_define_method(mWx, "EVT_LIST_COL_RIGHT_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_COL_RIGHT_CLICK),3);
    rb_define_method(mWx, "EVT_LIST_DELETE_ALL_ITEMS",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_DELETE_ALL_ITEMS),3);
    rb_define_method(mWx, "EVT_LIST_DELETE_ITEM",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_DELETE_ITEM),3);
    rb_define_method(mWx, "EVT_LIST_END_LABEL_EDIT",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_END_LABEL_EDIT),3);
    rb_define_method(mWx, "EVT_LIST_GET_INFO",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_GET_INFO),3);
    rb_define_method(mWx, "EVT_LIST_INSERT_ITEM",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_INSERT_ITEM),3);
    rb_define_method(mWx, "EVT_LIST_ITEM_ACTIVATED",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_ITEM_ACTIVATED),3);
    rb_define_method(mWx, "EVT_LIST_ITEM_DESELECTED",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_ITEM_DESELECTED),3);
    rb_define_method(mWx, "EVT_LIST_ITEM_FOCUSED",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_ITEM_FOCUSED),3);
    rb_define_method(mWx, "EVT_LIST_ITEM_MIDDLE_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_ITEM_MIDDLE_CLICK),3);
    rb_define_method(mWx, "EVT_LIST_ITEM_RIGHT_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_ITEM_RIGHT_CLICK),3);
    rb_define_method(mWx, "EVT_LIST_ITEM_SELECTED",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_ITEM_SELECTED),3);
    rb_define_method(mWx, "EVT_LIST_KEY_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_KEY_DOWN),3);
    rb_define_method(mWx, "EVT_LIST_SET_INFO",VALUEFUNC(WxEvtHandler::WxRbEVT_LIST_SET_INFO),3);
    rb_define_method(mWx, "EVT_FIND",VALUEFUNC(WxEvtHandler::WxRbEVT_FIND),3);
    rb_define_method(mWx, "EVT_FIND_NEXT",VALUEFUNC(WxEvtHandler::WxRbEVT_FIND_NEXT),3);
    rb_define_method(mWx, "EVT_FIND_REPLACE",VALUEFUNC(WxEvtHandler::WxRbEVT_FIND_REPLACE),3);
    rb_define_method(mWx, "EVT_FIND_REPLACE_ALL",VALUEFUNC(WxEvtHandler::WxRbEVT_FIND_REPLACE_ALL),3);
    rb_define_method(mWx, "EVT_FIND_CLOSE",VALUEFUNC(WxEvtHandler::WxRbEVT_FIND_CLOSE),3);
    rb_define_method(mWx, "EVT_SOCKET",VALUEFUNC(WxEvtHandler::WxRbEVT_SOCKET),3);
    rb_define_method(mWx, "EVT_TREE_BEGIN_DRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_BEGIN_DRAG),3);
    rb_define_method(mWx, "EVT_TREE_BEGIN_LABEL_EDIT",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_BEGIN_LABEL_EDIT),3);
    rb_define_method(mWx, "EVT_TREE_BEGIN_RDRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_BEGIN_RDRAG),3);
    rb_define_method(mWx, "EVT_TREE_DELETE_ITEM",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_DELETE_ITEM),3);
    rb_define_method(mWx, "EVT_TREE_END_DRAG",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_END_DRAG            ),3);
    rb_define_method(mWx, "EVT_TREE_END_LABEL_EDIT",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_END_LABEL_EDIT),3);
    rb_define_method(mWx, "EVT_TREE_GET_INFO",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_GET_INFO),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_ACTIVATED",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_ACTIVATED),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_COLLAPSED",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_COLLAPSED),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_COLLAPSING",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_COLLAPSING),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_EXPANDED",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_EXPANDED),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_EXPANDING",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_EXPANDING),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_MIDDLE_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_MIDDLE_CLICK),3);
    rb_define_method(mWx, "EVT_TREE_ITEM_RIGHT_CLICK",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_ITEM_RIGHT_CLICK),3);
    rb_define_method(mWx, "EVT_TREE_KEY_DOWN",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_KEY_DOWN),3);
    rb_define_method(mWx, "EVT_TREE_SEL_CHANGED",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_SEL_CHANGED),3);
    rb_define_method(mWx, "EVT_TREE_SEL_CHANGING",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_SEL_CHANGING),3);
    rb_define_method(mWx, "EVT_TREE_SET_INFO",VALUEFUNC(WxEvtHandler::WxRbEVT_TREE_SET_INFO),3);

    int argc = 1;
    char *argv = "wxruby";
    wxEntryStart(argc,&argv);

    SetConstant();

}


