/**********************************************************************

  url.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:49 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "socket.h"
#include "stream.h"
#include "url.h"

VALUE
WxURL::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxURL::init(VALUE self,VALUE vurl)
{
    wxString url = StringValuePtr(vurl);
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    ptr = new wxURL(url);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxURL::GetProtocolName(VALUE self)
{
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    return rb_str_new2(ptr->GetProtocolName());
}

VALUE
WxURL::GetProtocol(VALUE self)
{
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    return WxProtocol::init0(&ptr->GetProtocol());
}

VALUE
WxURL::GetPath(VALUE self)
{
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    return rb_str_new2(ptr->GetPath());
}

VALUE
WxURL::GetError(VALUE self)
{
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    return INT2NUM(ptr->GetError());
}

VALUE
WxURL::GetInputStream(VALUE self)
{
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    return WxInputStream::init0(ptr->GetInputStream());
}

void
WxURL::SetDefaultProxy(VALUE self,VALUE vurl_proxy)
{
    wxString url_proxy = StringValuePtr(vurl_proxy);
    wxURL::SetDefaultProxy(url_proxy);
}

void
WxURL::SetProxy(VALUE self,VALUE vurl_proxy)
{
    wxString url_proxy = StringValuePtr(vurl_proxy);
    wxURL *ptr;
    Data_Get_Struct(self, wxURL, ptr);
    ptr->SetProxy(url_proxy);
}

VALUE
WxURL::ConvertToValidURI(VALUE self,VALUE vuri)
{
    wxString uri = StringValuePtr(vuri);
    return rb_str_new2(wxURL::ConvertToValidURI(uri));
}














