/**********************************************************************

  tooltip.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:49 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "tooltip.h"
#include "window.h"

VALUE
WxToolTip::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxToolTip::init(VALUE self,VALUE vtip)
{
    wxString tip = StringValuePtr(vtip);
    wxToolTip *ptr;
    Data_Get_Struct(self, wxToolTip, ptr);
    ptr = new wxToolTip(tip);
    DATA_PTR(self) = ptr;

    return self;
}

void
WxToolTip::Enable(VALUE self,VALUE vflag)
{
    bool flag = (vflag == Qtrue);
    wxToolTip::Enable(flag);
}

void
WxToolTip::SetDelay(VALUE self,VALUE vmsecs)
{
    long msecs = NUM2INT(vmsecs);
    wxToolTip::SetDelay(msecs);
}

void
WxToolTip::SetTip(VALUE self,VALUE vtip)
{
    wxString tip = StringValuePtr(vtip);
    wxToolTip *ptr;
    Data_Get_Struct(self, wxToolTip, ptr);
    ptr->SetTip(tip);
}

VALUE
WxToolTip::GetTip(VALUE self)
{
    wxToolTip *ptr;
    Data_Get_Struct(self, wxToolTip, ptr);
    return rb_str_new2(ptr->GetTip());
}

VALUE
WxToolTip::GetWindow(VALUE self)
{
    wxToolTip *ptr;
    Data_Get_Struct(self, wxToolTip, ptr);
    return WxWindow::init0(ptr->GetWindow());
}

VALUE
WxToolTip::init0(wxToolTip *tooltip)
{
    extern VALUE rb_cWxToolTip;
    VALUE self = Data_Wrap_Struct(rb_cWxToolTip, 0, 0, 0);
    DATA_PTR(self) = tooltip;
    return self;
}




