
require 'wx'
include Wx

SPLIT_QUIT = 0
SPLIT_HORIZONTAL = 1
SPLIT_VERTICAL = 2
SPLIT_UNSPLIT = 3
SPLIT_LIVE = 4
SPLIT_SETPOSITION = 5
SPLIT_SETMINSIZE = 6

class MyCanvas < WxScrolledWindow
    def initialize(parent)
        super(parent, -1)
    end

    def OnDraw(dc)
        dc.SetPen(WxBLACK_PEN)
        dc.DrawLine(0, 0, 100, 100)

        dc.SetBackgroundMode(WxTRANSPARENT)
        dc.DrawText("Testing", 50, 50)

        dc.SetPen(WxRED_PEN)
        dc.SetBrush(WxGREEN_BRUSH)
        dc.DrawRectangle(120, 120, 100, 80)
    end

end

class MySplitterWindow < WxSplitterWindow
    def initialize(parent)
        super(parent, -1,
                       WxDefaultPosition, WxDefaultSize,
                       WxSP_3D | WxSP_LIVE_UPDATE | WxCLIP_CHILDREN)

        @m_frame = parent

        EVT_SPLITTER_SASH_POS_CHANGED(self,-1, "OnPositionChanged")
        EVT_SPLITTER_SASH_POS_CHANGING(self,-1, "OnPositionChanging")

        EVT_SPLITTER_DCLICK(self,-1, "OnDClick")

        EVT_SPLITTER_UNSPLIT(self,-1, "OnUnsplit")

    end

    def OnPositionChanged(event)
        WxLogStatus(@m_frame, "Position has changed, now = %d (or %d)",
                event.GetSashPosition(), GetSashPosition())

        event.Skip()
    end

    def OnPositionChanging(event)
        WxLogStatus(@m_frame, "Position is changing, now = %d (or %d)",
                event.GetSashPosition(), GetSashPosition())

        event.Skip()
    end

    def OnDClick(event)
        @m_frame.SetStatusText("Splitter double clicked", 1)
        event.Skip()
    end

    def OnUnsplit(event)
        @m_frame.SetStatusText("Splitter unsplit", 1)
        event.Skip()
    end
end

class MyFrame < WxFrame
    def initialize
        super(nil, -1, "WxSplitterWindow sample",
                 WxDefaultPosition, WxSize.new(420, 300),
                 WxDEFAULT_FRAME_STYLE | WxNO_FULL_REPAINT_ON_RESIZE)

        CreateStatusBar(2)

        # Make a menubar
        splitMenu = WxMenu.new
        splitMenu.Append(SPLIT_VERTICAL,
                          "Split &Vertically\tCtrl-V",
                          "Split vertically")
        splitMenu.Append(SPLIT_HORIZONTAL,
                          "Split &Horizontally\tCtrl-H",
                          "Split horizontally")
        splitMenu.Append(SPLIT_UNSPLIT,
                          "&Unsplit\tCtrl-U",
                          "Unsplit")
        splitMenu.AppendSeparator()

        splitMenu.AppendCheckItem(SPLIT_LIVE,
                                   "&Live update\tCtrl-L",
                                   "Toggle live update mode")
        splitMenu.Append(SPLIT_SETPOSITION,
                          "Set splitter &position\tCtrl-P",
                          "Set the splitter position")
        splitMenu.Append(SPLIT_SETMINSIZE,
                          "Set &min size\tCtrl-M",
                          "Set minimum pane size")
        splitMenu.AppendSeparator()

        splitMenu.Append(SPLIT_QUIT, "E&xit\tAlt-X", "Exit")

        menuBar = WxMenuBar.new
        menuBar.Append(splitMenu, "&Splitter")

        SetMenuBar(menuBar)

        menuBar.Check(SPLIT_LIVE, TRUE)
        @m_splitter = MySplitterWindow.new(self)


        @m_left = MyCanvas.new(@m_splitter)
        @m_left.SetBackgroundColour(WxRED)
        @m_left.SetScrollbars(20, 20, 50, 50)
        @m_left.SetCursor(WxCursor.new(WxCURSOR_MAGNIFIER))

        @m_right = MyCanvas.new(@m_splitter)
        @m_right.SetBackgroundColour(WxCYAN)
        @m_right.SetScrollbars(20, 20, 50, 50)

        # for testing kbd navigation inside the splitter
    #    @m_left = new WxTextCtrl(@m_splitter, -1, "first text")
    #    @m_right = new WxTextCtrl(@m_splitter, -1, "second text")

        # you can also do self to start with a single window

    #    @m_right.Show(FALSE)
    #    @m_splitter.Initialize(@m_left)

        # you can also try -100
        @m_splitter.SplitVertically(@m_left, @m_right, 100)


        SetStatusText("Min pane size = 0", 1)

        EVT_MENU(self,SPLIT_VERTICAL, "SplitVertical")
        EVT_MENU(self,SPLIT_HORIZONTAL, "SplitHorizontal")
        EVT_MENU(self,SPLIT_UNSPLIT, "Unsplit")
        EVT_MENU(self,SPLIT_LIVE, "ToggleLive")
        EVT_MENU(self,SPLIT_SETPOSITION, "SetPosition")
        EVT_MENU(self,SPLIT_SETMINSIZE, "SetMinSize")

        EVT_MENU(self,SPLIT_QUIT, "Quit")

        EVT_UPDATE_UI(self,SPLIT_VERTICAL, "UpdateUIVertical")
        EVT_UPDATE_UI(self,SPLIT_HORIZONTAL, "UpdateUIHorizontal")
        EVT_UPDATE_UI(self,SPLIT_UNSPLIT, "UpdateUIUnsplit")

    end

    def Quit(event)
        Close(TRUE)
    end

    def SplitHorizontal(event )
        if @m_splitter.IsSplit()
            @m_splitter.Unsplit()
        end
        @m_left.Show(TRUE)
        @m_right.Show(TRUE)
        @m_splitter.SplitHorizontally( @m_left, @m_right )

        SetStatusText("Splitter split horizontally", 1)
    end

    def SplitVertical(event )
        if @m_splitter.IsSplit()
            @m_splitter.Unsplit()
        end
        @m_left.Show(TRUE)
        @m_right.Show(TRUE)
        @m_splitter.SplitVertically( @m_left, @m_right )

        SetStatusText("Splitter split vertically", 1)
    end

    def Unsplit(event)
        if @m_splitter.IsSplit()
            @m_splitter.Unsplit()
        end
        SetStatusText("No splitter")
    end

    def ToggleLive(event)
        style = @m_splitter.GetWindowStyleFlag()
        if event.IsChecked()
            style |= WxSP_LIVE_UPDATE
        else
            style &= ~WxSP_LIVE_UPDATE
        end
        @m_splitter.SetWindowStyleFlag(style)
    end

    def SetPosition(event)

        str = sprintf("%d", @m_splitter.GetSashPosition())
        str = WxGetTextFromUser("Enter splitter position:", "", str, self)
        if str == ""
            return nil
        end

        pos = str.to_i
#        if  !str.ToLong(&pos)
#            WxLogError("The splitter position should be an integer.")
#            return nil
#        end

        @m_splitter.SetSashPosition(pos)

        WxLogStatus(self, "Splitter position set to %d", pos)
    end

    def SetMinSize(event)
        str = sprintf("%d", @m_splitter.GetMinimumPaneSize())
        str = WxGetTextFromUser("Enter minimal size for panes:", "", str, self)
        if str == ""
            return nil
        end

        minsize = str.to_i
        @m_splitter.SetMinimumPaneSize(minsize)
        str = sprintf( "Min pane size = %d", minsize)
        SetStatusText(str, 1)
    end

    def UpdateUIHorizontal(event)
        event.Enable( (!@m_splitter.IsSplit()) || (@m_splitter.GetSplitMode() != WxSPLIT_HORIZONTAL) )
    end

    def UpdateUIVertical(event)
        event.Enable( ( (!@m_splitter.IsSplit()) || (@m_splitter.GetSplitMode() != WxSPLIT_VERTICAL) ) )
    end

    def UpdateUIUnsplit(event)
        event.Enable( @m_splitter.IsSplit() )
    end

end


class MyApp < WxApp
    def OnInit
        # create and show the main frame
        frame = MyFrame.new

        frame.Show(TRUE)
    end
end


a = MyApp.new
a.MainLoop()

