
require 'wx'
include Wx


Minimal_Quit = 1
Minimal_About = WxID_ABOUT


def labeledEntry(parent,sizer,label,default)
  sizer.Add(WxStaticText.new(parent,-1,label.to_s, WxDefaultPosition,WxDefaultSize,WxALIGN_RIGHT),1,WxALIGN_CENTER_VERTICAL)
  sizer.Add(r=WxTextCtrl.new(parent,-1,default.to_s, WxDefaultPosition,WxDefaultSize,WxALIGN_LEFT),1,WxALIGN_CENTER_VERTICAL)
  return r
end

class MyFrame < WxFrame
  def initialize(title,pos,size,style=WxDEFAULT_FRAME_STYLE)
    super(nil,-1,title,pos,size,style)

    if WxRUBY_PLATFORM == "WXMSW"
      SetIcon(WxIcon.new("mondrian.ico",WxBITMAP_TYPE_ICO))
    else
      SetIcon(WxIcon.new("mondrian.xpm",WxBITMAP_TYPE_XPM))
    end

    menuFile = WxMenu.new
    helpMenu = WxMenu.new
    helpMenu.Append(Minimal_About, "&About...\tF1", "Show about dialog")
    menuFile.Append(Minimal_Quit, "E&xit\tAlt-X", "Quit this program")
    menuBar = WxMenuBar.new
    menuBar.Append(menuFile, "&File")
    menuBar.Append(helpMenu, "&Help")
    SetMenuBar(menuBar)

    CreateStatusBar(2)
    SetStatusText("Welcome to wxRuby!")

    EVT_MENU(self, Minimal_Quit,  "OnQuit")
    EVT_MENU(self, Minimal_About,  "OnAbout")

  end

  def OnQuit(event)
    Close(TRUE)
  end

  def OnAbout(event)
    msg =  sprintf("This is the About dialog of the minimal sample.\n" \
    		   "Welcome to %s", WxVERSION_STRING)

    WxMessageBox(msg, "About Minimal", WxOK | WxICON_INFORMATION, self)

  end
end

class WxRbApp < WxApp
  def OnInit
    frame = MyFrame.new("Minimal wxRuby App",WxPoint.new(50, 50), WxSize.new(450, 340))

    frame.Show(TRUE)

  end
end

a = WxRbApp.new
a.MainLoop()
