
require 'wx'
include Wx

ID_CHOICE = 1000

class ChoiceDlg < WxDialog
  def initialize
    super(nil, -1, "ChoiceDialog", WxDefaultPosition, WxSize.new(185, 185))

    list = [ "ABS", "Airbag", "Air conditioning" ]

    @m_pChoice = WxChoice.new(self, ID_CHOICE, WxDefaultPosition, WxDefaultSize, list)
    @m_pChoice.Append("Automatic gear")

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    choiceSizer = WxBoxSizer.new(WxVERTICAL)
    choiceSizer.Add(@m_pChoice, 1, WxGROW)
    dlgSizer.Add(choiceSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_CHOICE(self,ID_CHOICE, "OnChoice")
    EVT_CLOSE(self,"OnClose")
  end

  def OnChoice(event)
    @m_pChoice.SetSelection(event.GetSelection())
  end

  def OnClose(event)
     Destroy()
  end
end


class WxRbApp < WxApp
  def OnInit
    dlg = ChoiceDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

