
require 'wx'
include Wx

ID_CHECKLISTBOX = 1000

class CheckListBoxDlg < WxDialog
  def initialize
    super(nil, -1, "Test", WxDefaultPosition, WxSize.new(150, 150))

    list = [ "ABS", "Airbag", "Air conditioning" ]

    @m_pCheckListBox = WxCheckListBox.new(self, ID_CHECKLISTBOX, WxDefaultPosition, WxDefaultSize, list)

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    checkListBoxSizer = WxBoxSizer.new(WxVERTICAL)
    checkListBoxSizer.Add(@m_pCheckListBox, 1, WxGROW)
    dlgSizer.Add(checkListBoxSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_CHECKLISTBOX(self,ID_CHECKLISTBOX, "OnCheck")
    EVT_CLOSE(self,"OnClose")
  end

  def OnCheck(command)
    item = command.GetSelection
    msg = sprintf("You clicked on item %d. The item is now %s", item,
               @m_pCheckListBox.IsChecked(item) ? "checked" : "unchecked")
    WxMessageBox(msg)
  end

  def OnClose(event)
     Destroy()
  end
end

class WxRbApp < WxApp
  def OnInit
    dlg = CheckListBoxDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

