
require 'wx'
include Wx

ID_CHECKBOX = 1000

class CheckBoxDlg < WxDialog
  def initialize
    super(nil, -1, "CheckBoxDialog", WxDefaultPosition, WxSize.new(150, 150))

    @m_pCheckBox = WxCheckBox.new(self, ID_CHECKBOX, "Check Me")

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    checkBoxSizer = WxBoxSizer.new(WxVERTICAL)
    checkBoxSizer.Add(@m_pCheckBox, 0, WxALIGN_CENTER)
    dlgSizer.Add(checkBoxSizer, 1, WxALIGN_CENTER)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_CHECKBOX(self,ID_CHECKBOX, "OnCheck")
    EVT_CLOSE(self,"OnClose")
  end

  def OnCheck(command)
    if ( command.IsChecked() )
      WxMessageBox("You checked")
    else
      WxMessageBox("You unchecked!")
    end
  end

  def OnClose(event)
     Destroy()
  end
end


class WxRbApp < WxApp
  def OnInit
    dlg = CheckBoxDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

