
require 'wx'
include Wx

ID_RADIOBOX = 1000

class RadioBoxDlg < WxDialog
  def initialize
    super(nil, -1, "RadioboxDialog", WxDefaultPosition, WxSize.new(185, 185))

    list = [ "ABS", "Airbag", "Air conditioning" ]

    @m_pRadioBox = WxRadioBox.new(self, ID_RADIOBOX, " Car options ", WxDefaultPosition, WxDefaultSize, list ,1, WxRA_SPECIFY_COLS)

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    radioboxSizer = WxBoxSizer.new(WxVERTICAL)
    radioboxSizer.Add(@m_pRadioBox, 1, WxGROW)
    dlgSizer.Add(radioboxSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_RADIOBOX(self,ID_RADIOBOX, "OnRadiobox")
    EVT_CLOSE(self,"OnClose")
  end

  def OnRadiobox(event)
    selection = @m_pRadioBox.GetStringSelection
    WxMessageBox("You selected " + selection)
  end

  def OnClose(event)
     Destroy()
  end
end


class WxRbApp < WxApp
  def OnInit
    dlg = RadioBoxDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

