
require 'wx'
include Wx

ID_LISTBOX = 1000

class ListBoxDlg < WxDialog
  def initialize
    super(nil, -1, "ListboxDialog", WxDefaultPosition, WxSize.new(185, 185))

    list = [ "ABS", "Airbag", "Air conditioning" ]

    @m_pListBox = WxListBox.new(self, ID_LISTBOX, WxDefaultPosition, WxDefaultSize, list)

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    listboxSizer = WxBoxSizer.new(WxVERTICAL)
    listboxSizer.Add(@m_pListBox, 1, WxGROW)
    dlgSizer.Add(listboxSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_LISTBOX_DCLICK(self,ID_LISTBOX, "OnListboxDClick")
    EVT_CLOSE(self,"OnClose")
  end

  def OnListboxDClick(event)
    selection = @m_pListBox.GetStringSelection
    WxMessageBox("You double clicked on " + selection)
  end

  def OnClose(event)
     Destroy()
  end
end

class WxRbApp < WxApp
  def OnInit
    dlg = ListBoxDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

