
require 'wx'
include Wx

ConfTest_Quit = 0
ConfTest_About = 1
ConfTest_Delete = 2

class MyFrame < WxFrame

    def initialize
        super(nil, -1, "WxConfig Demo")

        # menu
        file_menu = WxMenu.new

        file_menu.Append(ConfTest_Delete, "&Delete", "Delete config file")
        file_menu.AppendSeparator()
        file_menu.Append(ConfTest_About, "&About\tF1", "About this sample")
        file_menu.AppendSeparator()
        file_menu.Append(ConfTest_Quit, "E&xit\tAlt-X", "Exit the program")
        menu_bar = WxMenuBar.new
        menu_bar.Append(file_menu, "&File")
        SetMenuBar(menu_bar)

        CreateStatusBar()

        # child controls
        panel = WxPanel.new(self)
        WxStaticText.new(panel, -1, "These controls remember their values!",
                             WxPoint.new(10, 10), WxSize.new(300, 20))
        @m_text = WxTextCtrl.new(panel, -1, "", WxPoint.new(10, 40), WxSize.new(300, 20))
        @m_check = WxCheckBox.new(panel, -1, "show welcome message box at startup",
                               WxPoint.new(10, 70), WxSize.new(300, 20))

        # restore the control's values from the config

        # NB: in this program, the config object is already created at this moment
        # because we had called Get() from MyApp::OnInit(). However, if you later
        # change the code and don't create it before this line, it won't break
        # anything - unlike if you manually create WxConfig object with Create()
        # or in any other way (then you must be sure to create it before using it!).
        pConfig = WxConfigBase::Get()
        # we could write Read("/Controls/Text") as well, it's just to show SetPath()
        pConfig.SetPath("/Controls")

        @m_text.SetValue(pConfig.Read("Text", ""))
        @m_check.SetValue(pConfig.ReadBool("Check", TRUE))

        # SetPath() understands ".."
        pConfig.SetPath("../MainFrame")

        # restore frame position and size
        x = pConfig.ReadInt("x", 50)
        y = pConfig.ReadInt("y", 50)
        w = pConfig.ReadInt("w", 350)
        h = pConfig.ReadInt("h", 200)
        Move(x, y)
        SetClientSize(w, h)

        pConfig.SetPath("/")
        s = pConfig.Read("TestValue")
        if s!=""
          WxLogStatus(self, "TestValue from config is '%s'", s)
        else
          WxLogStatus(self, "TestValue not found in the config")
        end


        EVT_MENU(self,ConfTest_Quit, "OnQuit")
        EVT_MENU(self,ConfTest_About, "OnAbout")
        EVT_MENU(self,ConfTest_Delete, "OnDelete")
        EVT_CLOSE(self,"OnClose")
    end

    def OnClose(event)
        pConfig = WxConfigBase::Get()
        if pConfig != nil
            # save the control's values to the config
            pConfig.Write("/Controls/Text", @m_text.GetValue())
            pConfig.Write("/Controls/Check", @m_check.GetValue())

            # save the frame position
            w,h = GetClientSize()
            x,y = GetPositionXY()
            pConfig.Write("/MainFrame/x", x)
            pConfig.Write("/MainFrame/y", y)
            pConfig.Write("/MainFrame/w", w)
            pConfig.Write("/MainFrame/h", h)

            pConfig.Write("/TestValue", "A test value")

        end
        Destroy()
    end

    def OnQuit(event)
        Close(TRUE)
    end

    def OnAbout(event)
        WxMessageBox("WxConfig demo\n 1998-2001 Vadim Zeitlin", "About",
                   WxICON_INFORMATION | WxOK)
    end

    def OnDelete(event)
        pConfig = WxConfigBase::Get()
        if pConfig == nil
            WxLogError("No config to delete!")
            return nil
        end

        if pConfig.DeleteAll()
            WxLogMessage("Config file/registry key successfully deleted.")

            WxConfigBase::Set(nil).free
            WxConfigBase::DontCreateOnDemand()
        else
            WxLogError("Deleting config file/registry key failed.")
        end
    end
end

class MyApp < WxApp
    def OnInit()

        # we're using WxConfig's "create-on-demand" feature: it will create the
        # config object when it's used for the first time. It has a number of
        # advantages compared with explicitly creating our WxConfig:
        #  1) we don't pay for it if we don't use it
        #  2) there is no danger to create it twice

        # application and vendor name are used by WxConfig to construct the name
        # of the config file/registry key and must be set before the first call
        # to Get() if you want to override the default values (the application
        # name is the name of the executable and the vendor name is the same)
        SetVendorName("WxWindows")
        SetAppName("conftest") # not needed, it's the default value

        pConfig = WxConfigBase::Get()
        # uncomment this to force writing back of the defaults for all values
        # if they're not present in the config - this can give the user an idea
        # of all possible settings for this program
        pConfig.SetRecordDefaults()

        WxConfigBase::Set(nil)
        # or you could also write something like this:
        #  WxFileConfig *pConfig = new WxFileConfig("conftest")
        #  WxConfigBase::Set(pConfig)
        # where you can also specify the file names explicitly if you wish.
        # Of course, calling Set() is optional and you only must do it if
        # you want to later retrieve this pointer with Get().

        # create the main program window
        frame = MyFrame.new
        frame.Show(TRUE)
        SetTopWindow(frame)

        # use our config object...
        if pConfig.ReadBool("/Controls/Check", TRUE)
            WxMessageBox("You can disable this message box by unchecking\n" +
                       "the checkbox in the main window (of course, a real\n" +
                       "program would have a checkbox right here but we\n" +
                     "keep it simple)", "Welcome to WxConfig demo",
                     WxICON_INFORMATION | WxOK)
        end

        return TRUE
    end
end


a = MyApp.new
a.MainLoop()

