
require 'wx'
include Wx

Menu_About = 100
Menu_Quit = 101
Menu_Selection = 102

Control_First = 1000
Control_Listbox = 1001
Btn_Up = 1002
Btn_Down = 1003

# Define a new frame type
class CheckListBoxFrame < WxFrame

    def initialize(frame,title,x,y,w,h)
        super(frame, -1, title, WxPoint.new(x, y), WxSize.new(w, h))

        # create the status line
        widths =  [-1, 60]
        CreateStatusBar(2)
        SetStatusWidths(widths)
        WxLogStatus(self, "no selection")

        # Make a menubar
        # --------------

        # file submenu
        menuFile = WxMenu.new
        menuFile.Append(Menu_About, "&About...\tF1")
        menuFile.AppendSeparator()
        menuFile.Append(Menu_Quit, "E&xit\tAlt-X")

        # listbox submenu
        menuList = WxMenu.new
        menuList.AppendCheckItem(Menu_Selection, "Multiple selection\tCtrl-M")

        # put it all together
        menu_bar = WxMenuBar.new
        menu_bar.Append(menuFile, "&File")
        menu_bar.Append(menuList, "&List")
        SetMenuBar(menu_bar)

        # make a panel with some controls
        @m_panel = WxPanel.new(self, -1, WxPoint.new(0, 0),
                              WxSize.new(400, 200), WxTAB_TRAVERSAL)

        CreateCheckListbox()

        # create buttons for moving the items around
        button1 = WxButton.new(@m_panel, Btn_Up, "   &Up  ", WxPoint.new(420, 90))
        button2 = WxButton.new(@m_panel, Btn_Down, "&Down", WxPoint.new(420, 120))


        mainsizer = WxBoxSizer.new( WxVERTICAL )

        mainsizer.Add( @m_pListBox, 1, WxGROW|WxALL, 10 )

        bottomsizer = WxBoxSizer.new( WxHORIZONTAL )

        bottomsizer.Add( button1, 0, WxALL, 10 )
        bottomsizer.Add( button2, 0, WxALL, 10 )

        mainsizer.Add( bottomsizer, 0, WxCENTER )

        # tell frame to make use of sizer (or constraints, if any)
        @m_panel.SetAutoLayout( TRUE )
        @m_panel.SetSizer( mainsizer )

        # don't allow frame to get smaller than what the sizers tell ye
        mainsizer.SetSizeHints( self )

        Show(TRUE)

        EVT_MENU(self,Menu_About, "OnAbout")
        EVT_MENU(self,Menu_Quit, "OnQuit")

        EVT_MENU(self,Menu_Selection, "OnToggleSelection")

        EVT_LISTBOX(self,Control_Listbox, "OnListboxSelect")
        EVT_CHECKLISTBOX(self,Control_Listbox, "OnCheckboxToggle")
        EVT_LISTBOX_DCLICK(self,Control_Listbox, "OnListboxDblClick")

        EVT_BUTTON(self,Btn_Up, "OnButtonUp")
        EVT_BUTTON(self,Btn_Down, "OnButtonDown")

    end

    def CreateCheckListbox(flags = 0)

        # check list box
        aszChoices = [
            "Zeroth",
            "First", "Second", "Third",
            "Fourth", "Fifth", "Sixth",
            "Seventh", "Eighth", "Nineth"]

        @m_pListBox = WxCheckListBox.new(
             @m_panel,              # parent
             Control_Listbox,       # control id
             WxPoint.new(10, 10),   # listbox poistion
             WxSize.new(400, 100),  # listbox size
             aszChoices,            # array of strings
             flags
            )

        #@m_pListBox.SetBackgroundColour(WxGREEN)

        # set grey background for every second entry
        0.step(aszChoices.length-1,2) { |ui|
            AdjustColour(ui)
        }

        @m_pListBox.Check(2)
        @m_pListBox.Select(3)
    end

    def OnQuit(event)
        Close(TRUE)
    end

    def OnAbout(event)
        WxMessageBox("Demo of WxCheckListBox control\n Vadim Zeitlin 1998-2002",
                     "About WxCheckListBox",
                     WxICON_INFORMATION, self)
    end

    def OnToggleSelection(event)

        sizer = @m_panel.GetSizer()

        sizer.Remove(@m_pListBox)
        @m_pListBox.free

        CreateCheckListbox(event.IsChecked() ? WxLB_EXTENDED : 0)

        sizer.Insert(0, @m_pListBox, 1, WxGROW | WxALL, 10)

        @m_panel.Layout()
    end

    def OnListboxSelect(event)
        nSel = event.GetSelection()
        WxLogStatus(self, "Item %d selected (%schecked)", nSel,
                          @m_pListBox.IsChecked(nSel) ? "" : "not ")
    end

    def OnListboxDblClick(event)
        strSelection = sprintf("Item %d double clicked", @m_pListBox.GetSelection())
        dialog = WxMessageDialog.new(self, strSelection, "WxCheckListBox message", WxICON_INFORMATION)
        dialog.ShowModal()
    end

    def OnCheckboxToggle(event)
        nItem = event.GetInt()
        WxLogStatus(self, "item %d was %schecked", nItem,
                          @m_pListBox.IsChecked(nItem) ? "" : "un")
    end

    def OnButtonUp(event)
        OnButtonMove(TRUE)
    end

    def OnButtonDown(event)
        OnButtonMove(FALSE)
    end

    def OnButtonMove(up)
        selection = @m_pListBox.GetSelection()
        if selection != -1
            label = @m_pListBox.GetString(selection)
            positionNew = up ? selection - 1 : selection + 2
            if positionNew < 0 || positionNew > @m_pListBox.GetCount()
                WxLogStatus(self, "Can't move self item %s", up ? "up" : "down")
            else
                wasChecked = @m_pListBox.IsChecked(selection)
                positionOld = up ? selection + 1 : selection

                # insert the item
                @m_pListBox.InsertItems([label], positionNew)

                # and delete the old one
                @m_pListBox.Delete(positionOld)

                selectionNew = up ? positionNew : positionNew - 1
                @m_pListBox.Check(selectionNew, wasChecked)
                @m_pListBox.SetSelection(selectionNew)

                AdjustColour(selection)
                AdjustColour(selectionNew)

                WxLogStatus(self, "Item moved %s", up ? "up" : "down")
            end
        else
            WxLogStatus(self, "Please select an item")
        end
    end

    def AdjustColour(index)
        # not implemented in ports other than (native) MSW yet
        if WxRUBY_PLATFORM == "WXMSW"
            # even items have grey backround, odd ones - white
            c = (index % 2)!=0 ? 255 : 200
            @m_pListBox.GetItem(index).SetBackgroundColour(WxColour.new(c, c, c))
        end
    end
end


# init our app: create windows
class CheckListBoxApp < WxApp
    def OnInit()
        pFrame = CheckListBoxFrame.new(
                                     nil,
                                     "WxWindows Checklistbox Sample",
                                     50, 50, 480, 320
                                    )
        SetTopWindow(pFrame)
    end
end

a = CheckListBoxApp.new
a.MainLoop()


