require 'wx'
include Wx


Calendar_File_About = 100
Calendar_File_Quit = 101
Calendar_Cal_Monday = 200
Calendar_Cal_Holidays = 201
Calendar_Cal_Special = 202
Calendar_Cal_Month = 203
Calendar_Cal_Year = 204
Calendar_Cal_SeqMonth = 205
Calendar_Cal_SurroundWeeks = 206
Calendar_CalCtrl = 1000


class MyPanel < WxPanel
    def initialize(frame)
        super(frame, -1)

        SetAutoLayout(TRUE)

        date = sprintf("Selected date: %s",
                    WxDateTime::Today().FormatISODate())
        @m_date = WxStaticText.new(self, -1, date)
        @m_calendar = WxCalendarCtrl.new(self, Calendar_CalCtrl,
                                        WxDefaultDateTime,
                                        WxDefaultPosition,
                                        WxDefaultSize,
                                        WxCAL_MONDAY_FIRST |
                                        WxCAL_SHOW_HOLIDAYS |
                                        WxRAISED_BORDER)

        c = WxLayoutConstraints.new
        c.left.SameAs(self, WxLeft, 10)
        c.centreY.SameAs(self, WxCentreY)
        c.height.AsIs()
        c.width.AsIs()

        @m_date.SetConstraints(c)

        c = WxLayoutConstraints.new
        c.left.SameAs(@m_date, WxRight, 20)
        c.centreY.SameAs(self, WxCentreY)
        c.height.AsIs()
        c.width.AsIs()

        @m_calendar.SetConstraints(c)


        EVT_CALENDAR            (self,Calendar_CalCtrl,   "OnCalendar")
        EVT_CALENDAR_MONTH      (self,Calendar_CalCtrl,   "OnCalMonthChange")
        EVT_CALENDAR_YEAR       (self,Calendar_CalCtrl,   "OnCalYearChange")
        EVT_CALENDAR_SEL_CHANGED(self,Calendar_CalCtrl,   "OnCalendarChange")
        EVT_CALENDAR_WEEKDAY_CLICKED(self,Calendar_CalCtrl, "OnCalendarWeekDayClick")

    end

    def OnCalendar(event)
        WxLogMessage("Selected %s from calendar",
                     event.GetDate().FormatISODate())
    end

    def OnCalendarChange(event)
        s = sprintf("Selected date: %s", event.GetDate().FormatISODate())
        @m_date.SetLabel(s)
    end

    def OnCalMonthChange(event)
        WxLogStatus("Calendar month changed")
    end

    def OnCalYearChange(event)
        WxLogStatus("Calendar year changed")
    end

    def OnCalendarWeekDayClick(event)
        WxLogMessage("Clicked on %s",
                     WxDateTime::GetWeekDayName(event.GetWeekDay()))
    end

    def ToggleCalStyle(on,flag)
        style = @m_calendar.GetWindowStyle()
        if  on
            style |= flag
        else
            style &= ~flag
        end
        @m_calendar.SetWindowStyle(style)
        @m_calendar.Refresh()
    end

    def HighlightSpecial(on)
        if on
            attrRedCircle = WxCalendarDateAttr.new(WxCAL_BORDER_ROUND, WxRED)
            attrGreenSquare = WxCalendarDateAttr.new(WxCAL_BORDER_SQUARE, WxGREEN)
            attrHeaderLike = WxCalendarDateAttr.new(WxBLUE, WxLIGHT_GREY)

            @m_calendar.SetAttr(17, attrRedCircle)
            @m_calendar.SetAttr(29, attrGreenSquare)
            @m_calendar.SetAttr(13, attrHeaderLike)
        else
            @m_calendar.ResetAttr(17)
            @m_calendar.ResetAttr(29)
            @m_calendar.ResetAttr(13)
        end
        @m_calendar.Refresh()
    end

    def GetCal()
        @m_calendar
    end

end

class MyFrame < WxFrame
    def initialize(title,pos,size)
        super(nil, -1, title, pos, size)
        # create a menu bar
        menuFile = WxMenu.new

        menuFile.Append(Calendar_File_About, "&About...\tCtrl-A", "Show about dialog")
        menuFile.AppendSeparator()
        menuFile.Append(Calendar_File_Quit, "E&xit\tAlt-X", "Quit self program")

        menuCal = WxMenu.new
        menuCal.Append(Calendar_Cal_Monday,
                        "Monday &first weekday\tCtrl-F",
                        "Toggle between Mon and Sun as the first week day",
                        WxITEM_CHECK)
        menuCal.Append(Calendar_Cal_Holidays, "Show &holidays\tCtrl-H",
                        "Toggle highlighting the holidays",
                        WxITEM_CHECK)
        menuCal.Append(Calendar_Cal_Special, "Highlight &special dates\tCtrl-S",
                        "Test custom highlighting",
                        WxITEM_CHECK)
        menuCal.Append(Calendar_Cal_SurroundWeeks,
                        "Show s&urrounding weeks\tCtrl-W",
                        "Show the neighbouring weeks in the prev/next month",
                        WxITEM_CHECK)
        menuCal.AppendSeparator()
        menuCal.Append(Calendar_Cal_SeqMonth,
                        "To&ggle month selector style\tCtrl-G",
                        "Use another style for the calendar controls",
                        WxITEM_CHECK)
        menuCal.Append(Calendar_Cal_Month, "&Month can be changed\tCtrl-M",
                        "Allow changing the month in the calendar",
                        WxITEM_CHECK)
        menuCal.Append(Calendar_Cal_Year, "&Year can be changed\tCtrl-Y",
                        "Allow changing the year in the calendar",
                        WxITEM_CHECK)

        # now append the freshly created menu to the menu bar...
        menuBar = WxMenuBar.new
        menuBar.Append(menuFile, "&File")
        menuBar.Append(menuCal, "&Calendar")

        menuBar.Check(Calendar_Cal_Monday, TRUE)
        menuBar.Check(Calendar_Cal_Holidays, TRUE)
        menuBar.Check(Calendar_Cal_Month, TRUE)
        menuBar.Check(Calendar_Cal_Year, TRUE)

        # ... and attach self menu bar to the frame
        SetMenuBar(menuBar)


        @m_panel = MyPanel.new(self)

        # create a status bar just for fun (by default with 1 pane only)
        CreateStatusBar(2)
        SetStatusText("Welcome to WxWindows!")

    	EVT_MENU(self,Calendar_File_Quit,  "OnQuit")
    	EVT_MENU(self,Calendar_File_About, "OnAbout")

    	EVT_MENU(self,Calendar_Cal_Monday, "OnCalMonday")
    	EVT_MENU(self,Calendar_Cal_Holidays, "OnCalHolidays")
    	EVT_MENU(self,Calendar_Cal_Special, "OnCalSpecial")

    	EVT_MENU(self,Calendar_Cal_Month, "OnCalAllowMonth")
    	EVT_MENU(self,Calendar_Cal_Year, "OnCalAllowYear")

    	EVT_MENU(self,Calendar_Cal_SeqMonth, "OnCalSeqMonth")
    	EVT_MENU(self,Calendar_Cal_SurroundWeeks, "OnCalShowSurroundingWeeks")

    	EVT_UPDATE_UI(self,Calendar_Cal_Year, "OnAllowYearUpdate")

    end

    def OnQuit(event)
        # TRUE is to force the frame to close
        Close(TRUE)
    end

    def OnAbout(event)
        WxMessageBox("WxCalendarCtrl sample\n 2000 Vadim Zeitlin",
                 "About Calendar", WxOK | WxICON_INFORMATION, self)
    end

    def OnCalMonday(event)
        enable = GetMenuBar().IsChecked(event.GetId())
        @m_panel.ToggleCalStyle(enable, WxCAL_MONDAY_FIRST)
    end

    def OnCalHolidays(event)
        enable = GetMenuBar().IsChecked(event.GetId())
        @m_panel.GetCal().EnableHolidayDisplay(enable)
    end

	def OnCalSpecial(event)
        @m_panel.HighlightSpecial(GetMenuBar().IsChecked(event.GetId()))
    end

	def OnCalAllowMonth(event)
        allow = GetMenuBar().IsChecked(event.GetId())
        @m_panel.GetCal().EnableMonthChange(allow)
    end

	def OnCalAllowYear(event)
        allow = GetMenuBar().IsChecked(event.GetId())
        @m_panel.GetCal().EnableYearChange(allow)
    end

	def OnCalSeqMonth(event)
        allow = GetMenuBar().IsChecked(event.GetId())
        @m_panel.ToggleCalStyle(allow, WxCAL_SEQUENTIAL_MONTH_SELECTION)
    end

	def OnCalShowSurroundingWeeks(event)
        allow = GetMenuBar().IsChecked(event.GetId())
        @m_panel.ToggleCalStyle(allow, WxCAL_SHOW_SURROUNDING_WEEKS)
    end

	def OnAllowYearUpdate(event)
        event.Enable( GetMenuBar().IsChecked(Calendar_Cal_Month))
    end
end


class WxRbApp < WxApp
    def OnInit()
  	    frame = MyFrame.new("Calendar WxWindows sample", WxPoint.new(50, 50), WxSize.new(450, 340))
	    frame.Show(TRUE)
    end
end

a = WxRbApp.new
a.MainLoop()


