/**********************************************************************

  rect.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:48 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "rect.h"

VALUE
WxRect::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxRect::init(VALUE self,VALUE vx,VALUE vy,VALUE vwidth,VALUE vheight)
{
    int x = NUM2INT(vx);
    int y = NUM2INT(vy);
    int width = NUM2INT(vwidth);
    int height = NUM2INT(vheight);
    wxRect *ptr;
    Data_Get_Struct(self, wxRect, ptr);
    ptr = new wxRect(x,y,width,height);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxRect::x(VALUE self)
{
    wxRect *ptr;
    Data_Get_Struct(self, wxRect, ptr);
    return INT2NUM(ptr->x);
}

VALUE
WxRect::y(VALUE self)
{
    wxRect *ptr;
    Data_Get_Struct(self, wxRect, ptr);
    return INT2NUM(ptr->y);
}

VALUE
WxRect::width(VALUE self)
{
    wxRect *ptr;
    Data_Get_Struct(self, wxRect, ptr);
    return INT2NUM(ptr->width);
}

VALUE
WxRect::height(VALUE self)
{
    wxRect *ptr;
    Data_Get_Struct(self, wxRect, ptr);
    return INT2NUM(ptr->height);
}

VALUE
WxRect::init0(const wxRect &rect)
{
    extern VALUE rb_cWxRect;
    VALUE self = Data_Wrap_Struct(rb_cWxRect, 0, 0, 0);
    DATA_PTR(self) = new wxRect(rect);
    return self;
}
