/**********************************************************************

  menu.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:48 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "menu.h"

VALUE
WxMenu::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxMenu::init(int argc, VALUE *argv, VALUE self)
{
    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    if(argc==0) {
        ptr = new wxMenu();
    } else if(TYPE(argv[0])==T_STRING) {
        wxString title = StringValuePtr(argv[0]);
        long style = 0;
        if(argc>1) style = NUM2INT(argv[1]);
        ptr = new wxMenu(title,style);
    } else {
        long style = NUM2INT(argv[1]);
        ptr = new wxMenu(style);
    }

    DATA_PTR(self) = ptr;

    return self;
}


void WxMenu::Append(int argc, VALUE *argv, VALUE self)
{
    int id = NUM2INT(argv[0]);
    wxString item = StringValuePtr(argv[1]);
    wxString helpString = "";
    if(argc>2)
      helpString = StringValuePtr(argv[2]);
    wxItemKind kind = wxITEM_NORMAL;
    if(argc>3) kind = (wxItemKind)NUM2INT(argv[3]);

    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    ptr->Append(id,item,helpString,kind);
}

void WxMenu::AppendCheckItem(int argc, VALUE *argv, VALUE self)
{
    int id = NUM2INT(argv[0]);
    wxString item = StringValuePtr(argv[1]);
    wxString helpString = "";
    if(argc>2)
      helpString = StringValuePtr(argv[2]);
    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    ptr->AppendCheckItem(id,item,helpString);
}

void WxMenu::AppendRadioItem(int argc, VALUE *argv, VALUE self)
{
    int id = NUM2INT(argv[0]);
    wxString item = StringValuePtr(argv[1]);
    wxString helpString = "";
    if(argc>2)
      helpString = StringValuePtr(argv[2]);
    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    ptr->AppendRadioItem(id,item,helpString);
}

void WxMenu::AppendSeparator(VALUE self)
{
    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    ptr->AppendSeparator();
}

void WxMenu::Check(VALUE self,VALUE vid,VALUE vcheck)
{
    int id = NUM2INT(vid);
    bool check = (vcheck == Qtrue);
    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    ptr->Check(id,check);
}

void WxMenu::Enable(VALUE self,VALUE vid,VALUE venable)
{
    int id = NUM2INT(vid);
    bool enable = (venable == Qtrue);
    wxMenu *ptr;
    Data_Get_Struct(self, wxMenu, ptr);
    ptr->Enable(id,enable);
}




