/**********************************************************************

  fontdialog.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "wx/fontdlg.h"
#include "fontdata.h"
#include "fontdialog.h"

VALUE
WxFontDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFontDialog::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    wxFontData *data;
    if(argc>0 && TYPE(argv[0])==T_DATA) {
      Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_DATA) {
      Data_Get_Struct(argv[1], wxFontData, data);
    }
    wxFontDialog *ptr;
    Data_Get_Struct(self, wxFontDialog, ptr);
    if(argc==1)
      ptr = new wxFontDialog(parent);
    else if(argc==2)
      ptr = new wxFontDialog(parent,*data);
    else
      ptr = new wxFontDialog();
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxFontDialog::ShowModal(VALUE self)
{
    wxFontDialog *ptr;
    Data_Get_Struct(self, wxFontDialog, ptr);
    return INT2NUM(ptr->ShowModal());
}


VALUE
WxFontDialog::GetFontData(VALUE self)
{
    wxFontDialog *ptr;
    Data_Get_Struct(self, wxFontDialog, ptr);
    return WxFontData::init0(ptr->GetFontData());
}
