require 'mkmf'

$objs = ["wx.o","app.o","bitmap.o","button.o","calendar.o","checkbox.o","choice.o","colour.o","colourdata.o",
"colourdialog.o","combobox.o","const.o","date.o","dialog.o","dirdialog.o","event.o","evthandler.o","filedialog.o",
"font.o","fontdata.o","fontdialog.o","frame.o","gauge.o","layout.o","listbox.o","menu.o","menubar.o",
"messagedialog.o","point.o","radio.o","rect.o","size.o","sizer.o","slider.o","spin.o","statictext.o","textctrl.o",
"timer.o","validator.o","window.o","icon.o","artprovider.o","log.o","listctrl.o","list.o","panel.o","scrolledwindow.o",
"dc.o","brush.o","pen.o","caret.o","statusbar.o","ownerdrawn.o","config.o","region.o","cursor.o","notebook.o",
"tooltip.o","mask.o","socket.o","url.o","stream.o","toolbar.o","image.o","palette.o","treectrl.o"]

if /linux/ =~ RUBY_PLATFORM
    CONFIG['CC'] = `wx-config --cxx`
    CONFIG['LDSHARED'].gsub!("gcc",`wx-config --cxx`.strip)
    $CFLAGS += " `wx-config --cxxflags`"
    $LDFLAGS += " `wx-config --libs` -Wl,--version-script,./version-script "
elsif have_header("windows.h") and have_library("kernel32")
    $WXDIR=ENV['WXWIN']
    $WXVERSION = '240'
    $WXSRC="#$WXDIR/src/msw"
    $WXINC="#$WXDIR/include"
    $INCTEMP="#$WXDIR/lib/mswdll"
    $WXLIB="#$WXDIR/lib/wxmsw#$WXVERSION.lib"
    $CFLAGS += " -I#$WXINC -I#$INCTEMP #$WINFLAGS #$EXTRADLLFLAGS -DSTRICT -DWIN32 -D__WIN32__ -D_WINDOWS -DWINVER=0x0400 /D__WIN95__ /D__WXMSW__ /DWXUSINGDLL=1 /D__WINDOWS__ -D__WXMSW__  "
    $libs += " #$WXLIB"
    $objs.push("wx.res")

end

create_makefile("wx")

if $WXDIR
    File.open("Makefile","a+") {|f|
        f.print "
wx.res : wx.rc
\trc -I#$WXINC wx.rc
"
    }
end

