/**********************************************************************

  evthandler.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "wx/tglbtn.h"
#include "wx/notebook.h"
#include "wx/process.h"
#include "wx/splitter.h"
#include "wx/listctrl.h"
#include "wx/fdrepdlg.h"
#include "wx/socket.h"
#ifdef __WXMSW__
#include "wx/msw/taskbar.h"
#endif
#if wxUSE_SASH
#include "wx/generic/laywin.h"
#endif
#include "calendar.h"
#include "evthandler.h"
#include "treectrl.h"

IMPLEMENT_ABSTRACT_CLASS(wxRbCallback, wxObject);

wxRbCallback::wxRbCallback(char *func,VALUE klass) {
    m_func = func;
    m_self = klass;
}

wxRbCallback::wxRbCallback(const wxRbCallback &other) {
    m_func = other.m_func;
    m_self = other.m_self;
}

void wxRbCallback::EventThunker(wxEvent &event) {
    extern VALUE rb_cWxKeyEvent;
    extern VALUE rb_cWxCloseEvent;
    extern VALUE rb_cWxCalendarEvent;
    extern VALUE rb_cWxCommandEvent;
    extern VALUE rb_cWxListEvent;
    extern VALUE rb_cWxTreeEvent;
    extern VALUE rb_cWxUpdateUIEvent;
    extern VALUE rb_cWxSizeEvent;
    extern VALUE rb_cWxMoveEvent;
    extern VALUE rb_cWxPaintEvent;
    extern VALUE rb_cWxNotebookEvent;
    extern VALUE rb_cWxFindDialogEvent;
    extern VALUE rb_cWxSpinEvent;
    extern VALUE rb_cWxSocketEvent;
    extern VALUE rb_cWxSplitterEvent;
    extern VALUE rb_cWxEvent;
    wxRbCallback *cb = (wxRbCallback *)event.m_callbackUserData;
    wxClassInfo *ci = event.GetClassInfo();
    const wxChar *classname = ci->GetClassName();
    static VALUE vevent;
    int eventType = event.GetEventType();
    if(eventType==wxEVT_CHAR || eventType==wxEVT_CHAR_HOOK || eventType==wxEVT_KEY_DOWN || eventType==wxEVT_KEY_UP) {
	  vevent = Data_Wrap_Struct(rb_cWxKeyEvent, 0, 0, 0);
    } else if(eventType==wxEVT_CLOSE_WINDOW || eventType==wxEVT_END_SESSION || eventType==wxEVT_QUERY_END_SESSION) {
	  vevent = Data_Wrap_Struct(rb_cWxCloseEvent, 0, 0, 0);
    } else if(eventType==wxEVT_CALENDAR_DOUBLECLICKED||eventType==wxEVT_CALENDAR_SEL_CHANGED||eventType==wxEVT_CALENDAR_DAY_CHANGED||eventType==wxEVT_CALENDAR_MONTH_CHANGED||eventType==wxEVT_CALENDAR_YEAR_CHANGED||eventType==wxEVT_CALENDAR_WEEKDAY_CLICKED) {
	  vevent = Data_Wrap_Struct(rb_cWxCalendarEvent, 0, 0, 0);
    } else if(eventType==wxEVT_COMMAND_BUTTON_CLICKED||
    eventType==wxEVT_COMMAND_CHECKBOX_CLICKED||
    eventType==wxEVT_COMMAND_CHOICE_SELECTED||
    eventType==wxEVT_COMMAND_LISTBOX_SELECTED||
    eventType==wxEVT_COMMAND_LISTBOX_DOUBLECLICKED||
    eventType==wxEVT_COMMAND_TEXT_UPDATED||
    eventType==wxEVT_COMMAND_TEXT_ENTER||
    eventType==wxEVT_COMMAND_MENU_SELECTED||
    eventType==wxEVT_COMMAND_SLIDER_UPDATED||
    eventType==wxEVT_COMMAND_RADIOBOX_SELECTED||
    eventType==wxEVT_COMMAND_RADIOBUTTON_SELECTED||
    eventType==wxEVT_COMMAND_SCROLLBAR_UPDATED||
    eventType==wxEVT_COMMAND_VLBOX_SELECTED||
    eventType==wxEVT_COMMAND_COMBOBOX_SELECTED||

    eventType==wxEVT_COMMAND_TOOL_CLICKED||
    eventType==wxEVT_COMMAND_TOOL_RCLICKED||
    eventType==wxEVT_COMMAND_TOOL_ENTER||

    eventType==wxEVT_COMMAND_TOGGLEBUTTON_CLICKED||
    eventType==wxEVT_COMMAND_CHECKLISTBOX_TOGGLED ) {
	  vevent = Data_Wrap_Struct(rb_cWxCommandEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_COMMAND_LIST_BEGIN_DRAG||
    eventType==wxEVT_COMMAND_LIST_BEGIN_RDRAG||
    eventType==wxEVT_COMMAND_LIST_BEGIN_LABEL_EDIT||
    eventType==wxEVT_COMMAND_LIST_END_LABEL_EDIT||
    eventType==wxEVT_COMMAND_LIST_DELETE_ITEM||
    eventType==wxEVT_COMMAND_LIST_DELETE_ALL_ITEMS||
    eventType==wxEVT_COMMAND_LIST_GET_INFO||
    eventType==wxEVT_COMMAND_LIST_SET_INFO||
    eventType==wxEVT_COMMAND_LIST_ITEM_SELECTED||
    eventType==wxEVT_COMMAND_LIST_ITEM_DESELECTED||
    eventType==wxEVT_COMMAND_LIST_KEY_DOWN||
    eventType==wxEVT_COMMAND_LIST_INSERT_ITEM||
    eventType==wxEVT_COMMAND_LIST_COL_CLICK||
    eventType==wxEVT_COMMAND_LIST_ITEM_RIGHT_CLICK||
    eventType==wxEVT_COMMAND_LIST_ITEM_MIDDLE_CLICK||
    eventType==wxEVT_COMMAND_LIST_ITEM_ACTIVATED||
    eventType==wxEVT_COMMAND_LIST_CACHE_HINT||
    eventType==wxEVT_COMMAND_LIST_COL_RIGHT_CLICK||
    eventType==wxEVT_COMMAND_LIST_COL_BEGIN_DRAG||
    eventType==wxEVT_COMMAND_LIST_COL_DRAGGING||
    eventType==wxEVT_COMMAND_LIST_COL_END_DRAG||
    eventType==wxEVT_COMMAND_LIST_ITEM_FOCUSED) {
	  vevent = Data_Wrap_Struct(rb_cWxListEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_COMMAND_TREE_BEGIN_DRAG||
    eventType==wxEVT_COMMAND_TREE_BEGIN_RDRAG||
    eventType==wxEVT_COMMAND_TREE_BEGIN_LABEL_EDIT||
    eventType==wxEVT_COMMAND_TREE_END_LABEL_EDIT||
    eventType==wxEVT_COMMAND_TREE_DELETE_ITEM||
    eventType==wxEVT_COMMAND_TREE_GET_INFO||
    eventType==wxEVT_COMMAND_TREE_SET_INFO||
    eventType==wxEVT_COMMAND_TREE_ITEM_EXPANDED||
    eventType==wxEVT_COMMAND_TREE_ITEM_EXPANDING||
    eventType==wxEVT_COMMAND_TREE_ITEM_COLLAPSED||
    eventType==wxEVT_COMMAND_TREE_ITEM_COLLAPSING||
    eventType==wxEVT_COMMAND_TREE_SEL_CHANGED||
    eventType==wxEVT_COMMAND_TREE_SEL_CHANGING||
    eventType==wxEVT_COMMAND_TREE_KEY_DOWN||
    eventType==wxEVT_COMMAND_TREE_ITEM_ACTIVATED||
    eventType==wxEVT_COMMAND_TREE_ITEM_RIGHT_CLICK||
    eventType==wxEVT_COMMAND_TREE_ITEM_MIDDLE_CLICK||
    eventType==wxEVT_COMMAND_TREE_END_DRAG) {
        vevent = Data_Wrap_Struct(rb_cWxTreeEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_SOCKET) {
	  vevent = Data_Wrap_Struct(rb_cWxSocketEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_UPDATE_UI) {
	  vevent = Data_Wrap_Struct(rb_cWxUpdateUIEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_SIZE) {
	  vevent = Data_Wrap_Struct(rb_cWxSizeEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_MOVE) {
	  vevent = Data_Wrap_Struct(rb_cWxMoveEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_PAINT||
    eventType==wxEVT_NC_PAINT||
    eventType==wxEVT_PAINT_ICON
    ) {
	  vevent = Data_Wrap_Struct(rb_cWxPaintEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED||
    eventType==wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGING
    ) {
	  vevent = Data_Wrap_Struct(rb_cWxNotebookEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_SCROLL_LINEUP||
    eventType==wxEVT_SCROLL_LINEDOWN||
    eventType==wxEVT_SCROLL_THUMBTRACK||
    eventType==wxEVT_COMMAND_SPINCTRL_UPDATED
    ) {
	  vevent = Data_Wrap_Struct(rb_cWxSpinEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_COMMAND_SPLITTER_SASH_POS_CHANGED||
    eventType==wxEVT_COMMAND_SPLITTER_SASH_POS_CHANGING||
    eventType==wxEVT_COMMAND_SPLITTER_DOUBLECLICKED||
    eventType==wxEVT_COMMAND_SPLITTER_UNSPLIT
    ) {
	  vevent = Data_Wrap_Struct(rb_cWxSplitterEvent, 0, 0, 0);
    } else if(
    eventType==wxEVT_COMMAND_FIND||
    eventType==wxEVT_COMMAND_FIND_NEXT||
    eventType==wxEVT_COMMAND_FIND_REPLACE||
    eventType==wxEVT_COMMAND_FIND_REPLACE_ALL||
    eventType==wxEVT_COMMAND_FIND_CLOSE
    ) {
	  vevent = Data_Wrap_Struct(rb_cWxFindDialogEvent, 0, 0, 0);
    }
    else {
	  vevent = Data_Wrap_Struct(rb_cWxEvent, 0, 0, 0);
    }
    DATA_PTR(vevent) = &event;
    rb_funcall(cb->m_self,rb_intern(cb->m_func),1,vevent);
}

VALUE
WxEvtHandler::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxEvtHandler::init0(wxEvtHandler *handler)
{
    extern VALUE rb_cWxEvtHandler;
    VALUE self = Data_Wrap_Struct(rb_cWxEvtHandler, 0, 0, 0);
    DATA_PTR(self) = handler;
    return self;
}

void
WxEvtHandler::Connect(VALUE argv0,VALUE argv1,VALUE argv2,VALUE argv3,VALUE argv4)
{
    int id = NUM2INT(argv1);
    int lastId = NUM2INT(argv2);
    wxEventType eventType = argv3;
    char *func = RSTRING(argv4)->ptr;
    VALUE klass = argv0;
    wxObjectEventFunction function = (wxObjectEventFunction )&wxRbCallback::EventThunker;
    wxObject* userData = new wxRbCallback(func,klass);
    wxEvtHandler *ptr;
    Data_Get_Struct(argv0, wxEvtHandler, ptr);
    ptr->Connect(id,lastId,eventType,function,userData);
}

void
WxEvtHandler::AddPendingEvent(VALUE self,VALUE vevent)
{
    wxEvent *event;
    Data_Get_Struct(vevent, wxEvent, event);
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    ptr->AddPendingEvent(*event);
}

VALUE
WxEvtHandler::GetClientData(VALUE self)
{
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    void *data = ptr->GetClientData();
    if(data==NULL)
        return Qnil;
    else
        return rb_hash_aref((VALUE)data, rb_str_new2("data"));
}

VALUE
WxEvtHandler::GetEvtHandlerEnabled(VALUE self)
{
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    return (ptr->GetEvtHandlerEnabled() ? Qtrue : Qfalse);
}

VALUE
WxEvtHandler::GetNextHandler(VALUE self)
{
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    return WxEvtHandler::init0(ptr->GetNextHandler());
}

VALUE
WxEvtHandler::GetPreviousHandler(VALUE self)
{
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    return WxEvtHandler::init0(ptr->GetPreviousHandler());
}

VALUE
WxEvtHandler::ProcessEvent(VALUE self,VALUE vevent)
{
    wxEvent *event;
    Data_Get_Struct(vevent, wxEvent, event);
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    return (ptr->ProcessEvent(*event) ? Qtrue : Qfalse);
}

void
WxEvtHandler::SetClientData(VALUE self,VALUE vcdata)
{
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);

    void *data = ptr->GetClientData();
    VALUE vdata;
    if(data==NULL)
        vdata = rb_hash_new();
    else
        vdata = (VALUE)data;
    rb_hash_aset(vdata,rb_str_new2("data"),vcdata);

    ptr->SetClientData((void*)vdata);
}


void
WxEvtHandler::SetEvtHandlerEnabled(VALUE self,VALUE venabled)
{
    bool enabled = (venabled == Qtrue);
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    ptr->SetEvtHandlerEnabled(enabled);
}

void
WxEvtHandler::SetNextHandler(VALUE self,VALUE vhandler)
{
    wxEvtHandler* handler;
    Data_Get_Struct(vhandler, wxEvtHandler, handler);
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    ptr->SetNextHandler(handler);
}

void
WxEvtHandler::SetPreviousHandler(VALUE self,VALUE vhandler)
{
    wxEvtHandler* handler;
    Data_Get_Struct(vhandler, wxEvtHandler, handler);
    wxEvtHandler *ptr;
    Data_Get_Struct(self, wxEvtHandler, ptr);
    ptr->SetPreviousHandler(handler);
}


// Miscellaneous
void WxEvtHandler::WxRbEVT_SIZE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SIZE, func);
}
void WxEvtHandler::WxRbEVT_MOVE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MOVE, func);
}
void WxEvtHandler::WxRbEVT_CLOSE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CLOSE_WINDOW, func);
}
void WxEvtHandler::WxRbEVT_PAINT(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_PAINT, func);
}
void WxEvtHandler::WxRbEVT_ERASE_BACKGROUND(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_ERASE_BACKGROUND, func);
}
void WxEvtHandler::WxRbEVT_CHAR(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CHAR, func);
}
void WxEvtHandler::WxRbEVT_CHAR_HOOK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CHAR_HOOK, func);
}
void WxEvtHandler::WxRbEVT_KEY_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_KEY_DOWN, func);
}
void WxEvtHandler::WxRbEVT_KEY_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_KEY_UP, func);
}
void WxEvtHandler::WxRbEVT_MENU_HIGHLIGHT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_MENU_HIGHLIGHT, func);
}
void WxEvtHandler::WxRbEVT_MENU_HIGHLIGHT_ALL(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MENU_HIGHLIGHT, func);
}
void WxEvtHandler::WxRbEVT_SET_FOCUS(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SET_FOCUS, func);
}
void WxEvtHandler::WxRbEVT_KILL_FOCUS(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_KILL_FOCUS, func);
}
void WxEvtHandler::WxRbEVT_CHILD_FOCUS(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CHILD_FOCUS, func);
}
void WxEvtHandler::WxRbEVT_ACTIVATE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_ACTIVATE, func);
}
void WxEvtHandler::WxRbEVT_ACTIVATE_APP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_ACTIVATE_APP, func);
}
void WxEvtHandler::WxRbEVT_END_SESSION(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_END_SESSION, func);
}
void WxEvtHandler::WxRbEVT_QUERY_END_SESSION(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_QUERY_END_SESSION, func);
}
void WxEvtHandler::WxRbEVT_DROP_FILES(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_DROP_FILES, func);
}
void WxEvtHandler::WxRbEVT_INIT_DIALOG(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_INIT_DIALOG, func);
}
void WxEvtHandler::WxRbEVT_SYS_COLOUR_CHANGED(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SYS_COLOUR_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_SHOW(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SHOW, func);
}
void WxEvtHandler::WxRbEVT_MAXIMIZE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MAXIMIZE, func);
}
void WxEvtHandler::WxRbEVT_ICONIZE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_ICONIZE, func);
}
void WxEvtHandler::WxRbEVT_NAVIGATION_KEY(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_NAVIGATION_KEY, func);
}
void WxEvtHandler::WxRbEVT_PALETTE_CHANGED(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_PALETTE_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_QUERY_NEW_PALETTE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_QUERY_NEW_PALETTE, func);
}
void WxEvtHandler::WxRbEVT_WINDOW_CREATE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CREATE, func);
}
void WxEvtHandler::WxRbEVT_WINDOW_DESTROY(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_DESTROY, func);
}
void WxEvtHandler::WxRbEVT_IDLE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_IDLE, func);
}
void WxEvtHandler::WxRbEVT_UPDATE_UI(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_UPDATE_UI, func);
}
void WxEvtHandler::WxRbEVT_UPDATE_UI_RANGE(VALUE self,VALUE win,VALUE id,VALUE id2,VALUE func) {
    Connect(win,id, id2, wxEVT_UPDATE_UI, func);
}

// Mouse Events
void WxEvtHandler::WxRbEVT_LEFT_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEFT_DOWN, func);
}
void WxEvtHandler::WxRbEVT_LEFT_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEFT_UP, func);
}
void WxEvtHandler::WxRbEVT_MIDDLE_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MIDDLE_DOWN, func);
}
void WxEvtHandler::WxRbEVT_MIDDLE_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MIDDLE_UP, func);
}
void WxEvtHandler::WxRbEVT_RIGHT_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_RIGHT_DOWN, func);
}
void WxEvtHandler::WxRbEVT_RIGHT_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_RIGHT_UP, func);
}
void WxEvtHandler::WxRbEVT_MOTION(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MOTION, func);
}
void WxEvtHandler::WxRbEVT_LEFT_DCLICK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEFT_DCLICK, func);
}
void WxEvtHandler::WxRbEVT_MIDDLE_DCLICK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MIDDLE_DCLICK, func);
}
void WxEvtHandler::WxRbEVT_RIGHT_DCLICK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_RIGHT_DCLICK, func);
}
void WxEvtHandler::WxRbEVT_LEAVE_WINDOW(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEAVE_WINDOW, func);
}
void WxEvtHandler::WxRbEVT_ENTER_WINDOW(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_ENTER_WINDOW, func);
}
void WxEvtHandler::WxRbEVT_MOUSEWHEEL(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MOUSEWHEEL, func);
}
// all mouse events
void WxEvtHandler::WxRbEVT_MOUSE_EVENTS(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEFT_DOWN,     func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEFT_UP,       func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MIDDLE_DOWN,   func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MIDDLE_UP,     func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_RIGHT_DOWN,    func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_RIGHT_UP,      func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MOTION,        func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEFT_DCLICK,   func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_MIDDLE_DCLICK, func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_RIGHT_DCLICK,  func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_LEAVE_WINDOW,  func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_ENTER_WINDOW,  func);
}
// EVT_COMMAND
void WxEvtHandler::WxRbEVT_COMMAND(VALUE self,VALUE win,VALUE id,VALUE cmd,VALUE func) {
    Connect(win,id, INT2NUM(-1), cmd, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_RANGE(VALUE self,VALUE win,VALUE id1,VALUE id2,VALUE cmd,VALUE func) {
    Connect(win,id1, id2, cmd, func);
}

// Scrolling
void WxEvtHandler::WxRbEVT_SCROLL(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_TOP,       func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_BOTTOM,    func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_LINEUP,    func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_LINEDOWN,  func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_PAGEUP,    func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_PAGEDOWN,  func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_THUMBTRACK,func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_THUMBRELEASE,func);
}
void WxEvtHandler::WxRbEVT_SCROLL_TOP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_TOP, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_BOTTOM(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_BOTTOM, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_LINEUP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_LINEUP, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_LINEDOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_LINEDOWN, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_PAGEUP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_PAGEUP, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_PAGEDOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_PAGEDOWN, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_THUMBTRACK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_THUMBTRACK, func);
}
void WxEvtHandler::WxRbEVT_SCROLL_THUMBRELEASE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLL_THUMBRELEASE, func);
}

// Scrolling, with an id
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_TOP,       func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_BOTTOM,    func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_LINEUP,    func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_LINEDOWN,  func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_PAGEUP,    func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_PAGEDOWN,  func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_THUMBTRACK,func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_THUMBRELEASE,func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_TOP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_TOP, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_BOTTOM(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_BOTTOM, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_LINEUP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_LINEUP, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_LINEDOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_LINEDOWN, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_PAGEUP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_PAGEUP, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_PAGEDOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_PAGEDOWN, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_THUMBTRACK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_THUMBTRACK, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLL_THUMBRELEASE(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_THUMBRELEASE, func);
}


void WxEvtHandler::WxRbEVT_SCROLLWIN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_TOP,         func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_BOTTOM,      func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_LINEUP,      func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_LINEDOWN,    func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_PAGEUP,      func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_PAGEDOWN,    func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_THUMBTRACK,  func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_THUMBRELEASE,func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_TOP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_TOP, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_BOTTOM(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_BOTTOM, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_LINEUP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_LINEUP, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_LINEDOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_LINEDOWN, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_PAGEUP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_PAGEUP, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_PAGEDOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_PAGEDOWN, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_THUMBTRACK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_THUMBTRACK, func);
}
void WxEvtHandler::WxRbEVT_SCROLLWIN_THUMBRELEASE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_SCROLLWIN_THUMBRELEASE, func);
}

// Scrolling, with an id
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_TOP,         func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_BOTTOM,      func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_LINEUP,      func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_LINEDOWN,    func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_PAGEUP,      func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_PAGEDOWN,    func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_THUMBTRACK,  func);
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_THUMBRELEASE,func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_TOP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_TOP, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_BOTTOM(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_BOTTOM, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_LINEUP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_LINEUP, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_LINEDOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_LINEDOWN, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_PAGEUP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_PAGEUP, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_PAGEDOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_PAGEDOWN, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_THUMBTRACK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_THUMBTRACK, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SCROLLWIN_THUMBRELEASE(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLLWIN_THUMBRELEASE, func);
}

// Convenience commands
void WxEvtHandler::WxRbEVT_BUTTON(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_BUTTON_CLICKED, func);
}
void WxEvtHandler::WxRbEVT_CHECKBOX(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_CHECKBOX_CLICKED, func);
}
void WxEvtHandler::WxRbEVT_CHOICE(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_CHOICE_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_LISTBOX(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LISTBOX_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_LISTBOX_DCLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LISTBOX_DOUBLECLICKED, func);
}
void WxEvtHandler::WxRbEVT_TEXT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TEXT_UPDATED, func);
}
void WxEvtHandler::WxRbEVT_TEXT_ENTER(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TEXT_ENTER, func);
}
void WxEvtHandler::WxRbEVT_TEXT_URL(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TEXT_URL, func);
}
void WxEvtHandler::WxRbEVT_TEXT_MAXLEN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TEXT_MAXLEN, func);
}
void WxEvtHandler::WxRbEVT_MENU(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_MENU_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_MENU_RANGE(VALUE self,VALUE win,VALUE id1,VALUE id2,VALUE func) {
    Connect(win,id1, id2, wxEVT_COMMAND_MENU_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_SLIDER(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SLIDER_UPDATED, func);
}
void WxEvtHandler::WxRbEVT_RADIOBOX(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_RADIOBOX_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_RADIOBUTTON(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_RADIOBUTTON_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_VLBOX(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_VLBOX_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_COMBOBOX(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_COMBOBOX_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_TOOL(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TOOL_CLICKED, func);
}
void WxEvtHandler::WxRbEVT_TOOL_RANGE(VALUE self,VALUE win,VALUE id,VALUE id2,VALUE func) {
    Connect(win,id, id2, wxEVT_COMMAND_TOOL_CLICKED, func);
}
void WxEvtHandler::WxRbEVT_TOOL_RCLICKED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TOOL_RCLICKED, func);
}
void WxEvtHandler::WxRbEVT_TOOL_RCLICKED_RANGE(VALUE self,VALUE win,VALUE id,VALUE id2,VALUE func) {
    Connect(win,id, id2, wxEVT_COMMAND_TOOL_RCLICKED, func);
}
void WxEvtHandler::WxRbEVT_TOOL_ENTER(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TOOL_ENTER, func);
}
void WxEvtHandler::WxRbEVT_CHECKLISTBOX(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_CHECKLISTBOX_TOGGLED, func);
}
void WxEvtHandler::WxRbEVT_SPINCTRL(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SPINCTRL_UPDATED, func);
}


// Generic command events
void WxEvtHandler::WxRbEVT_COMMAND_LEFT_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LEFT_CLICK, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_LEFT_DCLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LEFT_DCLICK, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_RIGHT_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_RIGHT_CLICK, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_RIGHT_DCLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_RIGHT_DCLICK, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_SET_FOCUS(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SET_FOCUS, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_KILL_FOCUS(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_KILL_FOCUS, func);
}
void WxEvtHandler::WxRbEVT_COMMAND_ENTER(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_ENTER, func);
}

// wxNotebook events
void WxEvtHandler::WxRbEVT_NOTEBOOK_PAGE_CHANGED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_NOTEBOOK_PAGE_CHANGING(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGING, func);
}

// wxSpinButton
void WxEvtHandler::WxRbEVT_SPIN_UP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_LINEUP, func);
}
void WxEvtHandler::WxRbEVT_SPIN_DOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_LINEDOWN, func);
}
void WxEvtHandler::WxRbEVT_SPIN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SCROLL_THUMBTRACK,func);
}

#ifdef __WXMSW__
// wxTaskBarIcon
void WxEvtHandler::WxRbEVT_TASKBAR_MOVE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_MOVE, func);
}
void WxEvtHandler::WxRbEVT_TASKBAR_LEFT_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_LEFT_DOWN, func);
}
void WxEvtHandler::WxRbEVT_TASKBAR_LEFT_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_LEFT_UP, func);
}
void WxEvtHandler::WxRbEVT_TASKBAR_RIGHT_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_RIGHT_DOWN, func);
}
void WxEvtHandler::WxRbEVT_TASKBAR_RIGHT_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_RIGHT_UP, func);
}
void WxEvtHandler::WxRbEVT_TASKBAR_LEFT_DCLICK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_LEFT_DCLICK, func);
}
void WxEvtHandler::WxRbEVT_TASKBAR_RIGHT_DCLICK(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_TASKBAR_RIGHT_DCLICK, func);
}
#endif

#if wxUSE_SASH
// wxSashWindow
void WxEvtHandler::WxRbEVT_SASH_DRAGGED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SASH_DRAGGED, func);
}
void WxEvtHandler::WxRbEVT_SASH_DRAGGED_RANGE(VALUE self,VALUE win,VALUE id1,VALUE id2,VALUE func) {
    Connect(win,id1, id2, wxEVT_SASH_DRAGGED, func);
}
void WxEvtHandler::WxRbEVT_QUERY_LAYOUT_INFO(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_QUERY_LAYOUT_INFO, func);
}
void WxEvtHandler::WxRbEVT_CALCULATE_LAYOUT(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CALCULATE_LAYOUT, func);
}
#endif

//wxSplitterWindow
void WxEvtHandler::WxRbEVT_SPLITTER_SASH_POS_CHANGING(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SPLITTER_SASH_POS_CHANGING, func);
}
void WxEvtHandler::WxRbEVT_SPLITTER_SASH_POS_CHANGED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SPLITTER_SASH_POS_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_SPLITTER_UNSPLIT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SPLITTER_UNSPLIT, func);
}
void WxEvtHandler::WxRbEVT_SPLITTER_DOUBLECLICKED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_SPLITTER_DOUBLECLICKED, func);
}

// wxTimer
void WxEvtHandler::WxRbEVT_TIMER(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_TIMER, func);
}
// wxProcess
void WxEvtHandler::WxRbEVT_END_PROCESS(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_END_PROCESS, func);
}

// wxJoyStick
void WxEvtHandler::WxRbEVT_JOY_DOWN(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_BUTTON_DOWN, func);
}
void WxEvtHandler::WxRbEVT_JOY_UP(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_BUTTON_UP, func);
}
void WxEvtHandler::WxRbEVT_JOY_MOVE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_MOVE, func);
}
void WxEvtHandler::WxRbEVT_JOY_ZMOVE(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_ZMOVE, func);
}
void WxEvtHandler::WxRbEVT_JOYSTICK_EVENTS(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_BUTTON_DOWN, func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_BUTTON_UP, func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_MOVE, func);
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_JOY_ZMOVE, func);
}

void WxEvtHandler::WxRbEVT_TOGGLEBUTTON(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TOGGLEBUTTON_CLICKED, func);
}

// Help events
void WxEvtHandler::WxRbEVT_HELP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_HELP, func);
}
void WxEvtHandler::WxRbEVT_HELP_RANGE(VALUE self,VALUE win,VALUE id,VALUE id2,VALUE func) {
    Connect(win,id, id2, wxEVT_HELP, func);
}
void WxEvtHandler::WxRbEVT_DETAILED_HELP(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_DETAILED_HELP, func);
}
void WxEvtHandler::WxRbEVT_DETAILED_HELP_RANGE(VALUE self,VALUE win,VALUE id,VALUE id2,VALUE func) {
    Connect(win,id, id2, wxEVT_DETAILED_HELP, func);
}
void WxEvtHandler::WxRbEVT_CONTEXT_MENU(VALUE self,VALUE win,VALUE func) {
    Connect(win,INT2NUM(-1), INT2NUM(-1), wxEVT_CONTEXT_MENU, func);
}

void WxEvtHandler::WxRbEVT_CALENDAR(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_CALENDAR_DOUBLECLICKED, func);
}
void WxEvtHandler::WxRbEVT_CALENDAR_SEL_CHANGED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_CALENDAR_SEL_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_CALENDAR_DAY(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_CALENDAR_DAY_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_CALENDAR_MONTH(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_CALENDAR_MONTH_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_CALENDAR_YEAR(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_CALENDAR_YEAR_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_CALENDAR_WEEKDAY_CLICKED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_CALENDAR_WEEKDAY_CLICKED, func);
}

void WxEvtHandler::WxRbEVT_LIST_BEGIN_DRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_BEGIN_DRAG, func);
}
void WxEvtHandler::WxRbEVT_LIST_BEGIN_RDRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_BEGIN_RDRAG, func);
}
void WxEvtHandler::WxRbEVT_LIST_BEGIN_LABEL_EDIT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_BEGIN_LABEL_EDIT, func);
}
void WxEvtHandler::WxRbEVT_LIST_END_LABEL_EDIT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_END_LABEL_EDIT, func);
}
void WxEvtHandler::WxRbEVT_LIST_DELETE_ITEM(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_DELETE_ITEM, func);
}
void WxEvtHandler::WxRbEVT_LIST_DELETE_ALL_ITEMS(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_DELETE_ALL_ITEMS, func);
}
void WxEvtHandler::WxRbEVT_LIST_GET_INFO(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_GET_INFO, func);
}
void WxEvtHandler::WxRbEVT_LIST_SET_INFO(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_SET_INFO, func);
}
void WxEvtHandler::WxRbEVT_LIST_KEY_DOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_KEY_DOWN, func);
}
void WxEvtHandler::WxRbEVT_LIST_INSERT_ITEM(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_INSERT_ITEM, func);
}
void WxEvtHandler::WxRbEVT_LIST_COL_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_COL_CLICK, func);
}
void WxEvtHandler::WxRbEVT_LIST_COL_RIGHT_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_COL_RIGHT_CLICK, func);
}
void WxEvtHandler::WxRbEVT_LIST_COL_BEGIN_DRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, func);
}
void WxEvtHandler::WxRbEVT_LIST_COL_DRAGGING(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_COL_DRAGGING, func);
}
void WxEvtHandler::WxRbEVT_LIST_COL_END_DRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_COL_END_DRAG, func);
}
void WxEvtHandler::WxRbEVT_LIST_ITEM_SELECTED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_ITEM_SELECTED, func);
}
void WxEvtHandler::WxRbEVT_LIST_ITEM_DESELECTED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_ITEM_DESELECTED, func);
}
void WxEvtHandler::WxRbEVT_LIST_ITEM_RIGHT_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_ITEM_RIGHT_CLICK, func);
}
void WxEvtHandler::WxRbEVT_LIST_ITEM_MIDDLE_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_ITEM_MIDDLE_CLICK, func);
}
void WxEvtHandler::WxRbEVT_LIST_ITEM_ACTIVATED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_ITEM_ACTIVATED, func);
}
void WxEvtHandler::WxRbEVT_LIST_ITEM_FOCUSED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_ITEM_FOCUSED, func);
}
void WxEvtHandler::WxRbEVT_LIST_CACHE_HINT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_LIST_CACHE_HINT, func);
}
void WxEvtHandler::WxRbEVT_FIND(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_FIND, func);
}
void WxEvtHandler::WxRbEVT_FIND_NEXT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_FIND_NEXT, func);
}
void WxEvtHandler::WxRbEVT_FIND_REPLACE(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_FIND_REPLACE, func);
}
void WxEvtHandler::WxRbEVT_FIND_REPLACE_ALL(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_FIND_REPLACE_ALL, func);
}
void WxEvtHandler::WxRbEVT_FIND_CLOSE(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_FIND_CLOSE, func);
}
void WxEvtHandler::WxRbEVT_SOCKET(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_SOCKET, func);
}
void WxEvtHandler::WxRbEVT_TREE_BEGIN_DRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TREE_BEGIN_DRAG, func);
}
void WxEvtHandler::WxRbEVT_TREE_BEGIN_RDRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TREE_BEGIN_RDRAG, func);
}
void WxEvtHandler::WxRbEVT_TREE_END_DRAG(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TREE_END_DRAG, func);
}
void WxEvtHandler::WxRbEVT_TREE_BEGIN_LABEL_EDIT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TREE_BEGIN_LABEL_EDIT, func);
}
void WxEvtHandler::WxRbEVT_TREE_END_LABEL_EDIT(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id, INT2NUM(-1), wxEVT_COMMAND_TREE_END_LABEL_EDIT, func);
}
void WxEvtHandler::WxRbEVT_TREE_GET_INFO(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_GET_INFO, func);
}
void WxEvtHandler::WxRbEVT_TREE_SET_INFO(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_SET_INFO, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_EXPANDED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_EXPANDED, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_EXPANDING(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_EXPANDING, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_COLLAPSED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_COLLAPSED, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_COLLAPSING(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_COLLAPSING, func);
}
void WxEvtHandler::WxRbEVT_TREE_SEL_CHANGED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_SEL_CHANGED, func);
}
void WxEvtHandler::WxRbEVT_TREE_SEL_CHANGING(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_SEL_CHANGING, func);
}
void WxEvtHandler::WxRbEVT_TREE_KEY_DOWN(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_KEY_DOWN, func);
}
void WxEvtHandler::WxRbEVT_TREE_DELETE_ITEM(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_DELETE_ITEM, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_ACTIVATED(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_ACTIVATED, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_RIGHT_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_RIGHT_CLICK, func);
}
void WxEvtHandler::WxRbEVT_TREE_ITEM_MIDDLE_CLICK(VALUE self,VALUE win,VALUE id,VALUE func) {
    Connect(win,id,INT2NUM(-1),wxEVT_COMMAND_TREE_ITEM_MIDDLE_CLICK, func);
}


