/**********************************************************************

  cursor.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "cursor.h"

VALUE
WxCursor::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxCursor::init(int argc, VALUE *argv, VALUE self)
{
    wxString cursorName;
    long type;
    int hotSpotX = 0;
    int hotSpotY = 0;

    wxCursor *ptr;
    Data_Get_Struct(self, wxCursor, ptr);
    if(argc==0) {
        ptr = new wxCursor();
    }
    else if(argc>0 && TYPE(argv[0])==T_STRING) {
    	cursorName = StringValuePtr(argv[0]);
        type = NUM2INT(argv[1]);
    	if(argc>2 && TYPE(argv[2])==T_FIXNUM)
    	  hotSpotX = NUM2INT(argv[2]);
    	if(argc>3 && TYPE(argv[3])==T_FIXNUM)
    	  hotSpotY = NUM2INT(argv[3]);
        ptr = new wxCursor(cursorName,type,hotSpotX,hotSpotY);
    } else if(argc==1 && TYPE(argv[0])==T_DATA) {
        wxImage *image;
        Data_Get_Struct(argv[0], wxImage, image);
      	ptr = new wxCursor(*image);
    } else {
        int cursorId = NUM2INT(argv[0]);
      	ptr = new wxCursor(cursorId);
    }
    DATA_PTR(self) = ptr;
    return self;
}




VALUE
WxCursor::Ok(VALUE self)
{
    wxCursor *ptr;
    Data_Get_Struct(self, wxCursor, ptr);
    return (ptr->Ok() ? Qtrue : Qfalse);
}

VALUE
WxCursor::init0(wxCursor *cursor)
{
    extern VALUE rb_cWxCursor;
    static VALUE self = Data_Wrap_Struct(rb_cWxCursor, 0, 0, 0);
    DATA_PTR(self) = cursor;
    return self;
}

//-----------------------------------------------------------------------------------
VALUE
WxBusyCursor::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxBusyCursor::init(int argc, VALUE *argv, VALUE self)
{
    wxCursor* cursor = wxHOURGLASS_CURSOR;
    if(argc>0) {
        Data_Get_Struct(argv[0], wxCursor, cursor);
    }
    wxBusyCursor *ptr;
    Data_Get_Struct(self, wxBusyCursor, ptr);
    ptr = new wxBusyCursor(cursor);
    DATA_PTR(self) = ptr;
    return self;
}

void
WxBusyCursor::free(VALUE self)
{
    wxBusyCursor *ptr;
    Data_Get_Struct(self, wxBusyCursor, ptr);
    delete ptr;
}
