/**********************************************************************

  colourdata.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "colour.h"
#include "colourdata.h"

VALUE
WxColourData::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxColourData::init(VALUE self)
{
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    ptr = new wxColourData();
    DATA_PTR(self) = ptr;

    return self;
}

void
WxColourData::SetColour(VALUE self,VALUE vcolour)
{
    wxColour *colour;
    Data_Get_Struct(vcolour, wxColour, colour);
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    ptr->SetColour(*colour);
}

void
WxColourData::SetCustomColour(VALUE self,VALUE vi,VALUE vcolour)
{
    int i = NUM2INT(vi);
    wxColour *colour;
    Data_Get_Struct(vcolour, wxColour, colour);
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    ptr->SetCustomColour(i,*colour);
}

void
WxColourData::SetChooseFull(VALUE self,VALUE vflag)
{
    bool flag = (vflag==Qtrue);
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    ptr->SetChooseFull(flag);
}

VALUE
WxColourData::GetColour(VALUE self)
{
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    return WxColour::init0(ptr->GetColour());
}

VALUE
WxColourData::init0(const wxColourData &colourData)
{
    extern VALUE rb_cWxColourData;
    wxColourData *ptr;
    VALUE self = Data_Wrap_Struct(rb_cWxColourData, 0, 0, 0);
    ptr = new wxColourData();
    *ptr = colourData;
    DATA_PTR(self) = ptr;
    return self;
}

VALUE
WxColourData::GetChooseFull(VALUE self)
{
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    return (ptr->GetChooseFull() ? Qtrue : Qfalse);
}

VALUE
WxColourData::GetCustomColour(VALUE self,VALUE vi)
{
    int i = NUM2INT(vi);
    wxColourData *ptr;
    Data_Get_Struct(self, wxColourData, ptr);
    return WxColour::init0(ptr->GetCustomColour(i));
}




