/**********************************************************************

  choice.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "choice.h"

VALUE
WxChoice::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxChoice::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    wxWindowID id;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    int n = 0;
    wxString *choices = NULL;
    long style = 0;

//    wxValidator validator = wxDefaultValidator;
//    wxString name = "choice";

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[2], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[3], wxSize, ptr);
	size = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_ARRAY) {
      n = RARRAY(argv[4])->len;
      choices = new wxString[n];
      for (int i = 0; i < RARRAY(argv[4])->len; i++) {
        choices[i] = wxString(StringValuePtr(RARRAY(argv[4])->ptr[i]));
      }
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    ptr = new wxChoice(parent,id,pos,size,n,choices,style);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

void
WxChoice::Append(int argc, VALUE *argv, VALUE self)
{
    wxString item = wxString(StringValuePtr(argv[0]));
    void* clientData;
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    if(argc>1) {
        VALUE vdata = rb_hash_new();
        rb_hash_aset(vdata,rb_str_new2("data"),argv[1]);
        clientData = (void*)vdata;
        ptr->Append(item,clientData);
    } else {
        ptr->Append(item);
    }
}

VALUE
WxChoice::GetCount(VALUE self)
{
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    return INT2NUM(ptr->GetCount());
}

VALUE
WxChoice::GetSelection(VALUE self)
{
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    return INT2NUM(ptr->GetSelection());
}

VALUE
WxChoice::GetString(VALUE self,VALUE vn)
{
    int n = NUM2INT(vn);
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    return rb_str_new2(ptr->GetString(n));
}

void
WxChoice::SetSelection(VALUE self,VALUE vn)
{
    int n = NUM2INT(vn);
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    ptr->SetSelection(n);
}


void
WxChoice::SetStringSelection(VALUE self,VALUE vstring)
{
    wxString string = StringValuePtr(vstring);
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    ptr->SetStringSelection(string);
}


void
WxChoice::SetClientData(VALUE self,VALUE vn,VALUE vcdata)
{
    int n = NUM2INT(vn);
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);

    void *data = ptr->GetClientData(n);
    VALUE vdata;
    if(data==NULL)
        vdata = rb_hash_new();
    else
        vdata = (VALUE)data;
    rb_hash_aset(vdata,rb_str_new2("data"),vcdata);
    data = (void*)vdata;

    ptr->SetClientData(n,data);
}

VALUE
WxChoice::GetClientData(VALUE self,VALUE vn)
{
    int n = NUM2INT(vn);
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    void *data = ptr->GetClientData(n);
    if(data==NULL)
        return Qnil;
    else
        return rb_hash_aref((VALUE)data, rb_str_new2("data"));
}

VALUE
WxChoice::GetStringSelection(VALUE self)
{
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    return rb_str_new2(ptr->GetStringSelection());
}

void
WxChoice::Clear(VALUE self)
{
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    ptr->Clear();
}

void
WxChoice::Delete(VALUE self,VALUE vn)
{
    int n = NUM2INT(vn);
    wxChoice *ptr;
    Data_Get_Struct(self, wxChoice, ptr);
    ptr->Delete(n);
}


