/**********************************************************************

  caret.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "window.h"
#include "caret.h"
#include "point.h"
#include "size.h"

VALUE
WxCaret::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxCaret::init(int argc, VALUE *argv, VALUE self)
{
    wxString name;
    long type;
    int desiredWidth = -1;
    int desiredHeight = -1;

    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    if(argc==0) {
        ptr = new wxCaret();
    }
    else if(argc==2) {
        wxWindowBase* window;
        Data_Get_Struct(argv[0], wxWindowBase, window);
        wxSize *size;
        Data_Get_Struct(argv[1], wxSize, size);
        ptr = new wxCaret(window,*size);
    } else {
        wxWindow* window;
        Data_Get_Struct(argv[0], wxWindow, window);
        int width = NUM2INT(argv[1]);
        int height = NUM2INT(argv[2]);
      	ptr = new wxCaret(window,width,height);
    }
    DATA_PTR(self) = ptr;
    return self;
}

VALUE
WxCaret::GetBlinkTime(VALUE self)
{
    return INT2NUM(wxCaret::GetBlinkTime());
}

VALUE
WxCaret::GetPosition(VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    return WxPoint::init0(ptr->GetPosition());
}

VALUE
WxCaret::GetPositionXY(VALUE self)
{
    int x;
    int y;
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    ptr->GetPosition(&x,&y);
    return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
}

VALUE
WxCaret::GetSize(VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    return WxSize::init0(ptr->GetSize());
}

VALUE
WxCaret::GetSizeXY(VALUE self)
{
    int width;
    int height;
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    ptr->GetSize(&width,&height);
    return rb_ary_new3(2,INT2NUM(width),INT2NUM(height));
}

VALUE
WxCaret::GetWindow(VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    return WxWindow::init0(ptr->GetWindow());
}

void
WxCaret::Hide(VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    ptr->Hide();
}

VALUE
WxCaret::IsOk(VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    return (ptr->IsOk() ? Qtrue : Qfalse);
}

VALUE
WxCaret::IsVisible(VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    return (ptr->IsVisible() ? Qtrue : Qfalse);
}

void
WxCaret::Move(VALUE self,VALUE vx,VALUE vy)
{
    int x = NUM2INT(vx);
    int y = NUM2INT(vy);
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    ptr->Move(x,y);
}

void
WxCaret::SetBlinkTime(VALUE self,VALUE vmilliseconds)
{
    int milliseconds = NUM2INT(vmilliseconds);
    wxCaret::SetBlinkTime(milliseconds);
}

void
WxCaret::SetSize(int argc, VALUE *argv, VALUE self)
{
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    if(argc==2) {
        int width = NUM2INT(argv[0]);
        int height = NUM2INT(argv[1]);
        ptr->SetSize(width,height);
    } else {
        wxSize *size;
        Data_Get_Struct(argv[0], wxSize, size);
        ptr->SetSize(*size);
    }
}

void
WxCaret::Show(int argc, VALUE *argv, VALUE self)
{
    bool show = TRUE;
    if(argc==1 && argv[0]==Qfalse) show = FALSE;
    wxCaret *ptr;
    Data_Get_Struct(self, wxCaret, ptr);
    ptr->Show(show);
}

VALUE
WxCaret::init0(wxCaret *caret)
{
    extern VALUE rb_cWxCaret;
    VALUE self = Data_Wrap_Struct(rb_cWxCaret, 0, 0, 0);
    DATA_PTR(self) = (void*)caret;
    return self;
}

