/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.tanukisoftware.wrapper.WrapperActionServer;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperResources;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperSecondInvocationEvent;
import org.tanukisoftware.wrapper.event.WrapperServicePauseEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceResumeEvent;
import org.tanukisoftware.wrapper.test.AbstractActionApp;

public class Main
extends AbstractActionApp
implements WrapperListener {
    private WrapperActionServer m_actionServer;
    private MainFrame m_frame;
    private ActionRunner m_actionRunner;
    private static WrapperResources m_res;
    private List m_listenerFlags;
    private TextField m_slowSeconds;
    private TextField m_suspendSeconds;
    private TextField m_serviceName;
    private TextField m_consoleTitle;
    private TextField m_childCommand;
    private Checkbox m_childDetached;
    private JDialog m_pauseDialog;

    private Main() {
    }

    public void fired(WrapperEvent event) {
        if (event instanceof WrapperSecondInvocationEvent) {
            this.bringToFront(this.m_frame);
        }
        if (event instanceof WrapperServicePauseEvent) {
            this.pause();
        }
        if (event instanceof WrapperServiceResumeEvent) {
            this.resume();
        }
    }

    public Integer start(String[] args) {
        String command;
        System.out.println(Main.getRes().getString("TestWrapper: start()"));
        this.prepareSystemOutErr();
        if (args.length <= 0) {
            System.out.println(Main.getRes().getString("TestWrapper: An action was not specified.  Default to \"dialog\".  Use \"help\" for list of actions."));
            command = "dialog";
        } else {
            command = args[0];
        }
        if (command.equals("help")) {
            Main.printHelp(null);
            return null;
        }
        try {
            int port = 9999;
            this.m_actionServer = new WrapperActionServer(port);
            this.m_actionServer.enableShutdownAction(true);
            this.m_actionServer.enableHaltExpectedAction(true);
            this.m_actionServer.enableRestartAction(true);
            this.m_actionServer.enableThreadDumpAction(true);
            this.m_actionServer.enableHaltUnexpectedAction(true);
            this.m_actionServer.enableAccessViolationAction(true);
            this.m_actionServer.enableAppearHungAction(true);
            this.m_actionServer.start();
            System.out.println(Main.getRes().getString("TestWrapper: ActionServer Enabled. "));
            System.out.println(Main.getRes().getString("TestWrapper:   Telnet localhost 9999"));
            System.out.println(Main.getRes().getString("TestWrapper:   Commands: "));
            System.out.println(Main.getRes().getString("TestWrapper:     S: Shutdown"));
            System.out.println(Main.getRes().getString("TestWrapper:     H: Expected Halt"));
            System.out.println(Main.getRes().getString("TestWrapper:     R: Restart"));
            System.out.println(Main.getRes().getString("TestWrapper:     D: Thread Dump"));
            System.out.println(Main.getRes().getString("TestWrapper:     U: Unexpected Halt (Simulate crash)"));
            System.out.println(Main.getRes().getString("TestWrapper:     V: Access Violation (Actual crash)"));
            System.out.println(Main.getRes().getString("TestWrapper:     G: Make the JVM appear to be hung."));
            System.out.println("TestWrapper: ");
        }
        catch (IOException e) {
            System.out.println(Main.getRes().getString("TestWrapper: Unable to open the action server socket: {0}", (Object)e.getMessage()));
            System.out.println("TestWrapper: ");
            this.m_actionServer = null;
        }
        if (command.equals("dialog")) {
            System.out.println(Main.getRes().getString("TestWrapper: Showing dialog..."));
            try {
                this.m_frame = new MainFrame();
                this.m_frame.setVisible(true);
            }
            catch (InternalError e) {
                System.out.println("TestWrapper: ");
                System.out.println(Main.getRes().getString("TestWrapper: ERROR - Unable to display the GUI:"));
                System.out.println("TestWrapper:           " + e.toString());
                System.out.println("TestWrapper: ");
                System.out.println(Main.getRes().getString("TestWrapper: Fall back to the \"console\" action."));
                command = "console";
            }
            catch (AWTError e) {
                System.out.println("TestWrapper: ");
                System.out.println(Main.getRes().getString("TestWrapper: ERROR - Unable to display the GUI:"));
                System.out.println("TestWrapper:           " + e.toString());
                System.out.println("TestWrapper: ");
                System.out.println(Main.getRes().getString("TestWrapper: Fall back to the \"console\" action."));
                command = "console";
            }
            catch (UnsupportedOperationException e) {
                if (e.getClass().getName().equals("java.awt.HeadlessException")) {
                    System.out.println("TestWrapper: ");
                    System.out.println(Main.getRes().getString("TestWrapper: ERROR - Unable to display the GUI:"));
                    System.out.println("TestWrapper:           " + e.toString());
                    System.out.println("TestWrapper: ");
                    System.out.println(Main.getRes().getString("TestWrapper: Fall back to the \"console\" action."));
                    command = "console";
                }
                throw e;
            }
        }
        if (!command.equals("dialog")) {
            this.m_actionRunner = new ActionRunner(command);
            Thread actionThread = new Thread(this.m_actionRunner);
            actionThread.start();
        }
        return null;
    }

    public int stop(int exitCode) {
        System.out.println(Main.getRes().getString("TestWrapper: stop({0})", (Object)new Integer(exitCode)));
        if (this.m_actionServer != null) {
            try {
                this.m_actionServer.stop();
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("TestWrapper: Unable to stop the action server: {0}", (Object)e.getMessage()));
            }
        }
        if (this.m_frame != null) {
            if (!WrapperManager.hasShutdownHookBeenTriggered()) {
                this.m_frame.setVisible(false);
                this.m_frame.dispose();
            }
            this.m_frame = null;
        }
        if (this.isNestedExit()) {
            System.out.println(Main.getRes().getString("TestWrapper: calling System.exit({0}) within stop.", (Object)String.valueOf(exitCode)));
            System.exit(exitCode);
        }
        return exitCode;
    }

    private void pause() {
        this.m_frame.setTitle(this.m_frame.getTitle() + Main.getRes().getString(" (paused)"));
        this.enableComponents(this.m_frame, false);
        JLabel label1 = new JLabel();
        label1.setHorizontalAlignment(0);
        label1.setAlignmentX(0.5f);
        label1.setText(Main.getRes().getString("The demo application is paused."));
        JLabel label2 = new JLabel();
        label2.setHorizontalAlignment(0);
        label2.setAlignmentX(0.5f);
        label2.setText(Main.getRes().getString("Resume it to make this dialog box disappear."));
        Border border1 = label1.getBorder();
        EmptyBorder margin1 = new EmptyBorder(25, 25, 0, 25);
        label1.setBorder(new CompoundBorder(border1, margin1));
        Border border2 = label2.getBorder();
        EmptyBorder margin2 = new EmptyBorder(0, 25, 30, 25);
        label2.setBorder(new CompoundBorder(border2, margin2));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(label1);
        panel.add(label2);
        this.m_pauseDialog = new JDialog(this.m_frame, this.m_frame.getTitle(), false);
        this.m_pauseDialog.getContentPane().add(panel);
        this.m_pauseDialog.setResizable(false);
        this.m_pauseDialog.setDefaultCloseOperation(0);
        this.m_pauseDialog.pack();
        this.m_pauseDialog.setLocationRelativeTo(this.m_frame);
        this.m_pauseDialog.setVisible(true);
    }

    private void resume() {
        String title = this.m_frame.getTitle();
        this.m_frame.setTitle(title.substring(0, title.indexOf(Main.getRes().getString(" (paused)"))));
        this.enableComponents(this.m_frame, true);
        this.m_pauseDialog.setDefaultCloseOperation(2);
        this.m_pauseDialog.setVisible(false);
        this.m_pauseDialog.dispatchEvent(new WindowEvent(this.m_pauseDialog, 201));
    }

    public void controlEvent(int event) {
        System.out.println(Main.getRes().getString("TestWrapper: controlEvent({0})", (Object)new Integer(event)));
        if (event == 202) {
            if (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs()) {
                System.out.println(Main.getRes().getString("TestWrapper:   Ignoring logoff event"));
            } else if (!this.ignoreControlEvents()) {
                WrapperManager.stop((int)0);
            }
        } else if (event == 200) {
            if (!this.ignoreControlEvents() && this.m_actionRunner != null) {
                this.m_actionRunner.endThread();
            }
        } else if (!this.ignoreControlEvents()) {
            WrapperManager.stop((int)0);
        }
    }

    private static void printHelp(String errorMsg) {
        System.err.println(Main.getRes().getString("USAGE"));
        System.err.println("");
        System.err.println(Main.getRes().getString("TestWrapper <action>"));
        Main.printActions();
        System.err.println(Main.getRes().getString("  Interactive:"));
        System.err.println(Main.getRes().getString("   dialog                   : Shows the dialog interface"));
        System.err.println(Main.getRes().getString("[EXAMPLE]"));
        System.err.println(Main.getRes().getString("   TestAction access_violation_native "));
        System.err.println("");
        if (errorMsg != null) {
            System.err.println(Main.getRes().getString("ERROR: ") + errorMsg);
            System.err.println("");
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrapperResources getRes() {
        if (m_res == null) {
            Class clazz = Main.class;
            synchronized (clazz) {
                if (m_res == null) {
                    m_res = WrapperManager.loadWrapperResources((String)"wrapperTestApp", (String)WrapperSystemPropertyUtil.getStringProperty((String)"wrapper.lang.folder", (String)"../lang"));
                }
            }
        }
        return m_res;
    }

    private boolean bringToFront(MainFrame frame) {
        try {
            Method m = MainFrame.class.getMethod("setAlwaysOnTop", Boolean.TYPE);
            m.invoke((Object)frame, new Boolean(true));
            m.invoke((Object)frame, new Boolean(false));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void enableComponents(Container container, boolean enable) {
        Component[] components = container.getComponents();
        for (int a = 0; a < components.length; ++a) {
            components[a].setEnabled(enable);
            if (!(components[a] instanceof Container)) continue;
            this.enableComponents((Container)components[a], enable);
        }
    }

    public static void main(String[] args) {
        System.out.println(Main.getRes().getString("TestWrapper: Initializing..."));
        WrapperManager.start((WrapperListener)new Main(), (String[])args);
    }

    private class ActionRunner
    implements Runnable {
        private String m_action;
        private boolean m_alive;

        public ActionRunner(String action) {
            this.m_action = action;
            this.m_alive = true;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!Main.this.doAction(this.m_action)) {
                Main.printHelp("\"" + this.m_action + Main.getRes().getString("\" is an unknown action."));
                WrapperManager.stop((int)0);
                return;
            }
            while (this.m_alive) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void endThread() {
            this.m_alive = false;
        }
    }

    private class MainFrame
    extends Frame
    implements ActionListener,
    WindowListener {
        private static final long serialVersionUID = -3847376282833547574L;
        private float dpiScaleFactor;

        MainFrame() {
            super(Main.getRes().getString("TestWrapper Example Application"));
            this.dpiScaleFactor = 1.0f;
            try {
                this.dpiScaleFactor = (float)WrapperManager.nativeGetDpiScale() / 96.0f;
            }
            catch (UnsatisfiedLinkError e) {
                this.dpiScaleFactor = 1.0f;
            }
            this.init();
            this.setLocation(10, 10);
            this.setSize((int)(750.0f * this.dpiScaleFactor), (int)(480.0f * this.dpiScaleFactor));
            this.setResizable(true);
        }

        private void init() {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            Panel panel = new Panel();
            panel.setLayout(gridBag);
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(panel);
            scrollPane.getHAdjustable().setUnitIncrement(20);
            scrollPane.getVAdjustable().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            this.buildCommand(panel, gridBag, c, "Stop(0)", "stop0", Main.getRes().getString("Calls WrapperManager.stop( 0 ) to shutdown the JVM and Wrapper with a success exit code."));
            this.buildCommand(panel, gridBag, c, "Stop(1)", "stop1", Main.getRes().getString("Calls WrapperManager.stop( 1 ) to shutdown the JVM and Wrapper with a failure exit code."));
            this.buildCommand(panel, gridBag, c, "Exit(0)", "exit0", Main.getRes().getString("Calls System.exit( 0 ) to shutdown the JVM and Wrapper with a success exit code."));
            this.buildCommand(panel, gridBag, c, "Exit(1)", "exit1", Main.getRes().getString("Calls System.exit( 1 ) to shutdown the JVM and Wrapper with a failure exit code."));
            this.buildCommand(panel, gridBag, c, "StopImmediate(0)", "stopimmediate0", Main.getRes().getString("Calls WrapperManager.stopImmediate( 0 ) to immediately shutdown the JVM and Wrapper with a success exit code."));
            this.buildCommand(panel, gridBag, c, "StopImmediate(1)", "stopimmediate1", Main.getRes().getString(" Calls WrapperManager.stopImmediate( 1 ) to immediately shutdown the JVM and Wrapper with a failure exit code."));
            this.buildCommand(panel, gridBag, c, "StopAndReturn(0)", "stopandreturn0", Main.getRes().getString("Calls WrapperManager.stopAndReturn( 0 ) to shutdown the JVM and Wrapper with a success exit code."));
            this.buildCommand(panel, gridBag, c, "Nested Exit(1)", "nestedexit1", Main.getRes().getString("Calls System.exit(1) within WrapperListener.stop(1) callback."));
            this.buildCommand(panel, gridBag, c, "Halt(0)", "halt0", Main.getRes().getString("Calls Runtime.getRuntime().halt(0) to kill the JVM, the Wrapper will restart it."));
            this.buildCommand(panel, gridBag, c, "Halt(1)", "halt1", Main.getRes().getString("Calls Runtime.getRuntime().halt(1) to kill the JVM, the Wrapper will restart it."));
            this.buildCommand(panel, gridBag, c, "Restart()", "restart", Main.getRes().getString("Calls WrapperManager.restart() to shutdown the current JVM and start a new one."));
            this.buildCommand(panel, gridBag, c, "RestartAndReturn()", "restartandreturn", Main.getRes().getString("Calls WrapperManager.restartAndReturn() to shutdown the current JVM and start a new one."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Native Access Violation"), "access_violation_native", Main.getRes().getString("Causes an access violation using native code, the JVM will crash and be restarted."));
            if (WrapperManager.isWindows()) {
                this.buildCommand(panel, gridBag, c, Main.getRes().getString("Native Exception"), "exception_native", Main.getRes().getString("Throw an exception using native code, on Windows, the JVM will crash and be restarted."));
                this.buildCommand(panel, gridBag, c, Main.getRes().getString("Native Fail Fast Exception"), "ff_exception_native", Main.getRes().getString("Throw a fail fast exception using native code, on Windows, the JVM will crash and be restarted."));
            }
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Simulate JVM Hang"), "appear_hung", Main.getRes().getString("Makes the JVM appear to be hung as viewed from the Wrapper, it will be killed and restarted."));
            Main.this.m_slowSeconds = new TextField("0");
            Panel slowPanel = new Panel();
            slowPanel.setLayout(new BorderLayout());
            slowPanel.add((Component)new Label(Main.getRes().getString("Delay Seconds: ")), "West");
            slowPanel.add((Component)Main.this.m_slowSeconds, "Center");
            Panel slowPanel2 = new Panel();
            slowPanel2.setLayout(new BorderLayout());
            slowPanel2.add((Component)slowPanel, "West");
            slowPanel2.add((Component)new Label(Main.getRes().getString("Makes the JVM appear sluggish by being slow to respond to all packet requests from the Wrapper.")), "Center");
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Simulate Slow JVM"), "appear_slow", slowPanel2);
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Create Deadlock"), "deadlock", Main.getRes().getString("Creates two new threads which intentionally go into a deadlock situation.  (Standard, Professional)"));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Simulate Out Of Memory"), "outofmemory", Main.getRes().getString("Throws an OutOfMemoryError to demonstrate the Trigger feature."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Ignore Control Events"), "ignore_events", Main.getRes().getString("Makes this application ignore control events.  It will not shutdown in response to CTRL-C.  The Wrapper will still respond."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Request Thread Dump"), "dump", Main.getRes().getString("Calls WrapperManager.requestThreadDump() to cause the JVM to dump its current thread state."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("System.out Deadlock"), "deadlock_out", Main.getRes().getString("Simulates a failure mode where the System.out object has become deadlocked."));
            Main.this.m_suspendSeconds = new TextField("60");
            Panel suspendPanel = new Panel();
            suspendPanel.setLayout(new BorderLayout());
            suspendPanel.add((Component)new Label(Main.getRes().getString("Seconds: ")), "West");
            suspendPanel.add((Component)Main.this.m_suspendSeconds, "Center");
            Panel suspendPanel2 = new Panel();
            suspendPanel2.setLayout(new BorderLayout());
            suspendPanel2.add((Component)suspendPanel, "West");
            suspendPanel2.add((Component)new Label(Main.getRes().getString("Suspend Wrapper timeouts while the JVM is running.  (Standard, Professional)")), "Center");
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Suspend Timeouts"), "suspend_timeouts", suspendPanel2);
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Resume Timeouts"), "resume_timeouts", Main.getRes().getString("Resume Wrapper timeouts.  (Standard, Professional)"));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Poll Users"), "users", Main.getRes().getString("Begins calling WrapperManager.getUser() and getInteractiveUser() to monitor the current and interactive users."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Poll Users with Groups"), "groups", Main.getRes().getString("Same as above, but includes information about the user''s groups."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Console"), "console", Main.getRes().getString("Prompt for Actions in the console."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Idle"), "idle", Main.getRes().getString("Run idly."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Dump Properties"), "properties", Main.getRes().getString("Dumps all System Properties to the console."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Dump Configuration"), "configuration", Main.getRes().getString("Dumps all Wrapper Configuration Properties to the console."));
            Main.this.m_listenerFlags = new List(2, true);
            Main.this.m_listenerFlags.add("Service");
            Main.this.m_listenerFlags.add("Control");
            Main.this.m_listenerFlags.add("Logging");
            Main.this.m_listenerFlags.add("Core");
            Main.this.m_listenerFlags.add("RemoteControl");
            Panel flagPanel = new Panel();
            flagPanel.setLayout(new BorderLayout());
            flagPanel.add((Component)new Label("Event Flags: "), "West");
            flagPanel.add((Component)Main.this.m_listenerFlags, "Center");
            flagPanel.setSize(100, 10);
            Panel flagPanel2 = new Panel();
            flagPanel2.setLayout(new BorderLayout());
            flagPanel2.add((Component)flagPanel, "West");
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Update Event Listener"), "listener", flagPanel2);
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Service List"), "service_list", Main.getRes().getString("Displays a list of registered services on Windows."));
            Main.this.m_serviceName = new TextField("testwrapper");
            Panel servicePanel = new Panel();
            servicePanel.setLayout(new BorderLayout());
            servicePanel.add((Component)new Label(Main.getRes().getString("Interrogate Service.  Service name: ")), "West");
            servicePanel.add((Component)Main.this.m_serviceName, "Center");
            Panel servicePanel2 = new Panel();
            servicePanel2.setLayout(new BorderLayout());
            servicePanel2.add((Component)servicePanel, "West");
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Service Interrogate"), "service_interrogate", servicePanel2);
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Service Start"), "service_start", Main.getRes().getString("Starts the above service."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Service Stop"), "service_stop", Main.getRes().getString("Stops the above service."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Service User Code"), "service_user", Main.getRes().getString("Sends a series of user codes to the above service."));
            Main.this.m_consoleTitle = new TextField(Main.getRes().getString("Java Service Wrapper"));
            Panel titlePanel = new Panel();
            titlePanel.setLayout(new BorderLayout());
            titlePanel.add((Component)new Label(Main.getRes().getString("Console Title: ")), "West");
            titlePanel.add((Component)Main.this.m_consoleTitle, "Center");
            Panel titlePanel2 = new Panel();
            titlePanel2.setLayout(new BorderLayout());
            titlePanel2.add((Component)titlePanel, "West");
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Set Console Title"), "console_title", titlePanel2);
            Main.this.m_childCommand = new TextField(Main.getRes().getString("(Please enter command)"));
            Main.this.m_childDetached = new Checkbox(Main.getRes().getString("Detached  (Professional)"), false);
            Panel childPanel = new Panel();
            childPanel.setLayout(new BorderLayout());
            childPanel.add((Component)new Label(Main.getRes().getString("Command: ")), "West");
            childPanel.add((Component)Main.this.m_childCommand, "Center");
            childPanel.add((Component)Main.this.m_childDetached, "East");
            Panel childPanel2 = new Panel();
            childPanel2.setLayout(new BorderLayout());
            childPanel2.add((Component)childPanel, "West");
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Execute Child Process"), "child_exec", childPanel2);
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("GC"), "gc", Main.getRes().getString("Performs a GC sweep."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Is Professional?"), "is_professional", Main.getRes().getString("Prints true if this is a Professional Edition."));
            this.buildCommand(panel, gridBag, c, Main.getRes().getString("Is Standard?"), "is_standard", Main.getRes().getString("Prints true if this is a Standard Edition."));
            this.addWindowListener(this);
            this.buildEventMask(new String[]{"Service", "RemoteControl"});
            Main.this.updateEventListener();
        }

        private void buildCommand(Container container, GridBagLayout gridBag, GridBagConstraints c, String label, String command, Object description) {
            Button button = new Button(label);
            button.setActionCommand(command);
            if (this.dpiScaleFactor != 1.0f) {
                button.setFont(new Font("Arial", 0, (int)(12.0f * this.dpiScaleFactor)));
            }
            c.fill = 1;
            c.gridwidth = 1;
            gridBag.setConstraints(button, c);
            container.add(button);
            button.addActionListener(this);
            c.gridwidth = 0;
            Component desc = description instanceof String ? new Label((String)description) : (description instanceof Component ? (Component)description : new Label(description.toString()));
            if (this.dpiScaleFactor != 1.0f) {
                desc.setFont(new Font("Arial", 0, (int)(12.0f * this.dpiScaleFactor)));
            }
            gridBag.setConstraints(desc, c);
            container.add(desc);
        }

        private void buildEventMask(String[] flags) {
            long mask = 0L;
            for (int i = 0; i < flags.length; ++i) {
                String flag = flags[i];
                if (flag.equals("Service")) {
                    mask |= 1L;
                    continue;
                }
                if (flag.equals("Control")) {
                    mask |= 2L;
                    continue;
                }
                if (flag.equals("Logging")) {
                    mask |= 4L;
                    continue;
                }
                if (flag.equals("Core")) {
                    mask |= 0xF000000000000000L;
                    continue;
                }
                if (!flag.equals("RemoteControl")) continue;
                mask |= 8L;
            }
            Main.this.setEventMask(mask);
        }

        public void actionPerformed(ActionEvent event) {
            int suspendSeconds;
            int slowSeconds;
            String action = event.getActionCommand();
            if (action.equals("listener")) {
                String[] flags = Main.this.m_listenerFlags.getSelectedItems();
                this.buildEventMask(flags);
            }
            try {
                slowSeconds = Integer.parseInt(Main.this.m_slowSeconds.getText());
            }
            catch (NumberFormatException e) {
                slowSeconds = 0;
            }
            Main.this.m_slowSeconds.setText(Integer.toString(slowSeconds));
            Main.this.setSlowSeconds(slowSeconds);
            try {
                suspendSeconds = Integer.parseInt(Main.this.m_suspendSeconds.getText());
            }
            catch (NumberFormatException e) {
                suspendSeconds = 0;
            }
            Main.this.m_suspendSeconds.setText(Integer.toString(suspendSeconds));
            Main.this.setSuspendSeconds(suspendSeconds);
            Main.this.setServiceName(Main.this.m_serviceName.getText());
            Main.this.setConsoleTitle(Main.this.m_consoleTitle.getText());
            Main.this.setChildParams(Main.this.m_childCommand.getText(), Main.this.m_childDetached.getState());
            Main.this.doAction(action);
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            WrapperManager.stopAndReturn((int)0);
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

