/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.test.Main;

public class DeadLock {
    private int m_id;
    private Object m_obj1;
    private Object m_obj2;

    private DeadLock(int id, Object obj1, Object obj2) {
        this.m_id = id;
        this.m_obj1 = obj1;
        this.m_obj2 = obj2;
        Thread runner = new Thread("Locker-" + this.m_id){

            public void run() {
                System.out.println(Main.getRes().getString("Locker-{0}: Started", (Object)new Integer(DeadLock.this.m_id)));
                try {
                    DeadLock.this.lockFirst();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.out.println(Main.getRes().getString("Locker-{0}: Complete", (Object)new Integer(DeadLock.this.m_id)));
            }
        };
        runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockSecond() {
        System.out.println(Main.getRes().getString("Locker-{0}: Try locking {1}...", (Object)new Integer(this.m_id), (Object)this.m_obj2.toString()));
        Object object = this.m_obj2;
        synchronized (object) {
            System.out.println(Main.getRes().getString("Locker-{0}: Oops! Locked {1}", (Object)new Integer(this.m_id), (Object)this.m_obj2.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockFirst() {
        System.out.println(Main.getRes().getString("Locker-{0}: Locking {1}", (Object)new Integer(this.m_id), (Object)this.m_obj1.toString()));
        Object object = this.m_obj1;
        synchronized (object) {
            System.out.println(Main.getRes().getString("Locker-{0}: Locked {1}", (Object)new Integer(this.m_id), (Object)this.m_obj1.toString()));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lockSecond();
        }
    }

    public static void create2ObjectDeadlock() {
        Object obj1 = new Object();
        Object obj2 = new Object();
        new DeadLock(1, obj1, obj2);
        new DeadLock(2, obj2, obj1);
    }

    public static void create3ObjectDeadlock() {
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        new DeadLock(1, obj1, obj2);
        new DeadLock(2, obj2, obj3);
        new DeadLock(3, obj3, obj1);
    }

    public static void main(String[] args) {
        System.out.println(Main.getRes().getString("Deadlock Tester Running..."));
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        int exitCode = WrapperManager.getJVMId();
        switch (exitCode) {
            case 1: {
                System.out.println(Main.getRes().getString("2-object deadlock."));
                DeadLock.create2ObjectDeadlock();
                break;
            }
            case 2: {
                System.out.println(Main.getRes().getString("Wait then 2-object deadlock."));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                DeadLock.create2ObjectDeadlock();
                break;
            }
            case 3: {
                System.out.println(Main.getRes().getString("3-object deadlock."));
                DeadLock.create3ObjectDeadlock();
                break;
            }
            default: {
                System.out.println(Main.getRes().getString("Done."));
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println(Main.getRes().getString("Main Complete."));
    }
}

