/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;

public class WrapperActionServer
implements Runnable {
    public static final byte COMMAND_SHUTDOWN = 83;
    public static final byte COMMAND_HALT_EXPECTED = 72;
    public static final byte COMMAND_RESTART = 82;
    public static final byte COMMAND_DUMP = 68;
    public static final byte COMMAND_HALT_UNEXPECTED = 85;
    public static final byte COMMAND_ACCESS_VIOLATION = 86;
    public static final byte COMMAND_APPEAR_HUNG = 71;
    private InetAddress m_bindAddr;
    private int m_port;
    private Thread m_runner;
    private boolean m_runnerStop = false;
    private ServerSocket m_serverSocket;
    private Hashtable m_actions = new Hashtable();
    private static WrapperPrintStream m_out;

    public WrapperActionServer(int port, InetAddress bindAddress) {
        String sunStdoutEncoding;
        this.m_port = port;
        this.m_bindAddr = bindAddress;
        boolean streamSet = false;
        if ("true".equals(System.getProperty("wrapper.use_sun_encoding")) && (sunStdoutEncoding = System.getProperty("sun.stdout.encoding")) != null && !sunStdoutEncoding.equals(System.getProperty("file.encoding"))) {
            try {
                m_out = new WrapperPrintStream(System.out, false, sunStdoutEncoding, "WrapperActionServer: ");
                streamSet = true;
            }
            catch (UnsupportedEncodingException e) {
                System.out.println(WrapperManager.getRes().getString("Failed to set the encoding '{0}' when creating a WrapperPrintStream.\n Make sure the value of sun.stdout.encoding is correct.", sunStdoutEncoding));
            }
        }
        if (!streamSet) {
            m_out = new WrapperPrintStream(System.out, "WrapperActionServer: ");
        }
    }

    public WrapperActionServer(int port) {
        this(port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        WrapperActionServer wrapperActionServer;
        if (Thread.currentThread() != this.m_runner) {
            throw new IllegalStateException(WrapperManager.getRes().getString("Private method."));
        }
        try {
            while (!this.m_runnerStop) {
                try {
                    Runnable action;
                    int command;
                    Socket socket = this.m_serverSocket.accept();
                    try {
                        socket.setSoTimeout(15000);
                        command = socket.getInputStream().read();
                    }
                    finally {
                        socket.close();
                    }
                    if (command < 0) continue;
                    Hashtable hashtable = this.m_actions;
                    synchronized (hashtable) {
                        action = (Runnable)this.m_actions.get(new Integer(command));
                        if (action == null) continue;
                    }
                    try {
                        action.run();
                    }
                    catch (Throwable t) {
                        m_out.println(WrapperManager.getRes().getString("Error processing action."));
                        t.printStackTrace(m_out);
                    }
                }
                catch (Throwable t) {
                    if (this.m_runnerStop && (t instanceof InterruptedException || t instanceof SocketException || t instanceof InterruptedIOException || t instanceof IOException && t.getMessage() != null && t.getMessage().indexOf("Bad file descriptor") >= 0)) continue;
                    m_out.println(WrapperManager.getRes().getString("Unexpected error."));
                    t.printStackTrace(m_out);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Object var7_9 = null;
            wrapperActionServer = this;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            WrapperActionServer wrapperActionServer2 = this;
            synchronized (wrapperActionServer2) {
                this.m_runner = null;
                this.notify();
                throw throwable;
            }
        }
        synchronized (wrapperActionServer) {
            this.m_runner = null;
            this.notify();
            return;
        }
    }

    public void start() throws IOException {
        this.m_serverSocket = new ServerSocket(this.m_port, 5, this.m_bindAddr);
        this.m_runner = new Thread((Runnable)this, "WrapperActionServer_runner");
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Thread runner = this.m_runner;
        this.m_runnerStop = true;
        runner.interrupt();
        ServerSocket serverSocket = this.m_serverSocket;
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        WrapperActionServer wrapperActionServer = this;
        synchronized (wrapperActionServer) {
            while (this.m_runner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(byte command, Runnable action) {
        Hashtable hashtable = this.m_actions;
        synchronized (hashtable) {
            this.m_actions.put(new Integer(command), action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAction(byte command) {
        Hashtable hashtable = this.m_actions;
        synchronized (hashtable) {
            this.m_actions.remove(new Integer(command));
        }
    }

    public void enableShutdownAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)83, new Runnable(){

                public void run() {
                    WrapperManager.stopAndReturn(0);
                }
            });
        } else {
            this.unregisterAction((byte)83);
        }
    }

    public void enableHaltExpectedAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)72, new Runnable(){

                public void run() {
                    WrapperManager.stopImmediate(0);
                }
            });
        } else {
            this.unregisterAction((byte)72);
        }
    }

    public void enableRestartAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)82, new Runnable(){

                public void run() {
                    WrapperManager.restartAndReturn();
                }
            });
        } else {
            this.unregisterAction((byte)82);
        }
    }

    public void enableThreadDumpAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)68, new Runnable(){

                public void run() {
                    WrapperManager.requestThreadDump();
                }
            });
        } else {
            this.unregisterAction((byte)68);
        }
    }

    public void enableHaltUnexpectedAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)85, new Runnable(){

                public void run() {
                    Runtime.getRuntime().halt(0);
                }
            });
        } else {
            this.unregisterAction((byte)85);
        }
    }

    public void enableAccessViolationAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)86, new Runnable(){

                public void run() {
                    WrapperManager.accessViolationNative();
                }
            });
        } else {
            this.unregisterAction((byte)86);
        }
    }

    public void enableAppearHungAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)71, new Runnable(){

                public void run() {
                    WrapperManager.appearHung();
                }
            });
        } else {
            this.unregisterAction((byte)71);
        }
    }
}

