/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class WrapperPrintParam {
    public static void main(String[] args) {
        System.out.println("Dump all JVM parameters using RuntimeMXBean:");
        System.out.println("  (There is a bug in Java that was fixed in 1.7 which causes all parameters being displayed below to be split into different arguments when spaces are encountered.)");
        try {
            String arg;
            Class<?> cRuntimeMXBean = Class.forName("java.lang.management.RuntimeMXBean");
            Class<?> cManagementFactory = Class.forName("java.lang.management.ManagementFactory");
            Method mGetRuntimeMXBean = cManagementFactory.getMethod("getRuntimeMXBean", null);
            Method mGetInputArguments = cRuntimeMXBean.getMethod("getInputArguments", null);
            Object runtimemxBean = mGetRuntimeMXBean.invoke(null, (Object[])null);
            List jvm_args = (List)mGetInputArguments.invoke(runtimemxBean, (Object[])null);
            System.out.println(jvm_args.size() + " JVM Parameter(s):");
            ListIterator i = jvm_args.listIterator();
            while (i.hasNext()) {
                String arg2 = (String)i.next();
                System.out.println("  " + arg2);
            }
            List<String> app_args = Arrays.asList(args);
            System.out.println(app_args.size() + " Application Parameter(s):");
            ListIterator<String> i2 = app_args.listIterator();
            while (i2.hasNext()) {
                arg = i2.next();
                System.out.println("  " + arg);
            }
            System.out.println();
            System.out.println("Resulting System Properties:");
            i2 = jvm_args.listIterator();
            while (i2.hasNext()) {
                int pos;
                arg = i2.next();
                if (!arg.startsWith("-D") || (pos = arg.indexOf(61)) < 0) continue;
                String name = arg.substring(2, pos);
                System.out.println("  " + name + "=" + System.getProperty(name));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

