/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.test.Main;

public class ChildWrapper {
    private static String c_encoding = System.getProperty("sun.jnu.encoding");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleJavaProcess(String command) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(command);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), c_encoding));
            try {
                while ((line = br.readLine()) != null) {
                    System.out.println("stdout: " + line);
                }
            }
            finally {
                br.close();
            }
            br = new BufferedReader(new InputStreamReader(process.getErrorStream(), c_encoding));
            try {
                while ((line = br.readLine()) != null) {
                    System.out.println("stderr: " + line);
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            int exitCode = process.waitFor();
            System.out.println("exitCode: " + exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWrapperProcess(String command) throws IOException, InterruptedException {
        WrapperProcess process = WrapperManager.exec((String)command);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), c_encoding));
            try {
                while ((line = br.readLine()) != null) {
                    System.out.println("stdout: " + line);
                }
            }
            finally {
                br.close();
            }
            br = new BufferedReader(new InputStreamReader(process.getErrorStream(), c_encoding));
            try {
                while ((line = br.readLine()) != null) {
                    System.out.println("stderr: " + line);
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            int exitCode = process.waitFor();
            System.out.println("exitCode: " + exitCode);
        }
    }

    public static void main(String[] args) {
        System.out.println("Communicate with child processes using encoding: " + c_encoding);
        try {
            String wrapperCmdTestWrapper;
            String wrapperCmdVersion;
            if (WrapperManager.isWindows()) {
                wrapperCmdVersion = "..\\bin\\wrapper.exe -v";
                wrapperCmdTestWrapper = "..\\bin\\wrapper.exe -c ..\\conf\\wrapper.conf -- exit0";
            } else {
                wrapperCmdVersion = "../bin/wrapper -v";
                wrapperCmdTestWrapper = "../bin/wrapper -c ../conf/wrapper.conf -- exit0";
            }
            String batCmd = "cmd /c ..\\bin\\TestWrapper.bat exit0";
            String batDirect = "..\\bin\\TestWrapper.bat exit0";
            System.out.println(Main.getRes().getString("Runtime.exec test (Version)."));
            ChildWrapper.handleJavaProcess(wrapperCmdVersion);
            System.out.println(Main.getRes().getString("Runtime.exec test (TestWrapper)."));
            ChildWrapper.handleJavaProcess(wrapperCmdTestWrapper);
            if (WrapperManager.isStandardEdition()) {
                System.out.println(Main.getRes().getString("WrapperManager.exec test (Version)."));
                ChildWrapper.handleWrapperProcess(wrapperCmdVersion);
                System.out.println(Main.getRes().getString("WrapperManager.exec test (TestWrapper)."));
                ChildWrapper.handleWrapperProcess(wrapperCmdTestWrapper);
            }
            if (WrapperManager.isWindows()) {
                System.out.println(Main.getRes().getString("Runtime.exec test (Bat with cmd)."));
                ChildWrapper.handleJavaProcess(batCmd);
                System.out.println(Main.getRes().getString("Runtime.exec test (Bat direct)."));
                ChildWrapper.handleJavaProcess(batDirect);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (c_encoding == null && (c_encoding = System.getProperty("file.encoding")) == null) {
            c_encoding = "Cp1252";
        }
    }
}

