/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Random;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;

public class RuntimeExec {
    private static String c_encoding = System.getProperty("sun.jnu.encoding");

    private static void handleInputStream(final InputStream is, final String encoding, final String label) {
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            System.out.println(label + ": " + line);
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleJavaProcessInner(Process process) throws IOException, InterruptedException {
        try {
            RuntimeExec.handleInputStream(process.getInputStream(), c_encoding, "stdout");
            RuntimeExec.handleInputStream(process.getErrorStream(), c_encoding, "stderr");
        }
        finally {
            int exitCode = process.waitFor();
            System.out.println("exitCode: " + exitCode);
        }
    }

    private static void handleJavaProcess(String command) throws IOException, InterruptedException {
        RuntimeExec.handleJavaProcessInner(Runtime.getRuntime().exec(command));
    }

    private static void handleJavaProcess(String[] command) throws IOException, InterruptedException {
        RuntimeExec.handleJavaProcessInner(Runtime.getRuntime().exec(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWrapperProcessInner(WrapperProcess process, long timeoutMS) throws IOException, InterruptedException {
        try {
            RuntimeExec.handleInputStream(process.getInputStream(), c_encoding, "stdout");
            RuntimeExec.handleInputStream(process.getErrorStream(), c_encoding, "stderr");
            if (timeoutMS > 0L) {
                long start = System.currentTimeMillis();
                while (process.isAlive() && System.currentTimeMillis() - start < timeoutMS) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
                if (process.isAlive()) {
                    System.out.println("Timed out waiting for child.  Destroying.");
                    process.destroy();
                }
            }
        }
        finally {
            int exitCode = process.waitFor();
            System.out.println("exitCode: " + exitCode);
        }
    }

    private static void handleWrapperProcess(String command, long timeoutMS) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcessInner(WrapperManager.exec((String)command), timeoutMS);
    }

    private static void handleWrapperProcess(String[] command, long timeoutMS) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcessInner(WrapperManager.exec((String[])command), timeoutMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String command;
        String line;
        BufferedReader br;
        WrapperProcess proc;
        WrapperProcessConfig wpm;
        Object p;
        WrapperProcess proc2;
        final String simplewaiter = WrapperManager.isWindows() ? "../test/simplewaiter.exe" : "../test/simplewaiter";
        String encoding = System.getProperty("sun.jnu.encoding");
        if (encoding == null && (encoding = System.getProperty("file.encoding")) == null) {
            encoding = "Cp1252";
        }
        System.out.println("Communicate with child processes using encoding: " + encoding);
        Random rand = new Random();
        System.out.println(Main.getRes().getString("Is DYNAMIC supported? A:") + WrapperProcessConfig.isSupported((int)4));
        System.out.println(Main.getRes().getString("Is FORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)2));
        System.out.println(Main.getRes().getString("Is VFORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)3));
        System.out.println(Main.getRes().getString("Is POSIX_SPAWN supported? A:") + WrapperProcessConfig.isSupported((int)1));
        try {
            System.out.println();
            System.out.println("Verifying correct parsing of the command:");
            System.out.println("First a single command line: " + simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"\"");
            String s = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
            System.out.println("Runtime.exec:");
            RuntimeExec.handleJavaProcess(s);
            System.out.println("Now WrapperManager.exec:");
            RuntimeExec.handleWrapperProcess(s, 0L);
            System.out.println("First test finished. ");
            System.out.println();
            System.out.println("Next a pass the command as array: " + simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"\"");
            String[] s2 = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
            System.out.println("Runtime.exec:");
            RuntimeExec.handleJavaProcess(s2);
            System.out.println("Now WrapperManager.exec:");
            RuntimeExec.handleWrapperProcess(s2, 0L);
            System.out.println("Second test finished. ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        System.out.println();
        System.out.println(i + Main.getRes().getString(" start a small child process, dont care about output but call waitfor..."));
        try {
            proc2 = WrapperManager.exec((String)(simplewaiter + " 65 1"));
            proc2.getOutputStream().close();
            System.out.println(Main.getRes().getString("{0} small child process {1} is alive {2}", new Object[]{Integer.toString(i), Integer.toString(proc2.getPID()), Boolean.toString(proc2.isAlive())}));
            System.out.println(Main.getRes().getString("{0} child process (PID= {1}) finished with code {2}", new Object[]{Integer.toString(i), Integer.toString(proc2.getPID()), Integer.toString(proc2.waitFor())}));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" start longrunning child process dont wait..."));
        try {
            System.out.println(i + Main.getRes().getString(" first, try to vfork..."));
            if (WrapperProcessConfig.isSupported((int)3)) {
                System.out.println(i + Main.getRes().getString(" vfork is supported"));
                proc2 = WrapperManager.exec((String)(simplewaiter + " " + (rand.nextInt(200) + 1) + " " + rand.nextInt(30)), (WrapperProcessConfig)new WrapperProcessConfig().setStartType(3));
            } else {
                System.out.println(i + Main.getRes().getString(" vfork is not supported"));
                proc2 = WrapperManager.exec((String)(simplewaiter + " " + (rand.nextInt(200) + 1) + " " + rand.nextInt(30)));
            }
            System.out.println(i + Main.getRes().getString(" longrunning child process {0} is alive {1}", new Object[]{Integer.toString(proc2.getPID()), Boolean.toString(proc2.isAlive())}));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" spawn a small child process..."));
        try {
            if (WrapperProcessConfig.isSupported((int)1)) {
                System.out.println(i + Main.getRes().getString(" posix_spawn is supported."));
                p = WrapperManager.exec((String)(simplewaiter + " 0 15"), (WrapperProcessConfig)new WrapperProcessConfig().setStartType(1));
            } else {
                System.out.println(i + Main.getRes().getString(" spawn is not supported."));
                p = WrapperManager.exec((String)(simplewaiter + " 0 15"));
            }
            BufferedReader br2 = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
            try {
                String line2 = "";
                while ((line2 = br2.readLine()) != null) {
                    System.out.println(i + " out..:" + line2);
                }
            }
            finally {
                br2.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" start a small child process, change the environment and read output..."));
        try {
            String line3;
            wpm = new WrapperProcessConfig();
            Map environment = wpm.getEnvironment();
            System.out.println(i + Main.getRes().getString(" size of Environment map (before calling clear()) = ") + environment.size());
            environment.clear();
            environment.put("TEST", "TEST123");
            System.out.println(i + Main.getRes().getString(" size of Environment map = ") + environment.size());
            WrapperProcess proc3 = WrapperManager.exec((String)(simplewaiter + " " + rand.nextInt(200) + " 3"), (WrapperProcessConfig)wpm);
            proc3.getOutputStream().close();
            System.out.println(i + Main.getRes().getString(" small child process {0} is alive {1}", new Object[]{Integer.toString(proc3.getPID()), Boolean.toString(proc3.isAlive())}));
            BufferedReader br3 = new BufferedReader(new InputStreamReader(proc3.getInputStream(), encoding));
            try {
                line3 = "";
                while ((line3 = br3.readLine()) != null) {
                    System.out.println(i + " out..:" + line3);
                }
            }
            finally {
                br3.close();
            }
            br3 = new BufferedReader(new InputStreamReader(proc3.getErrorStream(), encoding));
            try {
                line3 = "";
                while ((line3 = br3.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            finally {
                br3.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" start longrunning child process, change working dir, call waitFor and finally read output..."));
        try {
            wpm = new WrapperProcessConfig();
            if (WrapperProcessConfig.isSupported((int)2) || WrapperProcessConfig.isSupported((int)3)) {
                wpm.setStartType(WrapperProcessConfig.isSupported((int)2) ? 2 : 3);
                System.out.println(i + Main.getRes().getString(" changing the working directory is supported"));
                wpm.setWorkingDirectory(new File(".."));
            } else {
                System.out.println(i + Main.getRes().getString(" changing the working directory is not supported"));
            }
            try {
                System.out.println(i + Main.getRes().getString(" try to call dir"));
                proc = WrapperManager.exec((String)"cmd.exe /c dir", (WrapperProcessConfig)wpm);
            }
            catch (IOException e) {
                System.out.println(i + Main.getRes().getString(" dir failed. most likely we are not on Windows, try ls -l before giving up."));
                proc = WrapperManager.exec((String)"ls -l", (WrapperProcessConfig)wpm);
            }
            System.out.println(i + " PID = " + proc.getPID());
            System.out.println(i + Main.getRes().getString(" child process (PID= {0}) finished with code ", (Object)Integer.toString(proc.getPID())) + proc.waitFor());
            System.out.println(i + Main.getRes().getString(" now read the output"));
            br = new BufferedReader(new InputStreamReader(proc.getInputStream(), encoding));
            try {
                line = "";
                while ((line = br.readLine()) != null) {
                    System.out.println(i + " out..:" + line);
                }
            }
            finally {
                br.close();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" start a small child process by Runtime.exec and put a wrapperexec in between.."));
        try {
            p = Runtime.getRuntime().exec(simplewaiter + " " + (rand.nextInt(200) + 1) + " " + (rand.nextInt(20) + 1));
            proc = WrapperManager.exec((String)(simplewaiter + " 4 4"));
            proc.getOutputStream().close();
            System.out.println(i + Main.getRes().getString(" small child process {0} is alive {1}", new Object[]{Integer.toString(proc.getPID()), Boolean.toString(proc.isAlive())}));
            br = new BufferedReader(new InputStreamReader(proc.getInputStream(), encoding));
            try {
                line = "";
                while ((line = br.readLine()) != null) {
                    System.out.println(i + " out..:" + line);
                }
            }
            finally {
                br.close();
            }
            System.out.println(i + " " + p.toString() + Main.getRes().getString(" Runtime.exec exit ") + ((Process)p).waitFor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" start invalid child process..."));
        try {
            proc2 = WrapperManager.exec((String)"invalid");
            System.out.println(i + Main.getRes().getString(" invalid child process is alive ") + proc2.isAlive());
        }
        catch (IOException e) {
            System.out.println(i + Main.getRes().getString(" caught an invalid child process..."));
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" slow child process..."));
        try {
            command = simplewaiter + " 0 5";
            RuntimeExec.handleWrapperProcess(command, 10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(++i + Main.getRes().getString(" abort child process..."));
        try {
            command = simplewaiter + " 0 30";
            RuntimeExec.handleWrapperProcess(command, 10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(Main.getRes().getString("finally start a long-running child process attached to the wrapper, the wrapper will shut down soon, so the child process should get killed by the wrapper..."));
        try {
            p = WrapperManager.exec((String)(simplewaiter + " 2 1000"), (WrapperProcessConfig)new WrapperProcessConfig().setDetached(false));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WrapperJNIError e) {
            e.printStackTrace();
        }
        catch (WrapperLicenseError e) {
            e.printStackTrace();
        }
        System.out.println();
        if (WrapperManager.getJVMId() == 1) {
            System.out.println(Main.getRes().getString("All Done. Restarting..."));
            WrapperManager.restart();
        } else {
            System.out.println(Main.getRes().getString("All Done. Registering long shutdown hook and stopping.\nWrapper should timeout and kill the JVM, cleaning up all processes in the process."));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    System.out.println(Main.getRes().getString("Starting shutdown hook. Loop for 25 seconds."));
                    System.out.println(Main.getRes().getString("Should timeout unless this property is set: wrapper.jvm_exit.timeout=30"));
                    long start = System.currentTimeMillis();
                    boolean failed = false;
                    while (System.currentTimeMillis() - start < 25000L) {
                        if (!failed) {
                            try {
                                WrapperProcess proc = WrapperManager.exec((String)(simplewaiter + " 0 25"));
                                System.out.println(Main.getRes().getString("Launched child..."));
                            }
                            catch (WrapperJNIError e) {
                                System.out.println(Main.getRes().getString("Unable to launch child process because JNI library unavailable. Normal on shutdown."));
                                failed = true;
                            }
                            catch (IOException e) {
                                System.out.println(Main.getRes().getString("Unexpected problem launching child process: {0}", (Object)e.toString()));
                                failed = true;
                            }
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                    }
                    System.out.println(Main.getRes().getString("Shutdown hook complete. Should exit now."));
                }
            });
            System.exit(0);
        }
    }

    static {
        if (c_encoding == null && (c_encoding = System.getProperty("file.encoding")) == null) {
            c_encoding = "Cp1252";
        }
    }
}

