/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.tanukisoftware.wrapper.WrapperPropertyUtil;
import org.tanukisoftware.wrapper.test.Main;

public class TestUtils {
    private TestUtils() {
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text, String encoding, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, append);
        try {
            OutputStreamWriter osw = encoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, encoding);
            BufferedWriter writer = new BufferedWriter(osw);
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
        }
        finally {
            ((OutputStream)fos).close();
        }
    }

    public static void writeTextFile(File file, String text) throws IOException {
        TestUtils.writeTextFile(file, text, "UTF-8", false);
    }

    public static void writeWrapperCommand(String command) throws IOException, IllegalStateException {
        String commandFilename = WrapperPropertyUtil.getStringProperty((String)"wrapper.commandfile", null);
        if (commandFilename == null) {
            throw new IllegalStateException("The wrapper.commandfile property has not been configured.");
        }
        File commandFile = new File(commandFilename);
        if (commandFile.exists()) {
            System.out.println(Main.getRes().getString("WARNING - Command file already exists when trying to write a new command: {0}", (Object)commandFile.toString()));
        }
        TestUtils.writeTextFile(commandFile, command);
    }

    public static void writeWrapperTestCommand(String command) throws IOException, IllegalStateException {
        boolean enableTests = WrapperPropertyUtil.getBooleanProperty((String)"wrapper.commandfile.enable_tests", (boolean)false);
        if (!enableTests) {
            throw new IllegalStateException("The wrapper.command.enable_tests property has not been set to true.");
        }
        TestUtils.writeWrapperCommand(command);
    }
}

