/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.tanukisoftware.wrapper.test.Main;

public class Memory
implements Runnable {
    private static Memory c_theInstance;
    private Thread m_runner = new Thread((Runnable)this, "runner");
    private static final String PADDING = "                ";

    private Memory() {
        this.m_runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long startTime;
        long lastTest = startTime = System.currentTimeMillis();
        try {
            File file = new File("../logs/memory.log");
            System.out.println(Main.getRes().getString("Writing memory Log to: {0}", (Object)file));
            FileWriter writer = new FileWriter(file);
            try {
                writer.write(Main.getRes().getString("--> Starting Memory Log\n"));
                ((Writer)writer).flush();
                while (this.m_runner != null) {
                    long now = System.currentTimeMillis();
                    System.out.println(Main.getRes().getString("Running for {0}ms...", (Object)new Long(now - startTime)));
                    if (now - lastTest > 15000L) {
                        Runtime rt = Runtime.getRuntime();
                        System.gc();
                        long totalMemory = rt.totalMemory();
                        long freeMemory = rt.freeMemory();
                        long usedMemory = totalMemory - freeMemory;
                        writer.write(Main.getRes().getString("total memory=") + this.pad(totalMemory, 10) + Main.getRes().getString(", used=") + this.pad(usedMemory, 10) + Main.getRes().getString(", free=") + this.pad(freeMemory, 10) + "\n");
                        ((Writer)writer).flush();
                        lastTest = now;
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {}
                }
                writer.write(Main.getRes().getString("<-- Stopping Memory Log\n"));
                ((Writer)writer).flush();
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String pad(long n, int len) {
        String s = Long.toString(n);
        int sLen = s.length();
        if (sLen < len) {
            s = s + PADDING.substring(0, len - sLen);
        }
        return s;
    }

    public static void main(String[] args) {
        System.out.println(Main.getRes().getString("Memory Tester Running..."));
        c_theInstance = new Memory();
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown-hook"){

            public void run() {
                System.out.println(Main.getRes().getString("Stopping..."));
                Thread runner = c_theInstance.m_runner;
                c_theInstance.m_runner = null;
                try {
                    runner.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println(Main.getRes().getString("Stopped."));
            }
        });
    }
}

