/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import java.io.Reader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.el.AbstractEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.xml.AttrRemover;
import woolpack.xml.AttrValueBranch;
import woolpack.xml.AttrValueGetter;
import woolpack.xml.AttrValueUpdater;
import woolpack.xml.ChildElementInserter;
import woolpack.xml.ChildTextReplacer;
import woolpack.xml.ChildrenRemover;
import woolpack.xml.ChildrenRetain;
import woolpack.xml.NodeClone;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFactory;
import woolpack.xml.NodeFinder;
import woolpack.xml.NodeGetter;
import woolpack.xml.NodeNameGetter;
import woolpack.xml.NodeNormalizer;
import woolpack.xml.NodeSeeker;
import woolpack.xml.NodeSetter;
import woolpack.xml.ParentElementInserter;
import woolpack.xml.TemplateCopier;
import woolpack.xml.TextReplacer;
import woolpack.xml.ThisRemover;
import woolpack.xml.XmlTransformerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlUtils {
    public static final NodeGetter<RuntimeException> GET_NODE = new NodeGetter();
    public static final NodeNameGetter<RuntimeException> GET_NODE_NAME = new NodeNameGetter();
    public static final ThisRemover<RuntimeException> REMOVE_THIS = new ThisRemover();
    public static final ChildrenRemover<RuntimeException> REMOVE_CHILDREN = new ChildrenRemover();
    public static final ChildrenRetain<RuntimeException> RETAIN_CHILDREN = new ChildrenRetain();
    public static final NodeClone<RuntimeException> CLONE_NODE = new NodeClone();
    public static final NodeNormalizer<RuntimeException> NORMALIZE_NODE = new NodeNormalizer();
    public static final EL NODE_EL = new AbstractEL(){

        public Object getValue(Object root, Class clazz) {
            return ((NodeContext)root).getNode();
        }

        public void setValue(Object root, Object value) {
            ((NodeContext)root).setNode((Node)value);
        }
    };

    private XmlUtils() {
    }

    public static boolean equalsNode(Node node0, Node node1) {
        if (node0 == null) {
            return node1 == null;
        }
        if (node1 == null) {
            return false;
        }
        if (node0.getNodeType() != node1.getNodeType()) {
            return false;
        }
        if (node0.getNodeType() == 3 || node0.getNodeType() == 8) {
            return node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 2) {
            return node0.getNodeName().equals(node1.getNodeName()) && node0.getNodeValue().equals(node1.getNodeValue());
        }
        if (node0.getNodeType() == 9) {
            return XmlUtils.equalsNode(((Document)node0).getDocumentElement(), ((Document)node1).getDocumentElement());
        }
        if (!node0.getNodeName().equals(node1.getNodeName())) {
            return false;
        }
        Element e0 = (Element)node0;
        Element e1 = (Element)node1;
        NamedNodeMap map0 = e0.getAttributes();
        NamedNodeMap map1 = e1.getAttributes();
        if (map0.getLength() != map1.getLength()) {
            return false;
        }
        int i = 0;
        while (i < map0.getLength()) {
            if (!XmlUtils.equalsNode(map0.item(i), map1.item(i))) {
                return false;
            }
            ++i;
        }
        Node child0 = node0.getFirstChild();
        Node child1 = node1.getFirstChild();
        while (child0 != null || child1 != null) {
            if (!XmlUtils.equalsNode(child0, child1)) {
                return false;
            }
            child0 = child0.getNextSibling();
            child1 = child1.getNextSibling();
        }
        return true;
    }

    public static void removeThis(Node node) {
        node.getParentNode().removeChild(node);
    }

    public static void removeChildren(Node node) {
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    public static void retainChildren(Node node) {
        Node parent = node.getParentNode();
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            parent.insertBefore(child, node);
        }
        parent.removeChild(node);
    }

    public static void appendText(Node node, String text) {
        node.appendChild(XmlUtils.getDocumentNode(node).createTextNode(text));
    }

    public static Document getDocumentNode(Node node) {
        return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
    }

    public static <C extends NodeContext, E extends Exception> AttrValueBranch<C, E> branchByAttrValue(Iterable<String> attrNames, Fn<String, ? extends Fn<? super C, Void, ? extends E>, ? extends E> fn) {
        return new AttrValueBranch(attrNames, fn);
    }

    public static <C extends NodeContext, E extends Exception> NodeFinder<C, E> findNode(Fn<? super Node, ? extends NodeList, ? extends E> findable, Fn<? super C, Void, ? extends E> firstFn, Fn<? super C, Void, ? extends E> pluralFn) {
        return new NodeFinder<C, E>(findable, firstFn, pluralFn);
    }

    public static <C extends NodeContext, E extends Exception> NodeFinder<C, E> findNode(Fn<? super Node, ? extends NodeList, ? extends E> findable, Fn<? super C, Void, ? extends E> fn) {
        return new NodeFinder<C, E>(findable, fn, fn);
    }

    public static AttrValueGetter<RuntimeException> getAttrValue(String attrName) {
        return new AttrValueGetter<RuntimeException>(attrName);
    }

    public static <C extends NodeContext, E extends Exception> ChildElementInserter<C, E> insertElementToChild(String elementName, Fn<? super C, Void, ? extends E> fn) {
        return new ChildElementInserter<C, E>(elementName, fn);
    }

    public static <C extends NodeContext> ChildElementInserter<C, RuntimeException> insertElementToChild(String elementName) {
        return new ChildElementInserter(elementName, FnUtils.fix(null));
    }

    public static <C extends NodeContext, E extends Exception> ParentElementInserter<C, E> insertElementToParent(String elementName, Fn<? super C, Void, ? extends E> fn) {
        return new ParentElementInserter<C, E>(elementName, fn);
    }

    public static <C extends NodeContext> ParentElementInserter<C, RuntimeException> insertElementToParent(String elementName) {
        return new ParentElementInserter(elementName, FnUtils.fix(null));
    }

    public static <C extends NodeContext, E extends Exception> TemplateCopier<C, E> copyTemplate(GettingEL collectionEL, EL valueEL, Fn<? super C, Void, ? extends E> fn) {
        return new TemplateCopier<C, E>(collectionEL, valueEL, fn);
    }

    public static <E extends Exception> NodeFactory<E> nodeFactory(Fn<? super String, ? extends Reader, ? extends E> readerFactory, Fn<XmlTransformerContext, Void, ? extends E> transformer) {
        return new NodeFactory<E>(readerFactory, transformer);
    }

    public static AttrRemover<RuntimeException> removeAttr(String attrName) {
        return new AttrRemover<RuntimeException>(attrName);
    }

    public static <C extends NodeContext, E extends Exception> TextReplacer<C, E> replaceText(Fn<? super C, String, ? extends E> fn) {
        return new TextReplacer<C, E>(fn);
    }

    public static <C extends NodeContext, E extends Exception> ChildTextReplacer<C, E> replaceTextToChild(Fn<? super C, String, ? extends E> fn) {
        return new ChildTextReplacer<C, E>(fn);
    }

    public static <C extends NodeContext, E extends Exception> NodeSeeker<C, E> seekNode(Fn<? super C, Void, ? extends E> fn) {
        return new NodeSeeker<C, E>(fn);
    }

    public static <C extends NodeContext, E extends Exception> NodeSetter<C, E> setNode(Fn<? super C, ? extends Node, ? extends E> fn) {
        return new NodeSetter<C, E>(fn);
    }

    public static <C extends NodeContext, E extends Exception> AttrValueUpdater<C, E> updateAttrValue(String attrName, Fn<? super C, String, ? extends E> fn) {
        return new AttrValueUpdater<C, E>(attrName, fn);
    }
}

