/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import woolpack.convert.ConvertUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.typeconvert.BeanMap;
import woolpack.typeconvert.ConvertContext;
import woolpack.typeconvert.Converter;
import woolpack.typeconvert.DelegationIfNecessityConverter;
import woolpack.typeconvert.PropertyNameGetter;
import woolpack.typeconvert.SettingFnConverter;
import woolpack.typeconvert.ToArrayConverter;
import woolpack.typeconvert.ToBeanConverter;
import woolpack.typeconvert.ToCollectionDecompositionConverter;
import woolpack.typeconvert.ToCollectionViewConverter;
import woolpack.typeconvert.ToMapViewConverter;
import woolpack.typeconvert.ToTypeConverter;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConvertUtils {
    public static final Fn<ConvertContext, Class, RuntimeException> GET_TO_TYPE = new Fn<ConvertContext, Class, RuntimeException>(){

        @Override
        public Class exec(ConvertContext c) {
            return c.getToType();
        }
    };
    public static final Fn<ConvertContext, Class, RuntimeException> GET_FROM_TYPE = new Fn<ConvertContext, Class, RuntimeException>(){

        @Override
        public Class exec(ConvertContext c) {
            return c.getValue().getClass();
        }
    };
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final Fn<ConvertContext, Void, RuntimeException> SIMPLE_CONVERTER = TypeConvertUtils.getSimpleConverter(NUMBER_FORMAT, DATE_FORMAT, FnUtils.fix(null));
    public static final Fn<ConvertContext, Void, RuntimeException> COLLECTION_CONVERTER = TypeConvertUtils.getCollectionConverter(NUMBER_FORMAT, DATE_FORMAT);
    public static final Fn<ConvertContext, String, RuntimeException> GET_PROPERTY_NAME = new PropertyNameGetter();

    private TypeConvertUtils() {
    }

    private static Fn<ConvertContext, Void, RuntimeException> getSimpleConverterPrivate(final NumberFormat numberFormat, final DateFormat dateFormat, Fn<ConvertContext, Void, RuntimeException> successorFn) {
        Fn<Object, java.util.Date, RuntimeException> dateParser = new Fn<Object, java.util.Date, RuntimeException>(){

            @Override
            public java.util.Date exec(Object c) {
                if (c instanceof java.util.Date) {
                    return (java.util.Date)c;
                }
                try {
                    return dateFormat.parse(c.toString());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        Fn<Object, Number, RuntimeException> numberParser = new Fn<Object, Number, RuntimeException>(){

            @Override
            public Number exec(Object c) {
                if (Number.class.isAssignableFrom(c.getClass())) {
                    return (Number)c;
                }
                try {
                    return numberFormat.parse(c.toString());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        return FnUtils.seq((Iterable)Utils.list(new ToTypeConverter(FnUtils.TO_WRAPPER)).list((ToTypeConverter)((Object)FnUtils.exec(FnUtils.join(GET_TO_TYPE, FnUtils.switching((Map)Utils.map(String.class, new Fn<ConvertContext, Void, RuntimeException>(dateFormat, numberFormat){
            private final Fn<ConvertContext, Void, RuntimeException> dateConverter;
            private final Fn<ConvertContext, Void, RuntimeException> numberConverter;
            private final Fn<ConvertContext, Void, RuntimeException> defaultConverter;
            {
                this.dateConverter = new Converter(ConvertUtils.format(ConvertUtils.formatFactory(dateFormat)));
                this.numberConverter = new Converter(ConvertUtils.format(ConvertUtils.formatFactory(numberFormat)));
                this.defaultConverter = new Converter(ConvertUtils.TO_STRING);
            }

            @Override
            public Void exec(ConvertContext c) {
                if (c.getValue() instanceof java.util.Date) {
                    this.dateConverter.exec(c);
                } else if (c.getValue() instanceof Number) {
                    this.numberConverter.exec(c);
                } else {
                    this.defaultConverter.exec(c);
                }
                return null;
            }
        }).map(Boolean.class, (Object)new Converter(new Fn<Object, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Object c) {
                if (c != null && !"false".equals(c) && !Boolean.FALSE.equals(c)) {
                    return true;
                }
                return false;
            }
        })).map(Character.class, (Object)new Converter(new Fn<Object, Character, RuntimeException>(){

            @Override
            public Character exec(Object c) {
                String s = c.toString();
                if (s.length() == 0) {
                    throw new IllegalArgumentException();
                }
                return Character.valueOf(s.charAt(0));
            }
        })).map(java.util.Date.class, (Object)new Converter(dateParser)).map(Date.class, (Object)new Converter(FnUtils.join(dateParser, ConvertUtils.TO_SQL_DATE))).map(Time.class, (Object)new Converter(FnUtils.join(dateParser, ConvertUtils.TO_TIME))).map(Timestamp.class, (Object)new Converter(FnUtils.join(dateParser, ConvertUtils.TO_TIMESTAMP))).map(Byte.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_BYTE))).map(Short.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_SHORT))).map(Integer.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_INTEGER))).map(Long.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_LONG))).map(Float.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_FLOAT))).map(Double.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_DOUBLE))).map(BigInteger.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_BIG_INTEGER))).map(BigDecimal.class, (Object)new Converter(FnUtils.join(numberParser, ConvertUtils.TO_BIG_DECIMAL))), successorFn))))));
    }

    public static Fn<ConvertContext, Void, RuntimeException> getSimpleConverter(NumberFormat numberFormat, DateFormat dateFormat, Fn<ConvertContext, Void, RuntimeException> successorFn) {
        return new DelegationIfNecessityConverter((Fn<ConvertContext, Void, ? extends RuntimeException>)TypeConvertUtils.getSimpleConverterPrivate(numberFormat, dateFormat, successorFn));
    }

    public static Fn<ConvertContext, Void, RuntimeException> getCollectionConverter(NumberFormat numberFormat, DateFormat dateFormat) {
        return new SettingFnConverter(new DelegationIfNecessityConverter(new ToArrayConverter(new ToCollectionViewConverter(new ToCollectionDecompositionConverter(new ToMapViewConverter((Fn<ConvertContext, Void, ? extends RuntimeException>)TypeConvertUtils.getSimpleConverterPrivate(numberFormat, dateFormat, new ToBeanConverter())))))));
    }

    public static Fn<Object, BeanMap, RuntimeException> toMap() {
        return new Fn<Object, BeanMap, RuntimeException>(){

            @Override
            public BeanMap exec(Object c) {
                return new BeanMap(c);
            }
        };
    }

    public static Fn<Object, BeanMap, RuntimeException> toMap(final Fn<ConvertContext, Void, RuntimeException> fn) {
        return new Fn<Object, BeanMap, RuntimeException>(){

            @Override
            public BeanMap exec(Object c) {
                return new BeanMap(c, fn);
            }
        };
    }
}

