/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.util.concurrent.ConcurrentMap;
import woolpack.el.EL;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideEffectConcurrentMapCache<C, K, E extends Exception>
implements Fn<C, Void, E> {
    private Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter;
    private Fn<? super C, ? extends K, ? extends E> keyGetter;
    private Fn<? super C, ?, ? extends E> maker;
    private EL el;

    public SideEffectConcurrentMapCache(Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter, Fn<? super C, ? extends K, ? extends E> keyGetter, Fn<? super C, ?, ? extends E> maker, EL el) {
        this.mapGetter = mapGetter;
        this.keyGetter = keyGetter;
        this.maker = maker;
        this.el = el;
    }

    @Override
    public Void exec(C c) throws E {
        Object value;
        ConcurrentMap<K, Object> map = this.mapGetter.exec(c);
        K key = this.keyGetter.exec(c);
        while ((value = map.get(key)) == null) {
            this.maker.exec(c);
            map.putIfAbsent(key, this.el.getValue(c));
        }
        this.el.setValue(c, value);
        return null;
    }

    public EL getEl() {
        return this.el;
    }

    public void setEl(EL el) {
        this.el = el;
    }

    public Fn<? super C, ? extends K, ? extends E> getKeyGetter() {
        return this.keyGetter;
    }

    public void setKeyGetter(Fn<? super C, ? extends K, ? extends E> keyGetter) {
        this.keyGetter = keyGetter;
    }

    public Fn<? super C, ?, ? extends E> getMaker() {
        return this.maker;
    }

    public void setMaker(Fn<? super C, ?, ? extends E> maker) {
        this.maker = maker;
    }

    public Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> getMapGetter() {
        return this.mapGetter;
    }

    public void setMapGetter(Fn<? super C, ? extends ConcurrentMap<? super K, Object>, ? extends E> mapGetter) {
        this.mapGetter = mapGetter;
    }
}

