/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.fn.NullFn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentElementInserter<C extends NodeContext>
implements Fn<C, Void> {
    private String elementName;
    private Fn<? super C, Void> fn;

    public ParentElementInserter(String elementName, Fn<? super C, Void> fn) {
        this.elementName = elementName;
        this.fn = fn;
    }

    public ParentElementInserter(String elementName) {
        this(elementName, new NullFn());
    }

    @Override
    public Void exec(C context) {
        Node base = context.getNode();
        Element element = XmlUtils.getDocumentNode(base).createElement(this.elementName);
        base.getParentNode().insertBefore(element, base);
        element.appendChild(base);
        try {
            context.setNode(element);
            this.fn.exec(context);
        }
        finally {
            context.setNode(base);
        }
        return null;
    }

    public Fn<? super C, Void> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super C, Void> fn) {
        this.fn = fn;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }
}

