/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import woolpack.fn.Fn;
import woolpack.visitor.ArrayAcceptor;
import woolpack.visitor.BeanAcceptor;
import woolpack.visitor.ComplexAcceptor;
import woolpack.visitor.EchoAcceptor;
import woolpack.visitor.IterableAcceptor;
import woolpack.visitor.MapAcceptor;
import woolpack.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisitorUtils {
    public static final Fn<Visitor<?>, Void> ECHO_ACCEPTOR = new EchoAcceptor();
    public static final Fn<Visitor<?>, Void> MAP_ACCEPTOR = new MapAcceptor();
    public static final Fn<Visitor<?>, Void> ITERABLE_ACCEPTOR = new IterableAcceptor();
    public static final Fn<Visitor<?>, Void> ARRAY_ACCEPTOR = new ArrayAcceptor();
    public static final Fn<Visitor<?>, Void> BEAN_ACCEPTOR = new BeanAcceptor();
    public static final Fn<Visitor<?>, Void> COMPLEX_ACCEPTOR = new ComplexAcceptor();

    private VisitorUtils() {
    }

    public static <V> void localContext(V c, Visitor<V> visitor, Fn<? super Visitor<V>, Void> acceptor) {
        V baseContext = visitor.getSubContext();
        visitor.setSubContext(c);
        try {
            acceptor.exec(visitor);
        }
        finally {
            visitor.setSubContext(baseContext);
        }
    }

    public static <V> void localElement(Object element, Visitor<V> visitor, Fn<? super Visitor<V>, Void> acceptor) {
        Object baseElement = visitor.getElement();
        visitor.setElement(element);
        try {
            acceptor.exec(visitor);
        }
        finally {
            visitor.setElement(baseElement);
        }
    }
}

