/*
 * Decompiled with CFR 0.152.
 */
package woolpack.typeconvert;

import java.lang.reflect.Array;
import java.util.Collection;
import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionConverter
implements Fn<ConvertContext, Void> {
    private Fn<ConvertContext, Void> fn;

    public CollectionConverter(Fn<ConvertContext, Void> fn) {
        this.fn = fn;
    }

    @Override
    public Void exec(ConvertContext c) {
        Collection collection = Utils.toCollection(c.getValue());
        if (c.getToType().isArray()) {
            Class baseToType = c.getToType();
            Object baseValue = c.getValue();
            boolean successFlag = false;
            try {
                Class<?> componentType = baseToType.getComponentType();
                c.setToType(componentType);
                boolean primitiveFlag = componentType.isPrimitive();
                Object afterArray = Array.newInstance(componentType, collection.size());
                int i = 0;
                for (Object before : collection) {
                    c.setValue(before);
                    this.fn.exec(c);
                    if (!primitiveFlag || c.getValue() != null) {
                        Array.set(afterArray, i, c.getValue());
                    }
                    ++i;
                }
                successFlag = true;
                c.setValue(afterArray);
            }
            finally {
                c.setToType(baseToType);
                if (!successFlag) {
                    c.setValue(baseValue);
                }
            }
        } else if (Collection.class.isAssignableFrom(c.getToType())) {
            c.setValue(collection);
        } else {
            c.setValue(collection.iterator().next());
            this.fn.exec(c);
        }
        return null;
    }

    public Fn<ConvertContext, Void> getFn() {
        return this.fn;
    }

    public void setFn(Fn<ConvertContext, Void> fn) {
        this.fn = fn;
    }
}

