/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import woolpack.fn.Fn;
import woolpack.sql.fn.BeanResult;
import woolpack.sql.fn.CommitFn;
import woolpack.sql.fn.CountResult;
import woolpack.sql.fn.ListResult;
import woolpack.sql.fn.MapInput;
import woolpack.sql.fn.MapResult;
import woolpack.sql.fn.OneLineResult;
import woolpack.sql.fn.PreparedStatementInfo;
import woolpack.sql.fn.RollbackFn;
import woolpack.sql.fn.SingleInput;
import woolpack.sql.fn.SingleResult;
import woolpack.sql.fn.StatementInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFnUtils {
    private static final Pattern BIND_COMMENT_SQL_PATTERN = Pattern.compile("[^\\s]*/\\*([^\\*\\s]+)\\s*\\*/[^\\s]*");
    private static final Pattern COMMENT_SQL_PATTERN = Pattern.compile("/\\*\\s[^\\*]*\\*/");
    public static final CountResult GET_COUNT = new CountResult();
    public static final SingleResult GET_SINGLE = new SingleResult();

    private SqlFnUtils() {
    }

    public static <R> BeanResult<R> getBeanResult(Class<R> clazz) {
        return new BeanResult<R>(clazz);
    }

    public static MapResult getMapResult(Fn<? super Integer, ? extends Map<String, Object>> mapFactory) {
        return new MapResult(mapFactory);
    }

    public static MapResult getMapResult() {
        return new MapResult();
    }

    public static <R> ListResult<R> getList(Fn<? super ResultSet, ? extends R> fn) {
        return new ListResult<R>(fn);
    }

    public static <R> ListResult<R> getList(Fn<? super ResultSet, ? extends R> fn, int max) {
        return new ListResult<R>(fn, max);
    }

    public static <R> MapInput<R> inputMap(DataSource dataSource, Fn<? super Map<String, Object>, ? extends PreparedStatementInfo> queryFactory, Fn<? super PreparedStatement, ? extends R> converter) {
        return new MapInput<R>(dataSource, queryFactory, converter);
    }

    public static <R> MapInput<R> inputMap(DataSource dataSource, PreparedStatementInfo info, Fn<? super PreparedStatement, ? extends R> converter) {
        return new MapInput<R>(dataSource, info, converter);
    }

    public static <R> OneLineResult<R> getOne(Fn<? super ResultSet, ? extends R> rowFn, Fn<? super Statement, ? extends R> zeroFn) {
        return new OneLineResult<R>(rowFn, zeroFn);
    }

    public static <R> OneLineResult<R> getOne(Fn<? super ResultSet, ? extends R> rowFn) {
        return new OneLineResult<R>(rowFn);
    }

    public static <C, R> SingleInput<C, R> inputSingle(DataSource dataSource, Fn<? super C, ? extends String> queryFactory, Fn<? super PreparedStatement, ? extends R> converter) {
        return new SingleInput<C, R>(dataSource, queryFactory, converter);
    }

    public static <C, R> SingleInput<C, R> inputSingle(DataSource dataSource, String query, Fn<? super PreparedStatement, ? extends R> converter) {
        return new SingleInput(dataSource, query, converter);
    }

    public static <C, R> StatementInput<C, R> inputStatement(DataSource dataSource, Fn<? super C, ? extends String> fn, Fn<? super Statement, ? extends R> converter) {
        return new StatementInput<C, R>(dataSource, fn, converter);
    }

    public static <C, R> StatementInput<C, R> inputStatement(DataSource dataSource, String query, Fn<? super Statement, ? extends R> converter) {
        return new StatementInput(dataSource, query, converter);
    }

    public static <C, R> RollbackFn<C, R> rollback(DataSource dataSource) {
        return new RollbackFn(dataSource);
    }

    public static <C, R> CommitFn<C, R> commit(DataSource dataSource) {
        return new CommitFn(dataSource);
    }

    public static PreparedStatementInfo toPreparedStatementInfo(String bindCommentSQL) {
        PreparedStatementInfo info = new PreparedStatementInfo();
        ArrayList<String> list = new ArrayList<String>();
        info.setList(list);
        Matcher m = BIND_COMMENT_SQL_PATTERN.matcher(bindCommentSQL);
        StringBuffer sb = new StringBuffer(bindCommentSQL.length());
        while (m.find()) {
            list.add(m.group(1));
            m.appendReplacement(sb, "?");
        }
        m.appendTail(sb);
        info.setQuery(COMMENT_SQL_PATTERN.matcher(sb.toString()).replaceAll(""));
        return info;
    }
}

