/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

import woolpack.fn.Fn;

/**
 * {@link javax.xml.transform.Transformer}を使用して恒等変換を行う{@link Fn}です。
 * 複数のスレッドで同時に使用することはできません。
 * 
 * @author nakamura
 * 
 */
public class XmlTransformer implements Fn<XmlTransformerContext, Void> {
	private final Transformer transformer;
	
	public XmlTransformer() {
		final TransformerFactory transformerFactory = TransformerFactory.newInstance();
		try {
			transformer = transformerFactory.newTransformer();
		} catch (final TransformerConfigurationException e) {
			throw new IllegalStateException(e);
		}
	}

	public Void exec(final XmlTransformerContext c) {
		try {
			transformer.transform(c.getSource(), c.getResult());
		} catch (final TransformerException e) {
			throw new IllegalStateException(e);
		}
		return null;
	}
}
