/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import woolpack.fn.Delegator;
import woolpack.fn.Fn;

/**
 * キー値を一時的に設定して委譲し、
 * 委譲先から復帰したときに呼び出し時の状態に初期化する{@link Fn}です。
 * 
 * @author nakamura
 * 
 */
public class LocalKeyValidator extends Delegator<ValidatorContext, Boolean> {
	private String key;

	public LocalKeyValidator(
			final String key,
			final Fn<? super ValidatorContext, Boolean> fn) {
		super(fn);
		this.key = key;
	}

	@Override
	public Boolean exec(final ValidatorContext context) {
		final String baseKey = context.getKey();
		try {
			context.setKey(key);
			return super.exec(context);
		} finally {
			context.setKey(baseKey);
		}
	}

	public String getKey() {
		return key;
	}
	public void setKey(final String key) {
		this.key = key;
	}
}
