/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.meta;

import java.util.List;

/**
 * 参照制約の情報です。
 * @author nakamura
 *
 */
public class ReferenceInfo {
	private String pkTableCatalog;
	private String pkTableSchema;
	private String pkTableName;
	private String pkName;
	private List<String> pkNameList;
	private String fkTableCatalog;
	private String fkTableSchema;
	private String fkTableName;
	private String fkName;
	private List<String> fkNameList;

	public ReferenceInfo(
			final String pkTableCatalog,
			final String pkTableSchema,
			final String pkTableName,
			final String pkName,
			final List<String> pkNameList,
			final String fkTableCatalog,
			final String fkTableSchema,
			final String fkTableName,
			final String fkName,
			final List<String> fkNameList) {
		this.fkNameList = fkNameList;
		this.fkTableName = fkTableName;
		this.pkNameList = pkNameList;
		this.pkTableName = pkTableName;
		this.fkTableCatalog = fkTableCatalog;
		this.fkTableSchema = fkTableSchema;
		this.pkTableCatalog = pkTableCatalog;
		this.pkTableSchema = pkTableSchema;
		this.fkName = fkName;
		this.pkName = pkName;
	}
	
	public ReferenceInfo() {
	}
	
	public List<String> getFkNameList() {
		return fkNameList;
	}
	public void setFkNameList(final List<String> fkNameList) {
		this.fkNameList = fkNameList;
	}
	public String getFkTableName() {
		return fkTableName;
	}
	public void setFkTableName(final String fkTableName) {
		this.fkTableName = fkTableName;
	}
	public List<String> getPkNameList() {
		return pkNameList;
	}
	public void setPkNameList(final List<String> pkNameList) {
		this.pkNameList = pkNameList;
	}
	public String getPkTableName() {
		return pkTableName;
	}
	public void setPkTableName(final String pkTableName) {
		this.pkTableName = pkTableName;
	}
	public String getFkTableCatalog() {
		return fkTableCatalog;
	}
	public void setFkTableCatalog(final String fkTableCatalog) {
		this.fkTableCatalog = fkTableCatalog;
	}
	public String getFkTableSchema() {
		return fkTableSchema;
	}
	public void setFkTableSchema(final String fkTableSchema) {
		this.fkTableSchema = fkTableSchema;
	}
	public String getPkTableCatalog() {
		return pkTableCatalog;
	}
	public void setPkTableCatalog(final String pkTableCatalog) {
		this.pkTableCatalog = pkTableCatalog;
	}
	public String getPkTableSchema() {
		return pkTableSchema;
	}
	public void setPkTableSchema(final String pkTableSchema) {
		this.pkTableSchema = pkTableSchema;
	}
	public String getFkName() {
		return fkName;
	}
	public void setFkName(final String fkName) {
		this.fkName = fkName;
	}
	public String getPkName() {
		return pkName;
	}
	public void setPkName(final String pkName) {
		this.pkName = pkName;
	}
}
