/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.fn;

import java.sql.ResultSet;
import java.sql.SQLException;

import woolpack.fn.Fn;

/**
 * 現在の行の最初の列の値を返す{@link Fn}です。
 * @author nakamura
 *
 */
public class SingleResult implements Fn<ResultSet, Object> {
	public Object exec(final ResultSet c) {
		try {
			return c.getObject(1);
		} catch (final SQLException e) {
			throw new IllegalStateException(e);
		}
	}
}
