/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

/**
 * 委譲するだけの{@link PreparedStatement}です。
 * @author nakamura
 *
 */
public class PreparedStatementAdapter implements PreparedStatement {
	private PreparedStatement parent;
	
	public PreparedStatementAdapter(final PreparedStatement parent) {
		this.parent = parent;
	}
	public PreparedStatement getParent() {
		return parent;
	}
	public void setParent(final PreparedStatement parent) {
		this.parent = parent;
	}

	public void addBatch() throws SQLException {
		parent.addBatch();
	}

	public void addBatch(final String sql) throws SQLException {
		parent.addBatch(sql);
	}

	public void cancel() throws SQLException {
		parent.cancel();
	}

	public void clearBatch() throws SQLException {
		parent.clearBatch();
	}

	public void clearParameters() throws SQLException {
		parent.clearParameters();
	}

	public void clearWarnings() throws SQLException {
		parent.clearWarnings();
	}

	public void close() throws SQLException {
		parent.close();
	}

	public boolean execute() throws SQLException {
		return parent.execute();
	}

	public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
		return parent.execute(sql, autoGeneratedKeys);
	}

	public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
		return parent.execute(sql, columnIndexes);
	}

	public boolean execute(final String sql, final String[] columnNames) throws SQLException {
		return parent.execute(sql, columnNames);
	}

	public boolean execute(final String sql) throws SQLException {
		return parent.execute(sql);
	}

	public int[] executeBatch() throws SQLException {
		return parent.executeBatch();
	}

	public ResultSet executeQuery() throws SQLException {
		return parent.executeQuery();
	}

	public ResultSet executeQuery(final String sql) throws SQLException {
		return parent.executeQuery(sql);
	}

	public int executeUpdate() throws SQLException {
		return parent.executeUpdate();
	}

	public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
		return parent.executeUpdate(sql, autoGeneratedKeys);
	}

	public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
		return parent.executeUpdate(sql, columnIndexes);
	}

	public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
		return parent.executeUpdate(sql, columnNames);
	}

	public int executeUpdate(final String sql) throws SQLException {
		return parent.executeUpdate(sql);
	}

	public Connection getConnection() throws SQLException {
		return parent.getConnection();
	}

	public int getFetchDirection() throws SQLException {
		return parent.getFetchDirection();
	}

	public int getFetchSize() throws SQLException {
		return parent.getFetchSize();
	}

	public ResultSet getGeneratedKeys() throws SQLException {
		return parent.getGeneratedKeys();
	}

	public int getMaxFieldSize() throws SQLException {
		return parent.getMaxFieldSize();
	}

	public int getMaxRows() throws SQLException {
		return parent.getMaxRows();
	}

	public ResultSetMetaData getMetaData() throws SQLException {
		return parent.getMetaData();
	}

	public boolean getMoreResults() throws SQLException {
		return parent.getMoreResults();
	}

	public boolean getMoreResults(final int current) throws SQLException {
		return parent.getMoreResults(current);
	}

	public ParameterMetaData getParameterMetaData() throws SQLException {
		return parent.getParameterMetaData();
	}

	public int getQueryTimeout() throws SQLException {
		return parent.getQueryTimeout();
	}

	public ResultSet getResultSet() throws SQLException {
		return parent.getResultSet();
	}

	public int getResultSetConcurrency() throws SQLException {
		return parent.getResultSetConcurrency();
	}

	public int getResultSetHoldability() throws SQLException {
		return parent.getResultSetHoldability();
	}

	public int getResultSetType() throws SQLException {
		return parent.getResultSetType();
	}

	public int getUpdateCount() throws SQLException {
		return parent.getUpdateCount();
	}

	public SQLWarning getWarnings() throws SQLException {
		return parent.getWarnings();
	}

	public void setArray(final int i, final Array x) throws SQLException {
		parent.setArray(i, x);
	}

	public void setAsciiStream(final int parameterIndex, final InputStream x, final int length) throws SQLException {
		parent.setAsciiStream(parameterIndex, x, length);
	}

	public void setBigDecimal(final int parameterIndex, final BigDecimal x) throws SQLException {
		parent.setBigDecimal(parameterIndex, x);
	}

	public void setBinaryStream(final int parameterIndex, final InputStream x, final int length) throws SQLException {
		parent.setBinaryStream(parameterIndex, x, length);
	}

	public void setBlob(final int i, final Blob x) throws SQLException {
		parent.setBlob(i, x);
	}

	public void setBoolean(final int parameterIndex, final boolean x) throws SQLException {
		parent.setBoolean(parameterIndex, x);
	}

	public void setByte(final int parameterIndex, final byte x) throws SQLException {
		parent.setByte(parameterIndex, x);
	}

	public void setBytes(final int parameterIndex, final byte[] x) throws SQLException {
		parent.setBytes(parameterIndex, x);
	}

	public void setCharacterStream(final int parameterIndex, final Reader reader, final int length) throws SQLException {
		parent.setCharacterStream(parameterIndex, reader, length);
	}

	public void setClob(final int i, final Clob x) throws SQLException {
		parent.setClob(i, x);
	}

	public void setCursorName(final String name) throws SQLException {
		parent.setCursorName(name);
	}

	public void setDate(final int parameterIndex, final Date x, final Calendar cal) throws SQLException {
		parent.setDate(parameterIndex, x, cal);
	}

	public void setDate(final int parameterIndex, final Date x) throws SQLException {
		parent.setDate(parameterIndex, x);
	}

	public void setDouble(final int parameterIndex, final double x) throws SQLException {
		parent.setDouble(parameterIndex, x);
	}

	public void setEscapeProcessing(final boolean enable) throws SQLException {
		parent.setEscapeProcessing(enable);
	}

	public void setFetchDirection(final int direction) throws SQLException {
		parent.setFetchDirection(direction);
	}

	public void setFetchSize(final int rows) throws SQLException {
		parent.setFetchSize(rows);
	}

	public void setFloat(final int parameterIndex, final float x) throws SQLException {
		parent.setFloat(parameterIndex, x);
	}

	public void setInt(final int parameterIndex, final int x) throws SQLException {
		parent.setInt(parameterIndex, x);
	}

	public void setLong(final int parameterIndex, final long x) throws SQLException {
		parent.setLong(parameterIndex, x);
	}

	public void setMaxFieldSize(final int max) throws SQLException {
		parent.setMaxFieldSize(max);
	}

	public void setMaxRows(final int max) throws SQLException {
		parent.setMaxRows(max);
	}

	public void setNull(final int paramIndex, final int sqlType, final String typeName) throws SQLException {
		parent.setNull(paramIndex, sqlType, typeName);
	}

	public void setNull(final int parameterIndex, final int sqlType) throws SQLException {
		parent.setNull(parameterIndex, sqlType);
	}

	public void setObject(final int parameterIndex, final Object x, final int targetSqlType, final int scale) throws SQLException {
		parent.setObject(parameterIndex, x, targetSqlType, scale);
	}

	public void setObject(final int parameterIndex, final Object x, final int targetSqlType) throws SQLException {
		parent.setObject(parameterIndex, x, targetSqlType);
	}

	public void setObject(final int parameterIndex, final Object x) throws SQLException {
		parent.setObject(parameterIndex, x);
	}

	public void setQueryTimeout(final int seconds) throws SQLException {
		parent.setQueryTimeout(seconds);
	}

	public void setRef(final int i, final Ref x) throws SQLException {
		parent.setRef(i, x);
	}

	public void setShort(final int parameterIndex, final short x) throws SQLException {
		parent.setShort(parameterIndex, x);
	}

	public void setString(final int parameterIndex, final String x) throws SQLException {
		parent.setString(parameterIndex, x);
	}

	public void setTime(final int parameterIndex, final Time x, final Calendar cal) throws SQLException {
		parent.setTime(parameterIndex, x, cal);
	}

	public void setTime(final int parameterIndex, final Time x) throws SQLException {
		parent.setTime(parameterIndex, x);
	}

	public void setTimestamp(final int parameterIndex, final Timestamp x, final Calendar cal) throws SQLException {
		parent.setTimestamp(parameterIndex, x, cal);
	}

	public void setTimestamp(final int parameterIndex, final Timestamp x) throws SQLException {
		parent.setTimestamp(parameterIndex, x);
	}

	public void setUnicodeStream(final int parameterIndex, final InputStream x, final int length) throws SQLException {
		parent.setUnicodeStream(parameterIndex, x, length);
	}

	public void setURL(final int parameterIndex, final URL x) throws SQLException {
		parent.setURL(parameterIndex, x);
	}
}
