/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.lang.reflect.Member;
import java.util.Map;

import ognl.TypeConverter;
import woolpack.fn.Fn;
import woolpack.typeconvert.ConvertContext;

/**
 * {@link Fn}に委譲する{@link TypeConverter}です。
 * <br/>適用しているデザインパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class ConvertableTypeConverter implements TypeConverter {
	private Fn<ConvertContext, Void> fn;

	public ConvertableTypeConverter(final Fn<ConvertContext, Void> fn) {
		this.fn = fn;
	}

	public Object convertValue(
			final Map context,
			final Object target,
			final Member member,
			final String propertyName,
			final Object beforeValue,
			final Class toType) {
		final ConvertContext convertContext = new ConvertContext();
		convertContext.setPropertyName(propertyName);
		convertContext.setToType(toType);
		convertContext.setValue(beforeValue);
		fn.exec(convertContext);
		return convertContext.getValue();
	}

	public Fn<ConvertContext, Void> getFn() {
		return fn;
	}
	public void setFn(final Fn<ConvertContext, Void> fn) {
		this.fn = fn;
	}
}
